/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerCopyPastePreprocessor;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerExpressionComboBox
extends XDebuggerEditorBase {
    private final JComponent myComponent;
    private final ComboBox<XExpression> myComboBox;
    private final CollectionComboBoxModel<XExpression> myModel;
    private XDebuggerComboBoxEditor myEditor;
    private XExpression myExpression;
    private Function<? super Document, ? extends Document> myDocumentProcessor;
    private static final Key<Boolean> DUMMY_DOCUMENT = Key.create((String)"DummyDocument");

    public XDebuggerExpressionComboBox(@NotNull Project project, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, boolean showEditor, boolean languageInside) {
        if (project == null) {
            XDebuggerExpressionComboBox.$$$reportNull$$$0(0);
        }
        if (debuggerEditorsProvider == null) {
            XDebuggerExpressionComboBox.$$$reportNull$$$0(1);
        }
        super(project, debuggerEditorsProvider, EvaluationMode.EXPRESSION, historyId, sourcePosition);
        this.myModel = new CollectionComboBoxModel();
        this.myDocumentProcessor = Function.identity();
        this.myComboBox = this.createComboBox(this.myModel, 100);
        this.myComboBox.setEditable(true);
        this.myExpression = XExpressionImpl.EMPTY_EXPRESSION;
        Dimension minimumSize = new Dimension(this.myComboBox.getMinimumSize());
        minimumSize.width = 100;
        this.myComboBox.setMinimumSize(minimumSize);
        this.initEditor(showEditor, languageInside);
        this.fillComboBox();
        this.myComponent = JBUI.Panels.simplePanel().addToTop(this.myComboBox);
        InternalUICustomization customization = InternalUICustomization.getInstance();
        if (customization != null) {
            customization.installEditorBackground(this.myComponent);
        }
        this.setExpression(this.myExpression);
    }

    protected ComboBox<XExpression> createComboBox(CollectionComboBoxModel<XExpression> model, int width) {
        return new ComboBox(model, width);
    }

    public ComboBox getComboBox() {
        return this.myComboBox;
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor.getEditorTextField().getEditor(true);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myEditor.getEditorTextField();
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable == this.myComboBox.isEnabled()) {
            return;
        }
        UIUtil.setEnabled((Component)this.myComponent, (boolean)enable, (boolean)true);
        if (!enable) {
            this.myExpression = this.getExpression();
        }
        super.setEnabled(enable);
    }

    private void initEditor(boolean showMultiline, boolean languageInside) {
        this.myEditor = new XDebuggerComboBoxEditor(showMultiline, languageInside);
        this.myComboBox.setEditor((ComboBoxEditor)this.myEditor);
        this.myComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)this.myEditor));
        this.myComboBox.setMaximumRowCount(10);
    }

    @Override
    protected void onHistoryChanged() {
        this.fillComboBox();
    }

    private void fillComboBox() {
        this.myModel.setSelectedItem(null);
        this.myModel.replaceAll(this.getRecentExpressions());
    }

    @Override
    protected void doSetText(XExpression text) {
        this.myExpression = text;
        DocumentImpl dummyDocument = new DocumentImpl(text.getExpression());
        dummyDocument.putUserData(DUMMY_DOCUMENT, (Object)true);
        this.myEditor.getEditorTextField().setNewDocumentAndFileType(this.getFileType(text), (Document)dummyDocument);
        ReadAction.nonBlocking(() -> this.createDocument(text)).inSmartMode(this.getProject()).finishOnUiThread(ModalityState.any(), document -> {
            this.myEditor.getEditorTextField().setNewDocumentAndFileType(this.getFileType(text), document);
            this.getEditorsProvider().afterEditorCreated(this.getEditor());
        }).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Override
    public XExpression getExpression() {
        XExpression item = this.myEditor.getItem();
        return item != null ? item : this.myExpression;
    }

    @Override
    protected Document createDocument(XExpression text) {
        return this.myDocumentProcessor.apply((Document)super.createDocument(text));
    }

    public void setDocumentProcessor(Function<? super Document, ? extends Document> documentProcessor) {
        this.myDocumentProcessor = documentProcessor;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getEditorTextField();
    }

    @Override
    public void selectAll() {
        this.myComboBox.getEditor().selectAll();
    }

    @Override
    protected void prepareEditor(EditorEx editor) {
        super.prepareEditor(editor);
        editor.getColorsScheme().setEditorFontSize(Math.min(this.myComboBox.getFont().getSize(), EditorUtil.getEditorFont().getSize()));
    }

    public void fixEditorNotReleasedFalsePositiveException(@NotNull Project project, @NotNull Disposable parentDisposable) {
        EditorTextField field;
        if (project == null) {
            XDebuggerExpressionComboBox.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            XDebuggerExpressionComboBox.$$$reportNull$$$0(3);
        }
        if ((field = (EditorTextField)ObjectUtils.tryCast((Object)this.getEditorComponent(), EditorTextField.class)) == null) {
            return;
        }
        Disposable disposable = Disposer.newDisposable((String)"XDebuggerExpressionComboBox Disposable");
        Disposer.register((Disposable)parentDisposable, () -> ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)disposable)));
        Disposer.register((Disposable)project, (Disposable)disposable);
        field.setDisposedWith(disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerEditorsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/XDebuggerExpressionComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fixEditorNotReleasedFalsePositiveException";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class XDebuggerComboBoxEditor
    implements ComboBoxEditor {
        private final JComponent myPanel;
        private final EditorComboBoxEditor myDelegate;

        XDebuggerComboBoxEditor(final boolean showMultiline, boolean languageInside) {
            this.myDelegate = new EditorComboBoxEditor(XDebuggerExpressionComboBox.this.getProject(), XDebuggerExpressionComboBox.this.getEditorsProvider().getFileType()){

                protected void onEditorCreate(EditorEx editor) {
                    editor.putUserData(DebuggerCopyPastePreprocessor.REMOVE_NEWLINES_ON_PASTE, (Object)true);
                    XDebuggerExpressionComboBox.this.prepareEditor(editor);
                    if (showMultiline) {
                        XDebuggerExpressionComboBox.this.setExpandable((Editor)editor);
                    }
                    XDebuggerEditorBase.foldNewLines(editor);
                    editor.getFilteredDocumentMarkupModel().addMarkupModelListener(((EditorImpl)editor).getDisposable(), new MarkupModelListener(){
                        private final AtomicInteger errors = new AtomicInteger();

                        public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                            if (highlighter == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            this.processHighlighter(highlighter, true);
                        }

                        public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
                            if (highlighter == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            this.processHighlighter(highlighter, false);
                        }

                        void processHighlighter(@NotNull RangeHighlighterEx highlighter, boolean add) {
                            int value;
                            HighlightInfo info;
                            if (highlighter == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if ((info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)highlighter)) != null && HighlightSeverity.ERROR.equals((Object)info.getSeverity()) && ((value = this.errors.addAndGet(add ? 1 : -1)) == 0 || value == 1)) {
                                EdtInvocationManager.invokeLaterIfNeeded(() -> {
                                    if (UIUtil.isShowing(XDebuggerExpressionComboBox.this.myComboBox)) {
                                        XDebuggerExpressionComboBox.this.myComboBox.putClientProperty((Object)"JComponent.outline", (Object)(value > 0 ? "error" : null));
                                        XDebuggerExpressionComboBox.this.myComboBox.repaint();
                                    }
                                });
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "highlighter";
                            objectArray2[1] = "com/intellij/xdebugger/impl/ui/XDebuggerExpressionComboBox$XDebuggerComboBoxEditor$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "afterAdded";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "afterRemoved";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "processHighlighter";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            };
            this.myDelegate.getEditorComponent().setFontInheritedFromLAF(false);
            Object comp = this.myDelegate.getEditorComponent();
            if (languageInside) {
                comp = XDebuggerExpressionComboBox.this.addChooser((JComponent)comp);
            }
            if (showMultiline) {
                comp = XDebuggerExpressionComboBox.this.addExpand((JComponent)comp, true);
            }
            this.myPanel = comp;
        }

        public EditorTextField getEditorTextField() {
            return this.myDelegate.getEditorComponent();
        }

        @Override
        public JComponent getEditorComponent() {
            return this.myPanel;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                XDebuggerExpressionComboBox.this.setExpression((XExpression)anObject);
            }
        }

        public XExpression getItem() {
            Document document;
            Object item = this.myDelegate.getItem();
            if (item instanceof Document && !Boolean.TRUE.equals((document = (Document)item).getUserData(DUMMY_DOCUMENT))) {
                return XDebuggerExpressionComboBox.this.getEditorsProvider().createExpression(XDebuggerExpressionComboBox.this.getProject(), document, XDebuggerExpressionComboBox.this.myExpression.getLanguage(), XDebuggerExpressionComboBox.this.myExpression.getMode());
            }
            return null;
        }

        @Override
        public void selectAll() {
            this.myDelegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.myDelegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.myDelegate.removeActionListener(l);
        }
    }
}

