/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import javax.swing.JViewport;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDebuggerTreeState {
    private final NodeInfo myRootInfo;
    private Rectangle myLastVisibleNodeRect;

    private XDebuggerTreeState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            XDebuggerTreeState.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        XDebuggerTreeNode root = tree.getRoot();
        NodeInfo nodeInfo = this.myRootInfo = root != null ? new NodeInfo("", "", tree.isPathSelected(root.getPath())) : null;
        if (root != null) {
            this.addChildren(tree, this.myRootInfo, root);
        }
    }

    public XDebuggerTreeRestorer restoreState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            XDebuggerTreeState.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        XDebuggerTreeRestorer restorer = null;
        if (this.myRootInfo != null) {
            restorer = new XDebuggerTreeRestorer(tree, this.myLastVisibleNodeRect);
            tree.setCurrentRestorer(restorer);
            restorer.restore(tree.getRoot(), this.myRootInfo);
        }
        return restorer;
    }

    public static XDebuggerTreeState saveState(@NotNull XDebuggerTree tree) {
        if (tree == null) {
            XDebuggerTreeState.$$$reportNull$$$0(2);
        }
        return new XDebuggerTreeState(tree);
    }

    private void addChildren(XDebuggerTree tree, NodeInfo nodeInfo, XDebuggerTreeNode treeNode) {
        if (tree.isExpanded(treeNode.getPath())) {
            List<? extends XDebuggerTreeNode> children = treeNode.getLoadedChildren();
            nodeInfo.myExpanded = true;
            for (XDebuggerTreeNode xDebuggerTreeNode : children) {
                NodeInfo childInfo;
                TreePath path = xDebuggerTreeNode.getPath();
                Rectangle bounds = tree.getPathBounds(path);
                if (bounds != null) {
                    Rectangle treeVisibleRect;
                    Rectangle rectangle = treeVisibleRect = tree.getParent() instanceof JViewport ? ((JViewport)tree.getParent()).getViewRect() : tree.getVisibleRect();
                    if (treeVisibleRect.contains(bounds)) {
                        this.myLastVisibleNodeRect = bounds;
                    }
                }
                if ((childInfo = XDebuggerTreeState.createNode(xDebuggerTreeNode, tree.isPathSelected(path))) == null) continue;
                nodeInfo.addChild(childInfo);
                this.addChildren(tree, childInfo, xDebuggerTreeNode);
            }
        }
    }

    @Nullable
    private static NodeInfo createNode(XDebuggerTreeNode node, boolean selected) {
        RestorableStateNode valueNode2;
        if (node instanceof RestorableStateNode && (valueNode2 = (RestorableStateNode)((Object)node)).isComputed()) {
            return new NodeInfo(valueNode2.getName(), valueNode2.getRawValue(), selected);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "tree";
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "saveState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NodeInfo {
        private final String myName;
        private final String myValue;
        private boolean myExpanded;
        private final boolean mySelected;
        private MultiMap<String, NodeInfo> myChildren;

        public NodeInfo(String name, String value, boolean selected) {
            this.myName = name;
            this.myValue = value;
            this.mySelected = selected;
        }

        public void addChild(@NotNull NodeInfo child) {
            if (child == null) {
                NodeInfo.$$$reportNull$$$0(0);
            }
            if (this.myChildren == null) {
                this.myChildren = new MultiMap();
            }
            this.myChildren.putValue((Object)child.myName, (Object)child);
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }

        public boolean isSelected() {
            return this.mySelected;
        }

        public String getValue() {
            return this.myValue;
        }

        @Nullable
        public NodeInfo getChild(XNamedTreeNode node) {
            TreeNode parent;
            String name = node.getName();
            if (this.myChildren == null) {
                return null;
            }
            List infos = (List)this.myChildren.get((Object)name);
            if (infos.size() > 1 && (parent = node.getParent()) instanceof XDebuggerTreeNode) {
                int idx = 0;
                for (XDebuggerTreeNode xDebuggerTreeNode : ((XDebuggerTreeNode)parent).getLoadedChildren()) {
                    if (xDebuggerTreeNode == node) break;
                    if (!(xDebuggerTreeNode instanceof XNamedTreeNode) || !Objects.equals(((XNamedTreeNode)xDebuggerTreeNode).getName(), name)) continue;
                    ++idx;
                }
                if (idx < infos.size()) {
                    return (NodeInfo)infos.get(idx);
                }
            }
            return (NodeInfo)ContainerUtil.getFirstItem((List)infos);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState$NodeInfo", "addChild"));
        }
    }
}

