/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XAlwaysEvaluatedWatch;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XWatch;
import com.intellij.xdebugger.impl.XWatchImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.pinned.items.PinToTopParentValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class WatchesRootNode
extends XValueContainerNode<XValueContainer> {
    private final XWatchesView myWatchesView;
    private final List<WatchNodeImpl> myChildren;

    @Deprecated
    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, XExpression @NotNull [] expressions) {
        if (tree == null) {
            WatchesRootNode.$$$reportNull$$$0(0);
        }
        if (watchesView == null) {
            WatchesRootNode.$$$reportNull$$$0(1);
        }
        if (expressions == null) {
            WatchesRootNode.$$$reportNull$$$0(2);
        }
        this(tree, watchesView, Arrays.asList(expressions), null, false);
    }

    @Deprecated
    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull List<? extends XExpression> expressions, @Nullable XStackFrame stackFrame, boolean watchesInVariables) {
        if (tree == null) {
            WatchesRootNode.$$$reportNull$$$0(3);
        }
        if (watchesView == null) {
            WatchesRootNode.$$$reportNull$$$0(4);
        }
        if (expressions == null) {
            WatchesRootNode.$$$reportNull$$$0(5);
        }
        this(tree, watchesView, ContainerUtil.map(expressions, XAlwaysEvaluatedWatch::new), stackFrame, watchesInVariables, false);
    }

    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull String configurationName, @Nullable XStackFrame stackFrame, boolean watchesInVariables) {
        if (tree == null) {
            WatchesRootNode.$$$reportNull$$$0(6);
        }
        if (watchesView == null) {
            WatchesRootNode.$$$reportNull$$$0(7);
        }
        if (configurationName == null) {
            WatchesRootNode.$$$reportNull$$$0(8);
        }
        this(tree, watchesView, ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)tree.getProject())).getWatchesManager().getWatchEntries(configurationName), stackFrame, watchesInVariables, false);
    }

    private WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull List<? extends XWatch> watches, @Nullable XStackFrame stackFrame, boolean watchesInVariables, boolean avoidSignatureClash) {
        if (tree == null) {
            WatchesRootNode.$$$reportNull$$$0(9);
        }
        if (watchesView == null) {
            WatchesRootNode.$$$reportNull$$$0(10);
        }
        if (watches == null) {
            WatchesRootNode.$$$reportNull$$$0(11);
        }
        super(tree, null, false, new RootContainerNode(stackFrame, watchesInVariables));
        this.myWatchesView = watchesView;
        this.myChildren = new ArrayList<WatchNodeImpl>();
        this.copyEvaluationResultFromOldRoot(tree, stackFrame);
        for (XWatch xWatch : watches) {
            this.myChildren.add(new WatchNodeImpl(this.myTree, this, xWatch, stackFrame, null, null));
        }
    }

    private void copyEvaluationResultFromOldRoot(@NotNull XDebuggerTree tree, @Nullable XStackFrame stackFrame) {
        if (tree == null) {
            WatchesRootNode.$$$reportNull$$$0(12);
        }
        if (stackFrame == null) {
            return;
        }
        XDebuggerTreeNode xDebuggerTreeNode = tree.getRoot();
        if (!(xDebuggerTreeNode instanceof WatchesRootNode)) {
            return;
        }
        WatchesRootNode watchesRootNode = (WatchesRootNode)xDebuggerTreeNode;
        StreamEx.of(watchesRootNode.myChildren).select(ResultNode.class).findFirst().ifPresent(node -> this.myChildren.add(new ResultNode(this.myTree, this, node.getExpression(), node.getValueContainer())));
    }

    @Override
    @NotNull
    public @Unmodifiable List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List list = ContainerUtil.concat(this.myChildren, super.getLoadedChildren());
        if (list == null) {
            WatchesRootNode.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public @Unmodifiable List<? extends TreeNode> getChildren() {
        List<TreeNode> children = super.getChildren();
        List list = ContainerUtil.concat(this.myChildren, children);
        if (list == null) {
            WatchesRootNode.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<? extends WatchNode> getWatchChildren() {
        List<WatchNodeImpl> list = this.myChildren;
        if (list == null) {
            WatchesRootNode.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Deprecated(forRemoval=true)
    public List<XExpression> getWatchExpressions() {
        return ((StreamEx)StreamEx.of(this.getWatchChildren()).filter(node -> !(node instanceof ResultNode))).map(WatchNode::getExpression).toList();
    }

    public List<XWatch> getWatches() {
        return ((StreamEx)StreamEx.of(this.getWatchChildren()).select(WatchNodeImpl.class).filter(node -> !(node instanceof ResultNode))).map(WatchNodeImpl::getXWatch).toList();
    }

    @Override
    public void clearChildren() {
        super.clearChildren();
        this.myChildren.clear();
    }

    public void computeWatches() {
        this.myChildren.forEach(WatchNodeImpl::computePresentationIfNeeded);
    }

    public void removeResultNode() {
        this.myChildren.removeIf(node -> node instanceof ResultNode);
    }

    public void addResultNode(@Nullable XStackFrame stackFrame, @NotNull XExpression expression) {
        if (expression == null) {
            WatchesRootNode.$$$reportNull$$$0(16);
        }
        ResultNode message = new ResultNode(this.myTree, this, expression, stackFrame);
        Object object = ContainerUtil.getFirstItem(this.myChildren);
        if (object instanceof ResultNode) {
            ResultNode currentResultNode = (ResultNode)object;
            this.removeChildNode(currentResultNode);
        }
        this.myChildren.add(0, message);
        this.fireNodeInserted(0);
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)message);
    }

    public void addWatchExpression(@Nullable XStackFrame stackFrame, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            WatchesRootNode.$$$reportNull$$$0(17);
        }
        WatchNodeImpl message = new WatchNodeImpl(this.myTree, this, new XWatchImpl(expression), stackFrame, null, null);
        if (index < 0 || index > this.myChildren.size()) {
            index = this.myChildren.size();
        }
        this.myChildren.add(index, message);
        this.fireNodeInserted(index);
        TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)message);
        if (navigateToWatchNode) {
            this.myTree.scrollPathToVisible(message.getPath());
        }
    }

    private void fireNodeInserted(int index) {
        this.myTree.getTreeModel().nodesWereInserted(this, new int[]{index + this.headerNodesCount()});
    }

    public int removeChildNode(XDebuggerTreeNode node) {
        int index = this.myChildren.indexOf(node);
        if (index != -1) {
            this.myChildren.remove(node);
            this.fireNodesRemoved(new int[]{index + this.headerNodesCount()}, new TreeNode[]{node});
        }
        return index;
    }

    public void removeChildren(Collection<? extends XDebuggerTreeNode> nodes) {
        int[] indices = this.getNodesIndices(nodes);
        TreeNode[] removed = this.getChildNodes(indices);
        this.myChildren.removeAll(nodes);
        this.fireNodesRemoved(indices, removed);
    }

    public void removeAllChildren() {
        this.myChildren.clear();
        this.fireNodeStructureChanged();
    }

    public void moveUp(WatchNode node) {
        int index = this.getIndex(node);
        if (index > 0) {
            ContainerUtil.swapElements(this.myChildren, (int)index, (int)(index - 1));
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index - 1);
    }

    public void moveDown(WatchNode node) {
        int index = this.getIndex(node);
        if (index < this.myChildren.size() - 1) {
            ContainerUtil.swapElements(this.myChildren, (int)index, (int)(index + 1));
        }
        this.fireNodeStructureChanged();
        this.getTree().setSelectionRow(index + 1);
    }

    public void addNewWatch() {
        this.editWatch(null);
    }

    public void editWatch(@Nullable WatchNodeImpl node) {
        WatchNodeImpl messageNode;
        int index;
        int n = index = node != null ? this.myChildren.indexOf(node) : -1;
        if (index == -1) {
            int selectedIndex = this.myChildren.indexOf(ArrayUtil.getFirstElement((Object[])((WatchNodeImpl[])this.myTree.getSelectedNodes(WatchNodeImpl.class, null))));
            int targetIndex = selectedIndex == -1 ? this.myChildren.size() : selectedIndex + 1;
            messageNode = new WatchNodeImpl(this.myTree, this, XExpressionImpl.EMPTY_EXPRESSION, (XStackFrame)null);
            this.myChildren.add(targetIndex, messageNode);
            this.fireNodeInserted(targetIndex);
            this.getTree().setSelectionRows(ArrayUtilRt.EMPTY_INT_ARRAY);
        } else {
            messageNode = node;
        }
        new WatchInplaceEditor(this, this.myWatchesView, messageNode, node).show();
    }

    public int headerNodesCount() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchesView";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watches";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedChildren";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyEvaluationResultFromOldRoot";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addResultNode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addWatchExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    static class RootContainerNode
    extends XValueContainer
    implements PinToTopParentValue {
        private final XStackFrame stackFrame;
        private final boolean watchesInVariables;

        RootContainerNode(@Nullable XStackFrame stackFrame, boolean watchesInVariables) {
            this.stackFrame = stackFrame;
            this.watchesInVariables = watchesInVariables;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                RootContainerNode.$$$reportNull$$$0(0);
            }
            if (this.stackFrame != null && this.watchesInVariables) {
                this.stackFrame.computeChildren(node);
            } else {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
        }

        @Override
        @Nullable
        public String getTag() {
            XStackFrame xStackFrame = this.stackFrame;
            if (xStackFrame instanceof PinToTopParentValue) {
                PinToTopParentValue pinToTopParentValue = (PinToTopParentValue)xStackFrame;
                return pinToTopParentValue.getTag();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$RootContainerNode", "computeChildren"));
        }
    }

    static class ResultNode
    extends WatchNodeImpl {
        ResultNode(@NotNull XDebuggerTree tree, @NotNull WatchesRootNode parent, @NotNull XExpression expression, @Nullable XStackFrame stackFrame) {
            if (tree == null) {
                ResultNode.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ResultNode.$$$reportNull$$$0(1);
            }
            if (expression == null) {
                ResultNode.$$$reportNull$$$0(2);
            }
            super(tree, parent, new XAlwaysEvaluatedWatch(expression), stackFrame, XDebuggerBundle.message((String)"debugger.result.node.name", (Object[])new Object[0]), null);
        }

        ResultNode(@NotNull XDebuggerTree tree, @NotNull WatchesRootNode parent, @NotNull XExpression expression, @NotNull XValue value) {
            if (tree == null) {
                ResultNode.$$$reportNull$$$0(3);
            }
            if (parent == null) {
                ResultNode.$$$reportNull$$$0(4);
            }
            if (expression == null) {
                ResultNode.$$$reportNull$$$0(5);
            }
            if (value == null) {
                ResultNode.$$$reportNull$$$0(6);
            }
            super(tree, parent, new XAlwaysEvaluatedWatch(expression), null, XDebuggerBundle.message((String)"debugger.result.node.name", (Object[])new Object[0]), value);
        }

        @Override
        public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresentation, boolean hasChildren) {
            if (valuePresentation == null) {
                ResultNode.$$$reportNull$$$0(7);
            }
            Icon resultIcon = AllIcons.Debugger.Db_evaluateNode;
            if (icon instanceof CompositeIcon) {
                IconUtil.replaceInnerIcon((Icon)icon, (Icon)AllIcons.Debugger.Db_watch, (Icon)resultIcon);
            } else {
                icon = resultIcon;
            }
            super.applyPresentation(icon, valuePresentation, hasChildren);
        }

        @Override
        protected void evaluated() {
            ApplicationManager.getApplication().invokeLater(() -> {
                XDebugSessionProxy session = XDebugView.getSessionProxy((Component)((Object)this.getTree()));
                if (session != null) {
                    session.rebuildViews();
                }
            });
        }

        @Override
        @NotNull
        public XEvaluationOrigin getEvaluationOrigin() {
            XEvaluationOrigin xEvaluationOrigin = XEvaluationOrigin.INLINE;
            if (xEvaluationOrigin == null) {
                ResultNode.$$$reportNull$$$0(8);
            }
            return xEvaluationOrigin;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valuePresentation";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$ResultNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$ResultNode";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEvaluationOrigin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPresentation";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

