/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import java.awt.Color;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XValuePresentationUtil {
    public static void renderValue(@NotNull @NlsSafe String value, @NotNull ColoredTextContainer text, @NotNull SimpleTextAttributes attributes, int maxLength, @Nullable String additionalSpecialCharsToHighlight) {
        if (value == null) {
            XValuePresentationUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            XValuePresentationUtil.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            XValuePresentationUtil.$$$reportNull$$$0(2);
        }
        XValuePresentationUtil.renderValue(value, text, attributes, maxLength, additionalSpecialCharsToHighlight, DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE));
    }

    @ApiStatus.Internal
    public static void renderValue(@NotNull @NlsSafe String value, @NotNull ColoredTextContainer text, @NotNull SimpleTextAttributes attributes, int maxLength, @Nullable String additionalSpecialCharsToHighlight, @Nullable TextAttributes escapeCharsAttribute) {
        if (value == null) {
            XValuePresentationUtil.$$$reportNull$$$0(3);
        }
        if (text == null) {
            XValuePresentationUtil.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            XValuePresentationUtil.$$$reportNull$$$0(5);
        }
        SimpleTextAttributes escapeAttributes = escapeCharsAttribute != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)escapeCharsAttribute) : new SimpleTextAttributes(1, (Color)JBColor.GRAY);
        int lastOffset = 0;
        int length = maxLength == -1 ? value.length() : Math.min(value.length(), maxLength);
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            if (!XValuePresentationUtil.isEscapingSymbol(ch) && (additionalSpecialCharsToHighlight == null || additionalSpecialCharsToHighlight.indexOf(ch) == -1)) continue;
            if (i > lastOffset) {
                text.append(value.substring(lastOffset, i), attributes);
            }
            lastOffset = i + 1;
            if (XValuePresentationUtil.isEscapingSymbol(ch)) {
                text.append("\\", escapeAttributes);
            }
            text.append(String.valueOf(XValuePresentationUtil.getEscapingSymbol(ch)), escapeAttributes);
        }
        if (lastOffset < length) {
            text.append(value.substring(lastOffset, length), attributes);
        }
    }

    private static boolean isEscapingSymbol(char ch) {
        return XValuePresentationUtil.getEscapingSymbol(ch) != ch;
    }

    @ApiStatus.Experimental
    public static void renderName(@NotNull @NlsSafe String name, int maxOutputLength, Consumer<@NlsSafe String> appender) {
        if (name == null) {
            XValuePresentationUtil.$$$reportNull$$$0(6);
        }
        int lastPartStart = 0;
        int lastPartEnd = 0;
        boolean lastCharWasWhitespace = false;
        int appendedCount = 0;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (XValuePresentationUtil.isEscapingSymbol(ch) || ch == ' ') {
                lastCharWasWhitespace = true;
                continue;
            }
            if (lastCharWasWhitespace) {
                if ((appendedCount += XValuePresentationUtil.appendPart(name, appender, maxOutputLength, appendedCount, lastPartStart, lastPartEnd)) > 0 && appendedCount < maxOutputLength) {
                    ++appendedCount;
                    appender.accept(" ");
                }
                if (appendedCount == maxOutputLength) {
                    return;
                }
                lastPartStart = i;
                lastPartEnd = i + 1;
            } else {
                ++lastPartEnd;
            }
            lastCharWasWhitespace = false;
        }
        if (lastPartStart < lastPartEnd) {
            XValuePresentationUtil.appendPart(name, appender, maxOutputLength, appendedCount, lastPartStart, lastPartEnd);
        }
    }

    private static int appendPart(@NotNull String name, @NotNull Consumer<String> appender, int maxOutputLength, int appendedCount, int lastPartStart, int lastPartEnd) {
        int remainingLength;
        if (name == null) {
            XValuePresentationUtil.$$$reportNull$$$0(7);
        }
        if (appender == null) {
            XValuePresentationUtil.$$$reportNull$$$0(8);
        }
        if ((remainingLength = maxOutputLength - appendedCount - (lastPartEnd - lastPartStart)) <= 0) {
            lastPartEnd = Math.max(lastPartStart, lastPartEnd + remainingLength);
        }
        String substring = name.substring(lastPartStart, lastPartEnd);
        appender.accept(substring);
        return substring.length();
    }

    private static char getEscapingSymbol(char ch) {
        return switch (ch) {
            case '\n' -> 'n';
            case '\r' -> 'r';
            case '\t' -> 't';
            case '\b' -> 'b';
            case '\f' -> 'f';
            case '\u0007' -> 'a';
            case '\u000b' -> 'v';
            default -> ch;
        };
    }

    public static void appendSeparator(@NotNull ColoredTextContainer text, @NotNull @NlsSafe String separator) {
        if (text == null) {
            XValuePresentationUtil.$$$reportNull$$$0(9);
        }
        if (separator == null) {
            XValuePresentationUtil.$$$reportNull$$$0(10);
        }
        if (!separator.isEmpty()) {
            text.append(separator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    public static String computeValueText(@NotNull XValuePresentation presentation) {
        if (presentation == null) {
            XValuePresentationUtil.$$$reportNull$$$0(11);
        }
        XValuePresentationTextExtractor extractor = new XValuePresentationTextExtractor();
        presentation.renderValue((XValuePresentation.XValueTextRenderer)extractor);
        String string = extractor.getText();
        if (string == null) {
            XValuePresentationUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean isValueTextExtractor(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        if (renderer == null) {
            XValuePresentationUtil.$$$reportNull$$$0(13);
        }
        return renderer instanceof XValuePresentationTextExtractor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeValueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendPart";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendSeparator";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeValueText";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValueTextExtractor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class XValuePresentationTextExtractor
    extends XValueTextRendererBase {
        private final StringBuilder myBuilder = new StringBuilder();

        public void renderValue(@NotNull String value) {
            if (value == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(0);
            }
            this.myBuilder.append(value);
        }

        @Override
        protected void renderRawValue(@NotNull String value, @NotNull TextAttributesKey key) {
            if (value == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(1);
            }
            if (key == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(2);
            }
            this.myBuilder.append(value);
        }

        public void renderStringValue(@NotNull String value, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
            if (value == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(3);
            }
            this.myBuilder.append(value);
        }

        public void renderComment(@NotNull String comment) {
            if (comment == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(4);
            }
            this.myBuilder.append(comment);
        }

        public void renderError(@NotNull String error) {
            if (error == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(5);
            }
            this.myBuilder.append(error);
        }

        public void renderSpecialSymbol(@NotNull String symbol) {
            if (symbol == null) {
                XValuePresentationTextExtractor.$$$reportNull$$$0(6);
            }
            this.myBuilder.append(symbol);
        }

        public String getText() {
            return this.myBuilder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValuePresentationUtil$XValuePresentationTextExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderRawValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderStringValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderComment";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderError";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderSpecialSymbol";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

