/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.ui.visualizedtext.TextVisualizerContentType;
import com.intellij.xdebugger.impl.ui.visualizedtext.common.Helper;
import com.intellij.xdebugger.ui.TextValueVisualizer;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J\u0015\u0010\f\u001a\u00020\r2\u000b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0002R\u0019\u0010\u000e\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/common/HtmlTextVisualizer;", "Lcom/intellij/xdebugger/ui/TextValueVisualizer;", "<init>", "()V", "visualize", "", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "detectFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "isHtml", "", "htmlFileType", "Lorg/jetbrains/annotations/NotNull;", "getHtmlFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nHtmlTextVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlTextVisualizer.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/common/HtmlTextVisualizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,73:1\n130#2,2:74\n*S KotlinDebug\n*F\n+ 1 HtmlTextVisualizer.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/common/HtmlTextVisualizer\n*L\n48#1:74,2\n*E\n"})
public final class HtmlTextVisualizer
implements TextValueVisualizer {
    @NotNull
    public List<VisualizedContentTab> visualize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!this.isHtml(value)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new VisualizedContentTab(value){
            final /* synthetic */ String $value;
            {
                this.$value = $value;
            }

            public String getName() {
                String string = XDebuggerBundle.message((String)"xdebugger.visualized.text.name.html", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public String getId() {
                String string = Reflection.getOrCreateKotlinClass(HtmlTextVisualizer.class).getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public TextVisualizerContentType getContentTypeForStats() {
                return TextVisualizerContentType.HTML;
            }

            public JComponent createComponent(Project project, Disposable parentDisposable) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
                JEditorPane editor = new JEditorPane();
                editor.setEditable(false);
                editor.setContentType("text/html");
                editor.setText(this.$value);
                return (JComponent)new JBScrollPane((Component)editor);
            }
        });
    }

    @Nullable
    public FileType detectFileType(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.isHtml(value) ? this.getHtmlFileType() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHtml(String value) {
        char element$iv;
        block2: {
            CharSequence charSequence = value;
            if (!Helper.INSTANCE.getHtmlTagsRegex().containsMatchIn(charSequence)) return false;
            CharSequence $this$firstOrNull$iv = value;
            boolean $i$f$firstOrNull = false;
            int n = 0;
            while (n < $this$firstOrNull$iv.length()) {
                char it = element$iv = $this$firstOrNull$iv.charAt(n);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) {
                    ++n;
                    continue;
                }
                break block2;
            }
            return false;
        }
        Character c = Character.valueOf(element$iv);
        char c2 = '<';
        if (c == null) return false;
        if (c.charValue() != c2) return false;
        return true;
    }

    private final FileType getHtmlFileType() {
        FileType fileType = FileTypeManager.getInstance().getStdFileType("HTML");
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getStdFileType(...)");
        return fileType;
    }
}

