/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XAlternativeSourceHandler;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerExecutionPointManager;
import com.intellij.xdebugger.impl.XSourceKind;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.util.MonolithUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u0013"}, d2={"updateAfterActiveSessionChanged", "", "currentSession", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "project", "Lcom/intellij/openapi/project/Project;", "updateGutterRendererIcon", "detectSourceKind", "Lcom/intellij/xdebugger/impl/XSourceKind;", "session", "updateExecutionPosition", "checkAlternativePosition", "", "getGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "breakpoint", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointProxy;", "setGutterRenderer", "renderer", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nExecutionPointManagerChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionPointManagerChangeListener.kt\ncom/intellij/xdebugger/impl/ExecutionPointManagerChangeListenerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class ExecutionPointManagerChangeListenerKt {
    private static final void updateAfterActiveSessionChanged(XDebugSessionProxy currentSession, Project project) {
        XDebuggerExecutionPointManager xDebuggerExecutionPointManager = XDebugManagerProxy.Companion.getInstance().getDebuggerExecutionPointManager(project);
        if (xDebuggerExecutionPointManager == null) {
            return;
        }
        XDebuggerExecutionPointManager executionPointManager = xDebuggerExecutionPointManager;
        if (currentSession != null) {
            XDebugSessionImpl xDebugSession = MonolithUtils.findSessionById(currentSession.getId());
            if (xDebugSession != null) {
                executionPointManager.setAlternativeSourceKindFlow((Flow<Boolean>)((Flow)xDebugSession.getAlternativeSourceKindState()));
            }
            ExecutionPointManagerChangeListenerKt.updateExecutionPosition$default(currentSession, false, 2, null);
        } else {
            executionPointManager.clearExecutionPoint();
        }
    }

    private static final void updateGutterRendererIcon(Project project) {
        XDebugSessionProxy session = XDebugManagerProxy.Companion.getInstance().getCurrentSessionProxy(project);
        if (session != null && session.isTopFrameSelected()) {
            GutterIconRenderer renderer = ExecutionPointManagerChangeListenerKt.getGutterRenderer(session.getActiveNonLineBreakpoint(), session);
            ExecutionPointManagerChangeListenerKt.setGutterRenderer(project, renderer);
        } else {
            ExecutionPointManagerChangeListenerKt.setGutterRenderer(project, null);
        }
    }

    private static final XSourceKind detectSourceKind(XDebugSessionProxy session) {
        XDebugSessionImpl xDebugSessionImpl = MonolithUtils.findSessionById(session.getId());
        if (xDebugSessionImpl == null) {
            return XSourceKind.MAIN;
        }
        XDebugSessionImpl xDebugSession = xDebugSessionImpl;
        if (xDebugSession.getCurrentSourceKind() == XSourceKind.ALTERNATIVE) {
            return XSourceKind.ALTERNATIVE;
        }
        XSuspendContext xSuspendContext = xDebugSession.getSuspendContext();
        if (xSuspendContext == null) {
            return XSourceKind.MAIN;
        }
        XSuspendContext suspendContext = xSuspendContext;
        XAlternativeSourceHandler xAlternativeSourceHandler = xDebugSession.getDebugProcess().getAlternativeSourceHandler();
        if (xAlternativeSourceHandler == null) {
            return XSourceKind.MAIN;
        }
        XAlternativeSourceHandler alternativeSourceHandler = xAlternativeSourceHandler;
        boolean useAlternative = alternativeSourceHandler.isAlternativeSourceKindPreferred(suspendContext);
        return useAlternative ? XSourceKind.ALTERNATIVE : XSourceKind.MAIN;
    }

    public static final void updateExecutionPosition(@NotNull XDebugSessionProxy session, boolean checkAlternativePosition) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        XDebugSessionProxy xDebugSessionProxy = XDebugManagerProxy.Companion.getInstance().getCurrentSessionProxy(session.getProject());
        if (xDebugSessionProxy == null) {
            return;
        }
        XDebugSessionProxy currentSession = xDebugSessionProxy;
        if (!Intrinsics.areEqual((Object)currentSession.getId(), (Object)session.getId())) {
            return;
        }
        XDebuggerExecutionPointManager executionPointManager = XDebugManagerProxy.Companion.getInstance().getDebuggerExecutionPointManager(session.getProject());
        if (executionPointManager != null) {
            XSourcePosition xSourcePosition;
            XSourcePosition xSourcePosition2;
            XStackFrame currentStackFrame;
            boolean isTopFrame = session.isTopFrameSelected();
            XStackFrame xStackFrame = currentStackFrame = session.getCurrentStackFrame();
            if (xStackFrame != null) {
                XStackFrame it = xStackFrame;
                boolean bl = false;
                xSourcePosition2 = session.getFrameSourcePosition(it, XSourceKind.MAIN);
            } else {
                xSourcePosition2 = null;
            }
            XSourcePosition mainSourcePosition = xSourcePosition2;
            XStackFrame xStackFrame2 = currentStackFrame;
            if (xStackFrame2 != null) {
                XStackFrame it = xStackFrame2;
                boolean bl = false;
                xSourcePosition = session.getFrameSourcePosition(it, XSourceKind.ALTERNATIVE);
            } else {
                xSourcePosition = null;
            }
            XSourcePosition alternativeSourcePosition = xSourcePosition;
            XSourceKind navigationSourceKind = checkAlternativePosition ? ExecutionPointManagerChangeListenerKt.detectSourceKind(session) : XSourceKind.MAIN;
            executionPointManager.setExecutionPoint(mainSourcePosition, alternativeSourcePosition, isTopFrame, navigationSourceKind);
        }
        ExecutionPointManagerChangeListenerKt.updateGutterRendererIcon(session.getProject());
    }

    public static /* synthetic */ void updateExecutionPosition$default(XDebugSessionProxy xDebugSessionProxy, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ExecutionPointManagerChangeListenerKt.updateExecutionPosition(xDebugSessionProxy, bl);
    }

    private static final GutterIconRenderer getGutterRenderer(XBreakpointProxy breakpoint2, XDebugSessionProxy session) {
        XBreakpointProxy xBreakpointProxy = breakpoint2;
        if (xBreakpointProxy == null || (xBreakpointProxy = xBreakpointProxy.createGutterIconRenderer()) == null) {
            XExecutionStack xExecutionStack = session.getCurrentExecutionStack();
            xBreakpointProxy = xExecutionStack != null ? xExecutionStack.getExecutionLineIconRenderer() : null;
        }
        return xBreakpointProxy;
    }

    private static final void setGutterRenderer(Project project, GutterIconRenderer renderer) {
        block0: {
            XDebuggerExecutionPointManager xDebuggerExecutionPointManager = XDebugManagerProxy.Companion.getInstance().getDebuggerExecutionPointManager(project);
            if (xDebuggerExecutionPointManager == null) break block0;
            xDebuggerExecutionPointManager.setGutterIconRenderer(renderer);
        }
    }

    public static final /* synthetic */ void access$updateGutterRendererIcon(Project project) {
        ExecutionPointManagerChangeListenerKt.updateGutterRendererIcon(project);
    }

    public static final /* synthetic */ void access$updateAfterActiveSessionChanged(XDebugSessionProxy currentSession, Project project) {
        ExecutionPointManagerChangeListenerKt.updateAfterActiveSessionChanged(currentSession, project);
    }
}

