/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.icons.StrokeKt;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J \u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016R%\u0010\u0002\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/intellij/xdebugger/impl/InlayPopupButtonLook;", "Lcom/intellij/openapi/actionSystem/impl/IdeaActionButtonLook;", "effectiveHoverColorAndStroke", "Lkotlin/Function0;", "Lkotlin/Pair;", "Ljava/awt/Color;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getEffectiveHoverColorAndStroke", "()Lkotlin/jvm/functions/Function0;", "getStateBackground", "component", "Ljavax/swing/JComponent;", "state", "", "paintIcon", "", "g", "Ljava/awt/Graphics;", "actionButton", "Lcom/intellij/openapi/actionSystem/ActionButtonComponent;", "icon", "Ljavax/swing/Icon;", "x", "y", "paintLookBorder", "rect", "Ljava/awt/Rectangle;", "color", "intellij.platform.debugger.impl"})
final class InlayPopupButtonLook
extends IdeaActionButtonLook {
    @NotNull
    private final Function0<Pair<Color, Color>> effectiveHoverColorAndStroke;

    public InlayPopupButtonLook(@NotNull Function0<? extends Pair<? extends Color, ? extends Color>> effectiveHoverColorAndStroke) {
        Intrinsics.checkNotNullParameter(effectiveHoverColorAndStroke, (String)"effectiveHoverColorAndStroke");
        this.effectiveHoverColorAndStroke = effectiveHoverColorAndStroke;
    }

    @NotNull
    public final Function0<Pair<Color, Color>> getEffectiveHoverColorAndStroke() {
        return this.effectiveHoverColorAndStroke;
    }

    @Nullable
    protected Color getStateBackground(@Nullable JComponent component, int state) {
        if (state == 1) {
            return (Color)((Pair)this.effectiveHoverColorAndStroke.invoke()).getFirst();
        }
        return super.getStateBackground(component, state);
    }

    public void paintIcon(@NotNull Graphics g, @NotNull ActionButtonComponent actionButton, @NotNull Icon icon, int x, int y) {
        Icon icon2;
        boolean useStrokeVariants;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)actionButton, (String)"actionButton");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Pair pair = (Pair)this.effectiveHoverColorAndStroke.invoke();
        Color effectiveHoverColor = (Color)pair.component1();
        Color strokeColor = (Color)pair.component2();
        boolean bl = useStrokeVariants = strokeColor != null && ColorUtil.getColorDistance((Color)effectiveHoverColor, (Color)JBColor.PanelBackground) > 50.0 && ColorUtil.getColorDistance((Color)effectiveHoverColor, (Color)strokeColor) > 250.0;
        if (useStrokeVariants) {
            Color color = strokeColor;
            Intrinsics.checkNotNull((Object)color);
            icon2 = StrokeKt.toStrokeIcon((Icon)icon, (Color)color);
        } else {
            icon2 = icon;
        }
        Icon resultIcon = icon2;
        super.paintIcon(g, actionButton, resultIcon, x, y);
    }

    public void paintLookBorder(@NotNull Graphics g, @NotNull Rectangle rect, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
    }
}

