/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.FrontendXDebuggerManagerListener;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxyKeeperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/MonolithListenerAdapter;", "Lcom/intellij/xdebugger/XDebuggerManagerListener;", "<init>", "()V", "shouldTriggerListener", "", "getShouldTriggerListener", "()Z", "processStarted", "", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "processStopped", "currentSessionChanged", "previousSession", "Lcom/intellij/xdebugger/XDebugSession;", "currentSession", "intellij.platform.debugger.impl"})
final class MonolithListenerAdapter
implements XDebuggerManagerListener {
    private final boolean getShouldTriggerListener() {
        FrontendType frontendType = FrontendApplicationInfo.INSTANCE.getFrontendType();
        return !XDebugSessionProxy.Companion.useFeProxy() && frontendType instanceof FrontendType.Monolith;
    }

    public void processStarted(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (!this.getShouldTriggerListener()) {
            return;
        }
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession session = xDebugSession;
        ((FrontendXDebuggerManagerListener)session.getProject().getMessageBus().syncPublisher(FrontendXDebuggerManagerListener.TOPIC)).sessionStarted(XDebugSessionProxyKeeperKt.asProxy(session));
    }

    public void processStopped(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (!this.getShouldTriggerListener()) {
            return;
        }
        XDebugSession xDebugSession = debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession session = xDebugSession;
        ((FrontendXDebuggerManagerListener)session.getProject().getMessageBus().syncPublisher(FrontendXDebuggerManagerListener.TOPIC)).sessionStopped(XDebugSessionProxyKeeperKt.asProxy(session));
    }

    public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
        if (!this.getShouldTriggerListener()) {
            return;
        }
        Object object = previousSession;
        if (object == null || (object = object.getProject()) == null) {
            XDebugSession xDebugSession = currentSession;
            object = xDebugSession != null ? xDebugSession.getProject() : null;
            if (object == null) {
                return;
            }
        }
        XDebugSession project = object;
        XDebugSession xDebugSession = previousSession;
        XDebugSession xDebugSession2 = currentSession;
        ((FrontendXDebuggerManagerListener)project.getMessageBus().syncPublisher(FrontendXDebuggerManagerListener.TOPIC)).activeSessionChanged(xDebugSession != null ? XDebugSessionProxyKeeperKt.asProxy(xDebugSession) : null, xDebugSession2 != null ? XDebugSessionProxyKeeperKt.asProxy(xDebugSession2) : null);
    }
}

