/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.execution.configurations.AdditionalTabComponentManagerEx;
import com.intellij.ide.rpc.ComponentDirectTransferId;
import com.intellij.ide.rpc.ComponentDirectTransferIdKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.debugger.impl.rpc.XDebuggerSessionAdditionalTabDto;
import com.intellij.platform.debugger.impl.rpc.XDebuggerSessionAdditionalTabEvent;
import com.intellij.platform.kernel.ids.BackendGlobalIdsKt;
import com.intellij.platform.kernel.ids.BackendValueIdType;
import com.intellij.ui.content.Content;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.xdebugger.impl.XDebugSessionAdditionalTabComponentManagerValueIdType;
import com.intellij.xdebugger.impl.rpc.XDebugSessionAdditionalTabComponentManagerId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0019H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/xdebugger/impl/XDebugSessionAdditionalTabComponentManager;", "Lcom/intellij/execution/configurations/AdditionalTabComponentManagerEx;", "debugTabScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "id", "Lcom/intellij/xdebugger/impl/rpc/XDebugSessionAdditionalTabComponentManagerId;", "getId", "()Lcom/intellij/xdebugger/impl/rpc/XDebugSessionAdditionalTabComponentManagerId;", "tabToId", "", "Lcom/intellij/diagnostic/logging/AdditionalTabComponent;", "Lcom/intellij/ide/rpc/ComponentDirectTransferId;", "Lcom/intellij/platform/debugger/impl/rpc/XDebuggerSessionAdditionalTabId;", "_tabComponentEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/platform/debugger/impl/rpc/XDebuggerSessionAdditionalTabEvent;", "tabComponentEvents", "Lkotlinx/coroutines/flow/Flow;", "getTabComponentEvents", "()Lkotlinx/coroutines/flow/Flow;", "addAdditionalTabComponent", "Lcom/intellij/ui/content/Content;", "tabComponent", "", "icon", "Ljavax/swing/Icon;", "closeable", "", "", "component", "removeAdditionalTabComponent", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class XDebugSessionAdditionalTabComponentManager
implements AdditionalTabComponentManagerEx {
    @NotNull
    private final CoroutineScope debugTabScope;
    @NotNull
    private final XDebugSessionAdditionalTabComponentManagerId id;
    @NotNull
    private final Map<AdditionalTabComponent, ComponentDirectTransferId> tabToId;
    @NotNull
    private final MutableSharedFlow<XDebuggerSessionAdditionalTabEvent> _tabComponentEvents;
    @NotNull
    private final Flow<XDebuggerSessionAdditionalTabEvent> tabComponentEvents;

    public XDebugSessionAdditionalTabComponentManager(@NotNull CoroutineScope debugTabScope) {
        Intrinsics.checkNotNullParameter((Object)debugTabScope, (String)"debugTabScope");
        this.debugTabScope = debugTabScope;
        JobKt.getJob((CoroutineContext)this.debugTabScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> XDebugSessionAdditionalTabComponentManager._init_$lambda$0(this, arg_0));
        this.id = (XDebugSessionAdditionalTabComponentManagerId)BackendGlobalIdsKt.storeValueGlobally((CoroutineScope)this.debugTabScope, (Object)this, (BackendValueIdType)XDebugSessionAdditionalTabComponentManagerValueIdType.INSTANCE);
        this.tabToId = new LinkedHashMap();
        this._tabComponentEvents = SharedFlowKt.MutableSharedFlow$default((int)1000, (int)0, null, (int)6, null);
        this.tabComponentEvents = (Flow)FlowKt.asSharedFlow(this._tabComponentEvents);
    }

    @NotNull
    public final XDebugSessionAdditionalTabComponentManagerId getId() {
        return this.id;
    }

    @NotNull
    public final Flow<XDebuggerSessionAdditionalTabEvent> getTabComponentEvents() {
        return this.tabComponentEvents;
    }

    @Nullable
    public Content addAdditionalTabComponent(@NotNull AdditionalTabComponent tabComponent, @NotNull String id, @Nullable Icon icon, boolean closeable) {
        Intrinsics.checkNotNullParameter((Object)tabComponent, (String)"tabComponent");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ComponentDirectTransferId tabId = ComponentDirectTransferIdKt.setupTransfer((JComponent)((JComponent)tabComponent), (Disposable)CoroutineScopeKt.asDisposable((CoroutineScope)this.debugTabScope));
        this.tabToId.put(tabComponent, tabId);
        String string = tabComponent.getTabTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTabTitle(...)");
        Icon icon2 = icon;
        XDebuggerSessionAdditionalTabDto serializableTab = new XDebuggerSessionAdditionalTabDto(tabId, id, string, tabComponent.getTooltip(), (IconId)(icon2 != null ? IconIdKt.rpcId((Icon)icon2) : null), closeable);
        this._tabComponentEvents.tryEmit((Object)new XDebuggerSessionAdditionalTabEvent.TabAdded(serializableTab));
        return null;
    }

    public void addAdditionalTabComponent(@NotNull AdditionalTabComponent component, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.addAdditionalTabComponent(component, id, null, true);
    }

    public void removeAdditionalTabComponent(@NotNull AdditionalTabComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ActionsKt.runInEdt$default(null, () -> XDebugSessionAdditionalTabComponentManager.removeAdditionalTabComponent$lambda$0(component), (int)1, null);
        ComponentDirectTransferId componentDirectTransferId = this.tabToId.remove(component);
        if (componentDirectTransferId == null) {
            return;
        }
        ComponentDirectTransferId tabId = componentDirectTransferId;
        this._tabComponentEvents.tryEmit((Object)new XDebuggerSessionAdditionalTabEvent.TabRemoved(tabId));
    }

    private static final Unit _init_$lambda$0(XDebugSessionAdditionalTabComponentManager this$0, Throwable it) {
        List tabs = CollectionsKt.toList((Iterable)this$0.tabToId.keySet());
        for (AdditionalTabComponent tab : tabs) {
            this$0.removeAdditionalTabComponent(tab);
        }
        return Unit.INSTANCE;
    }

    private static final Unit removeAdditionalTabComponent$lambda$0(AdditionalTabComponent $component) {
        Disposer.dispose((Disposable)((Disposable)$component));
        return Unit.INSTANCE;
    }
}

