/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.DynamicPluginVetoer;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.idea.AppMode;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.platform.debugger.impl.rpc.XFrontendDebuggerCapabilities;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.CoroutineUtilsKt;
import com.intellij.xdebugger.impl.InlayRunToCursorEditorListener;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerActionsCollector;
import com.intellij.xdebugger.impl.XDebuggerState;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.evaluate.ValueLookupManagerController;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.pinned.items.XDebuggerPinToTopManager;
import com.intellij.xdebugger.impl.settings.ShowBreakpointsOverLineNumbersAction;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
@ApiStatus.Internal
public final class XDebuggerManagerImpl
extends XDebuggerManager
implements PersistentStateComponent<XDebuggerState>,
Disposable {
    public static final DataKey<Integer> ACTIVE_LINE_NUMBER = DataKey.create((String)"active.line.number");
    private static final ExecutorService EXECUTION_POINT_ICON_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Execution point icon updater", (int)1);
    private final Project myProject;
    private final CoroutineScope myCoroutineScope;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDebuggerWatchesManager myWatchesManager;
    private final XDebuggerPinToTopManager myPinToTopManager;
    private final Map<ProcessHandler, XDebugSessionImpl> mySessions;
    private final MutableStateFlow<@Nullable XDebugSessionImpl> myActiveSession;
    private XDebuggerState myState;
    private InlayRunToCursorEditorListener myNewRunToCursorListener;
    @NotNull
    private XFrontendDebuggerCapabilities myFrontendCapabilities;
    private static final TooltipGroup RUN_TO_CURSOR_TOOLTIP_GROUP = new TooltipGroup("RUN_TO_CURSOR_TOOLTIP_GROUP", 0);

    XDebuggerManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(1);
        }
        this.mySessions = Collections.synchronizedMap(new LinkedHashMap());
        this.myActiveSession = CoroutineUtilsKt.createMutableStateFlow(null);
        this.myState = new XDebuggerState();
        this.myNewRunToCursorListener = null;
        this.myFrontendCapabilities = new XFrontendDebuggerCapabilities(false);
        this.myProject = project;
        this.myCoroutineScope = coroutineScope;
        SimpleMessageBusConnection messageBusConnection = project.getMessageBus().connect(coroutineScope);
        this.myBreakpointManager = new XBreakpointManagerImpl(project, this, messageBusConnection, coroutineScope);
        this.myWatchesManager = new XDebuggerWatchesManager(project, coroutineScope);
        this.myPinToTopManager = new XDebuggerPinToTopManager(coroutineScope);
        if (!XDebugSessionProxy.useFeProxy() || AppMode.isRemoteDevHost()) {
            this.startContentSelectionListening(messageBusConnection);
        }
        GutterUiRunToCursorEditorListener listener = new GutterUiRunToCursorEditorListener();
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)listener, (Disposable)this);
        eventMulticaster.addEditorMouseListener((EditorMouseListener)listener, (Disposable)this);
        if (ExperimentalUI.isNewUI()) {
            this.myNewRunToCursorListener = new InlayRunToCursorEditorListener(this.myProject, coroutineScope);
            eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)this.myNewRunToCursorListener, (Disposable)this);
            eventMulticaster.addEditorMouseListener((EditorMouseListener)this.myNewRunToCursorListener, (Disposable)this);
        }
    }

    private void startContentSelectionListening(SimpleMessageBusConnection messageBusConnection) {
        messageBusConnection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor != null && "Debug".equals(executor.getToolWindowId())) {
                    XDebugSessionImpl session = XDebuggerManagerImpl.this.mySessions.get(descriptor.getProcessHandler());
                    XDebuggerManagerImpl.this.onSessionSelected(session);
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor != null && "Debug".equals(executor.getToolWindowId())) {
                    XDebugSessionImpl session = XDebuggerManagerImpl.this.mySessions.get(descriptor.getProcessHandler());
                    if (session == null) {
                        return;
                    }
                    XDebuggerManagerImpl.this.removeSessionNoNotify(session);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "executor";
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @ApiStatus.Internal
    public void onSessionSelected(@Nullable XDebugSessionImpl session) {
        if (session != null) {
            session.activateSession(true);
        } else {
            this.setCurrentSession(null);
        }
    }

    void reshowInlayToolbar(@NotNull Editor editor) {
        if (editor == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myNewRunToCursorListener == null) {
            return;
        }
        XDebugSessionImpl session = this.getCurrentSession();
        if (session == null) {
            return;
        }
        this.myNewRunToCursorListener.reshowInlayRunToCursor(editor);
    }

    public void dispose() {
    }

    public void initializeComponent() {
        this.myBreakpointManager.init();
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        XBreakpointManagerImpl xBreakpointManagerImpl = this.myBreakpointManager;
        if (xBreakpointManagerImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(3);
        }
        return xBreakpointManagerImpl;
    }

    public XDebuggerWatchesManager getWatchesManager() {
        return this.myWatchesManager;
    }

    @NotNull
    public XDebuggerPinToTopManager getPinToTopManager() {
        XDebuggerPinToTopManager xDebuggerPinToTopManager = this.myPinToTopManager;
        if (xDebuggerPinToTopManager == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(4);
        }
        return xDebuggerPinToTopManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public XDebugSession startSession(@NotNull ExecutionEnvironment environment, @NotNull XDebugProcessStarter processStarter) throws ExecutionException {
        if (environment == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(5);
        }
        if (processStarter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(6);
        }
        XDebugSessionImpl xDebugSessionImpl = this.startSession(environment.getContentToReuse(), processStarter, new XDebugSessionImpl(environment, this));
        if (xDebugSessionImpl == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(7);
        }
        return xDebugSessionImpl;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(8);
        }
        if (starter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(9);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, contentToReuse, false, starter);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(10);
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@Nls @NotNull String sessionName, @NotNull XDebugProcessStarter starter, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(11);
        }
        if (starter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(12);
        }
        if (environment == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(13);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, null, environment, environment.getContentToReuse(), false, starter);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(14);
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(15);
        }
        if (starter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(16);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, null, contentToReuse, showToolWindowOnSuspendOnly, starter);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(17);
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, Icon icon, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(18);
        }
        if (starter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(19);
        }
        XDebugSession xDebugSession = this.startSessionAndShowTab(sessionName, icon, null, contentToReuse, showToolWindowOnSuspendOnly, starter);
        if (xDebugSession == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(20);
        }
        return xDebugSession;
    }

    private XDebugSession startSessionAndShowTab(@Nls @NotNull String sessionName, Icon icon, @Nullable ExecutionEnvironment environment, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        if (sessionName == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(21);
        }
        if (starter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(22);
        }
        XDebugSessionImpl session = this.startSession(contentToReuse, starter, new XDebugSessionImpl(environment, this, sessionName, icon, showToolWindowOnSuspendOnly, contentToReuse));
        if (!showToolWindowOnSuspendOnly) {
            session.showSessionTab();
        }
        ProcessHandler handler = session.getDebugProcess().getProcessHandler();
        handler.startNotify();
        return session;
    }

    private XDebugSessionImpl startSession(@Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter, @NotNull XDebugSessionImpl session) throws ExecutionException {
        if (processStarter == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(23);
        }
        if (session == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(24);
        }
        XDebugProcess process = processStarter.start((XDebugSession)session);
        ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).processStarted(process);
        if (processStarter instanceof XDebugProcessConfiguratorStarter) {
            ((XDebugProcessConfiguratorStarter)processStarter).configure(session.getSessionData());
        }
        session.init(process, contentToReuse);
        if (processStarter instanceof XDebugProcessConfiguratorStarter) {
            session.activateSession(false);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            session.addSessionListener(new XDebugSessionListener(){

                public void sessionPaused() {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Editor editor = FileEditorManager.getInstance((Project)XDebuggerManagerImpl.this.myProject).getSelectedTextEditor();
                        if (editor == null) {
                            return;
                        }
                        XDebuggerManagerImpl.this.reshowInlayToolbar(editor);
                    });
                }
            });
        }
        this.mySessions.put(session.getDebugProcess().getProcessHandler(), session);
        return session;
    }

    void removeSession(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(25);
        }
        this.removeSessionNoNotify(session);
        if (this.myActiveSession.compareAndSet((Object)session, null)) {
            this.onActiveSessionChanged(session, null);
        }
    }

    @ApiStatus.Internal
    public void removeSessionNoNotify(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(26);
        }
        this.mySessions.remove(session.getDebugProcess().getProcessHandler());
    }

    private void onActiveSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
        ApplicationManager.getApplication().invokeLater(() -> ValueLookupManagerController.getInstance(this.myProject).hideHint(), this.myProject.getDisposed());
        if (!this.myProject.isDisposed()) {
            ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).currentSessionChanged(previousSession, currentSession);
            if (currentSession != null && previousSession != null) {
                XDebuggerActionsCollector.sessionChanged.log();
            }
        }
    }

    public XDebugSession @NotNull [] getDebugSessions() {
        XDebugSession[] xDebugSessionArray = this.mySessions.values().toArray(new XDebugSessionImpl[0]);
        if (xDebugSessionArray == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(27);
        }
        return xDebugSessionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XDebugSession getDebugSession(@NotNull ExecutionConsole executionConsole) {
        if (executionConsole == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(28);
        }
        Map<ProcessHandler, XDebugSessionImpl> map2 = this.mySessions;
        synchronized (map2) {
            return (XDebugSession)ContainerUtil.find(this.mySessions.values(), session -> session.getConsoleView() == executionConsole);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public <T extends XDebugProcess> List<? extends T> getDebugProcesses(Class<T> processClass) {
        Map<ProcessHandler, XDebugSessionImpl> map2 = this.mySessions;
        // MONITORENTER : map2
        List list = StreamEx.of(this.mySessions.values()).map(XDebugSessionImpl::getDebugProcess).select(processClass).toList();
        // MONITOREXIT : map2
        if (list != null) return list;
        XDebuggerManagerImpl.$$$reportNull$$$0(29);
        return list;
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        return (XDebugSessionImpl)this.myActiveSession.getValue();
    }

    @ApiStatus.Internal
    public StateFlow<@Nullable XDebugSessionImpl> getCurrentSessionFlow() {
        return this.myActiveSession;
    }

    boolean setCurrentSession(@Nullable XDebugSessionImpl session) {
        boolean sessionChanged;
        XDebugSessionImpl previousSession = (XDebugSessionImpl)StateFlowKt.getAndUpdate(this.myActiveSession, currentValue -> session);
        boolean bl = sessionChanged = previousSession != session;
        if (sessionChanged) {
            this.onActiveSessionChanged(previousSession, session);
        }
        return sessionChanged;
    }

    public XDebuggerState getState() {
        XDebuggerState state = this.myState;
        this.myBreakpointManager.saveState(state.getBreakpointManagerState());
        this.myWatchesManager.saveState(state.getWatchesManagerState());
        this.myPinToTopManager.saveState(state.getPinToTopManagerState());
        return state;
    }

    public void loadState(@NotNull XDebuggerState state) {
        if (state == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(30);
        }
        this.myState = state;
        this.myBreakpointManager.loadState(state.getBreakpointManagerState());
        this.myWatchesManager.loadState(state.getWatchesManagerState());
        this.myPinToTopManager.loadState(state.getPinToTopManagerState());
    }

    public void noStateLoaded() {
        this.myBreakpointManager.noStateLoaded();
    }

    @ApiStatus.Internal
    public void setFrontendCapabilities(@NotNull XFrontendDebuggerCapabilities capabilities) {
        if (capabilities == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(31);
        }
        this.myFrontendCapabilities = capabilities;
    }

    @NotNull
    public XFrontendDebuggerCapabilities getFrontendCapabilities() {
        XFrontendDebuggerCapabilities xFrontendDebuggerCapabilities = this.myFrontendCapabilities;
        if (xFrontendDebuggerCapabilities == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(32);
        }
        return xFrontendDebuggerCapabilities;
    }

    @NotNull
    public static NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Debugger messages");
        if (notificationGroup == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(33);
        }
        return notificationGroup;
    }

    static int getLineNumber(@NotNull EditorMouseEvent event) {
        Editor editor;
        if (event == null) {
            XDebuggerManagerImpl.$$$reportNull$$$0(34);
        }
        if (event.getVisualPosition().line >= ((EditorImpl)(editor = event.getEditor())).getVisibleLineCount()) {
            return -1;
        }
        int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset((Editor)editor, (int)event.getOffset());
        int documentLine = editor.getDocument().getLineNumber(lineStartOffset);
        return documentLine < editor.getDocument().getLineCount() ? documentLine : -1;
    }

    @ApiStatus.Internal
    public CoroutineScope getCoroutineScope() {
        return this.myCoroutineScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 10, 14, 17, 20, 27, 29, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 27: 
            case 29: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processStarter";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starter";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilities";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPinToTopManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startSession";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "startSessionAndShowTab";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugSessions";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcesses";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrontendCapabilities";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reshowInlayToolbar";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 27: 
            case 29: 
            case 32: 
            case 33: {
                break;
            }
            case 5: 
            case 6: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "startSession";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startSessionAndShowTab";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeSession";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeSessionNoNotify";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDebugSession";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setFrontendCapabilities";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 10, 14, 17, 20, 27, 29, 32, 33 -> new IllegalStateException(string);
        };
    }

    private final class GutterUiRunToCursorEditorListener
    implements EditorMouseMotionListener,
    EditorMouseListener {
        RangeHighlighter myCurrentHighlighter;

        private GutterUiRunToCursorEditorListener() {
        }

        boolean isEnabled(@NotNull EditorMouseEvent e) {
            if (e == null) {
                GutterUiRunToCursorEditorListener.$$$reportNull$$$0(0);
            }
            if (InlayRunToCursorEditorListener.isInlayRunToCursorEnabled() && ExperimentalUI.isNewUI()) {
                return false;
            }
            Editor editor = e.getEditor();
            if (ExperimentalUI.isNewUI() && ShowBreakpointsOverLineNumbersAction.isSelected()) {
                return false;
            }
            if (e.getArea() != EditorMouseEventArea.LINE_NUMBERS_AREA || editor.getProject() != XDebuggerManagerImpl.this.myProject || !EditorUtil.isRealFileEditor((Editor)editor) || !XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isRunToCursorGestureEnabled()) {
                return false;
            }
            XDebugSessionImpl session = XDebuggerManagerImpl.this.getCurrentSession();
            return session != null && session.isPaused() && !session.isReadOnly();
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                GutterUiRunToCursorEditorListener.$$$reportNull$$$0(1);
            }
            if (!this.isEnabled(e)) {
                this.removeHighlighter(e);
                return;
            }
            this.removeHighlighter(e);
            int lineNumber = XDebuggerManagerImpl.getLineNumber(e);
            if (lineNumber < 0) {
                return;
            }
            Editor editor = e.getEditor();
            this.myCurrentHighlighter = editor.getMarkupModel().addLineHighlighter(DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES, lineNumber, 5998);
            HintHint hint = new HintHint(e.getMouseEvent()).setAwtTooltip(true).setPreferredPosition(Balloon.Position.above).setStatus(HintHint.Status.Info);
            String text = UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor"));
            TooltipController.getInstance().showTooltipByMouseMove(editor, new RelativePoint(e.getMouseEvent()), (TooltipRenderer)new LineTooltipRenderer(text, new Object[]{text}), false, RUN_TO_CURSOR_TOOLTIP_GROUP, hint);
            IdeGlassPaneUtil.find((Component)e.getMouseEvent().getComponent()).setCursor(Cursor.getPredefinedCursor(12), (Object)this);
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            if (e == null) {
                GutterUiRunToCursorEditorListener.$$$reportNull$$$0(2);
            }
            this.removeHighlighter(e);
        }

        private void removeHighlighter(@NotNull EditorMouseEvent e) {
            if (e == null) {
                GutterUiRunToCursorEditorListener.$$$reportNull$$$0(3);
            }
            if (this.myCurrentHighlighter != null) {
                this.myCurrentHighlighter.dispose();
                TooltipController.getInstance().cancelTooltip(RUN_TO_CURSOR_TOOLTIP_GROUP, e.getMouseEvent(), true);
                IdeGlassPaneUtil.find((Component)e.getMouseEvent().getComponent()).setCursor(null, (Object)this);
                this.myCurrentHighlighter = null;
            }
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            if (e == null) {
                GutterUiRunToCursorEditorListener.$$$reportNull$$$0(4);
            }
            if (e.getMouseEvent().getButton() == 1 && this.isEnabled(e)) {
                XSourcePositionImpl position;
                int lineNumber = XDebuggerManagerImpl.getLineNumber(e);
                XDebugSessionImpl session = XDebuggerManagerImpl.this.getCurrentSession();
                if (session != null && lineNumber >= 0 && (position = XSourcePositionImpl.create(e.getEditor().getVirtualFile(), lineNumber)) != null) {
                    e.consume();
                    ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
                    AnAction action = actionManager.getAction("RunToCursor");
                    if (action == null) {
                        throw new AssertionError((Object)"'RunToCursor' action not found");
                    }
                    DataContext dataContext = DataManager.getInstance().getDataContext(e.getMouseEvent().getComponent());
                    AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)e.getMouseEvent(), (String)"ICON_NAVIGATION", (DataContext)dataContext);
                    actionManager.performWithActionCallbacks(action, event, () -> session.runToPosition(position, false));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerManagerImpl$GutterUiRunToCursorEditorListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeHighlighter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class XDebuggerPluginVetoer
    implements DynamicPluginVetoer {
        XDebuggerPluginVetoer() {
        }

        @Nls
        @Nullable
        public String vetoPluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                XDebuggerPluginVetoer.$$$reportNull$$$0(0);
            }
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                XDebugSession[] sessions;
                XDebuggerManager manager = (XDebuggerManager)project.getServiceIfCreated(XDebuggerManager.class);
                if (manager == null) continue;
                for (XDebugSession session : sessions = manager.getDebugSessions()) {
                    XDebugProcess process = session.getDebugProcess();
                    if (!process.dependsOnPlugin(pluginDescriptor)) continue;
                    return XDebuggerBundle.message((String)"plugin.is.not.unload.safe.because.of.the.started.debug.session", (Object[])new Object[0]);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/xdebugger/impl/XDebuggerManagerImpl$XDebuggerPluginVetoer", "vetoPluginUnload"));
        }
    }
}

