/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XEditorSourcePosition;
import com.intellij.xdebugger.impl.XEditorSourcePositionKt;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.actions.handlers.XToggleLineBreakpointActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointTypeProxy;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ToggleLineBreakpointAction
extends XDebuggerActionBase
implements DumbAware,
Toggleable,
ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
    public static final XToggleLineBreakpointActionHandler ourHandler = new XToggleLineBreakpointActionHandler(false);

    public ToggleLineBreakpointAction() {
        super(true);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(0);
        }
        XToggleLineBreakpointActionHandler xToggleLineBreakpointActionHandler = ourHandler;
        if (xToggleLineBreakpointActionHandler == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(1);
        }
        return xToggleLineBreakpointActionHandler;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(2);
        }
        super.update(event);
        if ("TouchBarGeneral".equals(event.getPlace())) {
            event.getPresentation().setIcon(AllIcons.Debugger.Db_set_breakpoint);
        }
        boolean selected = ToggleLineBreakpointAction.hasLineBreakpoint(event);
        Toggleable.setSelected((Presentation)event.getPresentation(), (boolean)selected);
    }

    private static boolean hasLineBreakpoint(@NotNull AnActionEvent e) {
        Project proj;
        if (e == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(3);
        }
        if ((proj = e.getProject()) == null) {
            return false;
        }
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.getInstance().getBreakpointManagerProxy(proj);
        List<XLineBreakpointTypeProxy> breakpointTypes = breakpointManager.getLineBreakpointTypes();
        for (XSourcePosition xSourcePosition : ToggleLineBreakpointAction.getAllPositionsForBreakpoints(proj, e.getDataContext())) {
            for (XLineBreakpointTypeProxy breakpointType : breakpointTypes) {
                int line;
                VirtualFile file;
                if (breakpointManager.findBreakpointAtLine(breakpointType, file = xSourcePosition.getFile(), line = xSourcePosition.getLine()) == null) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Collection<XEditorSourcePosition> getAllPositionsForBreakpoints(@NotNull Project project, DataContext context) {
        Editor editor;
        if (project == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(4);
        }
        if ((editor = XDebuggerUtilImpl.getEditor(project, context)) == null) {
            List<XEditorSourcePosition> list = Collections.emptyList();
            if (list == null) {
                ToggleLineBreakpointAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        SmartList res = new SmartList();
        Integer line = (Integer)XLineBreakpointManager.BREAKPOINT_LINE_KEY.getData(context);
        if (line != null) {
            XSourcePositionImpl position = XSourcePositionImpl.create(file, line);
            if (position != null) {
                res.add(XEditorSourcePositionKt.withEditor(position, editor));
            }
            SmartList smartList = res;
            if (smartList == null) {
                ToggleLineBreakpointAction.$$$reportNull$$$0(6);
            }
            return smartList;
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            XSourcePositionImpl position = XSourcePositionImpl.createByOffset(file, caret.getOffset());
            if (position == null) continue;
            res.add(XEditorSourcePositionKt.withEditor(position, editor));
        }
        SmartList smartList = res;
        if (smartList == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerSupport";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/ToggleLineBreakpointAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/ToggleLineBreakpointAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPositionsForBreakpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllPositionsForBreakpoints";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

