/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.idea.AppMode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHint;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionApi;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerSmartStepIntoHandlerKt;
import com.intellij.xdebugger.impl.actions.handlers.XSmartStepIntoTarget;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.ui.DebuggerColors;
import fleet.util.HelpersKt;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001:\u000278B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0019\u0010(\u001a\u00020$2\n\u0010)\u001a\u00060\u000eR\u00020\u0000H\u0000\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002J\u0019\u0010.\u001a\u00020$2\n\u0010)\u001a\u00060\u000eR\u00020\u0000H\u0000\u00a2\u0006\u0002\b/J\r\u00100\u001a\u00020$H\u0000\u00a2\u0006\u0002\b1J\r\u00102\u001a\u00020$H\u0000\u00a2\u0006\u0002\b3J\b\u00105\u001a\u00020$H\u0002J\b\u00106\u001a\u00020$H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00000\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0018\u00010\u000eR\u00020\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010RH\u0010\u001a\u001a6\u0012\u0014\u0012\u0012 \u001c*\b\u0018\u00010\u000eR\u00020\u00000\u000eR\u00020\u0000 \u001c*\u001a\u0012\u0014\u0012\u0012 \u001c*\b\u0018\u00010\u000eR\u00020\u00000\u000eR\u00020\u0000\u0018\u00010\u001b0\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0018\u00010\u000eR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013R\u001a\u0010!\u001a\b\u0018\u00010\u000eR\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u0010\u00104\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData;", "", "targets", "", "Lcom/intellij/xdebugger/impl/actions/handlers/XSmartStepIntoTarget;", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljava/util/List;Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;Lcom/intellij/openapi/editor/Editor;)V", "getSession$intellij_platform_debugger_impl", "()Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "myVariants", "Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData$VariantInfo;", "getMyVariants$intellij_platform_debugger_impl", "()Ljava/util/List;", "myCurrentVariant", "getMyCurrentVariant$intellij_platform_debugger_impl", "()Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData$VariantInfo;", "setMyCurrentVariant$intellij_platform_debugger_impl", "(Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData$VariantInfo;)V", "myHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getMyHighlighters$intellij_platform_debugger_impl", "DISTANCE_TO_CURRENT_COMPARATOR", "Ljava/util/Comparator;", "kotlin.jvm.PlatformType", "getDISTANCE_TO_CURRENT_COMPARATOR$intellij_platform_debugger_impl", "()Ljava/util/Comparator;", "previousVariant", "getPreviousVariant", "nextVariant", "getNextVariant", "selectNext", "", "direction", "Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData$Direction;", "selectNext$intellij_platform_debugger_impl", "select", "variant", "select$intellij_platform_debugger_impl", "setCurrentVariantHighlighterAttributes", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "stepInto", "stepInto$intellij_platform_debugger_impl", "stepIntoCurrent", "stepIntoCurrent$intellij_platform_debugger_impl", "clear", "clear$intellij_platform_debugger_impl", "myActionHintSyntheticHighlighter", "clearSyntheticHighlighter", "setSyntheticHighlighterIfNeeded", "Direction", "VariantInfo", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nXDebuggerSmartStepIntoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XDebuggerSmartStepIntoHandler.kt\ncom/intellij/xdebugger/impl/actions/handlers/SmartStepData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,552:1\n1563#2:553\n1634#2,3:554\n*S KotlinDebug\n*F\n+ 1 XDebuggerSmartStepIntoHandler.kt\ncom/intellij/xdebugger/impl/actions/handlers/SmartStepData\n*L\n178#1:553\n178#1:554,3\n*E\n"})
public final class SmartStepData {
    @NotNull
    private final XDebugSessionProxy session;
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<VariantInfo> myVariants;
    @Nullable
    private VariantInfo myCurrentVariant;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    private final Comparator<VariantInfo> DISTANCE_TO_CURRENT_COMPARATOR;
    @Nullable
    private RangeHighlighter myActionHintSyntheticHighlighter;

    /*
     * WARNING - void declaration
     */
    public SmartStepData(@NotNull List<XSmartStepIntoTarget> targets, @NotNull XDebugSessionProxy session, @NotNull Editor editor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.session = session;
        this.editor = editor;
        this.setSyntheticHighlighterIfNeeded();
        Iterable iterable = targets;
        SmartStepData smartStepData = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XSmartStepIntoTarget xSmartStepIntoTarget = (XSmartStepIntoTarget)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new VariantInfo((XSmartStepIntoTarget)it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Comparator<Object> comparator = Comparator.comparingInt(arg_0 -> SmartStepData.myVariants$lambda$2(SmartStepData::myVariants$lambda$1, arg_0)).thenComparingInt(arg_0 -> SmartStepData.myVariants$lambda$4(SmartStepData::myVariants$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparingInt(...)");
        smartStepData.myVariants = CollectionsKt.sortedWith((Iterable)iterable2, comparator);
        this.myHighlighters = new ArrayList();
        this.DISTANCE_TO_CURRENT_COMPARATOR = Comparator.comparingInt(arg_0 -> SmartStepData.DISTANCE_TO_CURRENT_COMPARATOR$lambda$1(arg_0 -> SmartStepData.DISTANCE_TO_CURRENT_COMPARATOR$lambda$0(this, arg_0), arg_0));
    }

    @NotNull
    public final XDebugSessionProxy getSession$intellij_platform_debugger_impl() {
        return this.session;
    }

    @NotNull
    public final List<VariantInfo> getMyVariants$intellij_platform_debugger_impl() {
        return this.myVariants;
    }

    @Nullable
    public final VariantInfo getMyCurrentVariant$intellij_platform_debugger_impl() {
        return this.myCurrentVariant;
    }

    public final void setMyCurrentVariant$intellij_platform_debugger_impl(@Nullable VariantInfo variantInfo) {
        this.myCurrentVariant = variantInfo;
    }

    @NotNull
    public final List<RangeHighlighter> getMyHighlighters$intellij_platform_debugger_impl() {
        return this.myHighlighters;
    }

    public final Comparator<VariantInfo> getDISTANCE_TO_CURRENT_COMPARATOR$intellij_platform_debugger_impl() {
        return this.DISTANCE_TO_CURRENT_COMPARATOR;
    }

    private final VariantInfo getPreviousVariant() {
        int currentIndex = CollectionsKt.indexOf(this.myVariants, (Object)this.myCurrentVariant);
        int previousIndex = currentIndex > 0 ? currentIndex - 1 : this.myVariants.size() - 1;
        return this.myVariants.get(previousIndex);
    }

    private final VariantInfo getNextVariant() {
        int currentIndex = CollectionsKt.indexOf(this.myVariants, (Object)this.myCurrentVariant);
        int nextIndex = currentIndex < this.myVariants.size() - 1 ? currentIndex + 1 : 0;
        return this.myVariants.get(nextIndex);
    }

    public final void selectNext$intellij_platform_debugger_impl(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        VariantInfo variantInfo = this.myCurrentVariant;
        Intrinsics.checkNotNull((Object)variantInfo);
        int currentLineY = variantInfo.getMyStartPoint().y;
        VariantInfo next = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> this.getPreviousVariant();
            case 2 -> this.getNextVariant();
            case 3 -> {
                int previousLineY = this.myVariants.stream().mapToInt(arg_0 -> SmartStepData.selectNext$lambda$1(SmartStepData::selectNext$lambda$0, arg_0)).filter(arg_0 -> SmartStepData.selectNext$lambda$2(currentLineY, arg_0)).max().orElse(-1);
                yield this.myVariants.stream().filter(arg_0 -> SmartStepData.selectNext$lambda$4(arg_0 -> SmartStepData.selectNext$lambda$3(previousLineY, arg_0), arg_0)).min(this.DISTANCE_TO_CURRENT_COMPARATOR).orElseGet(() -> SmartStepData.selectNext$lambda$5(this));
            }
            case 4 -> {
                int nextLineY = this.myVariants.stream().mapToInt(arg_0 -> SmartStepData.selectNext$lambda$7(SmartStepData::selectNext$lambda$6, arg_0)).filter(arg_0 -> SmartStepData.selectNext$lambda$8(currentLineY, arg_0)).min().orElse(-1);
                yield this.myVariants.stream().filter(arg_0 -> SmartStepData.selectNext$lambda$10(arg_0 -> SmartStepData.selectNext$lambda$9(nextLineY, arg_0), arg_0)).min(this.DISTANCE_TO_CURRENT_COMPARATOR).orElseGet(() -> SmartStepData.selectNext$lambda$11(this));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        if (next != null) {
            this.select$intellij_platform_debugger_impl(next);
        }
    }

    public final void select$intellij_platform_debugger_impl(@NotNull VariantInfo variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        TextAttributesKey textAttributesKey = DebuggerColors.SMART_STEP_INTO_TARGET;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SMART_STEP_INTO_TARGET");
        this.setCurrentVariantHighlighterAttributes(textAttributesKey);
        this.myCurrentVariant = variant;
        TextAttributesKey textAttributesKey2 = DebuggerColors.SMART_STEP_INTO_SELECTION;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"SMART_STEP_INTO_SELECTION");
        this.setCurrentVariantHighlighterAttributes(textAttributesKey2);
        String description = variant.getTarget().getVariant().getDescription();
        if (description != null && XDebuggerSmartStepIntoHandlerKt.access$shouldShowElementDescription(this.editor)) {
            XDebuggerSmartStepIntoHandlerKt.access$showHint(this.editor, description, variant);
        }
    }

    private final void setCurrentVariantHighlighterAttributes(TextAttributesKey attributesKey) {
        Integer n = HelpersKt.indexOfOrNull(this.myVariants, (Object)this.myCurrentVariant);
        if (n == null) {
            return;
        }
        int index = n;
        this.myHighlighters.get(index).setTextAttributesKey(attributesKey);
    }

    public final void stepInto$intellij_platform_debugger_impl(@NotNull VariantInfo variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        UIUtil.invokeLaterIfNeeded(() -> SmartStepData.stepInto$lambda$0(this));
        BuildersKt.launch$default((CoroutineScope)this.session.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(variant, null){
            int label;
            final /* synthetic */ VariantInfo $variant;
            {
                this.$variant = $variant;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = XDebugSessionApi.Companion.getInstance((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((XDebugSessionApi)v0).smartStepInto(this.$variant.getTarget().getId(), (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void stepIntoCurrent$intellij_platform_debugger_impl() {
        VariantInfo variantInfo = this.myCurrentVariant;
        Intrinsics.checkNotNull((Object)variantInfo);
        this.stepInto$intellij_platform_debugger_impl(variantInfo);
    }

    public final void clear$intellij_platform_debugger_impl() {
        EDT.assertIsEdt();
        this.editor.putUserData(XDebuggerSmartStepIntoHandlerKt.access$getSMART_STEP_INPLACE_DATA$p(), null);
        this.editor.putUserData(XDebuggerSmartStepIntoHandlerKt.access$getSMART_STEP_HINT_DATA$p(), null);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.session.getProject());
        Intrinsics.checkNotNull((Object)highlightManager, (String)"null cannot be cast to non-null type com.intellij.codeInsight.highlighting.HighlightManagerImpl");
        HighlightManagerImpl highlightManager2 = (HighlightManagerImpl)highlightManager;
        highlightManager2.hideHighlights(this.editor, 5);
        this.clearSyntheticHighlighter();
    }

    private final void clearSyntheticHighlighter() {
        RangeHighlighter rangeHighlighter = this.myActionHintSyntheticHighlighter;
        if (rangeHighlighter == null) {
            return;
        }
        RangeHighlighter highlighter = rangeHighlighter;
        this.editor.getMarkupModel().removeHighlighter(highlighter);
    }

    private final void setSyntheticHighlighterIfNeeded() {
        if (!AppMode.isRemoteDevHost()) {
            return;
        }
        MarkupModel markupModel = this.editor.getMarkupModel();
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        this.myActionHintSyntheticHighlighter = (RangeHighlighter)((MarkupModelEx)markupModel).addRangeHighlighterAndChangeAttributes(HighlighterColors.NO_HIGHLIGHTING, 0, this.editor.getDocument().getTextLength(), 6000, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> SmartStepData.setSyntheticHighlighterIfNeeded$lambda$1(SmartStepData::setSyntheticHighlighterIfNeeded$lambda$0, arg_0));
    }

    private static final int myVariants$lambda$1(VariantInfo v) {
        TextRange textRange = v.getTarget().getVariant().getHighlightRange();
        Intrinsics.checkNotNull((Object)textRange);
        return textRange.getStartOffset();
    }

    private static final int myVariants$lambda$2(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int myVariants$lambda$3(VariantInfo v) {
        TextRange textRange = v.getTarget().getVariant().getHighlightRange();
        Intrinsics.checkNotNull((Object)textRange);
        return textRange.getLength();
    }

    private static final int myVariants$lambda$4(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int DISTANCE_TO_CURRENT_COMPARATOR$lambda$0(SmartStepData this$0, VariantInfo it) {
        int n = it.getMyStartPoint().x;
        VariantInfo variantInfo = this$0.myCurrentVariant;
        Intrinsics.checkNotNull((Object)variantInfo);
        return Math.abs(n - variantInfo.getMyStartPoint().x);
    }

    private static final int DISTANCE_TO_CURRENT_COMPARATOR$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int selectNext$lambda$0(VariantInfo v) {
        return v.getMyStartPoint().y;
    }

    private static final int selectNext$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final boolean selectNext$lambda$2(int $currentLineY, int v) {
        return v < $currentLineY;
    }

    private static final boolean selectNext$lambda$3(int $previousLineY, VariantInfo v) {
        return v.getMyStartPoint().y == $previousLineY;
    }

    private static final boolean selectNext$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final VariantInfo selectNext$lambda$5(SmartStepData this$0) {
        return this$0.getPreviousVariant();
    }

    private static final int selectNext$lambda$6(VariantInfo v) {
        return v.getMyStartPoint().y;
    }

    private static final int selectNext$lambda$7(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final boolean selectNext$lambda$8(int $currentLineY, int v) {
        return v > $currentLineY;
    }

    private static final boolean selectNext$lambda$9(int $nextLineY, VariantInfo v) {
        return v.getMyStartPoint().y == $nextLineY;
    }

    private static final boolean selectNext$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final VariantInfo selectNext$lambda$11(SmartStepData this$0) {
        return this$0.getNextVariant();
    }

    private static final void stepInto$lambda$0(SmartStepData this$0) {
        this$0.clear$intellij_platform_debugger_impl();
    }

    private static final Unit setSyntheticHighlighterIfNeeded$lambda$0(RangeHighlighterEx h) {
        Intrinsics.checkNotNull((Object)h);
        EditorActionAvailabilityHint[] editorActionAvailabilityHintArray = new EditorActionAvailabilityHint[]{new EditorActionAvailabilityHint("EditorEnter", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null), new EditorActionAvailabilityHint("EditorTab", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null), new EditorActionAvailabilityHint("EditorEscape", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null), new EditorActionAvailabilityHint("EditorUp", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null), new EditorActionAvailabilityHint("EditorDown", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null), new EditorActionAvailabilityHint("EditorRight", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null), new EditorActionAvailabilityHint("EditorLeft", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside, null, 4, null)};
        EditorActionAvailabilityHintKt.addActionAvailabilityHint((RangeHighlighter)((RangeHighlighter)h), (EditorActionAvailabilityHint[])editorActionAvailabilityHintArray);
        return Unit.INSTANCE;
    }

    private static final void setSyntheticHighlighterIfNeeded$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData$Direction;", "", "<init>", "(Ljava/lang/String;I)V", "UP", "DOWN", "LEFT", "RIGHT", "intellij.platform.debugger.impl"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction UP = new Direction();
        public static final /* enum */ Direction DOWN = new Direction();
        public static final /* enum */ Direction LEFT = new Direction();
        public static final /* enum */ Direction RIGHT = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.UP, Direction.DOWN, Direction.LEFT, Direction.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData$VariantInfo;", "", "target", "Lcom/intellij/xdebugger/impl/actions/handlers/XSmartStepIntoTarget;", "<init>", "(Lcom/intellij/xdebugger/impl/actions/handlers/SmartStepData;Lcom/intellij/xdebugger/impl/actions/handlers/XSmartStepIntoTarget;)V", "getTarget", "()Lcom/intellij/xdebugger/impl/actions/handlers/XSmartStepIntoTarget;", "myStartPoint", "Ljava/awt/Point;", "getMyStartPoint", "()Ljava/awt/Point;", "intellij.platform.debugger.impl"})
    public final class VariantInfo {
        @NotNull
        private final XSmartStepIntoTarget target;
        @NotNull
        private final Point myStartPoint;

        public VariantInfo(XSmartStepIntoTarget target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            this.target = target2;
            Editor editor = SmartStepData.this.editor;
            TextRange textRange = this.target.getVariant().getHighlightRange();
            Intrinsics.checkNotNull((Object)textRange);
            Point point = editor.offsetToXY(textRange.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
            this.myStartPoint = point;
        }

        @NotNull
        public final XSmartStepIntoTarget getTarget() {
            return this.target;
        }

        @NotNull
        public final Point getMyStartPoint() {
            return this.myStartPoint;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

