/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hints.presentation.InputHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.BitUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.InlineLightBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointInlineVariantProxy;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00014B+\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u0019\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J,\u0010\u001a\u001a\u00020\u001b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\u0019\u0010,\u001a\u0004\u0018\u00010\u001b2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u001bH\u0002J\b\u00101\u001a\u00020\u001bH\u0002J\n\u00102\u001a\u0004\u0018\u000103H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00065"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/intellij/codeInsight/hints/presentation/InputHandler;", "lightBreakpoint", "Lcom/intellij/xdebugger/impl/breakpoints/InlineLightBreakpoint;", "variant", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointInlineVariantProxy;", "document", "Lcom/intellij/openapi/editor/Document;", "line", "", "<init>", "(Lcom/intellij/xdebugger/impl/breakpoints/InlineLightBreakpoint;Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointInlineVariantProxy;Lcom/intellij/openapi/editor/Document;I)V", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "setInlay", "(Lcom/intellij/openapi/editor/Inlay;)V", "tooltipHint", "Lcom/intellij/ui/LightweightHint;", "getTooltipHint", "()Lcom/intellij/ui/LightweightHint;", "setTooltipHint", "(Lcom/intellij/ui/LightweightHint;)V", "calcWidthInPixels", "paint", "", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "mousePressed", "event", "Ljava/awt/event/MouseEvent;", "translated", "Ljava/awt/Point;", "mouseReleased", "invokePopupIfNeeded", "mouseClicked", "mouseMoved", "mouseExited", "setCursor", "cursor", "Ljava/awt/Cursor;", "(Ljava/awt/Cursor;)Lkotlin/Unit;", "showTooltip", "hideTooltip", "centerPosition", "Lcom/intellij/ui/awt/RelativePoint;", "ClickAction", "intellij.platform.debugger.impl"})
public final class InlineBreakpointInlayRenderer
implements EditorCustomElementRenderer,
InputHandler {
    @Nullable
    private final InlineLightBreakpoint lightBreakpoint;
    @Nullable
    private final XLineBreakpointInlineVariantProxy variant;
    @NotNull
    private final Document document;
    private final int line;
    public Inlay<InlineBreakpointInlayRenderer> inlay;
    @Nullable
    private LightweightHint tooltipHint;

    public InlineBreakpointInlayRenderer(@Nullable InlineLightBreakpoint lightBreakpoint, @Nullable XLineBreakpointInlineVariantProxy variant, @NotNull Document document, int line) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.lightBreakpoint = lightBreakpoint;
        this.variant = variant;
        this.document = document;
        this.line = line;
        if (!(this.lightBreakpoint != null || this.variant != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Inlay<InlineBreakpointInlayRenderer> getInlay() {
        Inlay<InlineBreakpointInlayRenderer> inlay = this.inlay;
        if (inlay != null) {
            return inlay;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inlay");
        return null;
    }

    public final void setInlay(@NotNull Inlay<InlineBreakpointInlayRenderer> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"<set-?>");
        this.inlay = inlay;
    }

    @Nullable
    public final LightweightHint getTooltipHint() {
        return this.tooltipHint;
    }

    public final void setTooltipHint(@Nullable LightweightHint lightweightHint) {
        this.tooltipHint = lightweightHint;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        EditorColorsScheme editorColorsScheme = inlay.getEditor().getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        EditorColorsScheme colorsScheme = editorColorsScheme;
        FontUIResource fontUIResource = UIUtil.getFontWithFallback((Font)colorsScheme.getFont(EditorFontType.PLAIN));
        Intrinsics.checkNotNullExpressionValue((Object)fontUIResource, (String)"getFontWithFallback(...)");
        FontUIResource font = fontUIResource;
        FontRenderContext context = FontInfo.getFontRenderContext((Component)inlay.getEditor().getContentComponent());
        FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics editorFontMetrics = fontMetrics;
        String twoChars = "nn";
        return editorFontMetrics.stringWidth(twoChars);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        JComponent jComponent = inlay.getEditor().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        Icon baseIcon = null;
        float alpha = 0.0f;
        if (this.lightBreakpoint != null) {
            baseIcon = this.lightBreakpoint.getIcon();
            alpha = 1.0f;
        } else {
            XLineBreakpointInlineVariantProxy xLineBreakpointInlineVariantProxy = this.variant;
            Intrinsics.checkNotNull((Object)xLineBreakpointInlineVariantProxy);
            baseIcon = xLineBreakpointInlineVariantProxy.getIcon();
            alpha = RangesKt.coerceIn((float)JBUI.getFloat((String)"Breakpoint.iconHoverAlpha", (float)0.5f), (float)0.0f, (float)1.0f);
        }
        Editor editor = inlay.getEditor();
        EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
        float editorScale = editorImpl != null ? editorImpl.getScale() : 1.0f;
        float iconScale = 0.75f * editorScale;
        Icon scaledIcon = IconUtil.scale((Icon)baseIcon, (Component)component, (float)iconScale);
        int x = targetRegion.x + targetRegion.width / 2 - scaledIcon.getIconWidth() / 2;
        int y = targetRegion.y + targetRegion.height / 2 - scaledIcon.getIconHeight() / 2;
        GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha, () -> InlineBreakpointInlayRenderer.paint$lambda$0(scaledIcon, component, g, x, y));
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.invokePopupIfNeeded(event);
    }

    public void mouseReleased(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.invokePopupIfNeeded(event);
    }

    private final void invokePopupIfNeeded(MouseEvent event) {
        if (event.isPopupTrigger()) {
            if (this.lightBreakpoint != null) {
                XBreakpointProxy xBreakpointProxy = this.lightBreakpoint.getBreakpointProxy();
                if (xBreakpointProxy == null) {
                    InlineBreakpointInlayRenderer $this$invokePopupIfNeeded_u24lambda_u240 = this;
                    boolean bl = false;
                    return;
                }
                XBreakpointProxy breakpoint2 = xBreakpointProxy;
                RelativePoint relativePoint = this.centerPosition();
                if (relativePoint == null) {
                    return;
                }
                RelativePoint center = relativePoint;
                JComponent jComponent = this.getInlay().getEditor().getContentComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
                JComponent component = jComponent;
                DebuggerUIUtil.showXBreakpointEditorBalloon(breakpoint2.getProject(), center.getPoint((Component)component), component, false, breakpoint2);
            }
            event.consume();
        }
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        event.consume();
        int button = event.getButton();
        ClickAction action = null;
        if (this.lightBreakpoint != null) {
            if (this.lightBreakpoint.getBreakpointProxy() == null) {
                return;
            }
            if (button == 2 || button == 1 && BitUtil.isSet((int)event.getModifiersEx(), (int)512)) {
                action = !Registry.Companion.is("debugger.click.disable.breakpoints") ? ClickAction.ENABLE_DISABLE : ClickAction.REMOVE;
            } else if (button == 1) {
                action = Registry.Companion.is("debugger.click.disable.breakpoints") ? ClickAction.ENABLE_DISABLE : ClickAction.REMOVE;
            }
        } else {
            boolean bl;
            boolean bl2 = bl = this.variant != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (button == 1) {
                action = ClickAction.SET;
            }
        }
        if (action == null) {
            return;
        }
        Editor editor = this.getInlay().getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Project project = editor2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = editor2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                XLineBreakpointInlineVariantProxy xLineBreakpointInlineVariantProxy = this.variant;
                Intrinsics.checkNotNull((Object)xLineBreakpointInlineVariantProxy);
                xLineBreakpointInlineVariantProxy.createBreakpoint(project2, file, this.document, this.line);
                break;
            }
            case 2: {
                InlineLightBreakpoint inlineLightBreakpoint = this.lightBreakpoint;
                Intrinsics.checkNotNull((Object)inlineLightBreakpoint);
                XBreakpointProxy xBreakpointProxy = inlineLightBreakpoint.getBreakpointProxy();
                Intrinsics.checkNotNull((Object)xBreakpointProxy);
                XBreakpointProxy proxy = xBreakpointProxy;
                proxy.setEnabled(!proxy.isEnabled());
                break;
            }
            case 3: {
                InlineLightBreakpoint inlineLightBreakpoint = this.lightBreakpoint;
                Intrinsics.checkNotNull((Object)inlineLightBreakpoint);
                XBreakpointProxy xBreakpointProxy = inlineLightBreakpoint.getBreakpointProxy();
                Intrinsics.checkNotNull((Object)xBreakpointProxy);
                XBreakpointProxy proxy = xBreakpointProxy;
                XDebuggerUtilImpl.removeBreakpointWithConfirmation(proxy);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.showTooltip();
    }

    public void mouseExited() {
        this.setCursor(null);
        this.hideTooltip();
    }

    private final Unit setCursor(Cursor cursor) {
        Unit unit;
        Editor editor = this.getInlay().getEditor();
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx != null) {
            editorEx.setCustomCursor(InlineBreakpointInlayRenderer.class, cursor);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void showTooltip() {
        LightweightHint lightweightHint = this.tooltipHint;
        boolean bl = lightweightHint != null ? lightweightHint.isVisible() : false;
        if (bl) {
            return;
        }
        if (!this.getInlay().getEditor().getContentComponent().isShowing()) {
            return;
        }
        Object object = this.lightBreakpoint;
        if (object == null || (object = object.getTooltipDescription()) == null) {
            XLineBreakpointInlineVariantProxy xLineBreakpointInlineVariantProxy = this.variant;
            Intrinsics.checkNotNull((Object)xLineBreakpointInlineVariantProxy);
            object = xLineBreakpointInlineVariantProxy.getTooltipDescription();
        }
        Object text = object;
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)text));
        short constraint = 1;
        RelativePoint relativePoint = this.centerPosition();
        if (relativePoint == null) {
            return;
        }
        RelativePoint point = relativePoint;
        Point hintPoint = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)this.getInlay().getEditor(), (RelativePoint)point, (short)constraint);
        HintHint hintHint = HintManagerImpl.createHintHint((Editor)this.getInlay().getEditor(), (Point)hintPoint, (LightweightHint)hint, (short)constraint).setContentActive(false).setPositionChangeShift(0, 0);
        int flags = 42;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, this.getInlay().getEditor(), hintPoint, flags, 0, false, hintHint);
        this.tooltipHint = hint;
    }

    private final void hideTooltip() {
        LightweightHint lightweightHint = this.tooltipHint;
        if (lightweightHint != null) {
            lightweightHint.hide();
        }
        this.tooltipHint = null;
    }

    private final RelativePoint centerPosition() {
        Rectangle rectangle = this.getInlay().getBounds();
        if (rectangle == null) {
            return null;
        }
        Rectangle bounds = rectangle;
        return new RelativePoint((Component)this.getInlay().getEditor().getContentComponent(), new Point((int)bounds.getCenterX(), (int)bounds.getCenterY()));
    }

    private static final void paint$lambda$0(Icon $scaledIcon, JComponent $component, Graphics $g, int $x, int $y) {
        $scaledIcon.paintIcon($component, $g, $x, $y);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/InlineBreakpointInlayRenderer$ClickAction;", "", "<init>", "(Ljava/lang/String;I)V", "SET", "ENABLE_DISABLE", "REMOVE", "intellij.platform.debugger.impl"})
    private static final class ClickAction
    extends Enum<ClickAction> {
        public static final /* enum */ ClickAction SET = new ClickAction();
        public static final /* enum */ ClickAction ENABLE_DISABLE = new ClickAction();
        public static final /* enum */ ClickAction REMOVE = new ClickAction();
        private static final /* synthetic */ ClickAction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ClickAction[] values() {
            return (ClickAction[])$VALUES.clone();
        }

        public static ClickAction valueOf(String value) {
            return Enum.valueOf(ClickAction.class, value);
        }

        @NotNull
        public static EnumEntries<ClickAction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = clickActionArray = new ClickAction[]{ClickAction.SET, ClickAction.ENABLE_DISABLE, ClickAction.REMOVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClickAction.values().length];
            try {
                nArray[ClickAction.SET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickAction.ENABLE_DISABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClickAction.REMOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

