/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.CoroutineUtilsKt;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointGutterIconRenderer;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxyKt;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointProxy;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.rpc.XBreakpointId;
import com.intellij.xdebugger.impl.rpc.models.XBreakpointValueIdKt;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XBreakpointBase<Self extends XBreakpoint<P>, P extends XBreakpointProperties, S extends BreakpointState>
extends UserDataHolderBase
implements XBreakpoint<P>,
Comparable<Self> {
    @NonNls
    private static final String BR_NBSP = "<br>&nbsp;";
    private final XBreakpointType<Self, P> myType;
    @Nullable
    private final P myProperties;
    protected final S myState;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final CoroutineScope myCoroutineScope;
    private final XBreakpointId myId;
    private Icon myIcon;
    private CustomizedBreakpointPresentation myCustomizedPresentation;
    private boolean myConditionEnabled = true;
    private XExpression myCondition;
    private boolean myLogExpressionEnabled = true;
    private XExpression myLogExpression;
    private volatile boolean myDisposed;
    private final MutableSharedFlow<Unit> myBreakpointChangedFlow = CoroutineUtilsKt.createMutableSharedFlow(1, 1);

    public XBreakpointBase(XBreakpointType<Self, P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, S state) {
        this.myState = state;
        this.myType = type;
        this.myProperties = properties;
        this.myBreakpointManager = breakpointManager;
        this.myCoroutineScope = CoroutineScopeKt.childScope((CoroutineScope)breakpointManager.getCoroutineScope(), (String)"XBreakpoint", (CoroutineContext)EmptyCoroutineContext.INSTANCE, (boolean)true);
        this.myId = XBreakpointValueIdKt.storeGlobally(this, this.myCoroutineScope);
        this.initExpressions();
    }

    private void initExpressions() {
        this.myConditionEnabled = ((BreakpointState)this.myState).isConditionEnabled();
        BreakpointState.Condition condition = ((BreakpointState)this.myState).getCondition();
        this.myCondition = condition != null ? condition.toXExpression() : null;
        this.myLogExpressionEnabled = ((BreakpointState)this.myState).isLogExpressionEnabled();
        BreakpointState.LogExpression expression = ((BreakpointState)this.myState).getLogExpression();
        this.myLogExpression = expression != null ? expression.toXExpression() : null;
    }

    public final Project getProject() {
        return this.myBreakpointManager.getProject();
    }

    protected XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    @ApiStatus.Internal
    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myCoroutineScope;
        if (coroutineScope == null) {
            XBreakpointBase.$$$reportNull$$$0(0);
        }
        return coroutineScope;
    }

    @ApiStatus.Internal
    @NotNull
    public XBreakpointId getBreakpointId() {
        XBreakpointId xBreakpointId = this.myId;
        if (xBreakpointId == null) {
            XBreakpointBase.$$$reportNull$$$0(1);
        }
        return xBreakpointId;
    }

    public final void fireBreakpointChanged() {
        this.clearIcon();
        this.myBreakpointManager.fireBreakpointChanged(this);
        this.emitBreakpointChanged();
    }

    @ApiStatus.Internal
    public final void emitBreakpointChanged() {
        this.myBreakpointChangedFlow.tryEmit((Object)Unit.INSTANCE);
    }

    @ApiStatus.Internal
    public final void fireBreakpointPresentationUpdated(@Nullable XDebugSession session) {
        this.clearIcon();
        this.myBreakpointManager.fireBreakpointPresentationUpdated(this, session);
        this.emitBreakpointChanged();
    }

    public final Flow<Unit> breakpointChangedFlow() {
        return this.myBreakpointChangedFlow;
    }

    public XSourcePosition getSourcePosition() {
        return this.getType().getSourcePosition((XBreakpoint)this);
    }

    public Navigatable getNavigatable() {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            return null;
        }
        return position.createNavigatable(this.getProject());
    }

    protected <T> void updateStateIfNeededAndNotify(long requestId, T newValue, Supplier<? extends T> getter, Consumer<T> setter) {
        boolean updateNeeded;
        T currentValue = getter.get();
        boolean bl = updateNeeded = !Objects.equals(currentValue, newValue);
        if (updateNeeded) {
            setter.accept(newValue);
        }
        boolean requestCompleted = this.myBreakpointManager.getRequestCounter().setRequestCompleted(requestId);
        if (updateNeeded || requestCompleted) {
            this.fireBreakpointChanged();
        }
    }

    public boolean isEnabled() {
        return ((BreakpointState)this.myState).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(-1L, enabled);
    }

    public void setEnabled(long requestId, boolean enabled) {
        this.updateStateIfNeededAndNotify(requestId, enabled, () -> this.myState.isEnabled(), arg_0 -> this.myState.setEnabled(arg_0));
    }

    @NotNull
    public SuspendPolicy getSuspendPolicy() {
        SuspendPolicy suspendPolicy = ((BreakpointState)this.myState).getSuspendPolicy();
        if (suspendPolicy == null) {
            XBreakpointBase.$$$reportNull$$$0(2);
        }
        return suspendPolicy;
    }

    public void setSuspendPolicy(@NotNull SuspendPolicy policy) {
        if (policy == null) {
            XBreakpointBase.$$$reportNull$$$0(3);
        }
        this.setSuspendPolicy(-1L, policy);
    }

    /*
     * WARNING - void declaration
     */
    public void setSuspendPolicy(long requestId, @NotNull SuspendPolicy suspendPolicy) {
        void policy;
        if (suspendPolicy == null) {
            XBreakpointBase.$$$reportNull$$$0(4);
        }
        this.updateStateIfNeededAndNotify(requestId, policy, () -> this.myState.getSuspendPolicy(), p -> {
            ((BreakpointState)this.myState).setSuspendPolicy((SuspendPolicy)p);
            if (p == SuspendPolicy.NONE) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("debugger.breakpoint.non.suspending");
            }
        });
    }

    public boolean isLogMessage() {
        return ((BreakpointState)this.myState).isLogMessage();
    }

    public void setLogMessage(boolean logMessage) {
        this.setLogMessage(-1L, logMessage);
    }

    public void setLogMessage(long requestId, boolean logMessage) {
        this.updateStateIfNeededAndNotify(requestId, logMessage, () -> this.myState.isLogMessage(), arg_0 -> this.myState.setLogMessage(arg_0));
    }

    public boolean isLogStack() {
        return ((BreakpointState)this.myState).isLogStack();
    }

    public void setLogStack(boolean logStack) {
        this.setLogStack(-1L, logStack);
    }

    public void setLogStack(long requestId, boolean logStack) {
        this.updateStateIfNeededAndNotify(requestId, logStack, () -> this.myState.isLogStack(), arg_0 -> this.myState.setLogStack(arg_0));
    }

    public boolean isConditionEnabled() {
        return this.myConditionEnabled;
    }

    public void setConditionEnabled(boolean conditionEnabled) {
        this.setConditionEnabled(-1L, conditionEnabled);
    }

    public void setConditionEnabled(long requestId, boolean conditionEnabled) {
        this.updateStateIfNeededAndNotify(requestId, conditionEnabled, this::isConditionEnabled, s -> {
            this.myConditionEnabled = s;
        });
    }

    public boolean isLogExpressionEnabled() {
        return this.myLogExpressionEnabled;
    }

    public void setLogExpressionEnabled(boolean logExpressionEnabled) {
        this.setLogExpressionEnabled(-1L, logExpressionEnabled);
    }

    public void setLogExpressionEnabled(long requestId, boolean logExpressionEnabled) {
        this.updateStateIfNeededAndNotify(requestId, logExpressionEnabled, this::isLogExpressionEnabled, s -> {
            this.myLogExpressionEnabled = s;
        });
    }

    public String getLogExpression() {
        XExpression expression = this.getLogExpressionObject();
        return expression != null ? expression.getExpression() : null;
    }

    public void setLogExpression(@Nullable String expression) {
        this.setLogExpression(-1L, expression);
    }

    public void setLogExpression(long requestId, @Nullable String expression) {
        this.updateStateIfNeededAndNotify(requestId, expression, this::getLogExpression, e -> {
            this.myLogExpression = XExpressionImpl.fromText(e);
        });
    }

    public XExpression getLogExpressionObjectInt() {
        return this.myLogExpression;
    }

    @Nullable
    public XExpression getLogExpressionObject() {
        return this.myLogExpressionEnabled ? this.myLogExpression : null;
    }

    public void setLogExpressionObject(@Nullable XExpression expression) {
        this.setLogExpressionObject(-1L, expression);
    }

    public void setLogExpressionObject(long requestId, @Nullable XExpression expression) {
        this.updateStateIfNeededAndNotify(requestId, expression, this::getLogExpressionObjectInt, e -> {
            this.myLogExpression = e;
        });
    }

    public String getCondition() {
        XExpression expression = this.getConditionExpression();
        return expression != null ? expression.getExpression() : null;
    }

    public void setCondition(@Nullable String condition) {
        this.setCondition(-1L, condition);
    }

    public void setCondition(long requestId, @Nullable String condition) {
        this.updateStateIfNeededAndNotify(requestId, condition, this::getCondition, c -> {
            this.myCondition = XExpressionImpl.fromText(c);
        });
    }

    public XExpression getConditionExpressionInt() {
        return this.myCondition;
    }

    @Nullable
    public XExpression getConditionExpression() {
        return this.myConditionEnabled ? this.myCondition : null;
    }

    public void setConditionExpression(@Nullable XExpression condition) {
        this.setConditionExpression(-1L, condition);
    }

    public void setConditionExpression(long requestId, @Nullable XExpression condition) {
        this.updateStateIfNeededAndNotify(requestId, condition, this::getConditionExpressionInt, c -> {
            this.myCondition = c;
        });
    }

    public long getTimeStamp() {
        return ((BreakpointState)this.myState).getTimeStamp();
    }

    @Deprecated
    public boolean isValid() {
        return true;
    }

    @Nullable
    public P getProperties() {
        return this.myProperties;
    }

    @NotNull
    public XBreakpointType<Self, P> getType() {
        XBreakpointType<Self, P> xBreakpointType = this.myType;
        if (xBreakpointType == null) {
            XBreakpointBase.$$$reportNull$$$0(5);
        }
        return xBreakpointType;
    }

    public S getState() {
        Object propertiesState = this.myProperties == null ? null : this.myProperties.getState();
        Element element = propertiesState == null ? null : XmlSerializer.serialize((Object)propertiesState);
        Element propertiesElement = element == null ? null : JDOMUtil.internElement((Element)element);
        ((BreakpointState)this.myState).setCondition(BreakpointState.Condition.create(!this.myConditionEnabled, this.myCondition));
        ((BreakpointState)this.myState).setLogExpression(BreakpointState.LogExpression.create(!this.myLogExpressionEnabled, this.myLogExpression));
        ((BreakpointState)this.myState).setPropertiesElement(propertiesElement);
        return this.myState;
    }

    public XBreakpointDependencyState getDependencyState() {
        return ((BreakpointState)this.myState).getDependencyState();
    }

    public void setDependencyState(XBreakpointDependencyState state) {
        if (((BreakpointState)this.myState).getDependencyState() != state) {
            ((BreakpointState)this.myState).setDependencyState(state);
            this.fireBreakpointChanged();
        }
    }

    @Nullable
    public String getGroup() {
        return ((BreakpointState)this.myState).getGroup();
    }

    public void setGroup(String group) {
        this.setGroup(-1L, group);
    }

    public void setGroup(long requestId, String group) {
        String newGroup = StringUtil.nullize((String)group);
        this.updateStateIfNeededAndNotify(requestId, newGroup, () -> this.myState.getGroup(), arg_0 -> this.myState.setGroup(arg_0));
    }

    @NlsSafe
    public String getUserDescription() {
        return ((BreakpointState)this.myState).getDescription();
    }

    public void setUserDescription(String description) {
        this.setUserDescription(-1L, description);
    }

    public void setUserDescription(long requestId, String description) {
        String newDescription = StringUtil.nullize((String)description);
        this.updateStateIfNeededAndNotify(requestId, newDescription, () -> this.myState.getDescription(), arg_0 -> this.myState.setDescription(arg_0));
    }

    public final void dispose() {
        this.myDisposed = true;
        kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null);
        this.doDispose();
    }

    protected void doDispose() {
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String toString() {
        return "XBreakpointBase(id = " + String.valueOf(this.myId) + ", type=" + String.valueOf(this.myType) + ")";
    }

    protected List<? extends AnAction> getAdditionalPopupMenuActions(XDebugSession session) {
        return this.getType().getAdditionalPopupMenuActions((XBreakpoint)this, session);
    }

    @NotNull
    @Nls
    public String getDescription() {
        XBreakpoint<?> masterBreakpoint;
        String logExpression;
        SuspendPolicy defaultSuspendPolicy;
        SuspendPolicy suspendPolicy;
        StringBuilder builder = new StringBuilder();
        builder.append("<html>").append("<body>");
        LineSeparator separator = new LineSeparator(builder);
        builder.append(StringUtil.escapeXmlEntities((String)XBreakpointUtil.getGeneralDescription(this)));
        int prePropertiesLen = builder.length();
        String errorMessage = this.getErrorMessage();
        if (!StringUtil.isEmpty((String)errorMessage)) {
            builder.append(separator.get());
            builder.append("<font color='#").append(ColorUtil.toHex((Color)JBColor.RED)).append("'>");
            builder.append(errorMessage);
            builder.append("</font>");
        }
        if ((suspendPolicy = this.getSuspendPolicy()) == SuspendPolicy.NONE) {
            builder.append(separator.get()).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.none", (Object[])new Object[0]));
        } else if (this.getType().isSuspendThreadSupported() && suspendPolicy != (defaultSuspendPolicy = this.myBreakpointManager.getBreakpointDefaults(this.getType()).getSuspendPolicy())) {
            builder.append(separator.get());
            switch (suspendPolicy) {
                case ALL: {
                    builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.all", (Object[])new Object[0]));
                    break;
                }
                case THREAD: {
                    builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.suspend.policy.thread", (Object[])new Object[0]));
                }
            }
        }
        String condition = this.getCondition();
        if (!StringUtil.isEmpty((String)condition)) {
            builder.append(separator.get());
            builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.condition", (Object[])new Object[0]));
            builder.append("&nbsp;");
            builder.append(XmlStringUtil.escapeString((String)condition));
        }
        if (this.isLogMessage()) {
            builder.append(separator.get()).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.message", (Object[])new Object[0]));
        }
        if (this.isLogStack()) {
            builder.append(separator.get()).append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.stack", (Object[])new Object[0]));
        }
        if (!StringUtil.isEmpty((String)(logExpression = this.getLogExpression()))) {
            builder.append(separator.get());
            builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.log.expression", (Object[])new Object[0]));
            builder.append("&nbsp;");
            builder.append(XmlStringUtil.escapeString((String)logExpression));
        }
        if ((masterBreakpoint = this.getBreakpointManager().getDependentBreakpointManager().getMasterBreakpoint(this)) != null) {
            builder.append(separator.get());
            String str = XDebuggerBundle.message((String)"xbreakpoint.tooltip.depends.on", (Object[])new Object[0]);
            builder.append(str);
            builder.append("&nbsp;");
            builder.append(XBreakpointUtil.getShortText(masterBreakpoint));
        }
        for (String line : XBreakpointUtil.getPropertyXMLDescriptions(this)) {
            builder.append(separator.get());
            builder.append(line);
        }
        if (prePropertiesLen == builder.length()) {
            builder.append(separator.get());
            builder.append(XDebuggerBundle.message((String)"xbreakpoint.tooltip.edit.hint", (Object[])new Object[0]));
        }
        builder.append("</body>").append("</html>");
        String string = builder.toString();
        if (string == null) {
            XBreakpointBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void updateIcon() {
        this.myIcon = XBreakpointBase.calculateIcon(XBreakpointProxyKt.asProxy(this));
    }

    @ApiStatus.Internal
    @NotNull
    public static Icon calculateIcon(@NotNull XBreakpointProxy breakpoint2) {
        Icon specialIcon;
        if (breakpoint2 == null) {
            XBreakpointBase.$$$reportNull$$$0(7);
        }
        Icon icon = (specialIcon = XBreakpointBase.calculateSpecialIcon(breakpoint2)) != null ? specialIcon : breakpoint2.getType().getEnabledIcon();
        return XBreakpointBase.withQuestionBadgeIfNeeded(icon, breakpoint2);
    }

    @NotNull
    private static Icon withQuestionBadgeIfNeeded(@NotNull Icon icon, @NotNull XBreakpointProxy breakpoint2) {
        if (icon == null) {
            XBreakpointBase.$$$reportNull$$$0(8);
        }
        if (breakpoint2 == null) {
            XBreakpointBase.$$$reportNull$$$0(9);
        }
        if (XDebuggerUtilImpl.isEmptyExpression(breakpoint2.getConditionExpression())) {
            Icon icon2 = icon;
            if (icon2 == null) {
                XBreakpointBase.$$$reportNull$$$0(10);
            }
            return icon2;
        }
        LayeredIcon newIcon = new LayeredIcon(2);
        newIcon.setIcon(icon, 0);
        int hShift = ExperimentalUI.isNewUI() ? 7 : 10;
        newIcon.setIcon(AllIcons.Debugger.Question_badge, 1, hShift, 6);
        JBScalableIcon jBScalableIcon = JBUIScale.scaleIcon((JBScalableIcon)newIcon);
        if (jBScalableIcon == null) {
            XBreakpointBase.$$$reportNull$$$0(11);
        }
        return jBScalableIcon;
    }

    @Nullable
    private static Icon calculateSpecialIcon(@NotNull XBreakpointProxy breakpoint2) {
        XLineBreakpointProxy lineBreakpoint;
        Icon icon;
        CustomizedBreakpointPresentation presentation;
        if (breakpoint2 == null) {
            XBreakpointBase.$$$reportNull$$$0(12);
        }
        @NotNull XBreakpointTypeProxy type = breakpoint2.getType();
        XDebugManagerProxy debugManager = XDebugManagerProxy.getInstance();
        XDebugSessionProxy session = debugManager.getCurrentSessionProxy(breakpoint2.getProject());
        XBreakpointManagerProxy breakpointManager = debugManager.getBreakpointManagerProxy(breakpoint2.getProject());
        if (!breakpoint2.isEnabled()) {
            if (session != null && session.areBreakpointsMuted()) {
                return type.getMutedDisabledIcon();
            }
            return type.getDisabledIcon();
        }
        if (session == null) {
            if (breakpointManager.getDependentBreakpointManager().getMasterBreakpoint(breakpoint2) != null) {
                return type.getInactiveDependentIcon();
            }
        } else {
            if (session.areBreakpointsMuted()) {
                return type.getMutedEnabledIcon();
            }
            if (session.isInactiveSlaveBreakpoint(breakpoint2)) {
                return type.getInactiveDependentIcon();
            }
            presentation = breakpoint2.getCustomizedPresentationForCurrentSession();
            if (presentation != null && (icon = presentation.getIcon()) != null) {
                return icon;
            }
        }
        if (breakpoint2.getSuspendPolicy() == SuspendPolicy.NONE) {
            return type.getSuspendNoneIcon();
        }
        presentation = breakpoint2.getCustomizedPresentation();
        if (presentation != null && (icon = presentation.getIcon()) != null) {
            return icon;
        }
        if (breakpoint2 instanceof XLineBreakpointProxy && (lineBreakpoint = (XLineBreakpointProxy)breakpoint2).isTemporary() && lineBreakpoint.getType().getTemporaryIcon() != null) {
            return lineBreakpoint.getType().getTemporaryIcon();
        }
        return null;
    }

    public Icon getIcon() {
        if (this.myIcon == null) {
            this.updateIcon();
        }
        return this.myIcon;
    }

    @Nullable
    public String getErrorMessage() {
        String message;
        CustomizedBreakpointPresentation presentation;
        XDebugSessionImpl currentSession = this.getBreakpointManager().getDebuggerManager().getCurrentSession();
        if (currentSession != null && (presentation = currentSession.getBreakpointPresentation(this)) != null && (message = presentation.getErrorMessage()) != null) {
            return message;
        }
        return this.myCustomizedPresentation != null ? this.myCustomizedPresentation.getErrorMessage() : null;
    }

    @ApiStatus.Internal
    public CustomizedBreakpointPresentation getCustomizedPresentation() {
        return this.myCustomizedPresentation;
    }

    public void setCustomizedPresentation(CustomizedBreakpointPresentation presentation) {
        this.myCustomizedPresentation = presentation;
    }

    @NotNull
    public GutterIconRenderer createGutterIconRenderer() {
        return new BreakpointGutterIconRenderer(XBreakpointProxyKt.asProxy(this));
    }

    public void clearIcon() {
        this.myIcon = null;
    }

    @Override
    public int compareTo(@NotNull Self self) {
        if (self == null) {
            XBreakpointBase.$$$reportNull$$$0(13);
        }
        return this.myType.getBreakpointComparator().compare(this, self);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 7, 8, 9, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendPolicy";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withQuestionBadgeIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSuspendPolicy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateIcon";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withQuestionBadgeIfNeeded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateSpecialIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 7, 8, 9, 12, 13 -> new IllegalArgumentException(string);
        };
    }

    private static class LineSeparator {
        private final StringBuilder myBuilder;
        private final int myEmptyLength;
        private final String mySeparator;
        private boolean myGetSeparator;

        private LineSeparator(@NotNull StringBuilder builder) {
            if (builder == null) {
                LineSeparator.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder;
            this.myEmptyLength = builder.length();
            this.mySeparator = ExperimentalUI.isNewUI() && !ApplicationManager.getApplication().isUnitTestMode() ? "<br>" : XBreakpointBase.BR_NBSP;
        }

        @NonNls
        public String get() {
            if (this.myGetSeparator) {
                return this.mySeparator;
            }
            this.myGetSeparator = true;
            return this.myBuilder.length() > this.myEmptyLength ? this.mySeparator : "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/xdebugger/impl/breakpoints/XBreakpointBase$LineSeparator", "<init>"));
        }
    }
}

