/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorMouseHoverPopupManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredComponentWithProgress;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerDocumentOffsetEvaluator;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackWithOrigin;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Component;
import java.awt.Point;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(XValueHint.class);
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final int myOffset;
    private final XDebuggerEvaluator myEvaluator;
    private final XSourcePosition myPosition;
    private final boolean myFromKeyboard;
    private final String myExpression;
    private final String myValueName;
    private final XSourcePosition myExpressionPosition;
    private final boolean myIsManualSelection;
    private Disposable myDisposable;
    private final XValueMarkers<?, ?> myValueMarkers;

    @ApiStatus.Internal
    public XValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, int offset, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @NotNull XDebugSession session, boolean fromKeyboard) {
        if (project == null) {
            XValueHint.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XValueHint.$$$reportNull$$$0(1);
        }
        if (point == null) {
            XValueHint.$$$reportNull$$$0(2);
        }
        if (type == null) {
            XValueHint.$$$reportNull$$$0(3);
        }
        if (expressionInfo == null) {
            XValueHint.$$$reportNull$$$0(4);
        }
        if (evaluator == null) {
            XValueHint.$$$reportNull$$$0(5);
        }
        if (session == null) {
            XValueHint.$$$reportNull$$$0(6);
        }
        this(project, session.getDebugProcess().getEditorsProvider(), editor, point, type, offset, expressionInfo, evaluator, ((XDebugSessionImpl)session).getValueMarkers(), session.getCurrentPosition(), fromKeyboard);
    }

    @ApiStatus.Internal
    public XValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, int offset, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @NotNull XDebugSessionProxy sessionProxy, boolean fromKeyboard) {
        if (project == null) {
            XValueHint.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            XValueHint.$$$reportNull$$$0(8);
        }
        if (point == null) {
            XValueHint.$$$reportNull$$$0(9);
        }
        if (type == null) {
            XValueHint.$$$reportNull$$$0(10);
        }
        if (expressionInfo == null) {
            XValueHint.$$$reportNull$$$0(11);
        }
        if (evaluator == null) {
            XValueHint.$$$reportNull$$$0(12);
        }
        if (sessionProxy == null) {
            XValueHint.$$$reportNull$$$0(13);
        }
        this(project, sessionProxy.getEditorsProvider(), editor, point, type, offset, expressionInfo, evaluator, sessionProxy.getValueMarkers(), sessionProxy.getCurrentPosition(), fromKeyboard);
    }

    @ApiStatus.Internal
    public XValueHint(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, int offset, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, boolean fromKeyboard) {
        if (project == null) {
            XValueHint.$$$reportNull$$$0(14);
        }
        if (editorsProvider == null) {
            XValueHint.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            XValueHint.$$$reportNull$$$0(16);
        }
        if (point == null) {
            XValueHint.$$$reportNull$$$0(17);
        }
        if (type == null) {
            XValueHint.$$$reportNull$$$0(18);
        }
        if (expressionInfo == null) {
            XValueHint.$$$reportNull$$$0(19);
        }
        if (evaluator == null) {
            XValueHint.$$$reportNull$$$0(20);
        }
        this(project, editorsProvider, editor, point, type, offset, expressionInfo, evaluator, null, null, fromKeyboard);
    }

    private XValueHint(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, int offset, @NotNull ExpressionInfo expressionInfo, @NotNull XDebuggerEvaluator evaluator, @Nullable XValueMarkers<?, ?> valueMarkers, @Nullable XSourcePosition expressionPosition, boolean fromKeyboard) {
        LanguageConsoleView console;
        if (project == null) {
            XValueHint.$$$reportNull$$$0(21);
        }
        if (editorsProvider == null) {
            XValueHint.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            XValueHint.$$$reportNull$$$0(23);
        }
        if (point == null) {
            XValueHint.$$$reportNull$$$0(24);
        }
        if (type == null) {
            XValueHint.$$$reportNull$$$0(25);
        }
        if (expressionInfo == null) {
            XValueHint.$$$reportNull$$$0(26);
        }
        if (evaluator == null) {
            XValueHint.$$$reportNull$$$0(27);
        }
        super(project, editor, point, type, expressionInfo.getTextRange());
        this.myEditorsProvider = editorsProvider;
        this.myOffset = offset;
        this.myEvaluator = evaluator;
        this.myValueMarkers = valueMarkers;
        this.myPosition = expressionPosition;
        this.myFromKeyboard = fromKeyboard;
        this.myIsManualSelection = expressionInfo.isManualSelection();
        this.myExpression = XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument());
        this.myValueName = XDebuggerEvaluateActionHandler.getDisplayText(expressionInfo, editor.getDocument());
        ConsoleView consoleView = (ConsoleView)ConsoleViewImpl.CONSOLE_VIEW_IN_EDITOR_VIEW.get((UserDataHolder)editor);
        VirtualFile file = consoleView instanceof LanguageConsoleView ? ((console = (LanguageConsoleView)consoleView).getHistoryViewer() == editor ? console.getVirtualFile() : null) : FileDocumentManager.getInstance().getFile(editor.getDocument());
        this.myExpressionPosition = file != null ? XDebuggerUtil.getInstance().createPositionByOffset(file, expressionInfo.getTextRange().getStartOffset()) : null;
    }

    @Override
    protected void onHintHidden() {
        this.disposeVisibleHint();
    }

    @Override
    public void hideHint() {
        super.hideHint();
        this.disposeVisibleHint();
    }

    @Override
    protected void evaluateAndShowHint() {
        XDebuggerEvaluator xDebuggerEvaluator;
        AtomicBoolean showEvaluating = new AtomicBoolean(true);
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
            if (!this.isHintHidden() && !this.isShowing() && showEvaluating.get()) {
                SimpleColoredComponent component = HintUtil.createInformationComponent();
                component.append(XDebuggerUIConstants.getEvaluatingExpressionMessage());
                this.showHint((JComponent)component);
            }
        }, 200L, TimeUnit.MILLISECONDS);
        MyEvaluationCallback callback = new MyEvaluationCallback(showEvaluating);
        if (!this.myIsManualSelection && (xDebuggerEvaluator = this.myEvaluator) instanceof XDebuggerDocumentOffsetEvaluator) {
            XDebuggerDocumentOffsetEvaluator xDebuggerPsiEvaluator = (XDebuggerDocumentOffsetEvaluator)xDebuggerEvaluator;
            xDebuggerPsiEvaluator.evaluate(this.myEditor.getDocument(), this.myOffset, this.myType, callback);
        } else {
            this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)callback, this.myExpressionPosition);
        }
    }

    @NotNull
    protected JComponent createHintComponent(@Nullable Icon icon, @NotNull SimpleColoredText text, @NotNull XValuePresentation presentation, @Nullable XFullValueEvaluator evaluator) {
        if (text == null) {
            XValueHint.$$$reportNull$$$0(28);
        }
        if (presentation == null) {
            XValueHint.$$$reportNull$$$0(29);
        }
        BorderLayoutPanel panel2 = (BorderLayoutPanel)HintUtil.installInformationProperties((Component)new BorderLayoutPanel());
        SimpleColoredComponent component = HintUtil.createInformationComponent();
        component.setIcon(icon);
        text.appendToComponent((ColoredTextContainer)component);
        panel2.add((Component)component);
        if (evaluator != null) {
            SimpleColoredComponent evaluationLinkComponent = new SimpleColoredComponent();
            this.appendEvaluatorLink(evaluator, evaluationLinkComponent);
            LinkMouseListenerBase.installSingleTagOn((SimpleColoredComponent)evaluationLinkComponent);
            panel2.addToRight((Component)evaluationLinkComponent);
        }
        BorderLayoutPanel borderLayoutPanel = panel2;
        if (borderLayoutPanel == null) {
            XValueHint.$$$reportNull$$$0(30);
        }
        return borderLayoutPanel;
    }

    private void disposeVisibleHint() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void showTree(@NotNull XValue value) {
        if (value == null) {
            XValueHint.$$$reportNull$$$0(31);
        }
        this.showTreePopup(this.getTreeCreator(), Pair.create((Object)value, (Object)this.myValueName));
    }

    private XDebuggerTreeCreator getTreeCreator() {
        return new XDebuggerTreeCreator(this, this.getProject(), this.myEditorsProvider, this.myPosition, this.myValueMarkers){

            @Override
            @NotNull
            public String getTitle(@NotNull Pair<XValue, String> descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$1", "getTitle"));
            }
        };
    }

    private Runnable getShowPopupRunnable(@NotNull XValue value, @Nullable XFullValueEvaluator evaluator) {
        XValueTextProvider textValue;
        if (value == null) {
            XValueHint.$$$reportNull$$$0(32);
        }
        if (value instanceof XValueTextProvider && (textValue = (XValueTextProvider)value).shouldShowTextValue()) {
            @NotNull String initialText = StringUtil.notNullize((String)textValue.getValueText());
            return () -> this.showTextPopup(this.getTreeCreator(), (Pair<XValue, String>)Pair.create((Object)value, (Object)this.myValueName), initialText, evaluator);
        }
        return () -> this.showTree(value);
    }

    public String toString() {
        return this.myExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 10: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionInfo";
                break;
            }
            case 5: 
            case 12: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionProxy";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorsProvider";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showTree";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getShowPopupRunnable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 30 -> new IllegalStateException(string);
        };
    }

    private class MyEvaluationCallback
    extends XEvaluationCallbackBase
    implements XEvaluationCallbackWithOrigin {
        private final AtomicBoolean myShowEvaluating;

        MyEvaluationCallback(AtomicBoolean showEvaluating) {
            this.myShowEvaluating = showEvaluating;
        }

        @Override
        public XEvaluationOrigin getOrigin() {
            return XEvaluationOrigin.EDITOR;
        }

        public void evaluated(final @NotNull XValue result2) {
            if (result2 == null) {
                MyEvaluationCallback.$$$reportNull$$$0(0);
            }
            result2.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){
                private XFullValueEvaluator myFullValueEvaluator;
                private boolean myShown = false;
                private SimpleColoredComponent mySimpleColoredComponent;

                @Override
                public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                    if (valuePresenter == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyEvaluationCallback.this.myShowEvaluating.set(false);
                    if (XValueHint.this.isHintHidden()) {
                        return;
                    }
                    SimpleColoredText text = new SimpleColoredText();
                    XValueNodeImpl.buildText(valuePresenter, (ColoredTextContainer)text, false);
                    if (!hasChildren) {
                        XValueHint.this.showTooltipPopup(XValueHint.this.createHintComponent(icon, text, valuePresenter, this.myFullValueEvaluator));
                    } else if (XValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                        if (!this.myShown) {
                            Runnable showPopupRunnable = XValueHint.this.getShowPopupRunnable(result2, this.myFullValueEvaluator);
                            showPopupRunnable.run();
                        }
                    } else {
                        if (XValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                            if (XValueHint.this.myFromKeyboard) {
                                text.insert(0, "(" + KeymapUtil.getFirstKeyboardShortcutText((String)"ShowErrorDescription") + ") ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                            }
                            XValueHint.this.disposeVisibleHint();
                            XValueHint.this.myDisposable = Disposer.newDisposable();
                            ShortcutSet shortcut = KeymapUtil.getActiveKeymapShortcuts((String)"ShowErrorDescription");
                            DumbAwareAction.create(e -> XValueHint.this.showTree(result2)).registerCustomShortcutSet(shortcut, XValueHint.this.getEditor().getContentComponent(), XValueHint.this.myDisposable);
                        }
                        if (this.mySimpleColoredComponent != null) {
                            if (this.mySimpleColoredComponent instanceof SimpleColoredComponentWithProgress) {
                                ((SimpleColoredComponentWithProgress)this.mySimpleColoredComponent).stopLoading();
                            }
                            Icon previousIcon = this.mySimpleColoredComponent.getIcon();
                            int previousPreferredWidth = this.mySimpleColoredComponent.getPreferredSize().width;
                            this.mySimpleColoredComponent.clear();
                            XValueHint.this.fillSimpleColoredComponent(this.mySimpleColoredComponent, previousIcon, text, this.myFullValueEvaluator);
                            int delta = this.mySimpleColoredComponent.getPreferredSize().width - previousPreferredWidth;
                            if (delta < 0) {
                                return;
                            }
                            XValueHint.this.resizePopup(delta, 0);
                            return;
                        }
                        this.mySimpleColoredComponent = XValueHint.this.createExpandableHintComponent(icon, text, XValueHint.this.getShowPopupRunnable(result2, this.myFullValueEvaluator), this.myFullValueEvaluator, valuePresenter);
                        if (this.mySimpleColoredComponent instanceof SimpleColoredComponentWithProgress) {
                            ((SimpleColoredComponentWithProgress)this.mySimpleColoredComponent).startLoading();
                        }
                        XValueHint.this.showTooltipPopup((JComponent)this.mySimpleColoredComponent);
                    }
                    this.myShown = true;
                }

                @Override
                public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                    if (fullValueEvaluator == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.myFullValueEvaluator = fullValueEvaluator;
                }

                public boolean isObsolete() {
                    return XValueHint.this.isHintHidden();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "valuePresenter";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fullValueEvaluator";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$MyEvaluationCallback$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applyPresentation";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setFullValueEvaluator";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, XValuePlace.TOOLTIP);
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                MyEvaluationCallback.$$$reportNull$$$0(1);
            }
            this.myShowEvaluating.set(false);
            ApplicationManager.getApplication().invokeLater(() -> {
                switch (XValueHint.this.getType()) {
                    case MOUSE_CLICK_HINT: {
                        XValueHint.this.showHint(HintUtil.createErrorLabel((String)errorMessage));
                        break;
                    }
                    case MOUSE_OVER_HINT: {
                        XValueHint.this.hideCurrentHint();
                        EditorMouseEvent event = XValueHint.this.getEditorMouseEvent();
                        if (event == null) break;
                        EditorMouseHoverPopupManager.getInstance().showInfoTooltip(event);
                        break;
                    }
                    default: {
                        XValueHint.this.hideCurrentHint();
                    }
                }
            });
            LOG.debug("Cannot evaluate '" + XValueHint.this.myExpression + "':" + errorMessage);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/XValueHint$MyEvaluationCallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

