/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class DebuggerTreeWithHistoryContainer<D> {
    private static final Logger LOG = Logger.getInstance(DebuggerTreeWithHistoryContainer.class);
    private static final int HISTORY_SIZE = 11;
    private final List<D> myHistory;
    private int myCurrentIndex;
    protected final DebuggerTreeCreator<D> myTreeCreator;
    @NotNull
    protected final Project myProject;

    protected DebuggerTreeWithHistoryContainer(@NotNull D initialItem, @NotNull DebuggerTreeCreator<D> creator, @NotNull Project project) {
        if (initialItem == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(2);
        }
        this.myHistory = new ArrayList<D>();
        this.myCurrentIndex = -1;
        this.myTreeCreator = creator;
        this.myProject = project;
        this.myHistory.add(initialItem);
    }

    protected BorderLayoutPanel createMainPanel(Tree tree) {
        return this.fillMainPanel(JBUI.Panels.simplePanel(), tree);
    }

    protected BorderLayoutPanel fillMainPanel(BorderLayoutPanel mainPanel, Tree tree) {
        JComponent toolbar = this.createToolbar((JPanel)mainPanel, tree);
        tree.setBackground(UIUtil.getToolTipBackground());
        toolbar.setBackground(UIUtil.getToolTipActionBackground());
        new WindowMoveListener((Component)mainPanel).installTo((Component)toolbar);
        return mainPanel.addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)tree, (boolean)true)).addToBottom((Component)toolbar);
    }

    private void updateTree() {
        D item = this.myHistory.get(this.myCurrentIndex);
        this.updateTree(item);
    }

    protected void updateTree(@NotNull D selectedItem) {
        if (selectedItem == null) {
            DebuggerTreeWithHistoryContainer.$$$reportNull$$$0(3);
        }
        this.updateContainer(this.myTreeCreator.createTree(selectedItem), this.myTreeCreator.getTitle(selectedItem));
    }

    protected abstract void updateContainer(Tree var1, String var2);

    protected void addToHistory(D item) {
        if (this.myCurrentIndex < 11) {
            this.myCurrentIndex = this.myCurrentIndex != -1 ? ++this.myCurrentIndex : 1;
            this.myHistory.add(this.myCurrentIndex, item);
        }
    }

    protected JComponent createToolbar(JPanel parent, Tree tree) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SetAsRootAction(tree));
        GoBackwardAction back = new GoBackwardAction();
        back.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(37, 8)), parent);
        group.add((AnAction)back);
        GoForwardAction forward = new GoForwardAction();
        forward.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(39, 8)), parent);
        group.add((AnAction)forward);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DebuggerTreeWithHistory", (ActionGroup)group, true);
        toolbar.setTargetComponent((JComponent)tree);
        return toolbar.getComponent();
    }

    protected static void registerTreeDisposable(Disposable disposable, Tree tree) {
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)disposable, (Disposable)((Disposable)tree));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialItem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedItem";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SetAsRootAction
    extends AnAction {
        private final Tree myTree;

        SetAsRootAction(Tree tree) {
            super(XDebuggerBundle.message((String)"xdebugger.popup.value.tree.set.root.action.tooltip", (Object[])new Object[0]), XDebuggerBundle.message((String)"xdebugger.popup.value.tree.set.root.action.tooltip", (Object[])new Object[0]), AllIcons.Modules.UnmarkWebroot);
            this.myTree = tree;
        }

        public void update(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                SetAsRootAction.$$$reportNull$$$0(0);
            }
            boolean enabled = (path = this.myTree.getSelectionPath()) != null && path.getPathCount() > (this.myTree.isRootVisible() ? 1 : 2);
            Object component = this.myTree.getLastSelectedPathComponent();
            if (enabled && component instanceof XValueNodeImpl) {
                enabled = !((XValueNodeImpl)component).isLeaf();
            }
            e.getPresentation().setEnabled(enabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SetAsRootAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                SetAsRootAction.$$$reportNull$$$0(2);
            }
            if ((path = this.myTree.getSelectionPath()) != null) {
                Object node = path.getLastPathComponent();
                DebuggerTreeWithHistoryContainer.this.myTreeCreator.createDescriptorByNode(node, new ResultConsumer<D>(){

                    public void onSuccess(D value) {
                        if (value != null) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                DebuggerTreeWithHistoryContainer.this.addToHistory(value);
                                DebuggerTreeWithHistoryContainer.this.updateTree(value);
                            });
                        }
                    }

                    public void onFailure(@NotNull Throwable t) {
                        if (t == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        LOG.debug(t);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$SetAsRootAction$1", "onFailure"));
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$SetAsRootAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$SetAsRootAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class GoBackwardAction
    extends AnAction {
        GoBackwardAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.back", (Object[])new Object[0]), AllIcons.Actions.Back);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoBackwardAction.$$$reportNull$$$0(0);
            }
            if (DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex > 0) {
                --DebuggerTreeWithHistoryContainer.this.myCurrentIndex;
                DebuggerTreeWithHistoryContainer.this.updateTree();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoBackwardAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex > 0);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GoBackwardAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$GoBackwardAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$GoBackwardAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class GoForwardAction
    extends AnAction {
        GoForwardAction() {
            super(CodeInsightBundle.messagePointer((String)"quick.definition.forward", (Object[])new Object[0]), AllIcons.Actions.Forward);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoForwardAction.$$$reportNull$$$0(0);
            }
            if (DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex < DebuggerTreeWithHistoryContainer.this.myHistory.size() - 1) {
                ++DebuggerTreeWithHistoryContainer.this.myCurrentIndex;
                DebuggerTreeWithHistoryContainer.this.updateTree();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoForwardAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(DebuggerTreeWithHistoryContainer.this.myHistory.size() > 1 && DebuggerTreeWithHistoryContainer.this.myCurrentIndex < DebuggerTreeWithHistoryContainer.this.myHistory.size() - 1);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GoForwardAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$GoForwardAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryContainer$GoForwardAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

