/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.HighlightingPassesCache;
import com.intellij.icons.AllIcons;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebuggerActionsCollector;
import com.intellij.xdebugger.impl.frame.HiddenFramesStackFrame;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxyKeeperKt;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerEmbeddedComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import kotlin.jvm.functions.Function0;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class XFramesView
extends XDebugView {
    private static final Logger LOG = Logger.getInstance(XFramesView.class);
    private final Project myProject;
    @NotNull
    private final WeakReference<XDebugSessionProxy> mySessionRef;
    private final JPanel myMainPanel;
    private final XDebuggerFramesList myFramesList;
    private final JScrollPane myScrollPane;
    private final ComboBox<XExecutionStack> myThreadComboBox;
    private final Map<XExecutionStack, XStackFrame> myExecutionStacksWithSelection;
    private final AutoScrollToSourceHandler myFrameSelectionHandler;
    private XExecutionStack mySelectedStack;
    private XStackFrame mySelectedFrame;
    private Rectangle myVisibleRect;
    private boolean myListenersEnabled;
    private final Map<XExecutionStack, StackFramesListBuilder> myBuilders;
    private final Wrapper myThreadsPanel;
    private boolean myThreadsCalculated;
    private boolean myRefresh;

    public XFramesView(@NotNull XDebugSession session) {
        if (session == null) {
            XFramesView.$$$reportNull$$$0(0);
        }
        this(XDebugSessionProxyKeeperKt.asProxy(session));
    }

    public XFramesView(final @NotNull XDebugSessionProxy sessionProxy) {
        if (sessionProxy == null) {
            XFramesView.$$$reportNull$$$0(1);
        }
        this.myExecutionStacksWithSelection = new HashMap<XExecutionStack, XStackFrame>();
        this.myBuilders = new HashMap<XExecutionStack, StackFramesListBuilder>();
        this.myProject = sessionProxy.getProject();
        this.mySessionRef = new WeakReference<XDebugSessionProxy>(sessionProxy);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myFrameSelectionHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return XFramesView.this.myListenersEnabled;
            }

            protected void setAutoScrollMode(boolean state) {
            }

            protected boolean needToCheckFocus() {
                return false;
            }

            @RequiresEdt
            protected void scrollToSource(@NotNull Component list) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                ThreadingAssertions.assertEventDispatchThread();
                if (XFramesView.this.myListenersEnabled) {
                    XFramesView.this.processFrameSelection(XFramesView.this.getSession(), true, XFramesView.this.myRefresh);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/xdebugger/impl/frame/XFramesView$1", "scrollToSource"));
            }
        };
        this.myFramesList = new XDebuggerFramesList(this.myProject, sessionProxy){

            @Override
            @NotNull
            protected OccurenceNavigator.OccurenceInfo goOccurrence(int step) {
                OccurenceNavigator.OccurenceInfo info = super.goOccurrence(step);
                ScrollingUtil.ensureIndexIsVisible((JList)((Object)this), (int)this.getSelectedIndex(), (int)step);
                OccurenceNavigator.OccurenceInfo occurenceInfo = info;
                if (occurenceInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                return occurenceInfo;
            }

            @Override
            @NotNull
            protected Navigatable getFrameNavigatable(@NotNull XStackFrame frame, boolean isMainSourceKindPreferred) {
                XSourcePosition position;
                if (frame == null) {
                    2.$$$reportNull$$$0(1);
                }
                final Navigatable navigatable = (position = this.getFrameSourcePosition(frame, isMainSourceKindPreferred)) != null ? position.createNavigatable(sessionProxy.getProject()) : null;
                return new NavigatableAdapter(){

                    public void navigate(boolean requestFocus) {
                        if (navigatable != null && navigatable.canNavigate()) {
                            navigatable.navigate(requestFocus);
                        }
                        XFramesView.this.handleFrameSelection();
                    }
                };
            }

            @Nullable
            private XSourcePosition getFrameSourcePosition(@NotNull XStackFrame frame, boolean isMainSourceKindPreferred) {
                XSourcePosition position;
                if (frame == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (isMainSourceKindPreferred && (position = frame.getSourcePosition()) != null) {
                    return position;
                }
                return sessionProxy.getFrameSourcePosition(frame);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xdebugger/impl/frame/XFramesView$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "frame";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "goOccurrence";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getFrameNavigatable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getFrameSourcePosition";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        XFramesView.installSpeedSearch(this.myFramesList);
        this.myFrameSelectionHandler.install((JList)((Object)this.myFramesList));
        EditSourceOnDoubleClickHandler.install((JList)((Object)this.myFramesList));
        this.myFramesList.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int i = XFramesView.this.myFramesList.locationToIndex(new Point(x, y));
                if (i != -1) {
                    XFramesView.this.myFramesList.selectFrame(i);
                }
                ActionManager actionManager = ActionManager.getInstance();
                ActionGroup group = (ActionGroup)actionManager.getAction("XDebugger.Frames.Tree.Popup");
                actionManager.createActionPopupMenu("XDebuggerFramesList", group).getComponent().show(comp, x, y);
            }
        });
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myFramesList), (boolean)true);
        JComponent centerComponent = DebuggerUIUtil.wrapWithAntiFlickeringPanel(this.myScrollPane);
        this.myMainPanel.add((Component)centerComponent, "Center");
        this.myThreadComboBox = new XDebuggerEmbeddedComboBox<XExecutionStack>();
        this.myThreadComboBox.setSwingPopup(false);
        this.myThreadComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value != null) {
                label.setText(value.getDisplayName());
                label.setIcon(value.getIcon());
            } else if (index >= 0) {
                label.setText(CommonBundle.getLoadingTreeNodeText());
            }
        }));
        this.myThreadComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XDebugSessionProxy session;
                Object item;
                if (!XFramesView.this.myListenersEnabled) {
                    return;
                }
                if (e.getStateChange() == 1 && (item = e.getItem()) != XFramesView.this.mySelectedStack && item instanceof XExecutionStack && (session = XFramesView.this.getSession()) != null) {
                    XFramesView.this.myRefresh = false;
                    XFramesView.this.updateFrames((XExecutionStack)item, session, null, false);
                    XDebuggerActionsCollector.threadSelected.log((Object)"framesView");
                }
            }
        });
        this.myThreadComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            ThreadsBuilder myBuilder;

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.stopBuilder();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                this.stopBuilder();
            }

            private void stopBuilder() {
                if (this.myBuilder != null) {
                    this.myBuilder.setObsolete();
                    this.myBuilder = null;
                }
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                XDebugSessionProxy session = XFramesView.this.getSession();
                if (session == null || !session.hasSuspendContext() || XFramesView.this.myThreadsCalculated) {
                    return;
                }
                this.myBuilder = new ThreadsBuilder();
                session.computeExecutionStacks((Function0<? extends XSuspendContext.XExecutionStackContainer>)((Function0)() -> this.myBuilder));
            }
        });
        ActionToolbarImpl toolbar = this.createToolbar();
        this.myThreadsPanel = new Wrapper();
        toolbar.setOpaque(false);
        ((XDebuggerEmbeddedComboBox)this.myThreadComboBox).setExtension((JComponent)toolbar);
        this.myMainPanel.add((Component)this.myThreadsPanel, "North");
        this.myMainPanel.setFocusCycleRoot(true);
        this.myMainPanel.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusPolicy()));
        XFramesView.addFramesNavigationAd(this.myMainPanel);
    }

    private static void installSpeedSearch(XDebuggerFramesList framesList) {
        ListSpeedSearch.installOn((JList)((Object)framesList), obj -> {
            if (obj instanceof XStackFrame) {
                XStackFrame frame = (XStackFrame)obj;
                return XFramesView.getStackFramePresentableText(frame);
            }
            return null;
        });
    }

    @NotNull
    private static String getStackFramePresentableText(XStackFrame frame) {
        StringBuilderTextContainer builder = new StringBuilderTextContainer();
        frame.customizePresentation((ColoredTextContainer)builder);
        String string = builder.getText();
        if (string == null) {
            XFramesView.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void onFrameSelectionKeyPressed(final @NotNull Consumer<? super XStackFrame> handler) {
        if (handler == null) {
            XFramesView.$$$reportNull$$$0(3);
        }
        this.myFramesList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10 || key == 32 || key == 39) {
                    XFramesView.this.handleFrameSelection();
                    ApplicationManager.getApplication().invokeLater(() -> handler.accept(XFramesView.this.myFramesList.getSelectedFrame()));
                }
            }
        });
    }

    private void handleFrameSelection() {
        this.myFrameSelectionHandler.onMouseClicked((Component)((Object)this.myFramesList));
    }

    @Nullable
    @NlsSafe
    private static String getShortcutText(@NotNull @NonNls String actionId) {
        KeyboardShortcut shortcut;
        if (actionId == null) {
            XFramesView.$$$reportNull$$$0(4);
        }
        if ((shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId)) == null) {
            return null;
        }
        return KeymapUtil.getShortcutText((Shortcut)shortcut);
    }

    public XDebuggerFramesList getFramesList() {
        return this.myFramesList;
    }

    private ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        framesGroup.addAll(new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")});
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setTargetComponent((JComponent)((Object)this.myFramesList));
        return toolbar;
    }

    private StackFramesListBuilder getOrCreateBuilder(XExecutionStack executionStack, XDebugSessionProxy sessionProxy) {
        return this.myBuilders.computeIfAbsent(executionStack, k -> new StackFramesListBuilder(executionStack, sessionProxy));
    }

    private void withCurrentBuilder(Consumer<? super StackFramesListBuilder> consumer) {
        StackFramesListBuilder builder = this.myBuilders.get(this.mySelectedStack);
        if (builder != null) {
            consumer.accept(builder);
        }
    }

    @Override
    protected void sessionStopped() {
        this.myFramesList.sessionStopped();
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSessionProxy session) {
        if (event == null) {
            XFramesView.$$$reportNull$$$0(5);
        }
        if (session == null) {
            XFramesView.$$$reportNull$$$0(6);
        }
        boolean bl = this.myRefresh = event == XDebugView.SessionEvent.SETTINGS_CHANGED;
        if (event == XDebugView.SessionEvent.STOPPED) {
            this.sessionStopped();
            this.mySessionRef.clear();
        }
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            if (DebuggerUIUtil.freezePaintingToReduceFlickering(this.myScrollPane.getParent())) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    this.myScrollPane.getHorizontalScrollBar().setValue(0);
                    this.myScrollPane.getVerticalScrollBar().setValue(0);
                });
            }
            return;
        }
        XExecutionStack currentExecutionStack = session.getCurrentExecutionStack();
        XStackFrame currentStackFrame = session.getCurrentStackFrame();
        boolean hasSuspendContext = session.hasSuspendContext();
        if (event == XDebugView.SessionEvent.FRAME_CHANGED && Objects.equals(this.mySelectedStack, currentExecutionStack)) {
            ThreadingAssertions.assertEventDispatchThread();
            if (currentStackFrame != null) {
                this.myFramesList.setSelectedValue(currentStackFrame, true);
                this.mySelectedFrame = currentStackFrame;
                this.myExecutionStacksWithSelection.put(this.mySelectedStack, currentStackFrame);
            }
            return;
        }
        EdtExecutorService.getInstance().execute(() -> {
            StackFramesListBuilder previousBuilder;
            boolean shouldRefresh;
            if (event != XDebugView.SessionEvent.SETTINGS_CHANGED) {
                this.mySelectedFrame = null;
                this.mySelectedStack = null;
                this.myVisibleRect = null;
            } else {
                this.myVisibleRect = this.myFramesList.getVisibleRect();
            }
            boolean bl = shouldRefresh = event == XDebugView.SessionEvent.SETTINGS_CHANGED;
            if (shouldRefresh && this.mySelectedStack != null && (previousBuilder = this.myBuilders.get(this.mySelectedStack)) != null && previousBuilder.myRunning && !previousBuilder.myRefresh) {
                shouldRefresh = false;
            }
            this.myListenersEnabled = false;
            this.myBuilders.values().forEach(StackFramesListBuilder::dispose);
            this.myBuilders.clear();
            if (!hasSuspendContext) {
                this.requestClear();
                return;
            }
            if (event == XDebugView.SessionEvent.PAUSED) {
                this.cancelClear();
                this.clear();
            }
            XExecutionStack activeExecutionStack = this.mySelectedStack != null ? this.mySelectedStack : currentExecutionStack;
            this.addExecutionStacks(Collections.singletonList(activeExecutionStack), false);
            this.myThreadComboBox.setSelectedItem((Object)activeExecutionStack);
            boolean invisible = activeExecutionStack == null || StringUtil.isEmpty((String)activeExecutionStack.getDisplayName());
            if (invisible != (this.myThreadComboBox.getParent() == null)) {
                if (invisible) {
                    this.myThreadsPanel.remove(this.myThreadComboBox);
                    this.myThreadsPanel.setBorder(null);
                } else {
                    this.myThreadsPanel.add(this.myThreadComboBox, (Object)"Center");
                    this.myThreadsPanel.setBorder((Border)new CustomLineBorder(0, 0, 1, 0));
                }
                this.myThreadsPanel.revalidate();
            }
            this.updateFrames(activeExecutionStack, session, (XStackFrame)(event == XDebugView.SessionEvent.FRAME_CHANGED ? currentStackFrame : null), shouldRefresh);
        });
    }

    @Override
    protected void clear() {
        this.myThreadComboBox.removeAllItems();
        this.myFramesList.clear();
        this.myThreadsCalculated = false;
        this.myExecutionStacksWithSelection.clear();
    }

    private boolean addExecutionStacks(List<? extends XExecutionStack> executionStacks, boolean addBeforeSelection) {
        int count = this.myThreadComboBox.getItemCount();
        boolean loading = count > 0 && this.myThreadComboBox.getItemAt(count - 1) == null;
        Object selectedItem = this.myThreadComboBox.getSelectedItem();
        for (XExecutionStack xExecutionStack : executionStacks) {
            if (addBeforeSelection && xExecutionStack.equals(selectedItem)) {
                addBeforeSelection = false;
            }
            if (this.myExecutionStacksWithSelection.containsKey(xExecutionStack)) continue;
            if (addBeforeSelection) {
                this.myThreadComboBox.insertItemAt((Object)xExecutionStack, this.myThreadComboBox.getSelectedIndex());
            } else if (loading) {
                this.myThreadComboBox.insertItemAt((Object)xExecutionStack, this.myThreadComboBox.getItemCount() - 1);
            } else {
                this.myThreadComboBox.addItem((Object)xExecutionStack);
            }
            this.myExecutionStacksWithSelection.put(xExecutionStack, null);
        }
        return addBeforeSelection;
    }

    private void updateFrames(XExecutionStack executionStack, @NotNull XDebugSessionProxy sessionProxy, @Nullable XStackFrame frameToSelect, boolean refresh) {
        XDebugSessionProxy debugSession;
        if (sessionProxy == null) {
            XFramesView.$$$reportNull$$$0(7);
        }
        if (this.mySelectedStack != null) {
            this.withCurrentBuilder(StackFramesListBuilder::stop);
        }
        this.mySelectedStack = executionStack;
        if (executionStack != null) {
            this.mySelectedFrame = this.myExecutionStacksWithSelection.get(executionStack);
            StackFramesListBuilder builder = this.getOrCreateBuilder(executionStack, sessionProxy);
            builder.setRefresh(refresh);
            builder.setToSelect(frameToSelect != null ? frameToSelect : this.mySelectedFrame);
            this.myListenersEnabled = false;
            boolean selected = builder.initModel(this.myFramesList.getModel());
            boolean bl = this.myListenersEnabled = !builder.start() || selected;
        }
        if ((debugSession = this.getSession()) != null && debugSession.isSteppingSuspendContext()) {
            this.myListenersEnabled = true;
        }
    }

    public void dispose() {
    }

    @Nullable
    private XDebugSessionProxy getSession() {
        return (XDebugSessionProxy)this.mySessionRef.get();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @Override
    public JComponent getMainComponent() {
        return this.getMainPanel();
    }

    private void processFrameSelection(XDebugSessionProxy sessionProxy, boolean force, boolean refresh) {
        this.mySelectedFrame = this.myFramesList.getSelectedFrame();
        this.myExecutionStacksWithSelection.put(this.mySelectedStack, this.mySelectedFrame);
        this.withCurrentBuilder(b -> b.setToSelect(null));
        Object object = this.myFramesList.getSelectedValue();
        if (object instanceof XStackFrame) {
            XStackFrame frame = (XStackFrame)object;
            if (sessionProxy != null && (force || !refresh && sessionProxy.getCurrentStackFrame() != this.myFramesList.getSelectedValue())) {
                int selectedIndex = this.myFramesList.getSelectedIndex();
                sessionProxy.setCurrentStackFrame(this.mySelectedStack, frame, selectedIndex == 0);
                if (force) {
                    XDebuggerActionsCollector.frameSelected.log((Object)"framesView");
                }
            }
        }
    }

    @ApiStatus.Internal
    @NotNull
    public ComboBox<XExecutionStack> getThreadComboBox() {
        ComboBox<XExecutionStack> comboBox = this.myThreadComboBox;
        if (comboBox == null) {
            XFramesView.$$$reportNull$$$0(8);
        }
        return comboBox;
    }

    public static boolean shouldFoldHiddenFrames() {
        return Registry.is((String)"debugger.library.frames.fold.instead.of.hide");
    }

    static void addFramesNavigationAd(JPanel parent) {
        if (!(parent.getLayout() instanceof BorderLayout)) {
            return;
        }
        String prev = XFramesView.getShortcutText("PreviousOccurence");
        String next = XFramesView.getShortcutText("NextOccurence");
        String propKey = "XFramesView.AdPanel.SwitchFrames.enabled";
        if (PropertiesComponent.getInstance().getBoolean(propKey, true) && prev != null && next != null) {
            String message = XDebuggerBundle.message((String)"debugger.switch.frames.from.anywhere.hint", (Object[])new Object[]{prev, next});
            MyAdPanel hint = new MyAdPanel(message, p -> {
                parent.remove((Component)((Object)p));
                parent.revalidate();
                PropertiesComponent.getInstance().setValue(propKey, false, true);
            });
            parent.add((Component)((Object)hint), "South");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionProxy";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/frame/XFramesView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFramePresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onFrameSelectionKeyPressed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processSessionEvent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateFrames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8 -> new IllegalStateException(string);
        };
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            List<Component> list = Arrays.asList(new Component[]{XFramesView.this.myFramesList, XFramesView.this.myThreadComboBox});
            if (list == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/XFramesView$MyFocusPolicy", "getOrderedComponents"));
        }
    }

    private static class StringBuilderTextContainer
    implements ColoredTextContainer {
        private final StringBuilder builder = new StringBuilder();

        private StringBuilderTextContainer() {
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            if (fragment == null) {
                StringBuilderTextContainer.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                StringBuilderTextContainer.$$$reportNull$$$0(1);
            }
            this.builder.append(fragment);
        }

        public String getText() {
            return this.builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xdebugger/impl/frame/XFramesView$StringBuilderTextContainer";
            objectArray[2] = "append";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class StackFramesListBuilder
    implements XStackFrameContainerEx {
        private XExecutionStack myExecutionStack;
        private final List<XStackFrame> myStackFrames;
        private String myErrorMessage;
        private int myNextFrameIndex;
        private volatile boolean myRunning;
        private long myStartTimeMs;
        private boolean myAllFramesLoaded;
        private final XDebugSessionProxy mySessionProxy;
        private Object myToSelect;
        private boolean myRefresh;

        private StackFramesListBuilder(XExecutionStack executionStack, XDebugSessionProxy sessionProxy) {
            this.myExecutionStack = executionStack;
            this.mySessionProxy = sessionProxy;
            this.myStackFrames = new ArrayList<XStackFrame>();
        }

        void setToSelect(Object toSelect) {
            this.myToSelect = toSelect;
        }

        private void setRefresh(boolean refresh) {
            this.myRefresh = refresh;
        }

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
            if (stackFrames == null) {
                StackFramesListBuilder.$$$reportNull$$$0(0);
            }
            this.addStackFrames(stackFrames, null, last);
        }

        @Override
        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect, boolean last) {
            if (stackFrames == null) {
                StackFramesListBuilder.$$$reportNull$$$0(1);
            }
            if (this.isObsolete()) {
                return;
            }
            EdtExecutorService.getInstance().execute(() -> {
                if (this.isObsolete()) {
                    return;
                }
                this.myStackFrames.addAll(stackFrames);
                this.addFrameListElements(stackFrames, last);
                if (toSelect != null && !this.myRefresh) {
                    this.setToSelect(toSelect);
                }
                this.myNextFrameIndex += stackFrames.size();
                this.myAllFramesLoaded = last;
                this.selectCurrentFrame();
                if (last) {
                    if (XFramesView.this.myVisibleRect != null) {
                        XFramesView.this.myFramesList.scrollRectToVisible(XFramesView.this.myVisibleRect);
                    }
                    XDebuggerActionsCollector.logFramesUpdated(System.currentTimeMillis() - this.myStartTimeMs, this.myStackFrames);
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                StackFramesListBuilder.$$$reportNull$$$0(2);
            }
            if (this.isObsolete()) {
                return;
            }
            EdtExecutorService.getInstance().execute(() -> {
                if (this.isObsolete()) {
                    return;
                }
                if (this.myErrorMessage == null) {
                    this.myErrorMessage = errorMessage;
                    this.addFrameListElements(Collections.singletonList(errorMessage), true);
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        private void addFrameListElements(List<?> values, boolean last) {
            if (this.myExecutionStack != null && this.myExecutionStack == XFramesView.this.mySelectedStack) {
                boolean loadingPresent;
                CollectionListModel model = XFramesView.this.myFramesList.getModel();
                int insertIndex = model.getSize();
                boolean bl = loadingPresent = insertIndex > 0 && model.getElementAt(insertIndex - 1) == null;
                if (loadingPresent) {
                    --insertIndex;
                }
                model.addAll(insertIndex, values);
                StackFramesListBuilder.scheduleFilesHighlighting(values, XFramesView.this.myProject);
                if (last) {
                    if (loadingPresent) {
                        model.remove(model.getSize() - 1);
                    }
                } else if (!loadingPresent) {
                    model.add(null);
                }
                XFramesView.this.myFramesList.repaint();
            }
        }

        private static void scheduleFilesHighlighting(@NotNull List<?> values, @NotNull Project project) {
            if (values == null) {
                StackFramesListBuilder.$$$reportNull$$$0(3);
            }
            if (project == null) {
                StackFramesListBuilder.$$$reportNull$$$0(4);
            }
            if (!Registry.is((String)"highlighting.passes.cache")) {
                return;
            }
            List files = ((StreamEx)StreamEx.of(values).select(XStackFrame.class).map(it -> (VirtualFile)ObjectUtils.doIfNotNull((Object)it.getSourcePosition(), XSourcePosition::getFile)).filter(Objects::nonNull)).toList();
            HighlightingPassesCache.getInstance((Project)project).schedule(files, true);
        }

        public boolean isObsolete() {
            return !this.myRunning;
        }

        public void dispose() {
            this.myRunning = false;
            this.myStartTimeMs = 0L;
            this.myExecutionStack = null;
        }

        public boolean start() {
            if (this.myExecutionStack == null || this.myErrorMessage != null) {
                return false;
            }
            this.myRunning = true;
            this.myStartTimeMs = System.currentTimeMillis();
            this.myExecutionStack.computeStackFrames(this.myNextFrameIndex, (XExecutionStack.XStackFrameContainer)this);
            return true;
        }

        public void stop() {
            this.myRunning = false;
        }

        private boolean selectCurrentFrame() {
            if (this.selectFrame(this.myToSelect)) {
                XFramesView.this.myListenersEnabled = true;
                XFramesView.this.processFrameSelection(this.mySessionProxy, false, this.myRefresh);
                return true;
            }
            return false;
        }

        private boolean selectFrame(Object toSelect) {
            Integer selectIndex;
            if (toSelect instanceof XStackFrame) {
                XStackFrame frame = (XStackFrame)toSelect;
                if (XFramesView.this.myFramesList.selectFrame(frame)) {
                    return true;
                }
                if (this.myAllFramesLoaded && XFramesView.this.myFramesList.getSelectedValue() == null) {
                    LOG.warn("Frame was not found, it was either hidden without placeholder (" + String.valueOf(HiddenStackFramesItem.class) + ") or " + String.valueOf(this.myToSelect.getClass()) + " must correctly override equals");
                }
            } else if (toSelect instanceof Integer ? XFramesView.this.myFramesList.selectFrame(selectIndex = (Integer)toSelect) : toSelect == null && XFramesView.this.myFramesList.getSelectedIndex() == -1 && XFramesView.this.myFramesList.selectFrame(0)) {
                return true;
            }
            return false;
        }

        public boolean initModel(CollectionListModel model) {
            model.replaceAll(this.myStackFrames);
            if (this.myErrorMessage != null) {
                model.add((Object)this.myErrorMessage);
            } else if (!this.myAllFramesLoaded) {
                model.add(null);
            }
            return this.selectCurrentFrame();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stackFrames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStackFrames";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scheduleFilesHighlighting";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAdPanel
    extends BorderLayoutPanel {
        MyAdPanel(@NlsContexts.Label @NotNull String message, @NotNull Consumer<? super MyAdPanel> closeListener) {
            if (message == null) {
                MyAdPanel.$$$reportNull$$$0(0);
            }
            if (closeListener == null) {
                MyAdPanel.$$$reportNull$$$0(1);
            }
            JBLabel label = new JBLabel(message, UIUtil.ComponentStyle.SMALL);
            label.setForeground(UIUtil.getContextHelpForeground());
            label.setToolTipText(message);
            JButton closeButton = new JButton();
            closeButton.setText(null);
            closeButton.setOpaque(false);
            closeButton.setBorder(null);
            closeButton.setBorderPainted(false);
            closeButton.setContentAreaFilled(false);
            closeButton.setIcon(AllIcons.Actions.Close);
            closeButton.setRolloverIcon(AllIcons.Actions.CloseDarkGrey);
            closeButton.setToolTipText(CommonBundle.getCloseButtonText());
            closeButton.addActionListener(e -> closeListener.accept(this));
            Dimension dim = new Dimension(AllIcons.Actions.Close.getIconHeight(), AllIcons.Actions.Close.getIconWidth());
            closeButton.setPreferredSize(dim);
            this.addToCenter((Component)label);
            this.addToRight(closeButton);
            this.setBorder((Border)JBUI.Borders.empty((int)3, (int)8, (int)3, (int)4));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "closeListener";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xdebugger/impl/frame/XFramesView$MyAdPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HiddenStackFramesItem
    extends XStackFrame
    implements XDebuggerFramesList.ItemWithCustomBackgroundColor,
    XDebuggerFramesList.ItemWithSeparatorAbove,
    HiddenFramesStackFrame {
        final List<XStackFrame> hiddenFrames;

        public HiddenStackFramesItem(List<XStackFrame> hiddenFrames) {
            this.hiddenFrames = List.copyOf(hiddenFrames);
            if (hiddenFrames.isEmpty()) {
                throw new IllegalArgumentException();
            }
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            if (component == null) {
                HiddenStackFramesItem.$$$reportNull$$$0(0);
            }
            component.append(XDebuggerBundle.message((String)"label.folded.frames", (Object[])new Object[]{this.hiddenFrames.size()}), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            component.setIcon(EmptyIcon.ICON_16);
        }

        @Override
        @Nullable
        public Color getBackgroundColor() {
            return null;
        }

        @Override
        @NotNull
        public List<XStackFrame> getHiddenFrames() {
            List<XStackFrame> list = this.hiddenFrames;
            if (list == null) {
                HiddenStackFramesItem.$$$reportNull$$$0(1);
            }
            return list;
        }

        private Optional<XDebuggerFramesList.ItemWithSeparatorAbove> findFrameWithSeparator() {
            Optional<XDebuggerFramesList.ItemWithSeparatorAbove> optional;
            XStackFrame xStackFrame = this.hiddenFrames.get(0);
            if (xStackFrame instanceof XDebuggerFramesList.ItemWithSeparatorAbove) {
                XDebuggerFramesList.ItemWithSeparatorAbove frame = (XDebuggerFramesList.ItemWithSeparatorAbove)xStackFrame;
                optional = Optional.of(frame);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        @Override
        public boolean hasSeparatorAbove() {
            return this.findFrameWithSeparator().map(XDebuggerFramesList.ItemWithSeparatorAbove::hasSeparatorAbove).orElse(false);
        }

        @Override
        public String getCaptionAboveOf() {
            return this.findFrameWithSeparator().map(XDebuggerFramesList.ItemWithSeparatorAbove::getCaptionAboveOf).orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/frame/XFramesView$HiddenStackFramesItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$HiddenStackFramesItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHiddenFrames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizePresentation";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class ThreadsBuilder
    implements XSuspendContext.XExecutionStackContainer {
        private volatile boolean myObsolete;
        private boolean myAddBeforeSelection = true;

        ThreadsBuilder() {
            XFramesView.this.myThreadComboBox.addItem(null);
        }

        public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
            if (executionStacks == null) {
                ThreadsBuilder.$$$reportNull$$$0(0);
            }
            ArrayList<? extends XExecutionStack> copyStacks = new ArrayList<XExecutionStack>(executionStacks);
            ApplicationManager.getApplication().invokeLater(() -> {
                ComboPopup popup2;
                int initialCount = XFramesView.this.myThreadComboBox.getItemCount();
                if (last) {
                    this.removeLoading();
                    XFramesView.this.myThreadsCalculated = true;
                }
                this.myAddBeforeSelection = XFramesView.this.addExecutionStacks(copyStacks, this.myAddBeforeSelection);
                int newCount = XFramesView.this.myThreadComboBox.getItemCount();
                int maxComboboxRows = XFramesView.this.myThreadComboBox.getMaximumRowCount();
                if (newCount != initialCount && (initialCount < maxComboboxRows || newCount < maxComboboxRows) && (popup2 = XFramesView.this.myThreadComboBox.getPopup()) != null && popup2.isVisible()) {
                    popup2.hide();
                    popup2.show();
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ThreadsBuilder.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(this::removeLoading);
        }

        public boolean isObsolete() {
            return this.myObsolete;
        }

        public void setObsolete() {
            if (!this.myObsolete) {
                this.myObsolete = true;
                this.removeLoading();
            }
        }

        void removeLoading() {
            XFramesView.this.myThreadComboBox.removeItem(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionStacks";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XFramesView$ThreadsBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addExecutionStack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

