/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeUtilsKt;
import com.intellij.xdebugger.impl.ui.SessionTabComponentProvider;
import com.intellij.xdebugger.impl.ui.XDebugSessionTabCustomizerKt;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000  2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001 B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u001fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/xdebugger/impl/frame/XSplitterWatchesViewImpl;", "Lcom/intellij/xdebugger/impl/frame/XWatchesViewImpl;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "Lcom/intellij/xdebugger/impl/frame/XWatchesView;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "watchesInVariables", "", "isVertical", "withToolbar", "<init>", "(Lcom/intellij/xdebugger/impl/XDebugSessionImpl;ZZZ)V", "value", "Lcom/intellij/ui/OnePixelSplitter;", "splitter", "getSplitter", "()Lcom/intellij/ui/OnePixelSplitter;", "myPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "customized", "localsPanel", "Ljavax/swing/JComponent;", "createMainPanel", "Ljavax/swing/JPanel;", "localsPanelComponent", "updateMainPanel", "", "addMixedModeListenerIfNeeded", "updateView", "getShowCustomized", "useLowLevelDebugProcessPanel", "()Ljava/lang/Boolean;", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nXSplitterWatchesViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XSplitterWatchesViewImpl.kt\ncom/intellij/xdebugger/impl/frame/XSplitterWatchesViewImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class XSplitterWatchesViewImpl
extends XWatchesViewImpl
implements DnDNativeTarget,
XWatchesView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private OnePixelSplitter splitter;
    @Nullable
    private BorderLayoutPanel myPanel;
    private boolean customized;
    @Nullable
    private JComponent localsPanel;
    @NotNull
    private static final String proportionKey = "debugger.immediate.window.in.watches.proportion.key";

    /*
     * WARNING - void declaration
     */
    public XSplitterWatchesViewImpl(@NotNull XDebugSessionImpl session, boolean watchesInVariables, boolean isVertical, boolean withToolbar) {
        void it;
        XDebugSessionImpl xDebugSessionImpl;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        XDebugSessionImpl xDebugSessionImpl2 = xDebugSessionImpl = session;
        XSplitterWatchesViewImpl xSplitterWatchesViewImpl = this;
        boolean bl = false;
        XSplitterWatchesViewImpl.Companion.checkContract((XDebugSessionImpl)it);
        super(xDebugSessionImpl, watchesInVariables, isVertical, withToolbar);
        this.customized = true;
    }

    @NotNull
    public final OnePixelSplitter getSplitter() {
        OnePixelSplitter onePixelSplitter = this.splitter;
        if (onePixelSplitter != null) {
            return onePixelSplitter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"splitter");
        return null;
    }

    @Override
    @NotNull
    protected JPanel createMainPanel(@NotNull JComponent localsPanelComponent) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)localsPanelComponent, (String)"localsPanelComponent");
        this.customized = this.getShowCustomized();
        this.localsPanel = localsPanelComponent;
        XDebugSessionImpl xDebugSessionImpl = this.getSession();
        if (xDebugSessionImpl == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.addMixedModeListenerIfNeeded(xDebugSessionImpl);
        BorderLayoutPanel it = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        this.myPanel = it;
        this.updateMainPanel();
        return (JPanel)borderLayoutPanel;
    }

    private final void updateMainPanel() {
        BorderLayoutPanel borderLayoutPanel = this.myPanel;
        if (borderLayoutPanel == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        BorderLayoutPanel myPanel = borderLayoutPanel;
        JComponent jComponent = this.localsPanel;
        if (jComponent == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        JComponent localsPanel = jComponent;
        myPanel.removeAll();
        if (!this.customized) {
            BorderLayoutPanel borderLayoutPanel2 = new BorderLayoutPanel().addToCenter((Component)localsPanel);
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"addToCenter(...)");
            BorderLayoutPanel wrappedLocalsPanel = borderLayoutPanel2;
            myPanel.addToCenter((Component)super.createMainPanel((JComponent)wrappedLocalsPanel));
            return;
        }
        XDebugSessionImpl xDebugSessionImpl = this.getSession();
        if (xDebugSessionImpl == null) {
            throw new IllegalStateException("Not null session is expected here".toString());
        }
        XDebugSessionImpl session = xDebugSessionImpl;
        SessionTabComponentProvider sessionTabComponentProvider = XSplitterWatchesViewImpl.Companion.tryGetBottomComponentProvider(session, this.useLowLevelDebugProcessPanel());
        if (sessionTabComponentProvider == null) {
            throw new IllegalStateException("BottomLocalsComponentProvider is not implemented to use SplitterWatchesVariablesView".toString());
        }
        SessionTabComponentProvider bottomLocalsComponentProvider = sessionTabComponentProvider;
        JComponent evaluatorComponent = bottomLocalsComponentProvider.createBottomLocalsComponent();
        this.splitter = new OnePixelSplitter(true, proportionKey, 0.01f, 0.99f);
        this.getSplitter().setFirstComponent(localsPanel);
        this.getSplitter().setSecondComponent(evaluatorComponent);
        myPanel.addToCenter((Component)this.getSplitter());
    }

    private final void addMixedModeListenerIfNeeded(XDebugSessionImpl session) {
        boolean highSupportsCustomization;
        if (!session.isMixedMode()) {
            return;
        }
        boolean lowSupportsCustomization = XDebugSessionTabCustomizerKt.useSplitterView(XMixedModeUtilsKt.getLowLevelProcessOrThrow(session));
        if (lowSupportsCustomization == (highSupportsCustomization = XDebugSessionTabCustomizerKt.useSplitterView(XMixedModeUtilsKt.getHighLevelProcessOrThrow(session)))) {
            return;
        }
        session.addSessionListener(new XDebugSessionListener(this){
            final /* synthetic */ XSplitterWatchesViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void stackFrameChanged() {
                XSplitterWatchesViewImpl.access$updateView(this.this$0);
            }

            public void sessionPaused() {
                XSplitterWatchesViewImpl.access$updateView(this.this$0);
            }
        });
    }

    private final void updateView() {
        ApplicationKt.getApplication().invokeLater(() -> XSplitterWatchesViewImpl.updateView$lambda$0(this));
    }

    private final boolean getShowCustomized() {
        XDebugSessionImpl xDebugSessionImpl = this.getSession();
        if (xDebugSessionImpl == null) {
            return false;
        }
        XDebugSessionImpl session = xDebugSessionImpl;
        if (!session.isMixedMode()) {
            return true;
        }
        boolean lowSupportsCustomization = XDebugSessionTabCustomizerKt.useSplitterView(XMixedModeUtilsKt.getLowLevelProcessOrThrow(session));
        boolean highSupportsCustomization = XDebugSessionTabCustomizerKt.useSplitterView(XMixedModeUtilsKt.getHighLevelProcessOrThrow(session));
        boolean useLowLevelPanel = Intrinsics.areEqual((Object)this.useLowLevelDebugProcessPanel(), (Object)true);
        boolean useHighLevelPanel = !useLowLevelPanel;
        return useLowLevelPanel && lowSupportsCustomization || useHighLevelPanel && highSupportsCustomization;
    }

    private final Boolean useLowLevelDebugProcessPanel() {
        XDebugSessionImpl xDebugSessionImpl = this.getSession();
        if (xDebugSessionImpl == null) {
            return null;
        }
        XDebugSessionImpl session = xDebugSessionImpl;
        if (!session.isMixedMode()) {
            return null;
        }
        XStackFrame xStackFrame = session.getCurrentStackFrame();
        if (xStackFrame == null) {
            return false;
        }
        XStackFrame frame = xStackFrame;
        return XMixedModeUtilsKt.getLowLevelMixedModeExtensionOrThrow(session).belongsToMe(frame);
    }

    private static final void updateView$lambda$0(XSplitterWatchesViewImpl this$0) {
        boolean showCustomizedView = this$0.getShowCustomized();
        if (this$0.customized == showCustomizedView) {
            return;
        }
        this$0.customized = showCustomizedView;
        this$0.updateMainPanel();
    }

    public static final /* synthetic */ void access$updateView(XSplitterWatchesViewImpl $this) {
        $this.updateView();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J!\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/xdebugger/impl/frame/XSplitterWatchesViewImpl$Companion;", "", "<init>", "()V", "proportionKey", "", "checkContract", "", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "tryGetBottomComponentProvider", "Lcom/intellij/xdebugger/impl/ui/SessionTabComponentProvider;", "useLowLevelDebugProcessPanel", "", "(Lcom/intellij/xdebugger/impl/XDebugSessionImpl;Ljava/lang/Boolean;)Lcom/intellij/xdebugger/impl/ui/SessionTabComponentProvider;", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void checkContract(XDebugSessionImpl session) {
            if (this.tryGetBottomComponentProvider(session, null) == null) {
                throw new IllegalStateException("XDebugProcess must provide a properly configured XDebugSessionTabCustomizer to use XSplitterWatchesViewImpl. Read JavaDoc for details".toString());
            }
        }

        private final SessionTabComponentProvider tryGetBottomComponentProvider(XDebugSessionImpl session, Boolean useLowLevelDebugProcessPanel) {
            XDebugProcess xDebugProcess;
            Boolean bl = useLowLevelDebugProcessPanel;
            if (bl == null) {
                xDebugProcess = session.getDebugProcess();
            } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                xDebugProcess = XMixedModeUtilsKt.getLowLevelProcessOrThrow(session);
            } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                xDebugProcess = XMixedModeUtilsKt.getHighLevelProcessOrThrow(session);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return XDebugSessionTabCustomizerKt.getBottomLocalsComponentProvider(xDebugProcess);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

