/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergedCompositeConfigurable
extends CompositeConfigurable<Configurable>
implements SearchableConfigurable {
    static final EmptyBorder BOTTOM_INSETS = new EmptyBorder(0, 0, 10, 0);
    private static final Insets FIRST_COMPONENT_INSETS = new Insets(0, 0, 10, 0);
    private static final Insets N_COMPONENT_INSETS = new Insets(7, 0, 10, 0);
    protected final Configurable[] children;
    protected JComponent rootComponent;
    private final String id;
    @Nls
    private final String displayName;
    private final String helpTopic;

    MergedCompositeConfigurable(@NotNull String id, @NotNull @Nls String displayName, @Nullable String helpTopic, Configurable @NotNull [] children) {
        if (id == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(1);
        }
        if (children == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(2);
        }
        this.children = children;
        this.id = id;
        this.displayName = displayName;
        this.helpTopic = helpTopic;
    }

    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getHelpTopic() {
        if (this.helpTopic != null) {
            return this.helpTopic;
        }
        return this.children.length == 1 ? this.children[0].getHelpTopic() : null;
    }

    protected boolean isUseTargetedProductPolicyIfSeveralChildren() {
        return false;
    }

    @Nullable
    public JComponent createComponent() {
        if (this.rootComponent == null) {
            Configurable firstConfigurable = this.children[0];
            if (this.children.length == 1) {
                JComponent component = firstConfigurable.createComponent();
                String rootComponentDisplayName = firstConfigurable.getDisplayName();
                if (!StringUtil.isEmpty((String)rootComponentDisplayName) && !MergedCompositeConfigurable.isTargetedToProduct(firstConfigurable)) {
                    component.setBorder((Border)IdeBorderFactory.createTitledBorder((String)rootComponentDisplayName, (boolean)false, (Insets)FIRST_COMPONENT_INSETS));
                }
                this.rootComponent = MergedCompositeConfigurable.createPanel(true);
                this.rootComponent.add(component);
            } else {
                boolean isFirstNamed = true;
                JPanel panel2 = MergedCompositeConfigurable.createPanel(true);
                for (Configurable configurable : this.children) {
                    JComponent component = configurable.createComponent();
                    assert (component != null);
                    String displayName = configurable.getDisplayName();
                    if (StringUtil.isEmpty((String)displayName)) {
                        component.setBorder(BOTTOM_INSETS);
                    } else {
                        boolean addBorder = true;
                        if (this.isUseTargetedProductPolicyIfSeveralChildren() && isFirstNamed) {
                            isFirstNamed = false;
                            if (MergedCompositeConfigurable.isTargetedToProduct(configurable)) {
                                addBorder = false;
                            }
                        }
                        if (addBorder) {
                            component.setBorder((Border)IdeBorderFactory.createTitledBorder((String)displayName, (boolean)false, (Insets)(firstConfigurable == configurable ? FIRST_COMPONENT_INSETS : N_COMPONENT_INSETS)));
                        }
                    }
                    panel2.add(component);
                }
                this.rootComponent = panel2;
            }
        }
        return this.rootComponent;
    }

    static boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists((Iterable)DebuggerConfigurableProvider.EXTENSION_POINT.getExtensionList(), provider -> provider.isTargetedToProduct(configurable));
    }

    @NotNull
    static JPanel createPanel(boolean isUseTitledBorder) {
        int verticalGap = 7;
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, isUseTitledBorder ? 0 : verticalGap, true, true));
        if (!isUseTitledBorder) {
            panel2.setBorder(new EmptyBorder(-verticalGap, 0, 0, 0));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public void disposeUIResources() {
        this.rootComponent = null;
        super.disposeUIResources();
    }

    @NotNull
    protected List<Configurable> createConfigurables() {
        List<Configurable> list = Arrays.asList(this.children);
        if (list == null) {
            MergedCompositeConfigurable.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/settings/MergedCompositeConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/settings/MergedCompositeConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

