/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachHostProvider;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachHostItem;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0087\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0017J\b\u0010\u0017\u001a\u00020\u0015H\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J9\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachHostAndProvider;", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/AttachHostItem;", "host", "Lcom/intellij/xdebugger/attach/XAttachHost;", "provider", "Lcom/intellij/xdebugger/attach/XAttachHostProvider;", "project", "Lcom/intellij/openapi/project/Project;", "dataHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "<init>", "(Lcom/intellij/xdebugger/attach/XAttachHost;Lcom/intellij/xdebugger/attach/XAttachHostProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/UserDataHolder;)V", "getHost", "()Lcom/intellij/xdebugger/attach/XAttachHost;", "getProvider", "()Lcom/intellij/xdebugger/attach/XAttachHostProvider;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDataHolder", "()Lcom/intellij/openapi/util/UserDataHolder;", "getId", "", "getPresentation", "toString", "getIcon", "Ljavax/swing/Icon;", "equals", "", "other", "", "hashCode", "", "component1", "component2", "component3", "component4", "copy", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class AttachHostAndProvider
implements AttachHostItem {
    @NotNull
    private final XAttachHost host;
    @NotNull
    private final XAttachHostProvider<? extends XAttachHost> provider;
    @NotNull
    private final Project project;
    @NotNull
    private final UserDataHolder dataHolder;

    public AttachHostAndProvider(@NotNull XAttachHost host, @NotNull XAttachHostProvider<? extends XAttachHost> provider, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        this.host = host;
        this.provider = provider;
        this.project = project;
        this.dataHolder = dataHolder;
    }

    @Override
    @NotNull
    public XAttachHost getHost() {
        return this.host;
    }

    @NotNull
    public final XAttachHostProvider<? extends XAttachHost> getProvider() {
        return this.provider;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final UserDataHolder getDataHolder() {
        return this.dataHolder;
    }

    @Override
    @NotNull
    public String getId() {
        return this.getPresentation();
    }

    @Override
    @Nls
    @NotNull
    public String getPresentation() {
        XAttachPresentationGroup<XAttachHost> xAttachPresentationGroup = this.provider.getPresentationGroup();
        Intrinsics.checkNotNull(xAttachPresentationGroup, (String)"null cannot be cast to non-null type com.intellij.xdebugger.attach.XAttachPresentationGroup<com.intellij.xdebugger.attach.XAttachHost>");
        XAttachPresentationGroup<XAttachHost> presentationGroup = xAttachPresentationGroup;
        String string = presentationGroup.getItemDisplayText(this.project, this.getHost(), this.dataHolder);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getItemDisplayText(...)");
        return string;
    }

    @Nls
    @NotNull
    public String toString() {
        return this.getPresentation();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        XAttachPresentationGroup<XAttachHost> xAttachPresentationGroup = this.provider.getPresentationGroup();
        Intrinsics.checkNotNull(xAttachPresentationGroup, (String)"null cannot be cast to non-null type com.intellij.xdebugger.attach.XAttachPresentationGroup<com.intellij.xdebugger.attach.XAttachHost>");
        XAttachPresentationGroup<XAttachHost> presentationGroup = xAttachPresentationGroup;
        Icon icon = presentationGroup.getItemIcon(this.project, this.getHost(), this.dataHolder);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getItemIcon(...)");
        return icon;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AttachHostAndProvider)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((AttachHostAndProvider)other).getHost(), (Object)this.getHost());
    }

    public int hashCode() {
        return this.getHost().hashCode();
    }

    @NotNull
    public final XAttachHost component1() {
        return this.host;
    }

    @NotNull
    public final XAttachHostProvider<? extends XAttachHost> component2() {
        return this.provider;
    }

    @NotNull
    public final Project component3() {
        return this.project;
    }

    @NotNull
    public final UserDataHolder component4() {
        return this.dataHolder;
    }

    @NotNull
    public final AttachHostAndProvider copy(@NotNull XAttachHost host, @NotNull XAttachHostProvider<? extends XAttachHost> provider, @NotNull Project project, @NotNull UserDataHolder dataHolder) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataHolder, (String)"dataHolder");
        return new AttachHostAndProvider(host, provider, project, dataHolder);
    }

    public static /* synthetic */ AttachHostAndProvider copy$default(AttachHostAndProvider attachHostAndProvider, XAttachHost xAttachHost, XAttachHostProvider xAttachHostProvider, Project project, UserDataHolder userDataHolder, int n, Object object) {
        if ((n & 1) != 0) {
            xAttachHost = attachHostAndProvider.host;
        }
        if ((n & 2) != 0) {
            xAttachHostProvider = attachHostAndProvider.provider;
        }
        if ((n & 4) != 0) {
            project = attachHostAndProvider.project;
        }
        if ((n & 8) != 0) {
            userDataHolder = attachHostAndProvider.dataHolder;
        }
        return attachHostAndProvider.copy(xAttachHost, xAttachHostProvider, project, userDataHolder);
    }
}

