/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import com.intellij.xdebugger.impl.ui.tree.TreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public abstract class XDebuggerTreeInplaceEditor
extends TreeInplaceEditor {
    protected final XDebuggerTreeNode myNode;
    protected final XDebuggerExpressionComboBox myExpressionEditor;
    protected final XDebuggerTree myTree;

    public XDebuggerTreeInplaceEditor(XDebuggerTreeNode node, @NonNls String historyId) {
        this.myNode = node;
        this.myTree = this.myNode.getTree();
        this.myExpressionEditor = new XDebuggerExpressionComboBox(this.myTree.getProject(), this.myTree.getEditorsProvider(), historyId, this.myTree.getSourcePosition(), false, true);
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myExpressionEditor.getComponent();
    }

    @Override
    protected void onHidden() {
        ComboPopup popup2 = this.myExpressionEditor.getComboBox().getPopup();
        if (popup2 != null && popup2.isVisible()) {
            popup2.hide();
        }
    }

    @Override
    protected void doPopupOKAction() {
        Object value;
        ComboPopup popup2 = this.myExpressionEditor.getComboBox().getPopup();
        if (popup2 != null && popup2.isVisible() && (value = popup2.getList().getSelectedValue()) != null) {
            this.myExpressionEditor.setExpression((XExpression)value);
        }
        this.doOKAction();
    }

    @Override
    public void doOKAction() {
        this.myExpressionEditor.saveTextInHistory();
        super.doOKAction();
    }

    @Override
    protected void onShown() {
        XDebugSessionProxy session = XDebugView.getSessionProxy((Component)((Object)this.myTree));
        if (session != null) {
            session.addSessionListener(new XDebugSessionListener(){

                public void sessionPaused() {
                    this.cancel();
                }

                public void sessionResumed() {
                    this.cancel();
                }

                public void sessionStopped() {
                    this.cancel();
                }

                public void stackFrameChanged() {
                    this.cancel();
                }

                public void beforeSessionResume() {
                    this.cancel();
                }

                private void cancel() {
                    AppUIUtil.invokeOnEdt(XDebuggerTreeInplaceEditor.this::cancelEditing);
                }
            }, this.myDisposable);
        }
    }

    protected XExpression getExpression() {
        return this.myExpressionEditor.getExpression();
    }

    @Override
    protected JComponent getPreferredFocusedComponent() {
        return this.myExpressionEditor.getPreferredFocusedComponent();
    }

    @Override
    public Editor getEditor() {
        return this.myExpressionEditor.getEditor();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myExpressionEditor.getEditorComponent();
    }

    @Override
    protected TreePath getNodePath() {
        return this.myNode.getPath();
    }

    protected XDebuggerTree getTree() {
        return this.myTree;
    }

    @Override
    protected Project getProject() {
        return this.myNode.getTree().getProject();
    }

    protected final int getAfterIconX() {
        Icon icon = this.myNode.getIcon();
        if (icon != null) {
            SimpleColoredComponent iconLabel = new SimpleColoredComponent();
            iconLabel.getIpad().right = 0;
            iconLabel.getIpad().left = 0;
            iconLabel.setIcon(this.myNode.getIcon());
            Border border = iconLabel.getMyBorder();
            return iconLabel.getPreferredSize().width - (border != null ? border.getBorderInsets((Component)iconLabel).right : 0);
        }
        return 0;
    }
}

