/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext;

import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPanel;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtilKt;
import java.awt.Font;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/EvaluationCallback;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;", "panel", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel;", "<init>", "(Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel;)V", "obsolete", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastFullValueHashCode", "Ljava/util/concurrent/atomic/AtomicReference;", "", "evaluated", "", "fullValue", "", "font", "Ljava/awt/Font;", "errorOccurred", "errorMessage", "setObsolete", "isObsolete", "", "intellij.platform.debugger.impl"})
final class EvaluationCallback
implements XFullValueEvaluator.XFullValueEvaluationCallback {
    @NotNull
    private final VisualizedTextPanel panel;
    @NotNull
    private final AtomicBoolean obsolete;
    @NotNull
    private AtomicReference<Integer> lastFullValueHashCode;

    public EvaluationCallback(@NotNull VisualizedTextPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        this.panel = panel2;
        this.obsolete = new AtomicBoolean(false);
        this.lastFullValueHashCode = new AtomicReference();
    }

    public void evaluated(@NotNull String fullValue, @Nullable Font font) {
        int hashCode;
        Intrinsics.checkNotNullParameter((Object)fullValue, (String)"fullValue");
        Integer n = this.lastFullValueHashCode.get();
        if (n != null && (hashCode = fullValue.hashCode()) == n) {
            return;
        }
        this.lastFullValueHashCode.set(hashCode);
        AppUIUtil.invokeOnEdt(() -> EvaluationCallback.evaluated$lambda$0(this, fullValue));
    }

    public void errorOccurred(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        AppUIUtil.invokeOnEdt(() -> EvaluationCallback.errorOccurred$lambda$0(this, errorMessage));
    }

    public final void setObsolete() {
        this.obsolete.set(true);
    }

    public boolean isObsolete() {
        return this.obsolete.get();
    }

    private static final void evaluated$lambda$0(EvaluationCallback this$0, String $fullValue) {
        try {
            this$0.panel.showVisualizedText($fullValue);
        }
        catch (Exception e) {
            VisualizedTextPopupUtilKt.access$getLOG$p().error((Throwable)e);
            this$0.errorOccurred(e.toString());
        }
    }

    private static final void errorOccurred$lambda$0(EvaluationCallback this$0, String $errorMessage) {
        this$0.panel.showError($errorMessage);
    }
}

