/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.visualizedtext;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtil;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtilKt;
import com.intellij.xdebugger.ui.VisualizedContentTab;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0004\u001f !\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\u0011J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0016\u001a\u00020\f2\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\f0\u00190\u0018H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$State;", "showComponent", "", "component", "Ljavax/swing/JComponent;", "showTextMessage", "value", "", "format", "Lkotlin/Function1;", "Lcom/intellij/xdebugger/impl/ui/TextViewer;", "showError", "errorMessage", "showVisualizedText", "createTabbedPane", "tabsAndComponents", "", "Lkotlin/Pair;", "Lcom/intellij/xdebugger/ui/VisualizedContentTab;", "tryEditText", "", "finishEdit", "saveChanges", "State", "Showing", "Editing", "Other", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nVisualizedTextPopupUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualizedTextPopupUtil.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,305:1\n1563#2:306\n1634#2,3:307\n1563#2:310\n1634#2,3:311\n360#2,7:314\n1#3:321\n*S KotlinDebug\n*F\n+ 1 VisualizedTextPopupUtil.kt\ncom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel\n*L\n165#1:306\n165#1:307,3\n167#1:310\n167#1:311,3\n186#1:314,7\n*E\n"})
public final class VisualizedTextPanel
extends JPanel
implements Disposable.Default {
    @NotNull
    private final Project project;
    @NotNull
    private State state;

    public VisualizedTextPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new CardLayout());
        this.project = project;
        this.state = Other.INSTANCE;
        String string = XDebuggerUIConstants.getEvaluatingExpressionMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEvaluatingExpressionMessage(...)");
        VisualizedTextPanel.showTextMessage$default(this, string, null, 2, null);
    }

    private final void showComponent(JComponent component) {
        this.removeAll();
        this.add(component);
        this.setPreferredSize(component.getPreferredSize());
        this.revalidate();
        this.repaint();
    }

    public final void showTextMessage(@NotNull String value, @NotNull Function1<? super TextViewer, Unit> format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        TextViewer textArea = DebuggerUIUtil.createTextViewer(value, this.project);
        Intrinsics.checkNotNull((Object)((Object)textArea));
        format.invoke((Object)textArea);
        textArea.setPreferredSize((Dimension)JBUI.size((int)300, (int)60));
        this.showComponent((JComponent)((Object)textArea));
        this.state = Other.INSTANCE;
    }

    public static /* synthetic */ void showTextMessage$default(VisualizedTextPanel visualizedTextPanel, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = VisualizedTextPanel::showTextMessage$lambda$0;
        }
        visualizedTextPanel.showTextMessage(string, (Function1<? super TextViewer, Unit>)function1);
    }

    public final void showError(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.showTextMessage("ERROR OCCURRED: " + errorMessage, (Function1<? super TextViewer, Unit>)((Function1)VisualizedTextPanel::showError$lambda$0));
    }

    public final void showVisualizedText(@NotNull String value) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        List<Pair<VisualizedContentTab, JComponent>> tabs = VisualizedTextPopupUtil.INSTANCE.collectVisualizedTabs(this.project, value, (Disposable)this);
        if (tabs.isEmpty()) {
            return;
        }
        if (tabs.size() > 1) {
            jComponent = this.createTabbedPane(tabs);
        } else {
            Pair pair = (Pair)CollectionsKt.first(tabs);
            VisualizedContentTab tab = (VisualizedContentTab)pair.component1();
            JComponent component = (JComponent)pair.component2();
            tab.onShown(this.project, true);
            jComponent = component;
        }
        JComponent component = jComponent;
        this.showComponent(component);
        this.state = new Showing(value);
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createTabbedPane(List<? extends Pair<? extends VisualizedContentTab, ? extends JComponent>> tabsAndComponents) {
        int n;
        Set alreadyShownTabs;
        String selectedTabKey;
        int $i$f$mapTo;
        List tabs;
        JBTabbedPane panel2;
        block7: {
            void $this$mapTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Object component;
            boolean bl;
            boolean bl2 = bl = !((Collection)tabsAndComponents).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            panel2 = new JBTabbedPane();
            panel2.setTabComponentInsets((Insets)JBUI.emptyInsets());
            new WindowMoveListener((Component)panel2).installTo((Component)panel2);
            for (Pair<? extends VisualizedContentTab, ? extends JComponent> pair : tabsAndComponents) {
                VisualizedContentTab tab = (VisualizedContentTab)pair.component1();
                component = (JComponent)pair.component2();
                panel2.addTab(tab.getName(), (Component)component);
            }
            Iterable iterable = tabsAndComponents;
            boolean $i$f$map = false;
            component = iterable;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add((VisualizedContentTab)it.getFirst());
            }
            tabs = (List)destination$iv$iv;
            Iterable $this$map$iv2 = tabs;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = 0;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VisualizedContentTab bl3 = (VisualizedContentTab)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it.getId());
            }
            List list = (List)destination$iv$iv2;
            if (CollectionsKt.distinct((Iterable)list).size() != list.size()) {
                VisualizedTextPopupUtilKt.access$getLOG$p().error("non-unique tab ids: " + list);
            }
            selectedTabKey = "DEBUGGER_VISUALIZED_TEXT_SELECTED_TAB#" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)list), (CharSequence)"#", null, null, (int)0, null, null, (int)62, null);
            alreadyShownTabs = new LinkedHashSet();
            String savedSelectedTabId = PropertiesComponent.getInstance().getValue(selectedTabKey);
            $i$f$mapTo = 0;
            List $this$indexOfFirst$iv = tabs;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                VisualizedContentTab it = (VisualizedContentTab)item$iv;
                boolean bl5 = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)savedSelectedTabId)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = -1;
        }
        int $this$indexOfFirst$iv = n;
        int selectedIndex = Math.max($i$f$mapTo, $this$indexOfFirst$iv);
        panel2.setSelectedIndex(selectedIndex);
        VisualizedTextPanel.createTabbedPane$onTabShown(tabs, panel2, selectedTabKey, alreadyShownTabs, this);
        Dimension contentSize = ((JComponent)tabsAndComponents.get(selectedIndex).getSecond()).getPreferredSize();
        int tabHeight = panel2.getBoundsAt((int)0).height;
        panel2.setPreferredSize((Dimension)JBUI.size((int)contentSize.width, (int)(contentSize.height + tabHeight)));
        panel2.getModel().addChangeListener(arg_0 -> VisualizedTextPanel.createTabbedPane$lambda$3(tabs, panel2, selectedTabKey, alreadyShownTabs, this, arg_0));
        return (JComponent)panel2;
    }

    public final boolean tryEditText() {
        Editor editor;
        State state = this.state;
        Object object = state instanceof Showing ? (Showing)state : null;
        if (object == null || (object = ((Showing)object).getText()) == null) {
            return false;
        }
        Object initText = object;
        FileType fileType = VisualizedTextPopupUtilKt.access$guessTextFileType((String)initText);
        VisualizedTextPanel parentDisposable = this;
        Editor $this$tryEditText_u24lambda_u240 = editor = DebuggerUIUtil.createFormattedTextEditor((String)initText, fileType, this.project, (Disposable)parentDisposable, false);
        boolean bl = false;
        $this$tryEditText_u24lambda_u240.getComponent().setBorder((Border)JBUI.Borders.empty());
        Editor editor2 = editor;
        JComponent jComponent = editor2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.showComponent(jComponent);
        editor2.getCaretModel().getPrimaryCaret().setSelection(0, editor2.getDocument().getTextLength(), false);
        editor2.getContentComponent().requestFocus();
        Intrinsics.checkNotNull((Object)editor2);
        this.state = new Editing((String)initText, editor2);
        return true;
    }

    @NotNull
    public final String finishEdit(boolean saveChanges) {
        Object object = this.state;
        Editing editing = object instanceof Editing ? (Editing)object : null;
        if (editing == null) {
            VisualizedTextPanel $this$finishEdit_u24lambda_u240 = this;
            boolean bl = false;
            VisualizedTextPopupUtilKt.access$getLOG$p().error("tryEditText() must be called before finishEdit()");
            return "";
        }
        Editing state = editing;
        object = saveChanges ? state.getEditor().getDocument().getText() : state.getInitText();
        Intrinsics.checkNotNull((Object)object);
        Object newValue = object;
        this.showVisualizedText((String)newValue);
        return newValue;
    }

    private static final Unit showTextMessage$lambda$0(TextViewer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit showError$lambda$0(TextViewer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.setForeground(XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES.getFgColor());
        return Unit.INSTANCE;
    }

    private static final void createTabbedPane$onTabShown(List<? extends VisualizedContentTab> tabs, JBTabbedPane panel2, String selectedTabKey, Set<VisualizedContentTab> alreadyShownTabs, VisualizedTextPanel this$0) {
        VisualizedContentTab visualizedContentTab = (VisualizedContentTab)CollectionsKt.getOrNull(tabs, (int)panel2.getSelectedIndex());
        if (visualizedContentTab == null) {
            return;
        }
        VisualizedContentTab selectedTab = visualizedContentTab;
        PropertiesComponent.getInstance().setValue(selectedTabKey, selectedTab.getId());
        boolean firstTime = alreadyShownTabs.add(selectedTab);
        selectedTab.onShown(this$0.project, firstTime);
    }

    private static final void createTabbedPane$lambda$3(List $tabs, JBTabbedPane $panel, String $selectedTabKey, Set $alreadyShownTabs, VisualizedTextPanel this$0, ChangeEvent it) {
        VisualizedTextPanel.createTabbedPane$onTabShown($tabs, $panel, $selectedTabKey, $alreadyShownTabs, this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$Editing;", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$State;", "initText", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/Editor;)V", "getInitText", "()Ljava/lang/String;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.debugger.impl"})
    private static final class Editing
    extends State {
        @NotNull
        private final String initText;
        @NotNull
        private final Editor editor;

        public Editing(@NotNull String initText, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)initText, (String)"initText");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(null);
            this.initText = initText;
            this.editor = editor;
        }

        @NotNull
        public final String getInitText() {
            return this.initText;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final String component1() {
            return this.initText;
        }

        @NotNull
        public final Editor component2() {
            return this.editor;
        }

        @NotNull
        public final Editing copy(@NotNull String initText, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)initText, (String)"initText");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return new Editing(initText, editor);
        }

        public static /* synthetic */ Editing copy$default(Editing editing, String string, Editor editor, int n, Object object) {
            if ((n & 1) != 0) {
                string = editing.initText;
            }
            if ((n & 2) != 0) {
                editor = editing.editor;
            }
            return editing.copy(string, editor);
        }

        @NotNull
        public String toString() {
            return "Editing(initText=" + this.initText + ", editor=" + this.editor + ")";
        }

        public int hashCode() {
            int result2 = this.initText.hashCode();
            result2 = result2 * 31 + this.editor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Editing)) {
                return false;
            }
            Editing editing = (Editing)other;
            if (!Intrinsics.areEqual((Object)this.initText, (Object)editing.initText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.editor, (Object)editing.editor);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$Other;", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$State;", "<init>", "()V", "intellij.platform.debugger.impl"})
    private static final class Other
    extends State {
        @NotNull
        public static final Other INSTANCE = new Other();

        private Other() {
            super(null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$Showing;", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$State;", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.debugger.impl"})
    private static final class Showing
    extends State {
        @NotNull
        private final String text;

        public Showing(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(null);
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Showing copy(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Showing(text);
        }

        public static /* synthetic */ Showing copy$default(Showing showing, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = showing.text;
            }
            return showing.copy(string);
        }

        @NotNull
        public String toString() {
            return "Showing(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Showing)) {
                return false;
            }
            Showing showing = (Showing)other;
            return Intrinsics.areEqual((Object)this.text, (Object)showing.text);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$State;", "", "<init>", "()V", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$Editing;", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$Other;", "Lcom/intellij/xdebugger/impl/ui/visualizedtext/VisualizedTextPanel$Showing;", "intellij.platform.debugger.impl"})
    private static abstract sealed class State
    permits Editing, Other, Showing {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

