/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.utils;

import com.intellij.openapi.util.NlsContexts;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class AbstractTableModelWithColumns
extends AbstractTableModel {
    private final TableColumnDescriptor[] myColumnDescriptors;

    public AbstractTableModelWithColumns(TableColumnDescriptor[] descriptors) {
        this.myColumnDescriptors = descriptors;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.myColumnDescriptors[columnIndex].getColumnClass();
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnDescriptors[column].getName();
    }

    @Override
    public int getColumnCount() {
        return this.myColumnDescriptors.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumnDescriptors[columnIndex].getValue(rowIndex);
    }

    @ApiStatus.Internal
    public static interface TableColumnDescriptor {
        public Class<?> getColumnClass();

        public Object getValue(int var1);

        @NlsContexts.ColumnName
        public String getName();
    }
}

