/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters;

import com.fasterxml.jackson.core.JsonGenerator;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.IdGenerator;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"beginWriter", "", "w", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serviceName", "", "serviceVersion", "serviceNamespace", "writeStringTag", "name", "value", "writeAttributesAsJson", "attributes", "Lio/opentelemetry/api/common/Attributes;", "closeJsonFile", "jsonGenerator", "jsonEnd", "", "intellij.platform.diagnostic.telemetry.exporters"})
public final class JaegerJsonSpanExporterKt {
    @NotNull
    private static final byte[] jsonEnd = StringsKt.encodeToByteArray((String)"]}]}");

    private static final void beginWriter(JsonGenerator w, String serviceName, String serviceVersion, String serviceNamespace) {
        w.writeStartObject();
        w.writeArrayFieldStart("data");
        w.writeStartObject();
        w.writeStringField("traceID", IdGenerator.random().generateTraceId());
        w.writeObjectFieldStart("processes");
        w.writeObjectFieldStart("p1");
        w.writeStringField("serviceName", serviceName);
        w.writeArrayFieldStart("tags");
        w.writeStartObject();
        w.writeStringField("key", "time");
        w.writeStringField("type", "string");
        w.writeStringField("value", ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
        w.writeEndObject();
        if (serviceVersion != null) {
            JaegerJsonSpanExporterKt.writeStringTag("service.version", serviceVersion, w);
        }
        if (serviceNamespace != null) {
            JaegerJsonSpanExporterKt.writeStringTag("service.namespace", serviceNamespace, w);
        }
        w.writeEndArray();
        w.writeEndObject();
        w.writeEndObject();
        w.writeArrayFieldStart("spans");
    }

    private static final void writeStringTag(String name, String value, JsonGenerator w) {
        w.writeStartObject();
        w.writeStringField("key", name);
        w.writeStringField("type", "string");
        w.writeStringField("value", value);
        w.writeEndObject();
    }

    private static final void writeAttributesAsJson(JsonGenerator w, Attributes attributes) {
        attributes.forEach((arg_0, arg_1) -> JaegerJsonSpanExporterKt.writeAttributesAsJson$lambda$1((arg_0, arg_1) -> JaegerJsonSpanExporterKt.writeAttributesAsJson$lambda$0(w, arg_0, arg_1), arg_0, arg_1));
    }

    private static final void closeJsonFile(JsonGenerator jsonGenerator) {
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
    }

    private static final Unit writeAttributesAsJson$lambda$0(JsonGenerator $w, AttributeKey k, Object v) {
        $w.writeStartObject();
        $w.writeStringField("key", k.getKey());
        String string = k.getType().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        $w.writeStringField("type", string);
        if (v instanceof Iterable) {
            $w.writeArrayFieldStart("value");
            for (Object item : (Iterable)v) {
                Intrinsics.checkNotNull(item, (String)"null cannot be cast to non-null type kotlin.String");
                $w.writeString((String)item);
            }
            $w.writeEndArray();
        } else {
            $w.writeStringField("value", v.toString());
        }
        $w.writeEndObject();
        return Unit.INSTANCE;
    }

    private static final void writeAttributesAsJson$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$beginWriter(JsonGenerator w, String serviceName, String serviceVersion, String serviceNamespace) {
        JaegerJsonSpanExporterKt.beginWriter(w, serviceName, serviceVersion, serviceNamespace);
    }

    public static final /* synthetic */ void access$writeAttributesAsJson(JsonGenerator w, Attributes attributes) {
        JaegerJsonSpanExporterKt.writeAttributesAsJson(w, attributes);
    }

    public static final /* synthetic */ void access$closeJsonFile(JsonGenerator jsonGenerator) {
        JaegerJsonSpanExporterKt.closeJsonFile(jsonGenerator);
    }

    public static final /* synthetic */ byte[] access$getJsonEnd$p() {
        return jsonEnd;
    }
}

