/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters;

import com.intellij.openapi.diagnostic.Logger;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bJ)\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\b\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/OpenTelemetryRawTraceExporter;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "sendProtobuf", "", "targetUri", "Ljava/net/URI;", "binaryTraces", "", "sendJson", "json", "send", "customizer", "Lkotlin/Function1;", "Ljava/net/http/HttpRequest$Builder;", "Lkotlin/ExtensionFunctionType;", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nOpenTelemetryRawTraceExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenTelemetryRawTraceExporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/OpenTelemetryRawTraceExporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n13#2:45\n*S KotlinDebug\n*F\n+ 1 OpenTelemetryRawTraceExporter.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/OpenTelemetryRawTraceExporter\n*L\n15#1:45\n*E\n"})
public final class OpenTelemetryRawTraceExporter {
    @NotNull
    public static final OpenTelemetryRawTraceExporter INSTANCE = new OpenTelemetryRawTraceExporter();
    @NotNull
    private static final Logger LOG;

    private OpenTelemetryRawTraceExporter() {
    }

    public final void sendProtobuf(@NotNull URI targetUri, @NotNull byte[] binaryTraces) {
        Intrinsics.checkNotNullParameter((Object)targetUri, (String)"targetUri");
        Intrinsics.checkNotNullParameter((Object)binaryTraces, (String)"binaryTraces");
        this.send(targetUri, (Function1<? super HttpRequest.Builder, ? extends HttpRequest.Builder>)((Function1)arg_0 -> OpenTelemetryRawTraceExporter.sendProtobuf$lambda$0(binaryTraces, arg_0)));
    }

    public final void sendJson(@NotNull URI targetUri, @NotNull byte[] json) {
        Intrinsics.checkNotNullParameter((Object)targetUri, (String)"targetUri");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.send(targetUri, (Function1<? super HttpRequest.Builder, ? extends HttpRequest.Builder>)((Function1)arg_0 -> OpenTelemetryRawTraceExporter.sendJson$lambda$0(json, arg_0)));
    }

    private final void send(URI targetUri, Function1<? super HttpRequest.Builder, ? extends HttpRequest.Builder> customizer) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(targetUri);
            HttpClient httpClient = HttpClient.newHttpClient();
            Intrinsics.checkNotNull((Object)builder);
            httpClient.send(((HttpRequest.Builder)customizer.invoke((Object)builder)).build(), HttpResponse.BodyHandlers.discarding());
        }
        catch (Exception e) {
            LOG.warn("Unable to upload performance traces to the OTLP server (" + targetUri + ")");
        }
    }

    private static final HttpRequest.Builder sendProtobuf$lambda$0(byte[] $binaryTraces, HttpRequest.Builder $this$send) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"$this$send");
        $this$send.POST(HttpRequest.BodyPublishers.ofByteArray($binaryTraces));
        HttpRequest.Builder builder = $this$send.header("Content-Type", "application/x-protobuf");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"header(...)");
        return builder;
    }

    private static final HttpRequest.Builder sendJson$lambda$0(byte[] $json, HttpRequest.Builder $this$send) {
        Intrinsics.checkNotNullParameter((Object)$this$send, (String)"$this$send");
        $this$send.POST(HttpRequest.BodyPublishers.ofByteArray($json));
        HttpRequest.Builder builder = $this$send.header("Content-Type", "application/json");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"header(...)");
        return builder;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OpenTelemetryRawTraceExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

