/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.exporters.meters;

import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010J\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/exporters/meters/LinesStorage;", "", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "bufferedWriter", "Ljava/io/BufferedWriter;", "lines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "updateDestFile", "", "newFile", "getLines", "", "clearStorage", "closeBufferedWriter", "appendLine", "line", "appendHeaderLines", "dump", "intellij.platform.diagnostic.telemetry.exporters"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLinesStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinesStorage.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/LinesStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1869#2,2:59\n*S KotlinDebug\n*F\n+ 1 LinesStorage.kt\ncom/intellij/platform/diagnostic/telemetry/exporters/meters/LinesStorage\n*L\n52#1:59,2\n*E\n"})
public final class LinesStorage {
    @NotNull
    private BufferedWriter bufferedWriter;
    @NotNull
    private final ArrayList<String> lines;

    public LinesStorage(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(file, new OpenOption[0]), true);
        Charset charset = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter(outputStream, charset);
        int n = 8192;
        this.bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        this.lines = new ArrayList();
    }

    public final void updateDestFile(@NotNull Path newFile) {
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        this.closeBufferedWriter();
        OutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(newFile, new OpenOption[0]), true);
        Charset charset = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter(outputStream, charset);
        int n = 8192;
        this.bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> getLines() {
        ArrayList<String> arrayList = this.lines;
        synchronized (arrayList) {
            boolean bl = false;
            List list = CollectionsKt.toList((Iterable)this.lines);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearStorage() {
        ArrayList<String> arrayList = this.lines;
        synchronized (arrayList) {
            boolean bl = false;
            this.lines.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void closeBufferedWriter() {
        this.bufferedWriter.flush();
        this.bufferedWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        ArrayList<String> arrayList = this.lines;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.lines.add(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendHeaderLines() {
        ArrayList<String> arrayList = this.lines;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.lines.addAll(OpenTelemetryUtils.INSTANCE.csvHeadersLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump() {
        BufferedWriter out = this.bufferedWriter;
        boolean bl = false;
        ArrayList<String> arrayList = this.lines;
        synchronized (arrayList) {
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.lines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                ((Appendable)out).append(it).append('\n');
            }
            this.lines.clear();
            Unit unit = Unit.INSTANCE;
        }
        out.flush();
    }
}

