/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl;

import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TracerLevel;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/TraceWrapper;", "Lcom/intellij/platform/diagnostic/telemetry/IJTracer;", "scopeName", "", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "detailedTracers", "", "verbose", "", "<init>", "(Ljava/lang/String;Lio/opentelemetry/api/trace/Tracer;Ljava/util/Set;Z)V", "spanBuilder", "Lio/opentelemetry/api/trace/SpanBuilder;", "spanName", "level", "Lcom/intellij/platform/diagnostic/telemetry/TracerLevel;", "intellij.platform.diagnostic.telemetry.impl"})
final class TraceWrapper
implements IJTracer {
    @NotNull
    private final String scopeName;
    @NotNull
    private final Tracer tracer;
    @NotNull
    private final Set<String> detailedTracers;
    private final boolean verbose;

    public TraceWrapper(@NotNull String scopeName, @NotNull Tracer tracer, @NotNull Set<String> detailedTracers, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        Intrinsics.checkNotNullParameter(detailedTracers, (String)"detailedTracers");
        this.scopeName = scopeName;
        this.tracer = tracer;
        this.detailedTracers = detailedTracers;
        this.verbose = verbose;
    }

    @NotNull
    public SpanBuilder spanBuilder(@NotNull String spanName) {
        Intrinsics.checkNotNullParameter((Object)spanName, (String)"spanName");
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        return spanBuilder;
    }

    @NotNull
    public SpanBuilder spanBuilder(@NotNull String spanName, @NotNull TracerLevel level) {
        Intrinsics.checkNotNullParameter((Object)spanName, (String)"spanName");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (level == TracerLevel.DETAILED && !this.verbose && !this.detailedTracers.contains(this.scopeName)) {
            SpanBuilder spanBuilder = OpenTelemetry.noop().getTracer(this.scopeName).spanBuilder(spanName);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            return spanBuilder;
        }
        return this.spanBuilder(spanName);
    }
}

