/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl.agent;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/agent/TelemetryAgentResolver;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "JAVA_AGENT_VERSION", "", "JAVA_AGENT_FILE_SHA_256", "JAVA_AGENT_URI", "getAgentLocation", "Ljava/nio/file/Path;", "downloadAgent", "", "location", "isAgentHashMatch", "path", "getFileHash", "intellij.platform.diagnostic.telemetry.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTelemetryAgentResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelemetryAgentResolver.kt\ncom/intellij/platform/diagnostic/telemetry/impl/agent/TelemetryAgentResolver\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n32#2,2:83\n13#3:85\n*S KotlinDebug\n*F\n+ 1 TelemetryAgentResolver.kt\ncom/intellij/platform/diagnostic/telemetry/impl/agent/TelemetryAgentResolver\n*L\n75#1:83,2\n21#1:85\n*E\n"})
public final class TelemetryAgentResolver {
    @NotNull
    public static final TelemetryAgentResolver INSTANCE = new TelemetryAgentResolver();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final String JAVA_AGENT_VERSION = "2.8.0";
    @NotNull
    private static final String JAVA_AGENT_FILE_SHA_256 = "d6ff4ea6fe5dc39c30123106b782940e261fbed21047a9761ab6a59b591092a0";
    @NotNull
    private static final String JAVA_AGENT_URI = "https://github.com/open-telemetry/opentelemetry-java-instrumentation/releases/download/v2.8.0/opentelemetry-javaagent.jar";

    private TelemetryAgentResolver() {
    }

    @JvmStatic
    @Nullable
    public static final Path getAgentLocation() {
        Path location = PathManager.getSystemDir().resolve("otlp-agent").resolve("opentelemetry-javaagent-2.8.0.jar");
        Intrinsics.checkNotNull((Object)location);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(location, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (!INSTANCE.isAgentHashMatch(location)) {
                LOGGER.warn("OpenTelemetry java agent hash did not match with the expected value");
            }
            return location;
        }
        PathsKt.createParentDirectories((Path)location, (FileAttribute[])new FileAttribute[0]);
        if (INSTANCE.downloadAgent(location) && INSTANCE.isAgentHashMatch(location)) {
            return location;
        }
        LOGGER.warn("OpenTelemetry java agent hash did not match with the expected value. The agent is considered as invalid.");
        Files.deleteIfExists(location);
        return null;
    }

    private final boolean downloadAgent(Path location) {
        boolean success;
        LOGGER.info("Downloading OpenTelemetry java agent");
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(JAVA_AGENT_URI)).GET().build();
        HttpResponse<Path> response = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build().send(request, HttpResponse.BodyHandlers.ofFile(location));
        boolean bl = success = response.statusCode() == 200;
        if (!success) {
            LOGGER.warn("Unable to download an OpenTelemetry agent. Http status code: " + response.statusCode());
        }
        return success;
    }

    private final boolean isAgentHashMatch(Path path) {
        String actualHash = this.getFileHash(path);
        return Intrinsics.areEqual((Object)JAVA_AGENT_FILE_SHA_256, (Object)actualHash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFileHash(Path path) {
        Hasher hasher = Hashing.sha256().newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"newHasher(...)");
        Hasher hasher2 = hasher;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = stream;
            int n = 1024;
            closeable2 = closeable2 instanceof BufferedInputStream ? (BufferedInputStream)closeable2 : new BufferedInputStream((InputStream)closeable2, n);
            Throwable throwable2 = null;
            try {
                BufferedInputStream bufferedStream = (BufferedInputStream)closeable2;
                boolean bl2 = false;
                Iterator $this$forEach$iv = (Iterator)ByteStreamsKt.iterator((BufferedInputStream)bufferedStream);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    byte by = ((Number)element$iv).byteValue();
                    boolean bl3 = false;
                    hasher2.putByte(by);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = hasher2.hash().asBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"asBytes(...)");
        return HexExtensionsKt.toHexString((byte[])byArray, (HexFormat)HexFormat.Companion.getDefault());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TelemetryAgentResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

