/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.platform.diagnostic.telemetry.impl.CoroutineTimeMeasurerKey;
import com.intellij.platform.diagnostic.telemetry.impl.TraceReporter;
import com.intellij.platform.diagnostic.telemetry.impl.TracerKt;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CopyableThreadContextElement;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001d\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/CoroutineTimeMeasurer;", "Lkotlinx/coroutines/CopyableThreadContextElement;", "", "parentActivity", "Lcom/intellij/diagnostic/ActivityImpl;", "reporter", "Lcom/intellij/platform/diagnostic/telemetry/impl/TraceReporter;", "<init>", "(Lcom/intellij/diagnostic/ActivityImpl;Lcom/intellij/platform/diagnostic/telemetry/impl/TraceReporter;)V", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "creationTime", "", "currentActivity", "Lcom/intellij/diagnostic/Activity;", "getCurrentActivity$annotations", "()V", "lastSuspensionTime", "getLastSuspensionTime$annotations", "toString", "", "updateThreadContext", "context", "Lkotlin/coroutines/CoroutineContext;", "restoreThreadContext", "oldState", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/Unit;)V", "copyForChild", "mergeForChild", "overwritingElement", "Lkotlin/coroutines/CoroutineContext$Element;", "getActivity", "Companion", "intellij.platform.diagnostic.telemetry.impl"})
final class CoroutineTimeMeasurer
implements CopyableThreadContextElement<Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ActivityImpl parentActivity;
    @NotNull
    private final TraceReporter reporter;
    private final long creationTime;
    @Nullable
    private Activity currentActivity;
    private long lastSuspensionTime;
    @NotNull
    private static final VarHandle CURRENT_ACTIVITY;
    @NotNull
    private static final VarHandle LAST_SUSPENSION_TIME;

    public CoroutineTimeMeasurer(@Nullable ActivityImpl parentActivity, @NotNull TraceReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.parentActivity = parentActivity;
        this.reporter = reporter;
        this.creationTime = System.nanoTime();
        this.lastSuspensionTime = -1L;
    }

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return CoroutineTimeMeasurerKey.INSTANCE;
    }

    private static /* synthetic */ void getCurrentActivity$annotations() {
    }

    private static /* synthetic */ void getLastSuspensionTime$annotations() {
    }

    @NotNull
    public String toString() {
        Object object;
        Activity activity = CURRENT_ACTIVITY.getVolatile(this);
        if (activity == TracerKt.access$getNoActivity$p()) {
            object = "no parent and no name";
        } else {
            Activity activity2 = activity;
            if (activity2 != null) {
                String string = activity2.getName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            } else {
                object = this.parentActivity != null ? "uninitialized child of " + this.parentActivity.getName() : "uninitialized";
            }
        }
        return object;
    }

    public void updateThreadContext(@NotNull CoroutineContext context) {
        String coroutineName;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (CURRENT_ACTIVITY.getVolatile(this) != null) {
            return;
        }
        CoroutineName coroutineName2 = (CoroutineName)context.get((CoroutineContext.Key)CoroutineName.Key);
        String string = coroutineName = coroutineName2 != null ? coroutineName2.getName() : null;
        if (this.parentActivity != null && (coroutineName == null || Intrinsics.areEqual((Object)this.parentActivity.getName(), (Object)coroutineName))) {
            CURRENT_ACTIVITY.setVolatile(this, this.parentActivity);
            return;
        }
        if (coroutineName == null) {
            CURRENT_ACTIVITY.setVolatile(this, TracerKt.access$getNoActivity$p());
            return;
        }
        ActivityImpl activity = this.reporter.start(coroutineName, this.creationTime, this.parentActivity);
        CURRENT_ACTIVITY.setVolatile(this, activity);
        Job job = JobKt.getJob((CoroutineContext)context);
        job.invokeOnCompletion(arg_0 -> CoroutineTimeMeasurer.updateThreadContext$lambda$0(this, activity, coroutineName, arg_0));
    }

    public void restoreThreadContext(@NotNull CoroutineContext context, @NotNull Unit oldState) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        LAST_SUSPENSION_TIME.setVolatile(this, System.nanoTime());
    }

    @NotNull
    public CopyableThreadContextElement<Unit> copyForChild() {
        Object activity = CURRENT_ACTIVITY.getVolatile(this);
        if (activity == TracerKt.access$getNoActivity$p() || activity == null) {
            return new CoroutineTimeMeasurer(null, this.reporter);
        }
        return new CoroutineTimeMeasurer((ActivityImpl)activity, this.reporter);
    }

    @NotNull
    public CoroutineContext mergeForChild(@NotNull CoroutineContext.Element overwritingElement) {
        Intrinsics.checkNotNullParameter((Object)overwritingElement, (String)"overwritingElement");
        return (CoroutineContext)overwritingElement;
    }

    @Nullable
    public final ActivityImpl getActivity() {
        return CURRENT_ACTIVITY.getVolatile(this);
    }

    private static final Unit updateThreadContext$lambda$0(CoroutineTimeMeasurer this$0, ActivityImpl $activity, String $coroutineName, Throwable it) {
        long end = System.nanoTime();
        long lastSuspensionTime = LAST_SUSPENSION_TIME.getVolatile(this$0);
        this$0.reporter.end($activity, $coroutineName, end, lastSuspensionTime);
        return Unit.INSTANCE;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(CoroutineTimeMeasurer.class, MethodHandles.lookup());
        VarHandle varHandle = lookup.findVarHandle(CoroutineTimeMeasurer.class, "currentActivity", Activity.class);
        Intrinsics.checkNotNullExpressionValue((Object)varHandle, (String)"findVarHandle(...)");
        CURRENT_ACTIVITY = varHandle;
        VarHandle varHandle2 = lookup.findVarHandle(CoroutineTimeMeasurer.class, "lastSuspensionTime", Long.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)varHandle2, (String)"findVarHandle(...)");
        LAST_SUSPENSION_TIME = varHandle2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/CoroutineTimeMeasurer$Companion;", "", "<init>", "()V", "CURRENT_ACTIVITY", "Ljava/lang/invoke/VarHandle;", "LAST_SUSPENSION_TIME", "intellij.platform.diagnostic.telemetry.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

