/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.impl.agent;

import com.intellij.ide.plugins.ContentModuleDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginModuleId;
import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContext;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J;\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration;", "", "serviceName", "", "traceEndpoint", "Ljava/net/URI;", "settings", "Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings;", "context", "Lcom/intellij/platform/diagnostic/telemetry/rt/context/TelemetryContext;", "agentLocation", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/net/URI;Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings;Lcom/intellij/platform/diagnostic/telemetry/rt/context/TelemetryContext;Ljava/nio/file/Path;)V", "getServiceName", "()Ljava/lang/String;", "getTraceEndpoint", "()Ljava/net/URI;", "getSettings", "()Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings;", "getContext", "()Lcom/intellij/platform/diagnostic/telemetry/rt/context/TelemetryContext;", "getAgentLocation", "()Ljava/nio/file/Path;", "toJavaAgentSettings", "Ljava/util/Properties;", "getAgentExtensionPath", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Settings", "Companion", "intellij.platform.diagnostic.telemetry.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAgentConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgentConfiguration.kt\ncom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n230#2,2:149\n*S KotlinDebug\n*F\n+ 1 AgentConfiguration.kt\ncom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration\n*L\n143#1:149,2\n*E\n"})
public final class AgentConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String serviceName;
    @NotNull
    private final URI traceEndpoint;
    @NotNull
    private final Settings settings;
    @NotNull
    private final TelemetryContext context;
    @NotNull
    private final Path agentLocation;
    @NotNull
    private static final String AGENT_EXTENSION_MODULE_NAME = "intellij.platform.diagnostic.telemetry.agent.extension";

    public AgentConfiguration(@NotNull String serviceName, @NotNull URI traceEndpoint, @NotNull Settings settings, @NotNull TelemetryContext context, @NotNull Path agentLocation) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)traceEndpoint, (String)"traceEndpoint");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentLocation, (String)"agentLocation");
        this.serviceName = serviceName;
        this.traceEndpoint = traceEndpoint;
        this.settings = settings;
        this.context = context;
        this.agentLocation = agentLocation;
    }

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    @NotNull
    public final URI getTraceEndpoint() {
        return this.traceEndpoint;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final TelemetryContext getContext() {
        return this.context;
    }

    @NotNull
    public final Path getAgentLocation() {
        return this.agentLocation;
    }

    @NotNull
    public final Properties toJavaAgentSettings() {
        Path agentExtensionPath;
        Properties properties;
        Properties $this$toJavaAgentSettings_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        $this$toJavaAgentSettings_u24lambda_u240.put("otel.traces.exporter", "otlp");
        $this$toJavaAgentSettings_u24lambda_u240.put("otel.exporter.otlp.traces.endpoint", this.traceEndpoint.toString());
        $this$toJavaAgentSettings_u24lambda_u240.put("otel.service.name", this.serviceName);
        if (this.settings.getEnabled()) {
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.javaagent.enabled", "true");
        }
        if (this.settings.getDebug()) {
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.javaagent.debug", "true");
        }
        if (this.settings.getOpenTelemetryApiEnabled()) {
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.instrumentation.opentelemetry-api.enabled", "true");
        }
        if (this.settings.getRmiEnabled()) {
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.instrumentation.rmi.enabled", "true");
        }
        if (this.settings.getCommonMetricsEnabled()) {
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.instrumentation.common.default.enabled", "true");
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.instrumentation.runtime.metrics.enabled", "true");
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.instrumentation.jvm.metrics.enabled", "true");
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.instrumentation.executors.enabled", "true");
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.instrumentation.jmx-metrics.enabled", "true");
            if (this.settings.getMetricExportInterval-FghU774() != null) {
                $this$toJavaAgentSettings_u24lambda_u240.put("otel.metric.export.interval", String.valueOf(Duration.getInWholeMilliseconds-impl((long)this.settings.getMetricExportInterval-FghU774().unbox-impl())));
            }
        }
        if (this.settings.getOutputJsonDestination() != null && (agentExtensionPath = this.getAgentExtensionPath()) != null) {
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.traces.exporter.json.file.enabled", "true");
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.traces.exporter.json.file.location", ((Object)this.settings.getOutputJsonDestination()).toString());
            $this$toJavaAgentSettings_u24lambda_u240.put("otel.javaagent.extensions", ((Object)agentExtensionPath).toString());
        }
        return properties;
    }

    private final Path getAgentExtensionPath() {
        Path path;
        ContentModuleDescriptor contentModuleDescriptor = PluginManagerCore.getPluginSet().findEnabledModule(PluginModuleId.Companion.invoke(AGENT_EXTENSION_MODULE_NAME, "jetbrains"));
        if (contentModuleDescriptor == null) {
            return null;
        }
        ContentModuleDescriptor moduleDescriptor = contentModuleDescriptor;
        List list = moduleDescriptor.getJarFiles();
        if (list != null) {
            Object element$iv2;
            block4: {
                Iterable $this$first$iv = list;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Path it = (Path)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)"intellij.platform.diagnostic.telemetry.agent.extension.jar")) continue;
                    break block4;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            path = (Path)element$iv2;
        } else {
            path = null;
        }
        return path;
    }

    @NotNull
    public final String component1() {
        return this.serviceName;
    }

    @NotNull
    public final URI component2() {
        return this.traceEndpoint;
    }

    @NotNull
    public final Settings component3() {
        return this.settings;
    }

    @NotNull
    public final TelemetryContext component4() {
        return this.context;
    }

    @NotNull
    public final Path component5() {
        return this.agentLocation;
    }

    @NotNull
    public final AgentConfiguration copy(@NotNull String serviceName, @NotNull URI traceEndpoint, @NotNull Settings settings, @NotNull TelemetryContext context, @NotNull Path agentLocation) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)traceEndpoint, (String)"traceEndpoint");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)agentLocation, (String)"agentLocation");
        return new AgentConfiguration(serviceName, traceEndpoint, settings, context, agentLocation);
    }

    public static /* synthetic */ AgentConfiguration copy$default(AgentConfiguration agentConfiguration, String string, URI uRI, Settings settings, TelemetryContext telemetryContext, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            string = agentConfiguration.serviceName;
        }
        if ((n & 2) != 0) {
            uRI = agentConfiguration.traceEndpoint;
        }
        if ((n & 4) != 0) {
            settings = agentConfiguration.settings;
        }
        if ((n & 8) != 0) {
            telemetryContext = agentConfiguration.context;
        }
        if ((n & 0x10) != 0) {
            path = agentConfiguration.agentLocation;
        }
        return agentConfiguration.copy(string, uRI, settings, telemetryContext, path);
    }

    @NotNull
    public String toString() {
        return "AgentConfiguration(serviceName=" + this.serviceName + ", traceEndpoint=" + this.traceEndpoint + ", settings=" + this.settings + ", context=" + this.context + ", agentLocation=" + this.agentLocation + ")";
    }

    public int hashCode() {
        int result = this.serviceName.hashCode();
        result = result * 31 + this.traceEndpoint.hashCode();
        result = result * 31 + this.settings.hashCode();
        result = result * 31 + this.context.hashCode();
        result = result * 31 + ((Object)this.agentLocation).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AgentConfiguration)) {
            return false;
        }
        AgentConfiguration agentConfiguration = (AgentConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.serviceName, (Object)agentConfiguration.serviceName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.traceEndpoint, (Object)agentConfiguration.traceEndpoint)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.settings, (Object)agentConfiguration.settings)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.context, (Object)agentConfiguration.context)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.agentLocation, (Object)agentConfiguration.agentLocation);
    }

    @JvmStatic
    @NotNull
    public static final AgentConfiguration forService(@NotNull String serviceName, @NotNull TelemetryContext context, @NotNull URI traceEndpoint, @NotNull Path agentLocation, @NotNull Settings settings) {
        return Companion.forService(serviceName, context, traceEndpoint, agentLocation, settings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Companion;", "", "<init>", "()V", "AGENT_EXTENSION_MODULE_NAME", "", "forService", "Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration;", "serviceName", "context", "Lcom/intellij/platform/diagnostic/telemetry/rt/context/TelemetryContext;", "traceEndpoint", "Ljava/net/URI;", "agentLocation", "Ljava/nio/file/Path;", "settings", "Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings;", "intellij.platform.diagnostic.telemetry.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AgentConfiguration forService(@NotNull String serviceName, @NotNull TelemetryContext context, @NotNull URI traceEndpoint, @NotNull Path agentLocation, @NotNull Settings settings) {
            Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)traceEndpoint, (String)"traceEndpoint");
            Intrinsics.checkNotNullParameter((Object)agentLocation, (String)"agentLocation");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return new AgentConfiguration(serviceName, traceEndpoint, settings, context, agentLocation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0002()BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\b\u001eJ\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JX\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\b!J\u0013\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings;", "", "enabled", "", "openTelemetryApiEnabled", "rmiEnabled", "debug", "commonMetricsEnabled", "metricExportInterval", "Lkotlin/time/Duration;", "outputJsonDestination", "Ljava/nio/file/Path;", "<init>", "(ZZZZZLkotlin/time/Duration;Ljava/nio/file/Path;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getEnabled", "()Z", "getOpenTelemetryApiEnabled", "getRmiEnabled", "getDebug", "getCommonMetricsEnabled", "getMetricExportInterval-FghU774", "()Lkotlin/time/Duration;", "getOutputJsonDestination", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "component4", "component5", "component6", "component6-FghU774", "component7", "copy", "copy-7Yrd8eY", "equals", "other", "hashCode", "", "toString", "", "Builder", "Companion", "intellij.platform.diagnostic.telemetry.impl"})
    public static final class Settings {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean enabled;
        private final boolean openTelemetryApiEnabled;
        private final boolean rmiEnabled;
        private final boolean debug;
        private final boolean commonMetricsEnabled;
        @Nullable
        private final Duration metricExportInterval;
        @Nullable
        private final Path outputJsonDestination;

        private Settings(boolean enabled, boolean openTelemetryApiEnabled, boolean rmiEnabled, boolean debug, boolean commonMetricsEnabled, Duration metricExportInterval, Path outputJsonDestination) {
            this.enabled = enabled;
            this.openTelemetryApiEnabled = openTelemetryApiEnabled;
            this.rmiEnabled = rmiEnabled;
            this.debug = debug;
            this.commonMetricsEnabled = commonMetricsEnabled;
            this.metricExportInterval = metricExportInterval;
            this.outputJsonDestination = outputJsonDestination;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final boolean getOpenTelemetryApiEnabled() {
            return this.openTelemetryApiEnabled;
        }

        public final boolean getRmiEnabled() {
            return this.rmiEnabled;
        }

        public final boolean getDebug() {
            return this.debug;
        }

        public final boolean getCommonMetricsEnabled() {
            return this.commonMetricsEnabled;
        }

        @Nullable
        public final Duration getMetricExportInterval-FghU774() {
            return this.metricExportInterval;
        }

        @Nullable
        public final Path getOutputJsonDestination() {
            return this.outputJsonDestination;
        }

        public final boolean component1() {
            return this.enabled;
        }

        public final boolean component2() {
            return this.openTelemetryApiEnabled;
        }

        public final boolean component3() {
            return this.rmiEnabled;
        }

        public final boolean component4() {
            return this.debug;
        }

        public final boolean component5() {
            return this.commonMetricsEnabled;
        }

        @Nullable
        public final Duration component6-FghU774() {
            return this.metricExportInterval;
        }

        @Nullable
        public final Path component7() {
            return this.outputJsonDestination;
        }

        @NotNull
        public final Settings copy-7Yrd8eY(boolean enabled, boolean openTelemetryApiEnabled, boolean rmiEnabled, boolean debug, boolean commonMetricsEnabled, @Nullable Duration metricExportInterval, @Nullable Path outputJsonDestination) {
            return new Settings(enabled, openTelemetryApiEnabled, rmiEnabled, debug, commonMetricsEnabled, metricExportInterval, outputJsonDestination, null);
        }

        public static /* synthetic */ Settings copy-7Yrd8eY$default(Settings settings, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Duration duration, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                bl = settings.enabled;
            }
            if ((n & 2) != 0) {
                bl2 = settings.openTelemetryApiEnabled;
            }
            if ((n & 4) != 0) {
                bl3 = settings.rmiEnabled;
            }
            if ((n & 8) != 0) {
                bl4 = settings.debug;
            }
            if ((n & 0x10) != 0) {
                bl5 = settings.commonMetricsEnabled;
            }
            if ((n & 0x20) != 0) {
                duration = settings.metricExportInterval;
            }
            if ((n & 0x40) != 0) {
                path = settings.outputJsonDestination;
            }
            return settings.copy-7Yrd8eY(bl, bl2, bl3, bl4, bl5, duration, path);
        }

        @NotNull
        public String toString() {
            return "Settings(enabled=" + this.enabled + ", openTelemetryApiEnabled=" + this.openTelemetryApiEnabled + ", rmiEnabled=" + this.rmiEnabled + ", debug=" + this.debug + ", commonMetricsEnabled=" + this.commonMetricsEnabled + ", metricExportInterval=" + this.metricExportInterval + ", outputJsonDestination=" + this.outputJsonDestination + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.enabled);
            result = result * 31 + Boolean.hashCode(this.openTelemetryApiEnabled);
            result = result * 31 + Boolean.hashCode(this.rmiEnabled);
            result = result * 31 + Boolean.hashCode(this.debug);
            result = result * 31 + Boolean.hashCode(this.commonMetricsEnabled);
            result = result * 31 + (this.metricExportInterval == null ? 0 : Duration.hashCode-impl((long)this.metricExportInterval.unbox-impl()));
            result = result * 31 + (this.outputJsonDestination == null ? 0 : ((Object)this.outputJsonDestination).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Settings)) {
                return false;
            }
            Settings settings = (Settings)other;
            if (this.enabled != settings.enabled) {
                return false;
            }
            if (this.openTelemetryApiEnabled != settings.openTelemetryApiEnabled) {
                return false;
            }
            if (this.rmiEnabled != settings.rmiEnabled) {
                return false;
            }
            if (this.debug != settings.debug) {
                return false;
            }
            if (this.commonMetricsEnabled != settings.commonMetricsEnabled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.metricExportInterval, (Object)settings.metricExportInterval)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.outputJsonDestination, (Object)settings.outputJsonDestination);
        }

        @JvmStatic
        @NotNull
        public static final Builder builder() {
            return Companion.builder();
        }

        public /* synthetic */ Settings(boolean enabled, boolean openTelemetryApiEnabled, boolean rmiEnabled, boolean debug, boolean commonMetricsEnabled, Duration metricExportInterval, Path outputJsonDestination, DefaultConstructorMarker $constructor_marker) {
            this(enabled, openTelemetryApiEnabled, rmiEnabled, debug, commonMetricsEnabled, metricExportInterval, outputJsonDestination);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006("}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings$Builder;", "", "enabled", "", "openTelemetryApiEnabled", "rmiEnabled", "debug", "commonMetricsEnabled", "metricExportInterval", "Lkotlin/time/Duration;", "outputJsonDestination", "Ljava/nio/file/Path;", "<init>", "(ZZZZZLkotlin/time/Duration;Ljava/nio/file/Path;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getOpenTelemetryApiEnabled", "setOpenTelemetryApiEnabled", "getRmiEnabled", "setRmiEnabled", "getDebug", "setDebug", "getCommonMetricsEnabled", "setCommonMetricsEnabled", "getMetricExportInterval-FghU774", "()Lkotlin/time/Duration;", "setMetricExportInterval-BwNAW2A", "(Lkotlin/time/Duration;)V", "getOutputJsonDestination", "()Ljava/nio/file/Path;", "setOutputJsonDestination", "(Ljava/nio/file/Path;)V", "build", "Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings;", "withCommonJvmMetrics", "withDebugLogs", "withTelemetryDumpFile", "path", "intellij.platform.diagnostic.telemetry.impl"})
        public static final class Builder {
            private boolean enabled;
            private boolean openTelemetryApiEnabled;
            private boolean rmiEnabled;
            private boolean debug;
            private boolean commonMetricsEnabled;
            @Nullable
            private Duration metricExportInterval;
            @Nullable
            private Path outputJsonDestination;

            private Builder(boolean enabled, boolean openTelemetryApiEnabled, boolean rmiEnabled, boolean debug, boolean commonMetricsEnabled, Duration metricExportInterval, Path outputJsonDestination) {
                this.enabled = enabled;
                this.openTelemetryApiEnabled = openTelemetryApiEnabled;
                this.rmiEnabled = rmiEnabled;
                this.debug = debug;
                this.commonMetricsEnabled = commonMetricsEnabled;
                this.metricExportInterval = metricExportInterval;
                this.outputJsonDestination = outputJsonDestination;
            }

            public /* synthetic */ Builder(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Duration duration, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    bl2 = true;
                }
                if ((n & 4) != 0) {
                    bl3 = true;
                }
                if ((n & 8) != 0) {
                    bl4 = false;
                }
                if ((n & 0x10) != 0) {
                    bl5 = false;
                }
                if ((n & 0x20) != 0) {
                    duration = null;
                }
                if ((n & 0x40) != 0) {
                    path = null;
                }
                this(bl, bl2, bl3, bl4, bl5, duration, path, null);
            }

            public final boolean getEnabled() {
                return this.enabled;
            }

            public final void setEnabled(boolean bl) {
                this.enabled = bl;
            }

            public final boolean getOpenTelemetryApiEnabled() {
                return this.openTelemetryApiEnabled;
            }

            public final void setOpenTelemetryApiEnabled(boolean bl) {
                this.openTelemetryApiEnabled = bl;
            }

            public final boolean getRmiEnabled() {
                return this.rmiEnabled;
            }

            public final void setRmiEnabled(boolean bl) {
                this.rmiEnabled = bl;
            }

            public final boolean getDebug() {
                return this.debug;
            }

            public final void setDebug(boolean bl) {
                this.debug = bl;
            }

            public final boolean getCommonMetricsEnabled() {
                return this.commonMetricsEnabled;
            }

            public final void setCommonMetricsEnabled(boolean bl) {
                this.commonMetricsEnabled = bl;
            }

            @Nullable
            public final Duration getMetricExportInterval-FghU774() {
                return this.metricExportInterval;
            }

            public final void setMetricExportInterval-BwNAW2A(@Nullable Duration duration) {
                this.metricExportInterval = duration;
            }

            @Nullable
            public final Path getOutputJsonDestination() {
                return this.outputJsonDestination;
            }

            public final void setOutputJsonDestination(@Nullable Path path) {
                this.outputJsonDestination = path;
            }

            @NotNull
            public final Settings build() {
                return new Settings(this.enabled, this.openTelemetryApiEnabled, this.rmiEnabled, this.debug, this.commonMetricsEnabled, this.metricExportInterval, this.outputJsonDestination, null);
            }

            @NotNull
            public final Builder withCommonJvmMetrics() {
                this.commonMetricsEnabled = true;
                return this;
            }

            @NotNull
            public final Builder withDebugLogs() {
                this.debug = true;
                return this;
            }

            @NotNull
            public final Builder withTelemetryDumpFile(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                this.outputJsonDestination = path;
                return this;
            }

            public /* synthetic */ Builder(boolean enabled, boolean openTelemetryApiEnabled, boolean rmiEnabled, boolean debug, boolean commonMetricsEnabled, Duration metricExportInterval, Path outputJsonDestination, DefaultConstructorMarker $constructor_marker) {
                this(enabled, openTelemetryApiEnabled, rmiEnabled, debug, commonMetricsEnabled, metricExportInterval, outputJsonDestination);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings$Companion;", "", "<init>", "()V", "builder", "Lcom/intellij/platform/diagnostic/telemetry/impl/agent/AgentConfiguration$Settings$Builder;", "intellij.platform.diagnostic.telemetry.impl"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder() {
                return new Builder(false, false, false, false, false, null, null, 127, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

