/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.OpenTelemetryUtils;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Use com.intellij.platform.diagnostic.telemetry.exporters.meters.OpenTelemetryMetersJsonImporter")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J8\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bj\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J<\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bj\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/diagnostic/telemetry/MetricsImporterUtils;", "", "<init>", "()V", "isLongNumber", "", "", "fromCsvFile", "Ljava/util/HashMap;", "", "Lio/opentelemetry/sdk/metrics/data/LongPointData;", "Lkotlin/collections/HashMap;", "metricsCsvPath", "Ljava/nio/file/Path;", "metricsCsvFiles", "", "intellij.platform.diagnostic.telemetry"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMetricsImporterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsImporterUtils.kt\ncom/intellij/platform/diagnostic/telemetry/MetricsImporterUtils\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,72:1\n57#2:73\n1#3:74\n13#4:75\n216#5,2:76\n*S KotlinDebug\n*F\n+ 1 MetricsImporterUtils.kt\ncom/intellij/platform/diagnostic/telemetry/MetricsImporterUtils\n*L\n32#1:73\n32#1:74\n51#1:75\n65#1:76,2\n*E\n"})
public final class MetricsImporterUtils {
    @NotNull
    public static final MetricsImporterUtils INSTANCE = new MetricsImporterUtils();

    private MetricsImporterUtils() {
    }

    private final boolean isLongNumber(String $this$isLongNumber) {
        boolean bl;
        try {
            Long.parseLong($this$isLongNumber);
            bl = true;
        }
        catch (NumberFormatException e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HashMap<String, List<LongPointData>> fromCsvFile(Path metricsCsvPath) {
        HashMap<String, List<LongPointData>> meters = new HashMap<String, List<LongPointData>>();
        Path path = metricsCsvPath;
        Object object = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Reader $this$useLines$iv = new BufferedReader(new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(object, ((OpenOption[])object).length)), charset), n);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        closeable = (BufferedReader)closeable;
        object = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            for (String line : SequencesKt.drop((Sequence)lines, (int)OpenTelemetryUtils.INSTANCE.csvHeadersLines().size())) {
                if (((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()).length() == 0) continue;
                try {
                    LongPointData data;
                    List metrics;
                    String[] stringArray = new String[]{","};
                    List list = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    String metricName = (String)list.get(0);
                    String startEpochNanos = (String)list.get(1);
                    String endEpochNanos = (String)list.get(2);
                    String value = (String)list.get(3);
                    if (!INSTANCE.isLongNumber(value)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)ImmutableLongPointData.create((long)Long.parseLong(startEpochNanos), (long)Long.parseLong(endEpochNanos), (Attributes)Attributes.empty(), (long)Long.parseLong(value)), (String)"create(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)meters.computeIfAbsent(metricName, arg_0 -> MetricsImporterUtils.fromCsvFile$lambda$0$1(MetricsImporterUtils::fromCsvFile$lambda$0$0, arg_0)), (String)"computeIfAbsent(...)");
                    metrics.add(data);
                }
                catch (Exception e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(MetricsImporterUtils.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Failure during parsing OpenTelemetry metrics from CSV file " + metricsCsvPath + " on line " + line);
                    throw e;
                }
            }
            HashMap<String, List<LongPointData>> hashMap = meters;
            return hashMap;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    @NotNull
    public final HashMap<String, List<LongPointData>> fromCsvFile(@NotNull Iterable<? extends Path> metricsCsvFiles) {
        Intrinsics.checkNotNullParameter(metricsCsvFiles, (String)"metricsCsvFiles");
        HashMap<String, List<LongPointData>> meters = new HashMap<String, List<LongPointData>>();
        for (Path path : metricsCsvFiles) {
            HashMap<String, List<LongPointData>> currentMeters = this.fromCsvFile(path);
            Map $this$forEach$iv = currentMeters;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                meters.merge(key, value, (arg_0, arg_1) -> MetricsImporterUtils.fromCsvFile$lambda$1$1(MetricsImporterUtils::fromCsvFile$lambda$1$0, arg_0, arg_1));
            }
        }
        return meters;
    }

    private static final List fromCsvFile$lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List fromCsvFile$lambda$0$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List fromCsvFile$lambda$1$0(List originalList, List additionalList) {
        Intrinsics.checkNotNullParameter((Object)originalList, (String)"originalList");
        Intrinsics.checkNotNullParameter((Object)additionalList, (String)"additionalList");
        return CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)originalList, (Iterable)additionalList));
    }

    private static final List fromCsvFile$lambda$1$1(Function2 $tmp0, Object p0, Object p1) {
        return (List)$tmp0.invoke(p0, p1);
    }
}

