/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ImmutableDocumentFragmentContent
extends DiffContentBase
implements DocumentContent {
    @NotNull
    private final DocumentContent myOriginal;
    @NotNull
    private final Document myDocument;
    private final int myStartLine;

    public ImmutableDocumentFragmentContent(@NotNull DocumentContent original, @NotNull TextRange range) {
        if (original == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(0);
        }
        if (range == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(1);
        }
        this.myOriginal = original;
        Document originalDocument = this.myOriginal.getDocument();
        this.myStartLine = originalDocument.getLineNumber(range.getStartOffset());
        String text = StringUtil.convertLineSeparators((String)range.subSequence(originalDocument.getImmutableCharSequence()).toString());
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)text);
        this.myDocument.setReadOnly(true);
        IntUnaryOperator originalLineConvertor = (IntUnaryOperator)original.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
        this.putUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR, value -> {
            int line = this.myStartLine + value;
            return originalLineConvertor != null ? originalLineConvertor.applyAsInt(line) : line;
        });
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(2);
        }
        return document;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myOriginal.getHighlightFile();
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            ImmutableDocumentFragmentContent.$$$reportNull$$$0(3);
        }
        LineCol originalPosition = new LineCol(this.myStartLine + position.line, position.column);
        return this.myOriginal.getNavigatable(originalPosition);
    }

    @Nullable
    public FileType getContentType() {
        return this.myOriginal.getContentType();
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/ImmutableDocumentFragmentContent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/ImmutableDocumentFragmentContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

