/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.DiffContentVirtualFile;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffEditorTabFilesManagerImplKt;
import com.intellij.diff.editor.DiffEditorTabFilesUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/editor/EditorTabDiffPreviewAdvancedSettingsListener;", "Lcom/intellij/openapi/options/advanced/AdvancedSettingsChangeListener;", "<init>", "()V", "advancedSettingChanged", "", "id", "", "oldValue", "", "newValue", "Companion", "intellij.platform.diff.impl"})
public final class EditorTabDiffPreviewAdvancedSettingsListener
implements AdvancedSettingsChangeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        if (Intrinsics.areEqual((Object)id, (Object)"show.diff.as.editor.tab")) {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            for (Project project : projectArray) {
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                EditorTabDiffPreviewAdvancedSettingsListener.Companion.reopenDiffEditorsForFiles(project2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/diff/editor/EditorTabDiffPreviewAdvancedSettingsListener$Companion;", "", "<init>", "()V", "reopenDiffEditorsForFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nDiffEditorTabFilesManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorTabFilesManagerImpl.kt\ncom/intellij/diff/editor/EditorTabDiffPreviewAdvancedSettingsListener$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n3919#2:151\n4434#2,2:152\n1374#3:154\n1460#3,5:155\n774#3:160\n865#3,2:161\n774#3:163\n865#3,2:164\n*S KotlinDebug\n*F\n+ 1 DiffEditorTabFilesManagerImpl.kt\ncom/intellij/diff/editor/EditorTabDiffPreviewAdvancedSettingsListener$Companion\n*L\n96#1:151\n96#1:152,2\n97#1:154\n97#1:155,5\n98#1:160\n98#1:161,2\n99#1:163\n99#1:164,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void reopenDiffEditorsForFiles(Project project) {
            VirtualFile it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            boolean isOpenInNewWindow = DiffEditorTabFilesUtil.isDiffInWindow();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditorManagerImpl fileEditorManagerImpl = fileEditorManager instanceof FileEditorManagerImpl ? (FileEditorManagerImpl)fileEditorManager : null;
            if (fileEditorManagerImpl == null) {
                return;
            }
            FileEditorManagerImpl editorManager = fileEditorManagerImpl;
            DiffEditorTabFilesManager diffEditorManager = DiffEditorTabFilesManager.Companion.getInstance(project);
            Object object = editorManager.getWindows();
            boolean $i$f$filter = false;
            void var8_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void window = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(DiffEditorTabFilesManagerImplKt.isSingletonEditorInWindow((EditorWindow)window) != isOpenInNewWindow)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                EditorWindow window = (EditorWindow)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = window.getFileList();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof DiffContentVirtualFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(!DiffEditorTabFilesUtil.INSTANCE.isForceOpeningsInNewWindow(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List diffFiles = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            if (diffFiles.isEmpty()) {
                return;
            }
            for (VirtualFile file : diffFiles) {
                editorManager.closeFile(file, false, true);
            }
            object = UtilKt.headTail((List)diffFiles);
            VirtualFile toFocus = (VirtualFile)object.component1();
            List theRest = (List)object.component2();
            for (VirtualFile file : theRest) {
                diffEditorManager.showDiffFile(file, false);
            }
            diffEditorManager.showDiffFile(toFocus, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

