/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.impl.ui.DiffFilePathLabelWrapper;
import com.intellij.diff.impl.ui.FilePathDiffTitleCustomizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.xml.util.XmlStringUtil;
import java.nio.file.Path;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0012\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diff/impl/DiffEditorTitleDetails;", "", "pathLabel", "Lcom/intellij/diff/impl/DiffEditorTitleDetails$DetailsLabelProvider;", "revisionLabel", "<init>", "(Lcom/intellij/diff/impl/DiffEditorTitleDetails$DetailsLabelProvider;Lcom/intellij/diff/impl/DiffEditorTitleDetails$DetailsLabelProvider;)V", "Lcom/intellij/diff/impl/DiffEditorTitleDetails$PathLabelProvider;", "title", "", "(Lcom/intellij/diff/impl/DiffEditorTitleDetails$PathLabelProvider;Ljava/lang/String;)V", "getPathLabel", "()Lcom/intellij/diff/impl/DiffEditorTitleDetails$DetailsLabelProvider;", "getRevisionLabel", "getCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "Companion", "DetailsLabelProvider", "PathLabelProvider", "RevisionLabelProvider", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDiffEditorTitleDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorTitleDetails.kt\ncom/intellij/diff/impl/DiffEditorTitleDetails\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class DiffEditorTitleDetails {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final DetailsLabelProvider pathLabel;
    @Nullable
    private final DetailsLabelProvider revisionLabel;
    @JvmField
    @NotNull
    public static final DiffEditorTitleDetails EMPTY = new DiffEditorTitleDetails(null, null);

    public DiffEditorTitleDetails(@Nullable DetailsLabelProvider pathLabel, @Nullable DetailsLabelProvider revisionLabel) {
        this.pathLabel = pathLabel;
        this.revisionLabel = revisionLabel;
    }

    @Nullable
    public final DetailsLabelProvider getPathLabel() {
        return this.pathLabel;
    }

    @Nullable
    public final DetailsLabelProvider getRevisionLabel() {
        return this.revisionLabel;
    }

    private DiffEditorTitleDetails(PathLabelProvider pathLabel, @NlsContexts.Label String title) {
        RevisionLabelProvider revisionLabelProvider;
        DiffEditorTitleDetails diffEditorTitleDetails = this;
        DetailsLabelProvider detailsLabelProvider = pathLabel;
        String string = title;
        if (string != null) {
            String string2 = string;
            DetailsLabelProvider detailsLabelProvider2 = detailsLabelProvider;
            DiffEditorTitleDetails diffEditorTitleDetails2 = diffEditorTitleDetails;
            boolean bl = false;
            RevisionLabelProvider revisionLabelProvider2 = new RevisionLabelProvider(title, false);
            diffEditorTitleDetails = diffEditorTitleDetails2;
            detailsLabelProvider = detailsLabelProvider2;
            revisionLabelProvider = revisionLabelProvider2;
        } else {
            revisionLabelProvider = null;
        }
        diffEditorTitleDetails(detailsLabelProvider, revisionLabelProvider);
    }

    @NotNull
    public final DiffEditorTitleCustomizer getCustomizer() {
        return this.pathLabel != null ? (DiffEditorTitleCustomizer)new FilePathDiffTitleCustomizer(this.pathLabel, this.revisionLabel) : (this.revisionLabel != null ? () -> DiffEditorTitleDetails.getCustomizer$lambda$0(this) : DiffEditorTitleCustomizer.EMPTY);
    }

    private static final JComponent getCustomizer$lambda$0(DiffEditorTitleDetails this$0) {
        return this$0.revisionLabel.createComponent();
    }

    @JvmStatic
    @NotNull
    public static final DiffEditorTitleDetails createFromPath(@Nullable String displayedPath) {
        return Companion.createFromPath(displayedPath);
    }

    @JvmStatic
    @NotNull
    public static final DiffEditorTitleDetails createFromTitle(@NotNull String title) {
        return Companion.createFromTitle(title);
    }

    @JvmStatic
    @NotNull
    public static final DiffEditorTitleDetails create(@Nullable Project project, @Nullable FilePath file, @NlsContexts.Label @Nullable String title) {
        return Companion.create(project, file, title);
    }

    public /* synthetic */ DiffEditorTitleDetails(PathLabelProvider pathLabel, String title, DefaultConstructorMarker $constructor_marker) {
        this(pathLabel, title);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00052\r\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010\n\u001a\u00020\u00052\u000b\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\fH\u0007J(\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001f\u0010\u0014\u001a\u00070\b\u00a2\u0006\u0002\b\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/diff/impl/DiffEditorTitleDetails$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/diff/impl/DiffEditorTitleDetails;", "createFromPath", "displayedPath", "", "Lcom/intellij/openapi/util/NlsSafe;", "createFromTitle", "title", "Lcom/intellij/openapi/util/NlsContexts$Label;", "create", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vcs/FilePath;", "getFilePathLabel", "Lcom/intellij/diff/impl/DiffEditorTitleDetails$PathLabelProvider;", "getRelativeOrFullPath", "intellij.platform.diff.impl"})
    @SourceDebugExtension(value={"SMAP\nDiffEditorTitleDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorTitleDetails.kt\ncom/intellij/diff/impl/DiffEditorTitleDetails$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DiffEditorTitleDetails createFromPath(@Nullable String displayedPath) {
            PathLabelProvider pathLabelProvider;
            String string = displayedPath;
            if (string != null) {
                String it = string;
                boolean bl = false;
                pathLabelProvider = new PathLabelProvider(it, null, 2, null);
            } else {
                pathLabelProvider = null;
            }
            DetailsLabelProvider detailsLabelProvider = null;
            DetailsLabelProvider detailsLabelProvider2 = pathLabelProvider;
            return new DiffEditorTitleDetails(detailsLabelProvider2, detailsLabelProvider);
        }

        @JvmStatic
        @NotNull
        public final DiffEditorTitleDetails createFromTitle(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            return new DiffEditorTitleDetails(null, title, null);
        }

        @JvmStatic
        @NotNull
        public final DiffEditorTitleDetails create(@Nullable Project project, @Nullable FilePath file, @NlsContexts.Label @Nullable String title) {
            PathLabelProvider pathLabelProvider;
            FilePath filePath = file;
            if (filePath != null) {
                FilePath it = filePath;
                boolean bl = false;
                pathLabelProvider = Companion.getFilePathLabel(project, it);
            } else {
                pathLabelProvider = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            String string = title;
            PathLabelProvider pathLabelProvider2 = pathLabelProvider;
            return new DiffEditorTitleDetails(pathLabelProvider2, string, defaultConstructorMarker);
        }

        @ApiStatus.Internal
        @NotNull
        public final PathLabelProvider getFilePathLabel(@Nullable Project project, @NotNull FilePath file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = this.getRelativeOrFullPath(project, file);
            String string2 = FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)file.getPath()));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocationRelativeToUserHome(...)");
            return new PathLabelProvider(string, string2);
        }

        private final String getRelativeOrFullPath(Project project, FilePath file) {
            String string;
            VirtualFile guessedProjectDir;
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            Path path = NioPathUtil.toNioPathOrNull((String)string2);
            if (path == null) {
                String string3 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                return string3;
            }
            Path fileNioPath = path;
            Project project2 = project;
            Object object = guessedProjectDir = project2 != null ? ProjectUtil.guessProjectDir((Project)project2) : null;
            if (guessedProjectDir == null) {
                String string4 = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getLocationRelativeToUserHome(...)");
                return string4;
            }
            Path path2 = guessedProjectDir.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            Path projectDirPath = path2;
            if (fileNioPath.startsWith(projectDirPath)) {
                string = ((Object)projectDirPath.relativize(fileNioPath)).toString();
            } else {
                String string5 = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getLocationRelativeToUserHome(...)");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/diff/impl/DiffEditorTitleDetails$DetailsLabelProvider;", "", "createComponent", "Ljavax/swing/JComponent;", "intellij.platform.diff.impl"})
    public static interface DetailsLabelProvider {
        @NotNull
        public JComponent createComponent();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/diff/impl/DiffEditorTitleDetails$PathLabelProvider;", "Lcom/intellij/diff/impl/DiffEditorTitleDetails$DetailsLabelProvider;", "displayedPath", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "fullPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "createComponent", "Ljavax/swing/JComponent;", "intellij.platform.diff.impl"})
    @ApiStatus.Internal
    public static final class PathLabelProvider
    implements DetailsLabelProvider {
        @NotNull
        private final String displayedPath;
        @NotNull
        private final String fullPath;

        public PathLabelProvider(@NotNull String displayedPath, @NotNull String fullPath) {
            Intrinsics.checkNotNullParameter((Object)displayedPath, (String)"displayedPath");
            Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
            this.displayedPath = displayedPath;
            this.fullPath = fullPath;
        }

        public /* synthetic */ PathLabelProvider(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = string;
            }
            this(string, string2);
        }

        @Override
        @NotNull
        public JComponent createComponent() {
            return new DiffFilePathLabelWrapper(this.displayedPath, this.fullPath);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001c\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diff/impl/DiffEditorTitleDetails$RevisionLabelProvider;", "Lcom/intellij/diff/impl/DiffEditorTitleDetails$DetailsLabelProvider;", "text", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "copiable", "", "<init>", "(Ljava/lang/String;Z)V", "createComponent", "Ljavax/swing/JComponent;", "intellij.platform.diff.impl"})
    @ApiStatus.Internal
    public static final class RevisionLabelProvider
    implements DetailsLabelProvider {
        @NotNull
        private final String text;
        private final boolean copiable;

        public RevisionLabelProvider(@NotNull String text, boolean copiable) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
            this.copiable = copiable;
        }

        @Override
        @NotNull
        public JComponent createComponent() {
            JBLabel jBLabel = new JBLabel(XmlStringUtil.escapeString((String)this.text)).setCopyable(this.copiable);
            Intrinsics.checkNotNullExpressionValue((Object)jBLabel, (String)"setCopyable(...)");
            return (JComponent)jBLabel;
        }
    }
}

