/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.merge.ErrorMergeTool;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeContextEx;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MessageMergeViewer;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class MergeRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final MergeContext myContext;
    @NotNull
    private final List<MergeTool> myAvailableTools;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    private final Wrapper myContentPanel;
    @NotNull
    private final Wrapper myToolbarPanel;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final Wrapper myNotificationPanel;
    @NotNull
    private final Wrapper myButtonsPanel;
    @Nullable
    private MergeRequest myRequest;
    @NotNull
    private MergeTool.MergeViewer myViewer;
    @Nullable
    private BooleanGetter myCloseHandler;
    private boolean myConflictResolved = false;

    public MergeRequestProcessor(@Nullable Project project) {
        this.myProject = project;
        this.myContext = new MyDiffContext();
        this.myContext.putUserData(DiffUserDataKeys.PLACE, (Object)"Merge");
        this.myAvailableTools = DiffManagerEx.getInstance().getMergeTools();
        this.myMainPanel = new MyPanel();
        this.myContentPanel = new Wrapper();
        this.myToolbarPanel = new Wrapper();
        this.myToolbarPanel.setFocusable(true);
        this.myToolbarStatusPanel = new Wrapper();
        this.myNotificationPanel = new Wrapper();
        this.myButtonsPanel = new Wrapper();
        this.myPanel = JBUI.Panels.simplePanel((Component)this.myMainPanel);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel((Component)this.myToolbarPanel).addToRight((Component)this.myToolbarStatusPanel).addToBottom((Component)this.myNotificationPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)this.myContentPanel, "Center");
        this.myMainPanel.add((Component)this.myButtonsPanel, "South");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusTraversalPolicy()));
        this.myViewer = new MessageMergeViewer(this.myContext, CommonBundle.getLoadingTreeNodeText());
    }

    @RequiresEdt
    public void init(@NotNull MergeRequest request) {
        if (request == null) {
            MergeRequestProcessor.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.setTitle(request.getTitle());
        this.myRequest = request;
        MergeRequestProcessor.onAssigned(this.myRequest, true);
        this.myViewer = this.createViewerFor(request);
        this.initViewer();
        this.installCallbackListener(this.myRequest);
    }

    @RequiresEdt
    public void init(@NotNull MergeRequestProducer request) {
        if (request == null) {
            MergeRequestProcessor.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.setTitle(request.getName());
        this.initViewer();
        ModalityState modality = ModalityState.stateForComponent((Component)this.myPanel);
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
            try {
                MergeRequest mergeRequest = request.process((UserDataHolder)this.myContext, ProgressManager.getInstance().getProgressIndicator());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myDisposed) {
                        return;
                    }
                    this.myRequest = mergeRequest;
                    MergeRequestProcessor.onAssigned(this.myRequest, true);
                    this.swapViewer(this.createViewerFor(mergeRequest));
                    this.installCallbackListener(this.myRequest);
                }, modality);
            }
            catch (Throwable e) {
                LOG.warn(e);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.myDisposed) {
                        return;
                    }
                    this.swapViewer(new MessageMergeViewer(this.myContext, DiffBundle.message((String)"label.cant.show.merge.with.description", (Object[])new Object[]{e.getMessage()})));
                }, modality);
            }
        });
    }

    @NotNull
    private MergeTool.MergeViewer createViewerFor(@NotNull MergeRequest request) {
        MergeTool.MergeViewer mergeViewer;
        if (request == null) {
            MergeRequestProcessor.$$$reportNull$$$0(2);
        }
        try {
            mergeViewer = this.getFittedTool(request).createComponent(this.myContext, request);
        }
        catch (Throwable e) {
            LOG.error(e);
            MergeTool.MergeViewer mergeViewer2 = ErrorMergeTool.INSTANCE.createComponent(this.myContext, request);
            if (mergeViewer2 == null) {
                MergeRequestProcessor.$$$reportNull$$$0(4);
            }
            return mergeViewer2;
        }
        if (mergeViewer == null) {
            MergeRequestProcessor.$$$reportNull$$$0(3);
        }
        return mergeViewer;
    }

    @RequiresEdt
    private void initViewer() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myContentPanel.setContent(this.myViewer.getComponent());
        MergeTool.ToolbarComponents toolbarComponents = this.myViewer.init();
        this.buildToolbar(toolbarComponents.toolbarActions);
        this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
        this.myCloseHandler = toolbarComponents.closeHandler;
        this.updateBottomActions();
    }

    @RequiresEdt
    private void destroyViewer() {
        ThreadingAssertions.assertEventDispatchThread();
        Disposer.dispose((Disposable)this.myViewer);
        ActionUtil.clearActions((JComponent)this.myMainPanel);
        this.myContentPanel.setContent(null);
        this.myToolbarPanel.setContent(null);
        this.myToolbarStatusPanel.setContent(null);
        this.myButtonsPanel.setContent(null);
        this.myCloseHandler = null;
    }

    private void updateBottomActions() {
        Action applyLeft = this.myViewer.getResolveAction(MergeResult.LEFT);
        Action applyRight = this.myViewer.getResolveAction(MergeResult.RIGHT);
        final Action resolveAction = this.myViewer.getResolveAction(MergeResult.RESOLVED);
        Action cancelAction = this.myViewer.getResolveAction(MergeResult.CANCEL);
        if (resolveAction != null) {
            resolveAction.putValue("DefaultAction", true);
            new DumbAwareAction(this){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    resolveAction.actionPerformed(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/merge/MergeRequestProcessor$1", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.getCtrlEnter(), (JComponent)this.getRootPane(), (Disposable)this);
        }
        List leftActions = ContainerUtil.packNullables((Object[])new Action[]{applyLeft, applyRight});
        List rightActions = SystemInfo.isMac ? ContainerUtil.packNullables((Object[])new Action[]{cancelAction, resolveAction}) : ContainerUtil.packNullables((Object[])new Action[]{resolveAction, cancelAction});
        JRootPane rootPane = this.getRootPane();
        NonOpaquePanel buttonsPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        buttonsPanel.setBorder((Border)new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        if (!leftActions.isEmpty()) {
            buttonsPanel.add((Component)MergeRequestProcessor.createButtonsPanel(leftActions, rootPane), "West");
        }
        if (!rightActions.isEmpty()) {
            buttonsPanel.add((Component)MergeRequestProcessor.createButtonsPanel(rightActions, rootPane), "East");
        }
        BorderLayoutPanel toolbarPanel = this.createFeedbackToolbarPanel();
        buttonsPanel.add((Component)toolbarPanel, "Center");
        this.myButtonsPanel.setContent((JComponent)buttonsPanel);
    }

    @NotNull
    private BorderLayoutPanel createFeedbackToolbarPanel() {
        AnAction action2 = ActionManager.getInstance().getAction("Diff.Conflicts.Feedback");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FeedbackToolbar", (ActionGroup)action2, true);
        actionToolbar.setTargetComponent(this.myContentPanel.getTargetComponent());
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel().addToRight((Component)actionToolbar.getComponent());
        if (borderLayoutPanel == null) {
            MergeRequestProcessor.$$$reportNull$$$0(5);
        }
        return borderLayoutPanel;
    }

    @NotNull
    private static JPanel createButtonsPanel(@NotNull List<? extends Action> actions, @Nullable JRootPane rootPane) {
        if (actions == null) {
            MergeRequestProcessor.$$$reportNull$$$0(6);
        }
        List buttons = ContainerUtil.map(actions, action2 -> DialogWrapper.createJButtonForAction((Action)action2, (JRootPane)rootPane));
        JPanel jPanel = DialogWrapper.layoutButtonsPanel((List)buttons);
        if (jPanel == null) {
            MergeRequestProcessor.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    protected DefaultActionGroup collectToolbarActions(@Nullable List<? extends AnAction> viewerActions) {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        List<AnAction> navigationActions = Arrays.asList(actionManager.getAction("PreviousDiff"), actionManager.getAction("NextDiff"));
        DiffUtil.addActionBlock(group, navigationActions);
        DiffUtil.addActionBlock(group, viewerActions);
        List requestContextActions = this.myRequest != null ? (List)this.myRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS) : null;
        DiffUtil.addActionBlock(group, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(group, contextActions);
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            MergeRequestProcessor.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    protected void buildToolbar(@Nullable List<? extends AnAction> viewerActions) {
        DefaultActionGroup group = this.collectToolbarActions(viewerActions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)group, true);
        toolbar.setShowSeparatorTitles(true);
        toolbar.setTargetComponent(this.myContentPanel.getTargetComponent());
        this.myToolbarPanel.setContent(toolbar.getComponent());
        DiffUtil.recursiveRegisterShortcutSet((ActionGroup)group, this.myMainPanel, null);
    }

    @NotNull
    private MergeTool getFittedTool(@NotNull MergeRequest request) {
        if (request == null) {
            MergeRequestProcessor.$$$reportNull$$$0(9);
        }
        for (MergeTool tool : this.myAvailableTools) {
            MergeTool mergeTool;
            try {
                if (!tool.canShow(this.myContext, request)) continue;
                mergeTool = tool;
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (mergeTool == null) {
                MergeRequestProcessor.$$$reportNull$$$0(10);
            }
            return mergeTool;
        }
        ErrorMergeTool errorMergeTool = ErrorMergeTool.INSTANCE;
        if (errorMergeTool == null) {
            MergeRequestProcessor.$$$reportNull$$$0(11);
        }
        return errorMergeTool;
    }

    private void setTitle(@Nullable String title) {
        if (title == null) {
            title = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
        }
        this.setWindowTitle(title);
    }

    private void installCallbackListener(@NotNull MergeRequest request) {
        if (request == null) {
            MergeRequestProcessor.$$$reportNull$$$0(12);
        }
        MergeCallback callback = MergeCallback.getCallback((MergeRequest)request);
        callback.addListener(new MergeCallback.Listener(){

            public void fireConflictInvalid() {
                MergeRequestProcessor.this.showInvalidRequestNotification();
            }
        }, (Disposable)this);
        if (!callback.checkIsValid()) {
            this.showInvalidRequestNotification();
        }
    }

    private void showInvalidRequestNotification() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myDisposed) {
                return;
            }
            if (!this.myNotificationPanel.isNull()) {
                return;
            }
            EditorNotificationPanel notification = new EditorNotificationPanel(LightColors.RED, EditorNotificationPanel.Status.Error);
            notification.setText(DiffBundle.message((String)"error.conflict.is.not.valid.and.no.longer.can.be.resolved", (Object[])new Object[0]));
            notification.createActionLabel(DiffBundle.message((String)"button.abort.resolve", (Object[])new Object[0]), () -> {
                this.applyRequestResult(MergeResult.CANCEL);
                this.closeDialog();
            });
            this.myNotificationPanel.setContent((JComponent)notification);
            this.myMainPanel.validate();
            this.myMainPanel.repaint();
        }, ModalityState.stateForComponent((Component)this.myPanel));
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.destroyViewer();
            this.applyRequestResult(MergeResult.CANCEL);
            if (this.myRequest != null) {
                MergeRequestProcessor.onAssigned(this.myRequest, false);
            }
        });
    }

    @RequiresEdt
    private void applyRequestResult(@NotNull MergeResult result) {
        if (result == null) {
            MergeRequestProcessor.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myConflictResolved || this.myRequest == null) {
            return;
        }
        this.myConflictResolved = true;
        try {
            this.myRequest.applyResult(result);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            new Notification("Merge Internal Error", DiffBundle.message((String)"can.t.finish.merge.resolve", (Object[])new Object[0]), e.getMessage(), NotificationType.ERROR).setDisplayId("diff.merge.intenral.error").notify(this.myProject);
        }
    }

    @RequiresEdt
    private void reopenWithTool(@NotNull MergeTool tool) {
        MergeTool.MergeViewer newViewer;
        if (tool == null) {
            MergeRequestProcessor.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myRequest == null) {
            return;
        }
        if (this.myConflictResolved) {
            LOG.warn("Can't reopen with " + String.valueOf(tool) + " - conflict already resolved");
            return;
        }
        if (!tool.canShow(this.myContext, this.myRequest)) {
            LOG.warn("Can't reopen with " + String.valueOf(tool) + " - " + String.valueOf(this.myRequest));
            return;
        }
        try {
            newViewer = tool.createComponent(this.myContext, this.myRequest);
        }
        catch (Throwable e) {
            LOG.error(e);
            return;
        }
        this.swapViewer(newViewer);
    }

    private void swapViewer(@NotNull MergeTool.MergeViewer newViewer) {
        if (newViewer == null) {
            MergeRequestProcessor.$$$reportNull$$$0(15);
        }
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> {
            this.destroyViewer();
            this.myViewer = newViewer;
            this.initViewer();
        });
    }

    private static void onAssigned(@NotNull MergeRequest request, boolean isAssigned) {
        if (request == null) {
            MergeRequestProcessor.$$$reportNull$$$0(16);
        }
        try {
            request.onAssigned(isAssigned);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @RequiresEdt
    protected void onDispose() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    protected void setWindowTitle(@NotNull String title) {
        if (title == null) {
            MergeRequestProcessor.$$$reportNull$$$0(17);
        }
    }

    public abstract void closeDialog();

    @Nullable
    protected abstract JRootPane getRootPane();

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        if (key == null) {
            MergeRequestProcessor.$$$reportNull$$$0(18);
        }
        return (T)this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            MergeRequestProcessor.$$$reportNull$$$0(19);
        }
        this.myContext.putUserData(key, value);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            MergeRequestProcessor.$$$reportNull$$$0(20);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component2 = this.myViewer.getPreferredFocusedComponent();
        return component2 != null ? component2 : this.myToolbarPanel.getTargetComponent();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public MergeContext getContext() {
        MergeContext mergeContext = this.myContext;
        if (mergeContext == null) {
            MergeRequestProcessor.$$$reportNull$$$0(21);
        }
        return mergeContext;
    }

    @RequiresEdt
    public boolean checkCloseAction() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myConflictResolved || this.myCloseHandler == null || this.myCloseHandler.get();
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow(this.myPanel);
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 10, 11, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeRequestProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newViewer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewerFor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFeedbackToolbarPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectToolbarActions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFittedTool";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createViewerFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 20: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createButtonsPanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFittedTool";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installCallbackListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyRequestResult";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reopenWithTool";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "swapViewer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onAssigned";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setWindowTitle";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContextUserData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putContextUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 10, 11, 20, 21 -> new IllegalStateException(string);
        };
    }

    private class MyDiffContext
    extends MergeContextEx {
        private MyDiffContext() {
        }

        @Nullable
        public Project getProject() {
            return MergeRequestProcessor.this.getProject();
        }

        public boolean isFocusedInWindow() {
            return MergeRequestProcessor.this.isFocusedInWindow();
        }

        public void requestFocusInWindow() {
            MergeRequestProcessor.this.requestFocusInWindow();
        }

        public void finishMerge(@NotNull MergeResult result) {
            if (result == null) {
                MyDiffContext.$$$reportNull$$$0(0);
            }
            MergeRequestProcessor.this.applyRequestResult(result);
            MergeRequestProcessor.this.closeDialog();
        }

        @Override
        @RequiresEdt
        public void reopenWithTool(@NotNull MergeTool tool) {
            if (tool == null) {
                MyDiffContext.$$$reportNull$$$0(1);
            }
            ThreadingAssertions.assertEventDispatchThread();
            MergeRequestProcessor.this.reopenWithTool(tool);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeRequestProcessor$MyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finishMerge";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reopenWithTool";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPanel
    extends JPanel
    implements UiDataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            sink.set(CommonDataKeys.PROJECT, (Object)MergeRequestProcessor.this.myProject);
            String requestHelpId = MergeRequestProcessor.this.myRequest == null ? null : (String)MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.HELP_ID);
            sink.set(PlatformCoreDataKeys.HELP_ID, (Object)(requestHelpId != null ? requestHelpId : "procedures.vcWithIDEA.commonVcsOps.integrateDiffs.resolveConflict"));
            sink.set(DiffDataKeys.MERGE_VIEWER, (Object)MergeRequestProcessor.this.myViewer);
            DataProvider contextProvider = (DataProvider)MergeRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)contextProvider);
            DataProvider requestProvider = MergeRequestProcessor.this.myRequest != null ? (DataProvider)MergeRequestProcessor.this.myRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER) : null;
            DataSink.uiDataSnapshot((DataSink)sink, requestProvider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/diff/merge/MergeRequestProcessor$MyPanel", "uiDataSnapshot"));
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        public final Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component2 = MergeRequestProcessor.this.getPreferredFocusedComponent();
            if (component2 == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)component2, (FocusTraversalPolicy)((Object)this));
        }

        @Nullable
        protected Project getProject() {
            return MergeRequestProcessor.this.myProject;
        }
    }
}

