/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.diff.DiffContext;
import com.intellij.diff.EditorDiffViewer;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.SimpleUnifiedFragmentBuilder;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffChangeUi;
import com.intellij.diff.tools.fragmented.UnifiedDiffModel;
import com.intellij.diff.tools.fragmented.UnifiedDiffPanel;
import com.intellij.diff.tools.fragmented.UnifiedDiffState;
import com.intellij.diff.tools.fragmented.UnifiedEditorHighlighter;
import com.intellij.diff.tools.fragmented.UnifiedEditorRangeHighlighter;
import com.intellij.diff.tools.util.DiffChangedRangeProvider;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffTitleHandler;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.PrevNextDifferenceIterableBase;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffEditorHighlighterUpdater;
import com.intellij.diff.util.DiffLineNumberConverter;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EmptyFoldingModel;
import com.intellij.openapi.editor.impl.EmptyIndentsModel;
import com.intellij.openapi.editor.impl.EmptyMarkupModel;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.textarea.EmptyInlayModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffViewer
extends ListenerDiffViewerBase
implements EditorDiffViewer {
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Document myDocument;
    @NotNull
    protected final UnifiedDiffPanel myPanel;
    @NotNull
    private final OnesideContentPanel myContentPanel;
    @NotNull
    private final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MarkupUpdater myMarkupUpdater;
    @NotNull
    protected final TwosideTextDiffProvider.NoIgnore myTextDiffProvider;
    @NotNull
    protected Side myMasterSide;
    @ApiStatus.Internal
    @NotNull
    protected final UnifiedDiffModel myModel;
    private final boolean[] myForceReadOnlyFlags;
    private boolean myReadOnlyLockSet;
    private boolean myDuringOnesideDocumentModification;
    private boolean myDuringTwosideDocumentModification;
    private boolean myStateIsOutOfDate;
    private boolean mySuppressEditorTyping;

    public UnifiedDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myMasterSide = Side.RIGHT;
        this.myModel = new UnifiedDiffModel(this);
        this.myReadOnlyLockSet = false;
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myForceReadOnlyFlags = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        boolean leftEditable = this.isEditable(Side.LEFT, false);
        boolean rightEditable = this.isEditable(Side.RIGHT, false);
        if (leftEditable && !rightEditable) {
            this.myMasterSide = Side.LEFT;
        }
        if (!leftEditable && rightEditable) {
            this.myMasterSide = Side.RIGHT;
        }
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        this.myContentPanel = new OnesideContentPanel(this.myEditor.getComponent());
        if (this.getProject() != null) {
            this.myContentPanel.setBreadcrumbs(new UnifiedBreadcrumbsPanel(), this.getTextSettings());
        }
        this.myPanel = new UnifiedDiffPanel(this.myProject, this.myContentPanel, this.myContext){

            @Override
            public void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.uiDataSnapshot(sink);
                DataSink.uiDataSnapshot((DataSink)sink, (DataProvider)UnifiedDiffViewer.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$1", "uiDataSnapshot"));
            }
        };
        this.myFoldingModel = new MyFoldingModel(this.getProject(), this.myEditor, (Disposable)this);
        this.myMarkupUpdater = new MarkupUpdater(this.getContents());
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        this.myTextDiffProvider = DiffUtil.createNoIgnoreTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.LEFT), this.myPanel);
        DiffUtil.registerAction(new AppendSelectedChangesAction(Side.RIGHT), this.myPanel);
    }

    @Override
    @RequiresEdt
    protected void onInit() {
        ThreadingAssertions.assertEventDispatchThread();
        super.onInit();
        this.installEditorListeners();
        this.installTypingSupport();
        this.myPanel.setLoadingContent();
        this.myPanel.setPersistentNotifications(DiffUtil.createCustomNotifications(this, (UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
        DiffTitleHandler.createHandler(() -> this.createTitles(), this.myContentPanel, this.myRequest, (Disposable)this);
        DiffUtil.installShowNotifyListener(this.getComponent(), new Activatable(){

            public void showNotify() {
                UnifiedDiffViewer.this.myMarkupUpdater.scheduleUpdate();
            }

            public void hideNotify() {
                Project project = UnifiedDiffViewer.this.myProject;
                if (project == null) {
                    return;
                }
                Document document = UnifiedDiffViewer.this.getContent2().getDocument();
                DiffEditorHighlighterUpdater.restartHighlighterFor(project, (Editor)UnifiedDiffViewer.this.myEditor, document, "UnifiedDiffViewer.hide");
            }
        });
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        ThreadingAssertions.assertEventDispatchThread();
        super.onDispose();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    @RequiresEdt
    protected void processContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.processContextHints();
        Side side = (Side)DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null) {
            this.myMasterSide = side;
        }
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    @RequiresEdt
    protected void updateContextHints() {
        ThreadingAssertions.assertEventDispatchThread();
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
    }

    @Nullable
    protected JComponent createTitles() {
        List titles = DiffUtil.createTextTitles(this, this.myRequest, Arrays.asList(this.myEditor, this.myEditor));
        assert (titles.size() == 2);
        if ((titles = ContainerUtil.skipNulls(titles)).isEmpty()) {
            return null;
        }
        return DiffUtil.createStackedComponents(titles, DiffUtil.TITLE_GAP);
    }

    @RequiresEdt
    protected void updateEditorCanBeTyped() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myEditor.setViewer(this.mySuppressEditorTyping || !this.isEditable(this.myMasterSide, true));
    }

    private void installTypingSupport() {
        if (!this.isEditable(this.myMasterSide, false)) {
            return;
        }
        this.updateEditorCanBeTyped();
        this.myEditor.getColorsScheme().setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myDocument, (ReadonlyFragmentModificationHandler)new MyReadonlyFragmentModificationHandler());
        this.myDocument.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)this.getDocument(this.myMasterSide));
        this.myDocument.addDocumentListener((DocumentListener)new MyOnesideDocumentListener());
    }

    @Override
    @RequiresEdt
    @NotNull
    public List<AnAction> createToolbarActions() {
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @RequiresEdt
    @NotNull
    public List<AnAction> createPopupActions() {
        ThreadingAssertions.assertEventDispatchThread();
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new MyToggleExpandByDefaultAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(new ReplaceSelectedChangesAction(Side.LEFT));
        group.add(new ReplaceSelectedChangesAction(Side.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(TextDiffViewerUtil.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @RequiresEdt
    protected void installEditorListeners() {
        ThreadingAssertions.assertEventDispatchThread();
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors(), this.myPanel);
    }

    @ApiStatus.Internal
    @NotNull
    protected UnifiedDiffChangeUi createUi(@NotNull UnifiedDiffChange change) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(5);
        }
        return new UnifiedDiffChangeUi(this, change);
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(6);
        }
        super.onBeforeDocumentChange(event);
        this.myMarkupUpdater.suspendUpdate();
    }

    @Override
    protected void onBeforeRediff() {
        super.onBeforeRediff();
        this.myMarkupUpdater.suspendUpdate();
    }

    @Override
    @RequiresEdt
    protected void onSlowRediff() {
        ThreadingAssertions.assertEventDispatchThread();
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        if (indicator == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(7);
        }
        try {
            runnable = this.computeDifferences(indicator);
        }
        catch (DiffTooBigException e) {
            Runnable runnable2 = () -> {
                this.clearDiffPresentation();
                this.myPanel.setTooBigContent();
            };
            if (runnable2 == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(9);
            }
            return runnable2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable3 = this.applyErrorNotification();
            if (runnable3 == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(10);
            }
            return runnable3;
        }
        if (runnable == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(8);
        }
        return runnable;
    }

    @NotNull
    protected Runnable applyErrorNotification() {
        Runnable runnable = () -> {
            this.clearDiffPresentation();
            this.myPanel.setErrorContent();
        };
        if (runnable == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    protected Runnable computeDifferences(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(12);
        }
        Document document1 = this.getContent1().getDocument();
        Document document2 = this.getContent2().getDocument();
        CharSequence[] texts = (CharSequence[])ReadAction.compute(() -> new CharSequence[]{document1.getImmutableCharSequence(), document2.getImmutableCharSequence()});
        List<LineFragment> fragments = this.myTextDiffProvider.compare(texts[0], texts[1], indicator);
        UnifiedDiffState builder = (UnifiedDiffState)ReadAction.compute(() -> {
            indicator.checkCanceled();
            return new SimpleUnifiedFragmentBuilder(document1, document2, this.myMasterSide).exec(fragments);
        });
        Runnable runnable = this.apply(builder, texts, indicator);
        if (runnable == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(13);
        }
        return runnable;
    }

    protected void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.destroyChangedBlockData();
        this.myStateIsOutOfDate = false;
        this.mySuppressEditorTyping = false;
        this.updateEditorCanBeTyped();
    }

    @RequiresEdt
    protected void markSuppressEditorTyping() {
        ThreadingAssertions.assertEventDispatchThread();
        this.mySuppressEditorTyping = true;
        this.updateEditorCanBeTyped();
    }

    @RequiresEdt
    protected void markStateIsOutOfDate() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myStateIsOutOfDate = true;
        this.myFoldingModel.disposeLineConvertor();
        this.myModel.updateGutterActions();
    }

    @Nullable
    private static EditorHighlighter buildHighlighter(@Nullable Project project, @NotNull Document document, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (document == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(14);
        }
        if (content1 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(15);
        }
        if (content2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(16);
        }
        if (text1 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(18);
        }
        if (ranges == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(19);
        }
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(text2);
        }
        return new UnifiedEditorHighlighter(document, highlighter1, highlighter2, ranges, textLength);
    }

    @NotNull
    protected Runnable apply(@NotNull UnifiedDiffState builder, CharSequence @NotNull [] texts, @NotNull ProgressIndicator indicator) {
        if (builder == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(21);
        }
        if (texts == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(22);
        }
        DocumentContent content1 = this.getContent1();
        DocumentContent content2 = this.getContent2();
        HighlightersData highlightersData = (HighlightersData)BackgroundTaskUtil.tryComputeFast(___ -> (HighlightersData)ReadAction.compute(() -> {
            EditorHighlighter highlighter = UnifiedDiffViewer.buildHighlighter(this.myProject, this.myDocument, content1, content2, texts[0], texts[1], builder.getRanges(), builder.getText().length());
            UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(this.myProject, content1.getDocument(), content2.getDocument(), builder.getRanges());
            return new HighlightersData(highlighter, rangeHighlighter);
        }), (long)500L);
        LineNumberConvertor convertor1 = builder.getConvertor1();
        LineNumberConvertor convertor2 = builder.getConvertor2();
        List<LineRange> changedLines = builder.getChangedLines();
        boolean isContentsEqual = changedLines.isEmpty() && StringUtil.equals((CharSequence)texts[0], (CharSequence)texts[1]);
        Side masterSide = builder.getMasterSide();
        FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(changedLines, this.getFoldingModelSettings(), this.getDocument(masterSide), (LineNumberConvertor)masterSide.select((Object)convertor1, (Object)convertor2), StringUtil.countNewLines((CharSequence)builder.getText()) + 1);
        Runnable runnable = () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            LineCol oldCaretPosition = LineCol.fromOffset((Document)this.myDocument, (int)this.myEditor.getCaretModel().getPrimaryCaret().getOffset());
            Pair<int[], Side> oldCaretLineTwoside = this.transferLineFromOneside(oldCaretPosition.line);
            this.clearDiffPresentation();
            if (isContentsEqual && !DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.DISABLE_CONTENTS_EQUALS_NOTIFICATION, new UserDataHolder[]{this.myContext, this.myRequest})) {
                this.myPanel.addNotification(TextDiffViewerUtil.createEqualContentsNotification(this.getContents()));
            }
            IntPredicate foldingLinePredicate = this.myFoldingModel.hideLineNumberPredicate(0);
            IntUnaryOperator merged1 = DiffUtil.mergeLineConverters(DiffUtil.getContentLineConvertor(this.getContent1()), convertor1.createConvertor());
            IntUnaryOperator merged2 = DiffUtil.mergeLineConverters(DiffUtil.getContentLineConvertor(this.getContent2()), convertor2.createConvertor());
            this.myEditor.getGutter().setLineNumberConverter((LineNumberConverter)new DiffLineNumberConverter(foldingLinePredicate, merged1), (LineNumberConverter)new DiffLineNumberConverter(foldingLinePredicate, merged2));
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.myDuringOnesideDocumentModification = true;
                try {
                    this.myDocument.setText(builder.getText());
                }
                finally {
                    this.myDuringOnesideDocumentModification = false;
                }
            });
            DiffUtil.setEditorCodeStyle(this.myProject, this.myEditor, this.getContent(this.myMasterSide));
            ArrayList<RangeMarker> guarderRangeBlocks = new ArrayList<RangeMarker>();
            if (!this.myEditor.isViewer()) {
                for (UnifiedDiffChange change : builder.getChanges()) {
                    LineRange range = (LineRange)this.myMasterSide.select((Object)change.getInsertedRange(), (Object)change.getDeletedRange());
                    if (range.isEmpty()) continue;
                    TextRange textRange = DiffUtil.getLinesRange(this.myDocument, range.start, range.end);
                    guarderRangeBlocks.add(this.createGuardedBlock(textRange.getStartOffset(), textRange.getEndOffset()));
                }
                int textLength = this.myDocument.getTextLength();
                guarderRangeBlocks.add(this.createGuardedBlock(textLength, textLength));
            }
            this.myModel.setChanges(builder.getChanges(), isContentsEqual, guarderRangeBlocks, convertor1, convertor2, builder.getRanges());
            int newCaretLine = this.transferLineToOneside((Side)oldCaretLineTwoside.second, ((Side)oldCaretLineTwoside.second).select((int[])oldCaretLineTwoside.first));
            this.myEditor.getCaretModel().moveToOffset(LineCol.toOffset((Document)this.myDocument, (int)newCaretLine, (int)oldCaretPosition.column));
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            HighlightersData.apply(this.myProject, this.myEditor, highlightersData);
            this.myMarkupUpdater.resumeUpdate();
            this.myInitialScrollHelper.onRediff();
            this.myStatusPanel.update();
            this.myPanel.setGoodContent();
            this.myEditor.getGutterComponentEx().revalidateMarkup();
        };
        if (runnable == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(23);
        }
        return runnable;
    }

    @NotNull
    private RangeMarker createGuardedBlock(int start, int end) {
        RangeMarker block = this.myDocument.createGuardedBlock(start, end);
        block.setGreedyToLeft(true);
        block.setGreedyToRight(true);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(24);
        }
        return rangeMarker;
    }

    public int transferLineToOnesideStrict(@NotNull Side side, int line) {
        LineNumberConvertor convertor;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(25);
        }
        return (convertor = this.myModel.getLineNumberConvertor(side)) != null ? convertor.convertInv(line) : -1;
    }

    public int transferLineFromOnesideStrict(@NotNull Side side, int line) {
        LineNumberConvertor convertor;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(26);
        }
        return (convertor = this.myModel.getLineNumberConvertor(side)) != null ? convertor.convert(line) : -1;
    }

    public int transferLineToOneside(@NotNull Side side, int line) {
        LineNumberConvertor convertor;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(27);
        }
        return (convertor = this.myModel.getLineNumberConvertor(side)) != null ? convertor.convertApproximateInv(line) : line;
    }

    public int transferLineFromOneside(@NotNull Side side, int line) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(28);
        }
        return side.select((int[])this.transferLineFromOneside((int)line).first);
    }

    @NotNull
    public @NotNull Pair<int[], @NotNull Side> transferLineFromOneside(int line) {
        int[] lines = new int[2];
        UnifiedDiffModel.ChangedBlockData blockData = this.myModel.getData();
        if (blockData == null) {
            lines[0] = line;
            lines[1] = line;
            Pair pair = Pair.create((Object)lines, (Object)this.myMasterSide);
            if (pair == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(29);
            }
            return pair;
        }
        LineNumberConvertor lineConvertor1 = blockData.getLineNumberConvertor(Side.LEFT);
        LineNumberConvertor lineConvertor2 = blockData.getLineNumberConvertor(Side.RIGHT);
        Side side = this.myMasterSide;
        lines[0] = lineConvertor1.convert(line);
        lines[1] = lineConvertor2.convert(line);
        if (lines[0] == -1 && lines[1] == -1) {
            lines[0] = lineConvertor1.convertApproximate(line);
            lines[1] = lineConvertor2.convertApproximate(line);
        } else if (lines[0] == -1) {
            lines[0] = lineConvertor1.convertApproximate(line);
            side = Side.RIGHT;
        } else if (lines[1] == -1) {
            lines[1] = lineConvertor2.convertApproximate(line);
            side = Side.LEFT;
        }
        Pair pair = Pair.create((Object)lines, (Object)side);
        if (pair == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(30);
        }
        return pair;
    }

    @RequiresEdt
    private void destroyChangedBlockData() {
        ThreadingAssertions.assertEventDispatchThread();
        this.myModel.clear();
        UnifiedEditorRangeHighlighter.erase(this.myProject, this.myDocument);
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(31);
        }
        if (this.myDuringTwosideDocumentModification) {
            return;
        }
        this.markStateIsOutOfDate();
        this.markSuppressEditorTyping();
        this.scheduleRediff();
    }

    @RequiresWriteLock
    public void replaceChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(32);
        }
        if (sourceSide == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(33);
        }
        ThreadingAssertions.assertWriteAccess();
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        boolean isLastWithLocal = DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, new UserDataHolder[]{this.myContext});
        boolean isLocalChangeRevert = sourceSide == Side.LEFT && isLastWithLocal;
        TextDiffViewerUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getStartLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment), isLocalChangeRevert);
    }

    @RequiresWriteLock
    public void appendChange(@NotNull UnifiedDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(34);
        }
        if (sourceSide == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(35);
        }
        ThreadingAssertions.assertWriteAccess();
        Side outputSide = sourceSide.other();
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        LineFragment lineFragment = change.getLineFragment();
        if (sourceSide.getStartLine(lineFragment) == sourceSide.getEndLine(lineFragment)) {
            return;
        }
        DiffUtil.applyModification((Document)outputSide.select((Object)document1, (Object)document2), outputSide.getEndLine(lineFragment), outputSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
    }

    @RequiresEdt
    @NotNull
    protected List<UnifiedDiffChange> getSelectedChanges() {
        ThreadingAssertions.assertEventDispatchThread();
        BitSet lines = DiffUtil.getSelectedLines((Editor)this.myEditor);
        List changes = ContainerUtil.notNullize(this.myModel.getDiffChanges());
        List list = ContainerUtil.filter((Collection)changes, change -> UnifiedDiffViewer.isChangeSelected(change, lines));
        if (list == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(36);
        }
        return list;
    }

    private static boolean isChangeSelected(@NotNull UnifiedDiffChange change, @NotNull BitSet lines) {
        if (change == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(37);
        }
        if (lines == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(38);
        }
        return DiffUtil.isSelectedByLine(lines, change.getLine1(), change.getLine2());
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(39);
        }
        return textDiffSettings;
    }

    @NotNull
    public FoldingModelSupport.Settings getFoldingModelSettings() {
        FoldingModelSupport.Settings settings = TextDiffViewerUtil.getFoldingModelSettings(this.myContext);
        if (settings == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(40);
        }
        return settings;
    }

    @NotNull
    public FoldingModelSupport getFoldingModel() {
        MyFoldingModel myFoldingModel = this.myFoldingModel;
        if (myFoldingModel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(41);
        }
        return myFoldingModel;
    }

    @RequiresEdt
    public void scrollToLine(@NotNull Side side, int line) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(42);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int onesideLine = this.transferLineToOneside(side, line);
        DiffUtil.scrollEditor((Editor)this.myEditor, onesideLine, 0, false);
    }

    @RequiresEdt
    public boolean scrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (scrollToChangePolicy == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(43);
        }
        ThreadingAssertions.assertEventDispatchThread();
        List<UnifiedDiffChange> changes = this.myModel.getDiffChanges();
        if (changes == null) {
            return false;
        }
        UnifiedDiffChange targetChange = (UnifiedDiffChange)scrollToChangePolicy.select(ContainerUtil.filter(changes, it -> !it.isSkipped()));
        if (targetChange == null) {
            targetChange = scrollToChangePolicy.select(changes);
        }
        if (targetChange == null) {
            return false;
        }
        DiffUtil.scrollEditor((Editor)this.myEditor, targetChange.getLine1(), false);
        return true;
    }

    @NotNull
    public Side getMasterSide() {
        Side side = this.myMasterSide;
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(44);
        }
        return side;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(45);
        }
        return editorEx;
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        List<EditorEx> list = Collections.singletonList(this.myEditor);
        if (list == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    public List<? extends DocumentContent> getContents() {
        List list = this.myRequest.getContents();
        if (list == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(47);
        }
        return list;
    }

    @NotNull
    public DocumentContent getContent(@NotNull Side side) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(48);
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(49);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent getContent1() {
        DocumentContent documentContent = this.getContent(Side.LEFT);
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(50);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent getContent2() {
        DocumentContent documentContent = this.getContent(Side.RIGHT);
        if (documentContent == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(51);
        }
        return documentContent;
    }

    @Nullable
    public List<UnifiedDiffChange> getDiffChanges() {
        return this.myModel.getDiffChanges();
    }

    @NotNull
    private List<UnifiedDiffChange> getNonSkippedDiffChanges() {
        List list = ContainerUtil.filter((Collection)ContainerUtil.notNullize(this.getDiffChanges()), it -> !it.isSkipped());
        if (list == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    public JComponent getComponent() {
        UnifiedDiffPanel unifiedDiffPanel = this.myPanel;
        if (unifiedDiffPanel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(53);
        }
        return unifiedDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return this.myEditor.getContentComponent();
    }

    @Override
    @NotNull
    protected StatusPanel getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(54);
        }
        return myStatusPanel;
    }

    @RequiresEdt
    public boolean isEditable(@NotNull Side side, boolean respectReadOnlyLock) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(55);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myReadOnlyLockSet && respectReadOnlyLock) {
            return false;
        }
        if (side.select(this.myForceReadOnlyFlags)) {
            return false;
        }
        return DiffUtil.canMakeWritable(this.getDocument(side));
    }

    @NotNull
    public Document getDocument(@NotNull Side side) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(56);
        }
        Document document = this.getContent(side).getDocument();
        if (document == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(57);
        }
        return document;
    }

    public boolean isStateIsOutOfDate() {
        return this.myStateIsOutOfDate;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(LineCol.fromCaret((Editor)this.myEditor));
    }

    @RequiresEdt
    @Nullable
    protected UnifiedDiffChange getCurrentChange() {
        ThreadingAssertions.assertEventDispatchThread();
        List<UnifiedDiffChange> changes = this.myModel.getDiffChanges();
        if (changes == null) {
            return null;
        }
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        for (UnifiedDiffChange change : changes) {
            if (!DiffUtil.isSelectedByLine(caretLine, change.getLine1(), change.getLine2())) continue;
            return change;
        }
        return null;
    }

    @RequiresEdt
    @Nullable
    protected Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(58);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Pair<int[], Side> pair = this.transferLineFromOneside(position.line);
        int line1 = ((int[])pair.first)[0];
        int line2 = ((int[])pair.first)[1];
        Navigatable navigatable1 = this.getContent1().getNavigatable(new LineCol(line1, position.column));
        Navigatable navigatable2 = this.getContent2().getNavigatable(new LineCol(line2, position.column));
        if (navigatable1 == null) {
            return navigatable2;
        }
        if (navigatable2 == null) {
            return navigatable1;
        }
        return (Navigatable)((Side)pair.second).select((Object)navigatable1, (Object)navigatable2);
    }

    public boolean isContentGood() {
        return this.myPanel.isGoodContent() && this.myModel.isValid();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(59);
        }
        if (request == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(60);
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public PrevNextDifferenceIterable getDifferenceIterable() {
        return this.myPrevNextDifferenceIterable;
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(61);
        }
        super.uiDataSnapshot(sink);
        UnifiedDiffChange change = this.getCurrentChange();
        sink.set(DiffDataKeys.CURRENT_EDITOR, (Object)this.myEditor);
        if (change != null) {
            sink.set(DiffDataKeys.CURRENT_CHANGE_RANGE, (Object)new LineRange(change.getLine1(), change.getLine2()));
        }
        sink.set(DiffDataKeys.EDITOR_CHANGED_RANGE_PROVIDER, (Object)new MyChangedRangeProvider());
        sink.set(PlatformCoreDataKeys.FILE_EDITOR, (Object)TextEditorProvider.getInstance().getTextEditor((Editor)this.myEditor));
    }

    @NotNull
    public List<? extends Editor> getHighlightEditors() {
        if (this.myProject == null) {
            List list = Collections.emptyList();
            if (list == null) {
                UnifiedDiffViewer.$$$reportNull$$$0(62);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> {
            ArrayList<EditorEx> result = new ArrayList<EditorEx>();
            result.add(this.myEditor);
            ContainerUtil.addIfNotNull(result, (Object)this.createImaginaryEditor(Side.LEFT));
            ContainerUtil.addIfNotNull(result, (Object)this.createImaginaryEditor(Side.RIGHT));
            return result;
        });
        if (list == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(63);
        }
        return list;
    }

    @Nullable
    private Editor createImaginaryEditor(@NotNull Side side) {
        if (side == null) {
            UnifiedDiffViewer.$$$reportNull$$$0(64);
        }
        if (this.myProject == null) {
            return null;
        }
        if (UnifiedImaginaryEditor.ourDisableImaginaryEditor) {
            return null;
        }
        if (!Registry.is((String)"diff.unified.enable.imaginary.editor")) {
            return null;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        LineCol caretPosition = LineCol.fromOffset((Document)this.myDocument, (int)caretOffset);
        Document sideDocument = this.getDocument(side);
        UnifiedImaginaryEditor editor = new UnifiedImaginaryEditor(this.myProject, sideDocument, side);
        int sideLine = this.transferLineFromOnesideStrict(side, caretPosition.line);
        if (sideLine != -1) {
            editor.getCaretModel().moveToOffset(LineCol.toOffset((Document)sideDocument, (int)sideLine, (int)caretPosition.column));
        }
        return editor;
    }

    @Nullable
    @Nls
    protected String getStatusTextMessage() {
        UnifiedDiffModel.ChangedBlockData blockData = this.myModel.getData();
        if (blockData == null) {
            return null;
        }
        List<UnifiedDiffChange> allChanges = blockData.getDiffChanges();
        return DiffUtil.getStatusText(allChanges.size(), ContainerUtil.count(allChanges, it -> it.isExcluded()), this.myModel.isContentsEqual());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8, 9, 10, 11, 13, 23, 24, 29, 30, 36, 39, 40, 41, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 57, 62, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer";
                break;
            }
            case 5: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 42: 
            case 48: 
            case 55: 
            case 56: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollToChangePolicy";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyErrorNotification";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDifferences";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardedBlock";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "transferLineFromOneside";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModel";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMasterSide";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent1";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent2";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonSkippedDiffChanges";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusPanel";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 62: 
            case 63: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUi";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onBeforeDocumentChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeDifferences";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildHighlighter";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "transferLineToOnesideStrict";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "transferLineFromOnesideStrict";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "transferLineToOneside";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "transferLineFromOneside";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChange";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isChangeSelected";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "scrollToLine";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "scrollToChange";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createImaginaryEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8, 9, 10, 11, 13, 23, 24, 29, 30, 36, 39, 40, 41, 44, 45, 46, 47, 49, 50, 51, 52, 53, 54, 57, 62, 63 -> new IllegalStateException(string);
        };
    }

    private class MyInitialScrollHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        private MyInitialScrollHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = UnifiedDiffViewer.this.getEditors();
            if (list == null) {
                MyInitialScrollHelper.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
        }

        @Override
        public void onSlowRediff() {
        }

        @Override
        protected LogicalPosition @Nullable [] getCaretPositions() {
            LogicalPosition position = UnifiedDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{MyInitialScrollHelper.getPosition(((int[])pair.first)[0], position.column), MyInitialScrollHelper.getPosition(((int[])pair.first)[1], position.column)};
            return carets;
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition twosidePosition = (LogicalPosition)UnifiedDiffViewer.this.myMasterSide.selectNotNull((Object[])this.myCaretPosition);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(UnifiedDiffViewer.this.myMasterSide, twosidePosition.line);
            LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
            UnifiedDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint((Editor)UnifiedDiffViewer.this.myEditor, this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret((Editor)UnifiedDiffViewer.this.myEditor, false);
            }
            return true;
        }

        @NotNull
        private static LogicalPosition getPosition(int line, int column) {
            if (line == -1) {
                return new LogicalPosition(0, 0);
            }
            return new LogicalPosition(line, column);
        }

        @Override
        protected boolean doScrollToLine(boolean onSlowRediff) {
            if (this.myScrollToLine == null) {
                return false;
            }
            UnifiedDiffViewer.this.scrollToLine((Side)this.myScrollToLine.first, (Integer)this.myScrollToLine.second);
            return true;
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return UnifiedDiffViewer.this.scrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return UnifiedDiffViewer.this.scrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myModel.getDiffChanges();
            if (changes == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(changes);
            int line = this.myNavigationContext.contextMatchCheck((Iterator)changedLinesIterator);
            if (line == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(UnifiedDiffViewer.this.getContent2().getDocument());
                line = this.myNavigationContext.contextMatchCheck((Iterator)allLinesIterator);
            }
            if (line == -1) {
                return false;
            }
            UnifiedDiffViewer.this.scrollToLine(Side.RIGHT, line);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyInitialScrollHelper", "getEditors"));
        }
    }

    private class MyPrevNextDifferenceIterable
    extends PrevNextDifferenceIterableBase<UnifiedDiffChange> {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        @NotNull
        protected List<UnifiedDiffChange> getChanges() {
            List<UnifiedDiffChange> list = UnifiedDiffViewer.this.getNonSkippedDiffChanges();
            if (list == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        @NotNull
        protected EditorEx getEditor() {
            EditorEx editorEx = UnifiedDiffViewer.this.myEditor;
            if (editorEx == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        @Override
        protected int getStartLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(2);
            }
            return change.getLine1();
        }

        @Override
        protected int getEndLine(@NotNull UnifiedDiffChange change) {
            if (change == null) {
                MyPrevNextDifferenceIterable.$$$reportNull$$$0(3);
            }
            return change.getLine2();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyPrevNextDifferenceIterable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getStartLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEndLine";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        @Nullable
        protected String getMessage() {
            return UnifiedDiffViewer.this.getStatusTextMessage();
        }
    }

    private final class UnifiedBreadcrumbsPanel
    extends DiffBreadcrumbsPanel {
        @Nullable
        private final VirtualFile myFile1;
        @Nullable
        private final VirtualFile myFile2;
        @Nullable
        private final DiffBreadcrumbsPanel.DiffBreadcrumbCollectorHolder myCollectorHolder1;
        @Nullable
        private final DiffBreadcrumbsPanel.DiffBreadcrumbCollectorHolder myCollectorHolder2;

        private UnifiedBreadcrumbsPanel() {
            super((Editor)UnifiedDiffViewer.this.getEditor(), (Disposable)UnifiedDiffViewer.this);
            this.myFile1 = FileDocumentManager.getInstance().getFile(UnifiedDiffViewer.this.getDocument(Side.LEFT));
            this.myFile2 = FileDocumentManager.getInstance().getFile(UnifiedDiffViewer.this.getDocument(Side.RIGHT));
            this.myCollectorHolder1 = new DiffBreadcrumbsPanel.DiffBreadcrumbCollectorHolder(this);
            this.myCollectorHolder2 = new DiffBreadcrumbsPanel.DiffBreadcrumbCollectorHolder(this);
        }

        @Override
        protected boolean updateCollectors(boolean enabled) {
            boolean update1 = this.myCollectorHolder1 != null && this.myCollectorHolder1.update(this.myFile1, enabled);
            boolean update2 = this.myCollectorHolder2 != null && this.myCollectorHolder2.update(this.myFile2, enabled);
            return update1 || update2;
        }

        @Nullable
        protected Iterable<? extends Crumb> computeCrumbs(int offset) {
            FileBreadcrumbsCollector collector;
            Pair<Integer, Side> pair = this.transferOffsetToTwoside(offset);
            if (pair == null) {
                return null;
            }
            Side side = (Side)pair.second;
            int twosideOffset = (Integer)pair.first;
            VirtualFile file = (VirtualFile)side.select((Object)this.myFile1, (Object)this.myFile2);
            DiffBreadcrumbsPanel.DiffBreadcrumbCollectorHolder holder = (DiffBreadcrumbsPanel.DiffBreadcrumbCollectorHolder)side.select((Object)this.myCollectorHolder1, (Object)this.myCollectorHolder2);
            FileBreadcrumbsCollector fileBreadcrumbsCollector = collector = holder != null ? holder.getBreadcrumbsCollector() : null;
            if (file == null || collector == null) {
                return null;
            }
            Iterable crumbs = collector.computeCrumbs(file, UnifiedDiffViewer.this.getDocument(side), twosideOffset, null);
            return ContainerUtil.map((Iterable)crumbs, it -> it instanceof NavigatableCrumb ? new UnifiedNavigatableCrumb((NavigatableCrumb)it, side) : it);
        }

        protected void navigateToCrumb(Crumb crumb, boolean withSelection) {
            if (crumb instanceof UnifiedNavigatableCrumb) {
                super.navigateToCrumb(crumb, withSelection);
            }
        }

        @Nullable
        private Pair<Integer, Side> transferOffsetToTwoside(int offset) {
            LineCol onesidePosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)offset);
            Pair<int[], Side> pair = UnifiedDiffViewer.this.transferLineFromOneside(onesidePosition.line);
            Side side = (Side)pair.second;
            int twosideLine = side.select((int[])pair.first);
            if (twosideLine == -1) {
                return null;
            }
            Document twosideDocument = UnifiedDiffViewer.this.getDocument(side);
            LineCol twosidePosition = new LineCol(twosideLine, onesidePosition.column);
            return Pair.create((Object)twosidePosition.toOffset(twosideDocument), (Object)side);
        }

        private int transferOffsetFromTwoside(@NotNull Side side, int offset) {
            if (side == null) {
                UnifiedBreadcrumbsPanel.$$$reportNull$$$0(0);
            }
            LineCol twosidePosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.getDocument(side), (int)offset);
            int onesideLine = UnifiedDiffViewer.this.transferLineToOneside(side, twosidePosition.line);
            if (onesideLine == -1) {
                return -1;
            }
            LineCol onesidePosition = new LineCol(onesideLine, twosidePosition.column);
            return onesidePosition.toOffset(UnifiedDiffViewer.this.myDocument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedBreadcrumbsPanel", "transferOffsetFromTwoside"));
        }

        private final class UnifiedNavigatableCrumb
        implements NavigatableCrumb {
            @NotNull
            private final NavigatableCrumb myDelegate;
            @NotNull
            private final Side mySide;

            private UnifiedNavigatableCrumb(@NotNull NavigatableCrumb delegate, Side side) {
                if (delegate == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(0);
                }
                if (side == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(1);
                }
                this.myDelegate = delegate;
                this.mySide = side;
            }

            public int getAnchorOffset() {
                int offset = this.myDelegate.getAnchorOffset();
                return offset != -1 ? UnifiedBreadcrumbsPanel.this.transferOffsetFromTwoside(this.mySide, offset) : -1;
            }

            @Nullable
            public TextRange getHighlightRange() {
                TextRange range = this.myDelegate.getHighlightRange();
                if (range == null) {
                    return null;
                }
                int start = UnifiedBreadcrumbsPanel.this.transferOffsetFromTwoside(this.mySide, range.getStartOffset());
                int end = UnifiedBreadcrumbsPanel.this.transferOffsetFromTwoside(this.mySide, range.getEndOffset());
                if (start == -1 || end == -1) {
                    return null;
                }
                return new TextRange(start, end);
            }

            public void navigate(@NotNull Editor editor, boolean withSelection) {
                TextRange range;
                int offset;
                if (editor == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(2);
                }
                if ((offset = this.getAnchorOffset()) != -1) {
                    editor.getCaretModel().moveToOffset(offset);
                    editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
                if (withSelection && (range = this.getHighlightRange()) != null) {
                    editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                }
            }

            public Icon getIcon() {
                return this.myDelegate.getIcon();
            }

            public String getText() {
                return this.myDelegate.getText();
            }

            @Nullable
            public String getTooltip() {
                return this.myDelegate.getTooltip();
            }

            @NotNull
            public List<? extends Action> getContextActions() {
                List list = this.myDelegate.getContextActions();
                if (list == null) {
                    UnifiedNavigatableCrumb.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "delegate";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "side";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedBreadcrumbsPanel$UnifiedNavigatableCrumb";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedBreadcrumbsPanel$UnifiedNavigatableCrumb";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContextActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "navigate";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        @NotNull
        private DisposableLineNumberConvertor myLineNumberConvertor;

        MyFoldingModel(@Nullable Project project, @NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                MyFoldingModel.$$$reportNull$$$0(0);
            }
            if (disposable == null) {
                MyFoldingModel.$$$reportNull$$$0(1);
            }
            super(project, new EditorEx[]{editor}, disposable);
            this.myLineNumberConvertor = new DisposableLineNumberConvertor(null);
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public FoldingModelSupport.Data createState(@Nullable List<? extends LineRange> changedLines, @NotNull FoldingModelSupport.Settings settings, @NotNull Document document, @NotNull LineNumberConvertor lineConvertor, int lineCount) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AssignmentExpression.applyExpressionRewriter(AssignmentExpression.java:68)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ComparisonOperation.applyExpressionRewriter(ComparisonOperation.java:138)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.BooleanOperation.applyExpressionRewriter(BooleanOperation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:139)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.rewriteExpressions(StructuredIf.java:170)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void disposeLineConvertor() {
            this.myLineNumberConvertor.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineConvertor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class DisposableLineNumberConvertor {
            @Nullable
            private volatile LineNumberConvertor myConvertor;

            private DisposableLineNumberConvertor(@Nullable LineNumberConvertor convertor) {
                this.myConvertor = convertor;
            }

            public int convert(int lineNumber) {
                LineNumberConvertor convertor = this.myConvertor;
                return convertor != null ? convertor.convert(lineNumber) : -1;
            }

            public void dispose() {
                this.myConvertor = null;
            }
        }

        private static final class MyFoldingBuilder
        extends FoldingModelSupport.FoldingBuilderBase {
            @NotNull
            private final Document myDocument;
            @NotNull
            private final DisposableLineNumberConvertor myLineConvertor;

            private MyFoldingBuilder(@NotNull Document document, @NotNull DisposableLineNumberConvertor lineConvertor, int lineCount, @NotNull FoldingModelSupport.Settings settings) {
                if (document == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(0);
                }
                if (lineConvertor == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(1);
                }
                if (settings == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(2);
                }
                super(new int[]{lineCount}, settings);
                this.myDocument = document;
                this.myLineConvertor = lineConvertor;
            }

            @Override
            @Nullable
            protected FoldingModelSupport.FoldedRangeDescription getDescription(@NotNull Project project, int lineNumber, int index) {
                int masterLine;
                if (project == null) {
                    MyFoldingBuilder.$$$reportNull$$$0(3);
                }
                if ((masterLine = this.myLineConvertor.convert(lineNumber)) == -1) {
                    return null;
                }
                return FoldingModelSupport.getLineSeparatorDescription(project, this.myDocument, masterLine);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lineConvertor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyFoldingModel$MyFoldingBuilder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDescription";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private final class MarkupUpdater
    implements Disposable {
        @NotNull
        private final MergingUpdateQueue myUpdateQueue;
        @NotNull
        private volatile ProgressIndicator myUpdateIndicator;
        private volatile boolean mySuspended;

        private MarkupUpdater(List<? extends DocumentContent> contents) {
            if (contents == null) {
                MarkupUpdater.$$$reportNull$$$0(0);
            }
            this.myUpdateQueue = new MergingUpdateQueue("UnifiedDiffViewer.MarkupUpdater", 300, true, (JComponent)UnifiedDiffViewer.this.myPanel, (Disposable)this);
            this.myUpdateIndicator = new EmptyProgressIndicator();
            Disposer.register((Disposable)UnifiedDiffViewer.this, (Disposable)this);
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> this.resetMarkup());
            MyMarkupModelListener markupListener = new MyMarkupModelListener();
            for (DocumentContent documentContent : contents) {
                Document document = documentContent.getDocument();
                MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)document, (Project)UnifiedDiffViewer.this.myProject, (boolean)true);
                model.addMarkupModelListener((Disposable)this, (MarkupModelListener)markupListener);
            }
        }

        public void dispose() {
            this.myUpdateIndicator.cancel();
        }

        @RequiresEdt
        public void suspendUpdate() {
            ThreadingAssertions.assertEventDispatchThread();
            this.myUpdateIndicator.cancel();
            this.myUpdateQueue.cancelAllUpdates();
            this.mySuspended = true;
        }

        @RequiresEdt
        public void resumeUpdate() {
            ThreadingAssertions.assertEventDispatchThread();
            this.mySuspended = false;
            this.scheduleUpdate();
        }

        public void resetMarkup() {
            UnifiedDiffViewer.this.myEditor.setHighlighter(DiffUtil.createEmptyEditorHighlighter());
            UnifiedEditorRangeHighlighter.erase(UnifiedDiffViewer.this.myProject, (Document)UnifiedDiffViewer.this.myEditor.getDocument());
            this.scheduleUpdate();
            this.myUpdateQueue.sendFlush();
        }

        void scheduleUpdate() {
            if (UnifiedDiffViewer.this.myProject == null) {
                return;
            }
            if (this.mySuspended) {
                return;
            }
            this.myUpdateIndicator.cancel();
            this.myUpdateQueue.queue(new Update("update"){

                public void run() {
                    if (!UIUtil.isShowing((Component)UnifiedDiffViewer.this.getComponent())) {
                        return;
                    }
                    if (UnifiedDiffViewer.this.myStateIsOutOfDate || !UnifiedDiffViewer.this.myModel.isValid()) {
                        return;
                    }
                    MarkupUpdater.this.myUpdateIndicator.cancel();
                    MarkupUpdater.this.myUpdateIndicator = new EmptyProgressIndicator();
                    UnifiedDiffModel.ChangedBlockData blockData = Objects.requireNonNull(UnifiedDiffViewer.this.myModel.getData());
                    ReadAction.nonBlocking(() -> MarkupUpdater.this.updateHighlighters(blockData)).finishOnUiThread(ModalityState.stateForComponent((Component)UnifiedDiffViewer.this.myPanel), result -> {
                        if (UnifiedDiffViewer.this.myStateIsOutOfDate || blockData != UnifiedDiffViewer.this.myModel.getData()) {
                            return;
                        }
                        HighlightersData.apply(UnifiedDiffViewer.this.myProject, UnifiedDiffViewer.this.myEditor, result);
                    }).withDocumentsCommitted(UnifiedDiffViewer.this.myProject).wrapProgress(MarkupUpdater.this.myUpdateIndicator).submit((Executor)NonUrgentExecutor.getInstance());
                }
            });
        }

        @NotNull
        private HighlightersData updateHighlighters(@NotNull UnifiedDiffModel.ChangedBlockData blockData) {
            if (blockData == null) {
                MarkupUpdater.$$$reportNull$$$0(1);
            }
            List<HighlightRange> ranges = blockData.getRanges();
            Document document1 = UnifiedDiffViewer.this.getContent1().getDocument();
            Document document2 = UnifiedDiffViewer.this.getContent2().getDocument();
            ProgressManager.checkCanceled();
            EditorHighlighter highlighter = UnifiedDiffViewer.buildHighlighter(UnifiedDiffViewer.this.myProject, UnifiedDiffViewer.this.myDocument, UnifiedDiffViewer.this.getContent1(), UnifiedDiffViewer.this.getContent2(), document1.getCharsSequence(), document2.getCharsSequence(), ranges, UnifiedDiffViewer.this.myDocument.getTextLength());
            ProgressManager.checkCanceled();
            UnifiedEditorRangeHighlighter rangeHighlighter = new UnifiedEditorRangeHighlighter(UnifiedDiffViewer.this.myProject, document1, document2, ranges);
            return new HighlightersData(highlighter, rangeHighlighter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MarkupUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateHighlighters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyMarkupModelListener
        implements MarkupModelListener {
            private MyMarkupModelListener() {
            }

            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    MyMarkupModelListener.$$$reportNull$$$0(0);
                }
                MarkupUpdater.this.scheduleUpdate();
            }

            public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    MyMarkupModelListener.$$$reportNull$$$0(1);
                }
                MarkupUpdater.this.scheduleUpdate();
            }

            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                if (highlighter == null) {
                    MyMarkupModelListener.$$$reportNull$$$0(2);
                }
                MarkupUpdater.this.scheduleUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MarkupUpdater$MyMarkupModelListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attributesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            if (editor == null) {
                MyOpenInEditorWithMouseAction.$$$reportNull$$$0(0);
            }
            if (editor != UnifiedDiffViewer.this.myEditor) {
                return null;
            }
            return UnifiedDiffViewer.this.getNavigatable(new LineCol(line));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        AppendSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.copyShortcutFrom(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.AppendLeftSide", (Object)"Diff.AppendRightSide")));
            this.getTemplatePresentation().setText(DiffBundle.messagePointer((String)"action.presentation.diff.append.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setIcon(DiffUtil.getArrowDownIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                AppendSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (UnifiedDiffChange unifiedDiffChange : changes) {
                UnifiedDiffViewer.this.appendChange(unifiedDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$AppendSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyReadonlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private MyReadonlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }

    private class MyOnesideDocumentListener
    implements DocumentListener {
        private MyOnesideDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyOnesideDocumentListener.$$$reportNull$$$0(0);
            }
            if (UnifiedDiffViewer.this.myDuringOnesideDocumentModification) {
                return;
            }
            UnifiedDiffModel.ChangedBlockData blockData = UnifiedDiffViewer.this.myModel.getData();
            if (blockData == null) {
                LOG.warn("oneside beforeDocumentChange - model is invalid");
                return;
            }
            try {
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = true;
                Document twosideDocument = UnifiedDiffViewer.this.getDocument(UnifiedDiffViewer.this.myMasterSide);
                LineCol onesideStartPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)e.getOffset());
                LineCol onesideEndPosition = LineCol.fromOffset((Document)UnifiedDiffViewer.this.myDocument, (int)(e.getOffset() + e.getOldLength()));
                int line1 = onesideStartPosition.line;
                int line2 = onesideEndPosition.line + 1;
                int shift = DiffUtil.countLinesShift(e);
                int twosideStartLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideStartPosition.line);
                int twosideEndLine = UnifiedDiffViewer.this.transferLineFromOnesideStrict(UnifiedDiffViewer.this.myMasterSide, onesideEndPosition.line);
                if (twosideStartLine == -1 || twosideEndLine == -1) {
                    this.logDebugInfo(e, onesideStartPosition, onesideEndPosition, twosideStartLine, twosideEndLine);
                    UnifiedDiffViewer.this.markSuppressEditorTyping();
                    return;
                }
                int twosideStartOffset = twosideDocument.getLineStartOffset(twosideStartLine) + onesideStartPosition.column;
                int twosideEndOffset = twosideDocument.getLineStartOffset(twosideEndLine) + onesideEndPosition.column;
                twosideDocument.replaceString(twosideStartOffset, twosideEndOffset, e.getNewFragment());
                for (UnifiedDiffChange change : blockData.getDiffChanges()) {
                    change.processChange(line1, line2, shift);
                }
                LineNumberConvertor masterConvertor = blockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide);
                LineNumberConvertor slaveConvertor = blockData.getLineNumberConvertor(UnifiedDiffViewer.this.myMasterSide.other());
                masterConvertor.handleMasterChange(line1, line2, shift, true);
                slaveConvertor.handleMasterChange(line1, line2, shift, false);
            }
            finally {
                UnifiedDiffViewer.this.markStateIsOutOfDate();
                UnifiedDiffViewer.this.scheduleRediff();
                UnifiedDiffViewer.this.myDuringTwosideDocumentModification = false;
            }
        }

        private void logDebugInfo(DocumentEvent e, LineCol onesideStartPosition, LineCol onesideEndPosition, int twosideStartLine, int twosideEndLine) {
            @NonNls StringBuilder info = new StringBuilder();
            Document document1 = UnifiedDiffViewer.this.getDocument(Side.LEFT);
            Document document2 = UnifiedDiffViewer.this.getDocument(Side.RIGHT);
            info.append("==== UnifiedDiffViewer Debug Info ====");
            info.append("myMasterSide - ").append(UnifiedDiffViewer.this.myMasterSide).append('\n');
            info.append("myLeftDocument.length() - ").append(document1.getTextLength()).append('\n');
            info.append("myRightDocument.length() - ").append(document2.getTextLength()).append('\n');
            info.append("myDocument.length() - ").append(UnifiedDiffViewer.this.myDocument.getTextLength()).append('\n');
            info.append("e.getOffset() - ").append(e.getOffset()).append('\n');
            info.append("e.getNewLength() - ").append(e.getNewLength()).append('\n');
            info.append("e.getOldLength() - ").append(e.getOldLength()).append('\n');
            info.append("onesideStartPosition - ").append(onesideStartPosition).append('\n');
            info.append("onesideEndPosition - ").append(onesideEndPosition).append('\n');
            info.append("twosideStartLine - ").append(twosideStartLine).append('\n');
            info.append("twosideEndLine - ").append(twosideEndLine).append('\n');
            Pair<int[], Side> pair1 = UnifiedDiffViewer.this.transferLineFromOneside(onesideStartPosition.line);
            Pair<int[], Side> pair2 = UnifiedDiffViewer.this.transferLineFromOneside(onesideEndPosition.line);
            info.append("non-strict transferStartLine - ").append(((int[])pair1.first)[0]).append("-").append(((int[])pair1.first)[1]).append(":").append(pair1.second).append('\n');
            info.append("non-strict transferEndLine - ").append(((int[])pair2.first)[0]).append("-").append(((int[])pair2.first)[1]).append(":").append(pair2.second).append('\n');
            info.append("---- UnifiedDiffViewer Debug Info ----");
            LOG.warn(info.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyOnesideDocumentListener", "beforeDocumentChange"));
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerUtil.ToggleExpandByDefaultAction {
        MyToggleExpandByDefaultAction(UnifiedDiffViewer unifiedDiffViewer) {
            super(unifiedDiffViewer.getTextSettings(), unifiedDiffViewer.myFoldingModel);
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.ReadOnlyLockAction {
        MyReadOnlyLockAction() {
            super(UnifiedDiffViewer.this.getContext());
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            UnifiedDiffViewer.this.myReadOnlyLockSet = readOnly;
            UnifiedDiffViewer.this.myModel.updateGutterActions();
            UnifiedDiffViewer.this.updateEditorCanBeTyped();
            this.putEditorHint(UnifiedDiffViewer.this.myEditor, readOnly && UnifiedDiffViewer.this.isEditable(UnifiedDiffViewer.this.myMasterSide, false));
        }

        @Override
        protected boolean canEdit() {
            return !UnifiedDiffViewer.this.myForceReadOnlyFlags[0] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent1().getDocument()) || !UnifiedDiffViewer.this.myForceReadOnlyFlags[1] && DiffUtil.canMakeWritable(UnifiedDiffViewer.this.getContent2().getDocument());
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        ReplaceSelectedChangesAction(Side focusedSide) {
            if (focusedSide == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(0);
            }
            super(focusedSide.other());
            this.copyShortcutFrom(ActionManager.getInstance().getAction((String)focusedSide.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide")));
            this.getTemplatePresentation().setText(UnifiedDiffChangeUi.getApplyActionText(UnifiedDiffViewer.this, focusedSide));
            this.getTemplatePresentation().setIcon(UnifiedDiffChangeUi.getApplyIcon(focusedSide));
        }

        @Override
        protected void apply(@NotNull List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                ReplaceSelectedChangesAction.$$$reportNull$$$0(1);
            }
            for (UnifiedDiffChange unifiedDiffChange : changes) {
                UnifiedDiffViewer.this.replaceChange(unifiedDiffChange, this.myModifiedSide.other());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "focusedSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ReplaceSelectedChangesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HighlightersData {
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final UnifiedEditorRangeHighlighter myRangeHighlighter;

        private HighlightersData(@Nullable EditorHighlighter highlighter, @Nullable UnifiedEditorRangeHighlighter rangeHighlighter) {
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        public static void apply(@Nullable Project project, @NotNull EditorEx editor, @Nullable HighlightersData highlightersData) {
            UnifiedEditorRangeHighlighter rangeHighlighter;
            if (editor == null) {
                HighlightersData.$$$reportNull$$$0(0);
            }
            EditorHighlighter highlighter = highlightersData != null ? highlightersData.myHighlighter : null;
            UnifiedEditorRangeHighlighter unifiedEditorRangeHighlighter = rangeHighlighter = highlightersData != null ? highlightersData.myRangeHighlighter : null;
            if (highlighter != null) {
                editor.setHighlighter(highlighter);
            } else {
                editor.setHighlighter(DiffUtil.createEmptyEditorHighlighter());
            }
            UnifiedEditorRangeHighlighter.erase(project, (Document)editor.getDocument());
            if (rangeHighlighter != null) {
                rangeHighlighter.apply(project, (Document)editor.getDocument());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$HighlightersData", "apply"));
        }
    }

    private class MyChangedRangeProvider
    implements DiffChangedRangeProvider {
        private MyChangedRangeProvider() {
        }

        @Override
        @Nullable
        public List<TextRange> getChangedRanges(@NotNull Editor editor) {
            if (editor == null) {
                MyChangedRangeProvider.$$$reportNull$$$0(0);
            }
            if (editor != UnifiedDiffViewer.this.myEditor) {
                return null;
            }
            return ContainerUtil.map(UnifiedDiffViewer.this.getNonSkippedDiffChanges(), change -> DiffUtil.getLinesRange(editor.getDocument(), change.getLine1(), change.getLine2()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$MyChangedRangeProvider", "getChangedRanges"));
        }
    }

    private class UnifiedImaginaryEditor
    extends ImaginaryEditor {
        private static final Set<String> ourReportedMockMethods = ConcurrentHashMap.newKeySet();
        private static boolean ourDisableImaginaryEditor = false;
        private final Side mySide;

        private UnifiedImaginaryEditor(@NotNull Project project, @NotNull Document document, Side side) {
            if (project == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(0);
            }
            if (document == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(1);
            }
            if (side == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(2);
            }
            super(project, document);
            this.mySide = side;
        }

        protected RuntimeException notImplemented() {
            ourDisableImaginaryEditor = true;
            return new UnsupportedOperationException("Not implemented. UnifiedDiffViewer.UnifiedImaginaryEditor will be disabled.");
        }

        protected void warnMockImplementation(@NotNull String methodName) {
            if (methodName == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(3);
            }
            if (ourReportedMockMethods.add(methodName)) {
                String message = "Method + '" + methodName + "' is not applicable. Consider using 'editor instanceOf ImaginaryEditor'";
                if (ApplicationManager.getApplication().isInternal() || ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error(message);
                } else {
                    LOG.warn(message);
                }
            }
        }

        @Nullable
        @ApiStatus.Obsolete
        public VirtualFile getVirtualFile() {
            return FileDocumentManager.getInstance().getFile(this.getDocument());
        }

        @NotNull
        public EditorColorsScheme getColorsScheme() {
            EditorColorsScheme editorColorsScheme = UnifiedDiffViewer.this.myEditor.getColorsScheme();
            if (editorColorsScheme == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(4);
            }
            return editorColorsScheme;
        }

        @NotNull
        public ProperTextRange calculateVisibleRange() {
            UnifiedDiffModel.ChangedBlockData blockData = UnifiedDiffViewer.this.myModel.getData();
            if (blockData == null) {
                return new ProperTextRange(0, 0);
            }
            ProperTextRange range = UnifiedDiffViewer.this.myEditor.calculateVisibleRange();
            Document oneSideDocument = UnifiedDiffViewer.this.myDocument;
            int line1 = oneSideDocument.getLineNumber(range.getStartOffset());
            int line2 = oneSideDocument.getLineNumber(range.getEndOffset());
            Document sideDocument = UnifiedDiffViewer.this.getDocument(this.mySide);
            LineNumberConvertor lineConvertor = blockData.getLineNumberConvertor(this.mySide);
            int sideLine1 = lineConvertor.convertApproximate(Math.max(0, line1 - 1));
            int sideLine2 = lineConvertor.convertApproximate(Math.min(DiffUtil.getLineCount(oneSideDocument), line2 + 1));
            if (sideLine1 < 0 || sideLine1 > sideLine2 || sideLine2 > DiffUtil.getLineCount(sideDocument)) {
                ProperTextRange properTextRange = ProperTextRange.create((int)0, (int)0);
                if (properTextRange == null) {
                    UnifiedImaginaryEditor.$$$reportNull$$$0(5);
                }
                return properTextRange;
            }
            TextRange sideRange = DiffUtil.getLinesRange(sideDocument, sideLine1, sideLine2, false);
            ProperTextRange properTextRange = ProperTextRange.create((int)sideRange.getStartOffset(), (int)sideRange.getEndOffset());
            if (properTextRange == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(6);
            }
            return properTextRange;
        }

        public boolean isOneLineMode() {
            return false;
        }

        public boolean isViewer() {
            return true;
        }

        @NotNull
        public EditorSettings getSettings() {
            EditorSettings editorSettings = UnifiedDiffViewer.this.myEditor.getSettings();
            if (editorSettings == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(7);
            }
            return editorSettings;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = UnifiedDiffViewer.this.myEditor.getComponent();
            if (jComponent == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getContentComponent() {
            JComponent jComponent = UnifiedDiffViewer.this.myEditor.getContentComponent();
            if (jComponent == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(9);
            }
            return jComponent;
        }

        @NotNull
        public MarkupModel getMarkupModel() {
            return new EmptyMarkupModel(this.getDocument());
        }

        @NotNull
        public IndentsModel getIndentsModel() {
            return new EmptyIndentsModel();
        }

        @NotNull
        public InlayModel getInlayModel() {
            return new EmptyInlayModel();
        }

        @NotNull
        public FoldingModel getFoldingModel() {
            return new EmptyFoldingModel();
        }

        public boolean hasHeaderComponent() {
            return false;
        }

        @Nullable
        public JComponent getHeaderComponent() {
            return null;
        }

        public void setHeaderComponent(@Nullable JComponent header) {
            this.warnMockImplementation("setHeaderComponent");
        }

        public int getLineHeight() {
            this.warnMockImplementation("getLineHeight");
            return UnifiedDiffViewer.this.myEditor.getLineHeight();
        }

        @NotNull
        public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
            if (visiblePos == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(10);
            }
            this.warnMockImplementation("visualToLogicalPosition");
            return new LogicalPosition(0, 0);
        }

        @NotNull
        public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
            if (p == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(11);
            }
            this.warnMockImplementation("xyToLogicalPosition");
            return new LogicalPosition(0, 0);
        }

        @NotNull
        public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
            if (logicalPos == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(12);
            }
            this.warnMockImplementation("logicalToVisualPosition");
            return new VisualPosition(0, 0);
        }

        @NotNull
        public VisualPosition xyToVisualPosition(@NotNull Point p) {
            if (p == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(13);
            }
            this.warnMockImplementation("xyToVisualPosition");
            return new VisualPosition(0, 0);
        }

        @NotNull
        public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
            if (p == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(14);
            }
            this.warnMockImplementation("xyToVisualPosition");
            return new VisualPosition(0, 0);
        }

        @NotNull
        public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
            if (pos == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(15);
            }
            this.warnMockImplementation("logicalPositionToXY");
            return new Point(0, 0);
        }

        @NotNull
        public Point visualPositionToXY(@NotNull VisualPosition visible) {
            if (visible == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(16);
            }
            this.warnMockImplementation("visualPositionToXY");
            return new Point(0, 0);
        }

        @NotNull
        public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
            if (pos == null) {
                UnifiedImaginaryEditor.$$$reportNull$$$0(17);
            }
            this.warnMockImplementation("visualPositionToPoint2D");
            return new Point(0, 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedImaginaryEditor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visiblePos";
                    break;
                }
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logicalPos";
                    break;
                }
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pos";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visible";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$UnifiedImaginaryEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColorsScheme";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateVisibleRange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "warnMockImplementation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visualToLogicalPosition";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "xyToLogicalPosition";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "logicalToVisualPosition";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "xyToVisualPosition";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "logicalPositionToXY";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visualPositionToXY";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "visualPositionToPoint2D";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
            };
        }
    }

    private final class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final List<? extends UnifiedDiffChange> myChanges;
        private int myIndex;

        private ChangedLinesIterator(List<? extends UnifiedDiffChange> changes) {
            if (changes == null) {
                ChangedLinesIterator.$$$reportNull$$$0(0);
            }
            this.myIndex = 0;
            this.myChanges = changes;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            LOG.assertTrue(!UnifiedDiffViewer.this.myStateIsOutOfDate);
            UnifiedDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            LineFragment lineFragment = change.getLineFragment();
            Document document = UnifiedDiffViewer.this.getContent2().getDocument();
            for (int lineNumber = lineFragment.getStartLine2(); lineNumber < lineFragment.getEndLine2(); ++lineNumber) {
                int offset1 = document.getLineStartOffset(lineNumber);
                int offset2 = document.getLineEndOffset(lineNumber);
                CharSequence line = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(lineNumber, line);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ChangedLinesIterator", "<init>"));
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        @NotNull
        protected final Side myModifiedSide;

        ApplySelectedChangesActionBase(Side modifiedSide) {
            if (modifiedSide == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(0);
            }
            this.myModifiedSide = modifiedSide;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(2);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != UnifiedDiffViewer.this.getEditor()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true) || UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(this.isSomeChangeSelected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<UnifiedDiffChange> selectedChanges;
            if (e == null) {
                ApplySelectedChangesActionBase.$$$reportNull$$$0(3);
            }
            if ((selectedChanges = UnifiedDiffViewer.this.getSelectedChanges()).isEmpty()) {
                return;
            }
            if (!UnifiedDiffViewer.this.isEditable(this.myModifiedSide, true)) {
                return;
            }
            if (UnifiedDiffViewer.this.isStateIsOutOfDate()) {
                return;
            }
            String title = DiffBundle.message((String)"message.use.selected.changes.command", (Object[])new Object[]{e.getPresentation().getText()});
            DiffUtil.executeWriteCommand(UnifiedDiffViewer.this.getDocument(this.myModifiedSide), e.getProject(), title, () -> {
                this.apply(ContainerUtil.reverse((List)selectedChanges));
                UnifiedDiffViewer.this.scheduleRediff();
            });
        }

        protected boolean isSomeChangeSelected() {
            List<UnifiedDiffChange> changes = UnifiedDiffViewer.this.myModel.getDiffChanges();
            if (changes == null || changes.isEmpty()) {
                return false;
            }
            return DiffUtil.isSomeRangeSelected((Editor)UnifiedDiffViewer.this.getEditor(), (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists((Iterable)changes, change -> UnifiedDiffViewer.isChangeSelected(change, lines))));
        }

        @RequiresWriteLock
        protected abstract void apply(@NotNull List<? extends UnifiedDiffChange> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiedSide";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffViewer$ApplySelectedChangesActionBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

