/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChangeUi {
    @NotNull
    protected final SimpleDiffViewer myViewer;
    @NotNull
    protected final SimpleDiffChange myChange;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters;
    @NotNull
    protected final List<DiffGutterOperation> myOperations;

    public SimpleDiffChangeUi(@NotNull SimpleDiffViewer viewer, @NotNull SimpleDiffChange change) {
        if (viewer == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(0);
        }
        if (change == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(1);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<DiffGutterOperation>();
        this.myViewer = viewer;
        this.myChange = change;
    }

    public void installHighlighter(@Nullable SimpleDiffChange previousChange) {
        assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
        this.createHighlighter(Side.LEFT);
        this.createHighlighter(Side.RIGHT);
        List innerFragments = this.myChange.getFragment().getInnerFragments();
        for (DiffFragment fragment : ContainerUtil.notNullize((List)innerFragments)) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
        this.createNonSquashedChangesSeparator(previousChange, Side.LEFT);
        this.createNonSquashedChangesSeparator(previousChange, Side.RIGHT);
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    protected void doInstallActionHighlighters() {
        if (this.myChange.isSkipped()) {
            return;
        }
        this.myOperations.add(this.createAcceptOperation(Side.LEFT));
        this.myOperations.add(this.createAcceptOperation(Side.RIGHT));
    }

    @ApiStatus.Internal
    protected void createHighlighter(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(2);
        }
        EditorEx editor = this.myViewer.getEditor(side);
        TextDiffType type = this.myChange.getDiffType();
        int startLine = this.myChange.getStartLine(side);
        int endLine = this.myChange.getEndLine(side);
        boolean ignored = this.myChange.getFragment().getInnerFragments() != null;
        boolean alignedSides = this.myViewer.needAlignChanges();
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder((Editor)editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(this.myChange.isSkipped()).withExcludedInGutter(this.myChange.isExcluded()).withAlignedSides(alignedSides).done());
    }

    private void createInlineHighlighter(@NotNull DiffFragment innerFragment, @NotNull Side side) {
        if (innerFragment == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(3);
        }
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(4);
        }
        if (this.myChange.isSkipped()) {
            return;
        }
        int start = side.getStartOffset(innerFragment);
        int end = side.getEndOffset(innerFragment);
        TextDiffType type = DiffUtil.getDiffType(innerFragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myChange.getFragment());
        EditorEx editor = this.myViewer.getEditor(side);
        this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter((Editor)editor, start += startOffset, end += startOffset, type));
    }

    private void createNonSquashedChangesSeparator(@Nullable SimpleDiffChange previousChange, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(5);
        }
        if (previousChange == null) {
            return;
        }
        int startLine = this.myChange.getStartLine(side);
        int endLine = this.myChange.getEndLine(side);
        int prevStartLine = previousChange.getStartLine(side);
        int prevEndLine = previousChange.getEndLine(side);
        if (startLine == endLine) {
            return;
        }
        if (prevStartLine == prevEndLine) {
            return;
        }
        if (prevEndLine != startLine) {
            return;
        }
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker((Editor)this.myViewer.getEditor(side), startLine, TextDiffType.MODIFIED));
    }

    public void updateGutterActions(boolean force) {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public void invalidate() {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public boolean drawDivider(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
        if (handler == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(6);
        }
        int startLine1 = this.myChange.getStartLine(Side.LEFT);
        int endLine1 = this.myChange.getEndLine(Side.LEFT);
        int startLine2 = this.myChange.getStartLine(Side.RIGHT);
        int endLine2 = this.myChange.getEndLine(Side.RIGHT);
        TextDiffType type = this.myChange.getDiffType();
        if (this.myViewer.needAlignChanges()) {
            return handler.processAligned(startLine1, endLine1, startLine2, endLine2, type);
        }
        return handler.processExcludable(startLine1, endLine1, startLine2, endLine2, type, this.myChange.isExcluded(), this.myChange.isSkipped());
    }

    @NotNull
    protected DiffGutterOperation createOperation(@NotNull Side side, @NotNull DiffGutterOperation.ModifiersRendererBuilder builder) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(8);
        }
        int offset = side.getStartOffset((DiffFragment)this.myChange.getFragment());
        EditorEx editor = this.myViewer.getEditor(side);
        return new DiffGutterOperation.WithModifiers((Editor)editor, offset, this.myViewer.getModifierProvider(), builder);
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(9);
        }
        DiffGutterOperation diffGutterOperation = this.createOperation(side, (ctrlPressed, shiftPressed, altPressed) -> {
            boolean isAppendable;
            boolean isOtherEditable = this.myViewer.isEditable(side.other());
            boolean bl = isAppendable = this.myChange.getDiffType() == TextDiffType.MODIFIED;
            if (isOtherEditable) {
                if (ctrlPressed && isAppendable) {
                    return this.createAppendRenderer(side);
                }
                return this.createApplyRenderer(side);
            }
            return null;
        });
        if (diffGutterOperation == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(10);
        }
        return diffGutterOperation;
    }

    @NotNull
    @Nls
    static String getApplyActionText(@NotNull SimpleDiffViewer viewer, @NotNull Side sourceSide) {
        String customValue;
        if (viewer == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(11);
        }
        if (sourceSide == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(12);
        }
        if ((customValue = (String)DiffUtil.getUserData((UserDataHolder)viewer.getRequest(), (UserDataHolder)viewer.getContext(), (Key)sourceSide.select(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_ACTION_TEXT, DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_ACTION_TEXT))) != null) {
            String string = customValue;
            if (string == null) {
                SimpleDiffChangeUi.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (sourceSide == Side.LEFT && viewer.isDiffForLocalChanges()) {
            String string = DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]);
            if (string == null) {
                SimpleDiffChangeUi.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        if (string == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(15);
        }
        return string;
    }

    private GutterIconRenderer createApplyRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(16);
        }
        String text = SimpleDiffChangeUi.getApplyActionText(this.myViewer, side);
        Icon icon = DiffUtil.getArrowIcon(side);
        String actionId = (String)side.select((Object)"Diff.ApplyLeftSide", (Object)"Diff.ApplyRightSide");
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        String shortcutsText = StringUtil.nullize((String)KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
        String tooltipText = DiffUtil.createTooltipText(text, shortcutsText);
        return this.createIconRenderer(side, tooltipText, icon, () -> this.myViewer.replaceChange(this.myChange, side));
    }

    private GutterIconRenderer createAppendRenderer(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(17);
        }
        return this.createIconRenderer(side, DiffBundle.message((String)"action.presentation.diff.append.text", (Object[])new Object[0]), DiffUtil.getArrowDownIcon(side), () -> this.myViewer.appendChange(this.myChange, side));
    }

    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull @Nls String tooltipText, @NotNull Icon icon, final @NotNull Runnable perform) {
        if (sourceSide == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(18);
        }
        if (tooltipText == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(19);
        }
        if (icon == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(20);
        }
        if (perform == null) {
            SimpleDiffChangeUi.$$$reportNull$$$0(21);
        }
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (!SimpleDiffChangeUi.this.myChange.isValid()) {
                    return;
                }
                Project project = SimpleDiffChangeUi.this.myViewer.getProject();
                DocumentEx document = SimpleDiffChangeUi.this.myViewer.getEditor(sourceSide.other()).getDocument();
                DiffUtil.executeWriteCommand((Document)document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), perform);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerFragment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffChangeUi";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffChangeUi";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAcceptOperation";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInlineHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNonSquashedChangesSeparator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "drawDivider";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createOperation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAcceptOperation";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getApplyActionText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createApplyRenderer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAppendRenderer";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createIconRenderer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

