/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThreesideDiffChangeBase {
    @NotNull
    protected MergeConflictType myType;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters;
    @NotNull
    protected final List<RangeHighlighter> myInnerHighlighters;
    @NotNull
    protected final List<DiffGutterOperation> myOperations;

    public ThreesideDiffChangeBase(@NotNull MergeConflictType type) {
        if (type == null) {
            ThreesideDiffChangeBase.$$$reportNull$$$0(0);
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myInnerHighlighters = new ArrayList<RangeHighlighter>();
        this.myOperations = new ArrayList<DiffGutterOperation>();
        this.myType = type;
    }

    @RequiresEdt
    public void destroy() {
        ThreadingAssertions.assertEventDispatchThread();
        this.destroyHighlighters();
        this.destroyInnerHighlighters();
        this.destroyOperations();
    }

    @RequiresEdt
    protected void installHighlighters() {
        ThreadingAssertions.assertEventDispatchThread();
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    @RequiresEdt
    protected void installInnerHighlighters() {
        ThreadingAssertions.assertEventDispatchThread();
        assert (this.myInnerHighlighters.isEmpty());
        this.createInnerHighlighter(ThreeSide.BASE);
        if (this.isChange(Side.LEFT)) {
            this.createInnerHighlighter(ThreeSide.LEFT);
        }
        if (this.isChange(Side.RIGHT)) {
            this.createInnerHighlighter(ThreeSide.RIGHT);
        }
    }

    @RequiresEdt
    protected void destroyHighlighters() {
        ThreadingAssertions.assertEventDispatchThread();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    @RequiresEdt
    protected void destroyInnerHighlighters() {
        ThreadingAssertions.assertEventDispatchThread();
        for (RangeHighlighter highlighter : this.myInnerHighlighters) {
            highlighter.dispose();
        }
        this.myInnerHighlighters.clear();
    }

    @RequiresEdt
    protected void installOperations() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void destroyOperations() {
        ThreadingAssertions.assertEventDispatchThread();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public void updateGutterActions(boolean force) {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public abstract int getStartLine(@NotNull ThreeSide var1);

    public abstract int getEndLine(@NotNull ThreeSide var1);

    public abstract boolean isResolved(@NotNull ThreeSide var1);

    @NotNull
    protected abstract Editor getEditor(@NotNull ThreeSide var1);

    @Nullable
    protected abstract MergeInnerDifferences getInnerFragments();

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getDiffType(this.myType);
        if (textDiffType == null) {
            ThreesideDiffChangeBase.$$$reportNull$$$0(1);
        }
        return textDiffType;
    }

    @NotNull
    public MergeConflictType getConflictType() {
        MergeConflictType mergeConflictType = this.myType;
        if (mergeConflictType == null) {
            ThreesideDiffChangeBase.$$$reportNull$$$0(2);
        }
        return mergeConflictType;
    }

    public boolean isConflict() {
        return this.myType.getType() == MergeConflictType.Type.CONFLICT;
    }

    public boolean isChange(@NotNull Side side) {
        if (side == null) {
            ThreesideDiffChangeBase.$$$reportNull$$$0(3);
        }
        return this.myType.isChange(side);
    }

    public boolean isChange(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideDiffChangeBase.$$$reportNull$$$0(4);
        }
        return this.myType.isChange(side);
    }

    protected void createHighlighter(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideDiffChangeBase.$$$reportNull$$$0(5);
        }
        Editor editor = this.getEditor(side);
        TextDiffType type = this.getDiffType();
        int startLine = this.getStartLine(side);
        int endLine = this.getEndLine(side);
        boolean resolved = this.isResolved(side);
        boolean ignored = !resolved && this.getInnerFragments() != null;
        boolean shouldHideWithoutLineNumbers = side == ThreeSide.BASE && !this.isChange(Side.LEFT) && this.isChange(Side.RIGHT);
        this.myHighlighters.addAll(new DiffDrawUtil.LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withHideWithoutLineNumbers(shouldHideWithoutLineNumbers).withHideStripeMarkers(side == ThreeSide.BASE).done());
    }

    protected void createInnerHighlighter(@NotNull ThreeSide side) {
        if (side == null) {
            ThreesideDiffChangeBase.$$$reportNull$$$0(6);
        }
        if (this.isResolved(side)) {
            return;
        }
        MergeInnerDifferences innerFragments = this.getInnerFragments();
        if (innerFragments == null) {
            return;
        }
        List<TextRange> ranges = innerFragments.get(side);
        if (ranges == null) {
            return;
        }
        Editor editor = this.getEditor(side);
        int start = DiffUtil.getLinesRange(editor.getDocument(), this.getStartLine(side), this.getEndLine(side)).getStartOffset();
        for (TextRange fragment : ranges) {
            int innerStart = start + fragment.getStartOffset();
            int innerEnd = start + fragment.getEndOffset();
            this.myInnerHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, innerStart, innerEnd, this.getDiffType()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/ThreesideDiffChangeBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/ThreesideDiffChangeBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInnerHighlighter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

