/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffPanelBase
extends JPanel
implements UiCompatibleDataProvider {
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final DiffContext myContext;
    @NotNull
    private final List<JComponent> myPersistentNotifications;
    @NotNull
    private final List<JComponent> myNotifications;
    @NotNull
    protected final JPanel myContentPanel;
    @NotNull
    protected final Wrapper myNotificationsPanel;
    @NotNull
    private final Wrapper myNorthPanel;
    @NotNull
    private final Wrapper mySouthPanel;
    @NotNull
    protected final CardLayout myCardLayout;
    @NotNull
    protected String myCurrentCard;

    public DiffPanelBase(@Nullable Project project, @NotNull DiffContext context) {
        if (context == null) {
            DiffPanelBase.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myPersistentNotifications = new ArrayList<JComponent>();
        this.myNotifications = new ArrayList<JComponent>();
        this.myProject = project;
        this.myContext = context;
        this.myCardLayout = new CardLayout();
        this.myContentPanel = new JPanel(this.myCardLayout);
        this.myNotificationsPanel = new Wrapper();
        this.myNorthPanel = new Wrapper();
        this.mySouthPanel = new Wrapper();
        this.add((Component)this.myContentPanel, "Center");
        this.add((Component)this.myNorthPanel, "North");
        this.add((Component)this.mySouthPanel, "South");
    }

    public void setTopPanel(@Nullable JComponent component2) {
        this.myNorthPanel.setContent(component2);
    }

    public void setBottomPanel(@Nullable JComponent component2) {
        this.mySouthPanel.setContent(component2);
    }

    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            DiffPanelBase.$$$reportNull$$$0(1);
        }
        this.setCurrentCard(card, true);
    }

    protected void setCurrentCard(@NotNull String card, boolean keepFocus) {
        if (card == null) {
            DiffPanelBase.$$$reportNull$$$0(2);
        }
        if (Objects.equals(this.myCurrentCard, card)) {
            return;
        }
        Runnable task = () -> {
            this.myCardLayout.show(this.myContentPanel, card);
            this.myCurrentCard = card;
            UIUtil.layoutRecursively((Component)this.myContentPanel);
            this.myContentPanel.repaint();
        };
        if (keepFocus) {
            DiffUtil.runPreservingFocus((FocusableContext)this.myContext, task);
        } else {
            task.run();
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            DiffPanelBase.$$$reportNull$$$0(3);
        }
    }

    public void setPersistentNotifications(@NotNull List<? extends JComponent> components) {
        if (components == null) {
            DiffPanelBase.$$$reportNull$$$0(4);
        }
        this.myPersistentNotifications.clear();
        this.myPersistentNotifications.addAll(components);
        this.updateNotifications();
    }

    public void resetNotifications() {
        this.myNotifications.clear();
        this.updateNotifications();
    }

    public void addNotification(@Nullable JComponent notification) {
        if (notification == null) {
            return;
        }
        this.myNotifications.add(notification);
        this.updateNotifications();
    }

    private void updateNotifications() {
        List<Object> notifications = new ArrayList(ContainerUtil.concat(this.myPersistentNotifications, this.myNotifications));
        notifications = DiffUtil.wrapEditorNotificationBorders(notifications);
        this.myNotificationsPanel.setContent(DiffUtil.createStackedComponents(notifications, DiffUtil.TITLE_GAP));
        this.validate();
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "card";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/base/DiffPanelBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentCard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setPersistentNotifications";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

