/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.SyntheticPsiFileSupport;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.merge.ConflictType;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.SmartTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffEditorHighlighterUpdater;
import com.intellij.diff.util.DiffLineNumberConverter;
import com.intellij.diff.util.DiffNotificationProvider;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.InvisibleWrapper;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.LinesRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.SyncHeightComponent;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import icons.PlatformDiffImplIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    public static final Key<Boolean> TEMP_FILE_KEY = Key.create((String)"Diff.TempFile");
    @NotNull
    @NonNls
    public static final String DIFF_CONFIG = "diff.xml";
    public static final JBValue TITLE_GAP = new JBValue.Float(2.0f);
    public static final NotNullLazyValue<@Unmodifiable List<Image>> DIFF_FRAME_ICONS = NotNullLazyValue.createValue(() -> ContainerUtil.skipNulls(Arrays.asList(DiffUtil.iconToImage(PlatformDiffImplIcons.Diff_frame32), DiffUtil.iconToImage(PlatformDiffImplIcons.Diff_frame64), DiffUtil.iconToImage(PlatformDiffImplIcons.Diff_frame128))));

    @Nullable
    private static Image iconToImage(@NotNull Icon icon) {
        if (icon == null) {
            DiffUtil.$$$reportNull$$$0(0);
        }
        return IconLoader.toImage((Icon)icon, null);
    }

    private static CharSequence getDocumentCharSequence(DocumentContent documentContent) {
        return (CharSequence)ReadAction.compute(() -> documentContent.getDocument().getImmutableCharSequence());
    }

    public static boolean isDiffEditor(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(1);
        }
        return editor.getEditorKind() == EditorKind.DIFF;
    }

    public static boolean isFileWithoutContent(@NotNull VirtualFile file) {
        if (file == null) {
            DiffUtil.$$$reportNull$$$0(2);
        }
        return file instanceof VirtualFileWithoutContent;
    }

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content, @NotNull CharSequence text) {
        EditorHighlighter highlighter;
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(3);
        }
        if (text == null) {
            DiffUtil.$$$reportNull$$$0(4);
        }
        if ((highlighter = DiffUtil.createEditorHighlighter(project, content)) == null) {
            return null;
        }
        highlighter.setText(text);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text) {
        if (text == null) {
            DiffUtil.$$$reportNull$$$0(5);
        }
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text);
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            DiffUtil.$$$reportNull$$$0(6);
        }
        return editorHighlighter;
    }

    @Nullable
    public static EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content) {
        boolean hasContentType;
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(7);
        }
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        VirtualFile file = FileDocumentManager.getInstance().getFile(content.getDocument());
        FileType contentType = content.getContentType();
        VirtualFile highlightFile = content.getHighlightFile();
        Language language = (Language)content.getUserData(DiffUserDataKeys.LANGUAGE);
        boolean bl = hasContentType = contentType != null && contentType != PlainTextFileType.INSTANCE && contentType != UnknownFileType.INSTANCE;
        if (language != null) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)highlightFile);
            return highlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        }
        if (highlightFile != null && highlightFile.isValid() && (!hasContentType || FileTypeRegistry.getInstance().isFileOfType(highlightFile, contentType) || highlightFile instanceof LightVirtualFile)) {
            return highlighterFactory.createEditorHighlighter(project, highlightFile);
        }
        if (file != null && file.isValid()) {
            boolean hasFileType;
            FileType type = file.getFileType();
            boolean bl2 = hasFileType = !type.isBinary() && type != PlainTextFileType.INSTANCE;
            if (!hasContentType || hasFileType) {
                return highlighterFactory.createEditorHighlighter(project, file);
            }
        }
        if (contentType != null) {
            return highlighterFactory.createEditorHighlighter(project, contentType);
        }
        return null;
    }

    @NotNull
    public static EditorHighlighter createEmptyEditorHighlighter() {
        return new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
    }

    public static void setEditorHighlighter(@Nullable Project project, @NotNull EditorEx editor, @NotNull DocumentContent content) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(8);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(9);
        }
        Disposable disposable = ((EditorImpl)editor).getDisposable();
        if (project != null) {
            DiffEditorHighlighterUpdater updater = new DiffEditorHighlighterUpdater(project, disposable, editor, content);
            updater.updateHighlighters();
        } else {
            ReadAction.nonBlocking(() -> {
                CharSequence text = editor.getDocument().getImmutableCharSequence();
                return DiffUtil.initEditorHighlighter(null, content, text);
            }).finishOnUiThread(ModalityState.any(), result -> {
                if (result != null) {
                    editor.setHighlighter(result);
                }
            }).expireWith(disposable).submit((Executor)NonUrgentExecutor.getInstance());
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project, @NotNull EditorEx editor, @Nullable DocumentContent content) {
        Language language;
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(10);
        }
        if (project != null && content != null && editor.getVirtualFile() == null) {
            PsiFile psiFile;
            try (AccessToken ignore = SlowOperations.knownIssue((String)"IJPL-162978");){
                psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(content.getDocument());
            }
            CommonCodeStyleSettings.IndentOptions indentOptions = psiFile != null ? CodeStyle.getSettings((PsiFile)psiFile).getIndentOptionsByFile(psiFile) : CodeStyle.getSettings((Project)project).getIndentOptions(content.getContentType());
            editor.getSettings().setTabSize(indentOptions.TAB_SIZE);
            editor.getSettings().setUseTabCharacter(indentOptions.USE_TAB_CHARACTER);
        }
        Language language2 = language = content != null ? (Language)content.getUserData(DiffUserDataKeys.LANGUAGE) : null;
        if (language != null) {
            editor.getSettings().setLanguageSupplier(() -> language);
        } else if (editor.getProject() != null) {
            editor.getSettings().setLanguageSupplier(() -> TextEditorImpl.Companion.getDocumentLanguage((Editor)editor));
        }
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(11);
        }
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setAutoCodeFoldingEnabled(false);
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(12);
        }
        return DiffUtil.createEditor(document, project, isViewer, false);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer, boolean enableFolding) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(13);
        }
        EditorFactory factory = EditorFactory.getInstance();
        EditorKind kind = EditorKind.DIFF;
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document, project, kind) : factory.createEditor(document, project, kind));
        editor.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)editor.getMarkupModel()).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            DiffUtil.$$$reportNull$$$0(14);
        }
        return editorEx;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content, @Nullable Project project) {
        VirtualFile virtualFile;
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(15);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(16);
        }
        if ((virtualFile = FileDocumentManager.getInstance().getFile(content.getDocument())) != null) {
            editor.setFile(virtualFile);
        }
        DiffUtil.setEditorHighlighter(project, editor, content);
        DiffUtil.setEditorCodeStyle(project, editor, content);
    }

    public static boolean isMirrored(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(17);
        }
        if (editor instanceof EditorEx) {
            return ((EditorEx)editor).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean canNavigateToFile(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || project.isDefault()) {
            return false;
        }
        if (file == null || !file.isValid()) {
            return false;
        }
        if (SyntheticPsiFileSupport.isOutsiderFile((VirtualFile)file)) {
            return false;
        }
        return file.getUserData(TEMP_FILE_KEY) != Boolean.TRUE;
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull FoldingModelSupport foldingSupport) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(18);
        }
        if (foldingSupport == null) {
            DiffUtil.$$$reportNull$$$0(19);
        }
        assert (foldingSupport.getCount() == 1);
        IntPredicate foldingLinePredicate = foldingSupport.hideLineNumberPredicate(0);
        editor.getGutter().setLineNumberConverter((LineNumberConverter)new DiffLineNumberConverter(foldingLinePredicate, null));
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @NotNull DocumentContent content) {
        IntUnaryOperator contentLineConvertor;
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(20);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(21);
        }
        if ((contentLineConvertor = DiffUtil.getContentLineConvertor(content)) == null) {
            editor.getGutter().setLineNumberConverter(null);
        } else {
            editor.getGutter().setLineNumberConverter((LineNumberConverter)new DiffLineNumberConverter(null, contentLineConvertor));
        }
    }

    public static void installLineConvertor(@NotNull EditorEx editor, @Nullable DocumentContent content, @NotNull FoldingModelSupport foldingSupport, int editorIndex) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(22);
        }
        if (foldingSupport == null) {
            DiffUtil.$$$reportNull$$$0(23);
        }
        IntUnaryOperator contentLineConvertor = content != null ? DiffUtil.getContentLineConvertor(content) : null;
        IntPredicate foldingLinePredicate = foldingSupport.hideLineNumberPredicate(editorIndex);
        editor.getGutter().setLineNumberConverter((LineNumberConverter)new DiffLineNumberConverter(foldingLinePredicate, contentLineConvertor));
    }

    @Nullable
    public static IntUnaryOperator getContentLineConvertor(@NotNull DocumentContent content) {
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(24);
        }
        return (IntUnaryOperator)content.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
    }

    @Nullable
    public static IntUnaryOperator mergeLineConverters(@Nullable IntUnaryOperator convertor1, @Nullable IntUnaryOperator convertor2) {
        if (convertor1 == null && convertor2 == null) {
            return null;
        }
        if (convertor1 == null) {
            return convertor2;
        }
        if (convertor2 == null) {
            return convertor1;
        }
        return value -> {
            int value2 = convertor2.applyAsInt(value);
            return value2 >= 0 ? convertor1.applyAsInt(value2) : value2;
        };
    }

    public static void disableBlitting(@NotNull EditorEx editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(25);
        }
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            editor.getScrollPane().getViewport().setScrollMode(0);
        }
    }

    public static void moveCaret(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor, int line, boolean animated) {
        DiffUtil.scrollEditor(editor, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column, boolean animated) {
        if (editor == null) {
            return;
        }
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
        DiffUtil.scrollToCaret(editor, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point, boolean animated) {
        if (point == null) {
            DiffUtil.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            return new Point(0, 0);
        }
        ScrollingModel model = editor.getScrollingModel();
        return new Point(model.getHorizontalScrollOffset(), model.getVerticalScrollOffset());
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        return editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
    }

    public static void moveCaretToLineRangeIfNeeded(@NotNull Editor editor, int startLine, int endLine) {
        int caretLine;
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(27);
        }
        if (!DiffUtil.isSelectedByLine(caretLine = editor.getCaretModel().getLogicalPosition().line, startLine, endLine)) {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(startLine, 0));
        }
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            DiffUtil.$$$reportNull$$$0(28);
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
        if (icon == null) {
            DiffUtil.$$$reportNull$$$0(29);
        }
        return icon;
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            DiffUtil.$$$reportNull$$$0(30);
        }
        Icon icon = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
        if (icon == null) {
            DiffUtil.$$$reportNull$$$0(31);
        }
        return icon;
    }

    public static boolean isFromShortcut(@NotNull AnActionEvent e) {
        String place;
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(32);
        }
        return "keyboard shortcut".equals(place = e.getPlace()) || "mouse shortcut".equals(place);
    }

    public static void registerAction(@NotNull AnAction action2, @NotNull JComponent component2) {
        if (action2 == null) {
            DiffUtil.$$$reportNull$$$0(33);
        }
        if (component2 == null) {
            DiffUtil.$$$reportNull$$$0(34);
        }
        action2.registerCustomShortcutSet(action2.getShortcutSet(), component2);
    }

    @Deprecated(forRemoval=true)
    public static void recursiveRegisterShortcutSet(@NotNull ActionGroup group, @NotNull JComponent component2, @Nullable Disposable parentDisposable) {
        AnAction[] actions;
        CustomisedActionGroup o;
        ActionGroup actionGroup;
        AnAction[] anActionArray;
        if (group == null) {
            DiffUtil.$$$reportNull$$$0(35);
        }
        if (component2 == null) {
            DiffUtil.$$$reportNull$$$0(36);
        }
        if (group instanceof DefaultActionGroup) {
            DefaultActionGroup o2 = (DefaultActionGroup)group;
            anActionArray = o2.getChildren(ActionManager.getInstance());
        } else if (group instanceof CustomisedActionGroup && (actionGroup = (o = (CustomisedActionGroup)group).getDelegate()) instanceof DefaultActionGroup) {
            DefaultActionGroup oo = (DefaultActionGroup)actionGroup;
            anActionArray = oo.getChildren(ActionManager.getInstance());
        } else {
            anActionArray = group.getChildren(null);
        }
        for (AnAction action2 : actions = anActionArray) {
            if (action2 instanceof ActionGroup) {
                DiffUtil.recursiveRegisterShortcutSet((ActionGroup)action2, component2, parentDisposable);
            }
            action2.registerCustomShortcutSet(component2, parentDisposable);
        }
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull @Nls String message) {
        if (message == null) {
            DiffUtil.$$$reportNull$$$0(37);
        }
        String text = StringUtil.replace((String)message, (String)"\n", (String)"<br/>");
        JBLabel label = new JBLabel(text){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = Math.min(size.width, 200);
                size.height = Math.min(size.height, 100);
                return size;
            }
        }.setCopyable(true);
        return DiffUtil.createMessagePanel((JComponent)label);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull JComponent label) {
        if (label == null) {
            DiffUtil.$$$reportNull$$$0(38);
        }
        JBColor commentFg = JBColor.lazy(() -> {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes commentAttributes = scheme.getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT);
            Color commentAttributesForegroundColor = commentAttributes.getForegroundColor();
            if (commentAttributesForegroundColor != null && commentAttributes.getBackgroundColor() == null) {
                return commentAttributesForegroundColor;
            }
            return scheme.getDefaultForeground();
        });
        label.setForeground((Color)commentFg);
        JPanel panel = new JPanel((LayoutManager)new SingleComponentCenteringLayout());
        panel.setBorder(JBUI.Borders.empty((int)5));
        panel.setBackground((Color)JBColor.lazy(() -> EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()));
        panel.add(label);
        JPanel jPanel = panel;
        if (jPanel == null) {
            DiffUtil.$$$reportNull$$$0(39);
        }
        return jPanel;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions) {
        if (group == null) {
            DiffUtil.$$$reportNull$$$0(40);
        }
        DiffUtil.addActionBlock(group, Arrays.asList(actions));
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions) {
        if (group == null) {
            DiffUtil.$$$reportNull$$$0(41);
        }
        DiffUtil.addActionBlock(group, actions, true);
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions, boolean prependSeparator) {
        if (group == null) {
            DiffUtil.$$$reportNull$$$0(42);
        }
        if (actions == null || actions.isEmpty()) {
            return;
        }
        if (prependSeparator) {
            group.addSeparator();
        }
        ActionManager actionManager = ActionManager.getInstance();
        Object[] children = group.getChildren(actionManager);
        for (AnAction anAction : actions) {
            if (!(anAction instanceof Separator) && ArrayUtil.contains((Object)anAction, (Object[])children)) continue;
            group.add(anAction);
        }
    }

    @Nls
    @NotNull
    public static String getSettingsConfigurablePath() {
        String string = SystemInfo.isMac ? DiffBundle.message((String)"label.diff.settings.path.macos", (Object[])new Object[0]) : DiffBundle.message((String)"label.diff.settings.path", (Object[])new Object[0]);
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NlsContexts.Tooltip
    @NotNull
    public static String createTooltipText(@NlsContexts.Tooltip @NotNull String text, @Nullable @Nls String appendix) {
        if (text == null) {
            DiffUtil.$$$reportNull$$$0(44);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(text);
        if (appendix != null) {
            result.br();
            result.append((HtmlChunk)HtmlChunk.div((String)"margin-top:5px; font-size:small").addText(appendix));
        }
        String string = result.wrapWithHtmlBody().toString();
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String createNotificationText(@NotNull @Nls String text, @Nullable @Nls String appendix) {
        if (text == null) {
            DiffUtil.$$$reportNull$$$0(46);
        }
        HtmlBuilder result = new HtmlBuilder();
        result.append(text);
        if (appendix != null) {
            result.br();
            result.append((HtmlChunk)HtmlChunk.span((String)("color:#" + ColorUtil.toHex((Color)JBColor.gray) + "; font-size:small")).addText(appendix));
        }
        String string = result.wrapWithHtmlBody().toString();
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    public static void runWhenFirstShown(@NotNull JComponent component2, @NotNull Runnable runnable) {
        if (component2 == null) {
            DiffUtil.$$$reportNull$$$0(48);
        }
        if (runnable == null) {
            DiffUtil.$$$reportNull$$$0(49);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            runnable.run();
        } else {
            UiNotifyConnector.doWhenFirstShown((JComponent)component2, (Runnable)runnable);
        }
    }

    public static void installShowNotifyListener(@NotNull JComponent component2, final @NotNull Runnable runnable) {
        if (component2 == null) {
            DiffUtil.$$$reportNull$$$0(50);
        }
        if (runnable == null) {
            DiffUtil.$$$reportNull$$$0(51);
        }
        DiffUtil.installShowNotifyListener(component2, new Activatable(){

            public void showNotify() {
                runnable.run();
            }
        });
    }

    public static void installShowNotifyListener(@NotNull JComponent component2, @NotNull Activatable activatable) {
        if (component2 == null) {
            DiffUtil.$$$reportNull$$$0(52);
        }
        if (activatable == null) {
            DiffUtil.$$$reportNull$$$0(53);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            activatable.showNotify();
        } else {
            UiNotifyConnector.installOn((Component)component2, (Activatable)activatable, (boolean)false);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull ContentDiffRequest request) {
        if (viewer == null) {
            DiffUtil.$$$reportNull$$$0(54);
        }
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(55);
        }
        List contents = request.getContents();
        @Nls List titles = request.getContentTitles();
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        List diffTitleCustomizers = (List)request.getUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER);
        boolean needCreateTitle = !DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.EDITORS_HIDE_TITLE, new UserDataHolder[]{request});
        for (int i = 0; i < contents.size(); ++i) {
            DiffEditorTitleCustomizer customizer = diffTitleCustomizers != null ? (DiffEditorTitleCustomizer)diffTitleCustomizers.get(i) : null;
            JComponent title = needCreateTitle ? DiffUtil.createTitle(viewer, (String)titles.get(i), false, customizer) : null;
            title = DiffUtil.createTitleWithNotifications(viewer, title, (DiffContent)contents.get(i));
            components.add(title);
        }
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static List<JComponent> createTextTitles(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull ContentDiffRequest request, @NotNull List<? extends Editor> editors) {
        if (viewer == null) {
            DiffUtil.$$$reportNull$$$0(57);
        }
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(58);
        }
        if (editors == null) {
            DiffUtil.$$$reportNull$$$0(59);
        }
        List contents = request.getContents();
        @Nls List titles = request.getContentTitles();
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        ArrayList<JComponent> result = new ArrayList<JComponent>(contents.size());
        List diffTitleCustomizers = (List)request.getUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER);
        boolean needCreateTitle = !DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.EDITORS_HIDE_TITLE, new UserDataHolder[]{request});
        for (int i = 0; i < contents.size(); ++i) {
            JComponent title = needCreateTitle ? DiffUtil.createTitle(viewer, (String)titles.get(i), (DiffContent)contents.get(i), equalCharsets, equalSeparators, editors.get(i), diffTitleCustomizers != null ? (DiffEditorTitleCustomizer)diffTitleCustomizers.get(i) : null) : null;
            title = DiffUtil.createTitleWithNotifications(viewer, title, (DiffContent)contents.get(i));
            result.add(title);
        }
        ArrayList<JComponent> arrayList = result;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    @NotNull
    public static List<JComponent> createPatchTextTitles(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull DiffRequest request, @NotNull List<@Nls @Nullable String> titles) {
        if (viewer == null) {
            DiffUtil.$$$reportNull$$$0(61);
        }
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(62);
        }
        if (titles == null) {
            DiffUtil.$$$reportNull$$$0(63);
        }
        ArrayList<JComponent> result = new ArrayList<JComponent>(titles.size());
        List diffTitleCustomizers = (List)request.getUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER);
        boolean needCreateTitle = !DiffUtil.isUserDataFlagSet(DiffUserDataKeysEx.EDITORS_HIDE_TITLE, new UserDataHolder[]{request});
        for (int i = 0; i < titles.size(); ++i) {
            JComponent title = null;
            if (needCreateTitle) {
                String titleText = titles.get(i);
                DiffEditorTitleCustomizer customizer = diffTitleCustomizers != null ? (DiffEditorTitleCustomizer)diffTitleCustomizers.get(i) : null;
                title = DiffUtil.createTitle(viewer, titleText, true, customizer);
            }
            title = DiffUtil.createTitleWithNotifications(viewer, title, null);
            result.add(title);
        }
        ArrayList<JComponent> arrayList = result;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    @Nullable
    private static JComponent createTitleWithNotifications(@NotNull FrameDiffTool.DiffViewer viewer, @Nullable JComponent title, @Nullable DiffContent content) {
        FileContent fileContent;
        VirtualFile file;
        if (viewer == null) {
            DiffUtil.$$$reportNull$$$0(65);
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        if (title != null) {
            components.add(title);
        }
        if (content != null) {
            components.addAll(DiffUtil.createCustomNotifications(viewer, content));
        }
        if (content instanceof DocumentContent) {
            DocumentContent documentContent = (DocumentContent)content;
            Document document = documentContent.getDocument();
            if (FileDocumentManager.getInstance().isPartialPreviewOfALargeFile(document)) {
                components.add(DiffUtil.wrapEditorNotificationComponent(DiffNotifications.createNotification(DiffBundle.message((String)"error.file.is.too.large.only.preview.is.loaded", (Object[])new Object[0]))));
            }
        }
        if (content instanceof FileContent && (file = (fileContent = (FileContent)content).getFile()).isInLocalFileSystem() && !file.isValid()) {
            components.add(DiffUtil.wrapEditorNotificationComponent(DiffNotifications.createNotification(DiffBundle.message((String)"error.file.is.not.valid", (Object[])new Object[0]))));
        }
        if (components.isEmpty()) {
            return null;
        }
        return DiffUtil.createStackedComponents(components, TITLE_GAP);
    }

    @Nullable
    private static JComponent createTitle(@NotNull FrameDiffTool.DiffViewer viewer, @NlsContexts.Label @Nullable String title, @NotNull DiffContent content, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor, @Nullable DiffEditorTitleCustomizer titleCustomizer) {
        if (viewer == null) {
            DiffUtil.$$$reportNull$$$0(66);
        }
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(67);
        }
        if (content instanceof EmptyContent) {
            return null;
        }
        DocumentContent documentContent = (DocumentContent)content;
        Charset charset = equalCharsets ? null : documentContent.getCharset();
        Boolean bom = equalCharsets ? null : documentContent.hasBom();
        LineSeparator separator = equalSeparators ? null : documentContent.getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(viewer, title, separator, charset, bom, isReadOnly, titleCustomizer);
    }

    @NotNull
    public static JComponent createTitle(@NlsContexts.Label @Nullable String title) {
        return DiffUtil.createTitle(null, title, null, null, null, false, null);
    }

    @NotNull
    public static JComponent createTitle(@NlsContexts.Label @Nullable String title, @Nullable DiffEditorTitleCustomizer titleCustomizer) {
        return DiffUtil.createTitle(null, title, null, null, null, false, titleCustomizer);
    }

    @NotNull
    private static JComponent createTitle(@NotNull FrameDiffTool.DiffViewer viewer, @NlsContexts.Label @Nullable String title, boolean readOnly, @Nullable DiffEditorTitleCustomizer titleCustomizer) {
        if (viewer == null) {
            DiffUtil.$$$reportNull$$$0(68);
        }
        return DiffUtil.createTitle(viewer, title, null, null, null, readOnly, titleCustomizer);
    }

    @NotNull
    private static JComponent createTitle(@Nullable FrameDiffTool.DiffViewer viewer, @NlsContexts.Label @Nullable String title, @Nullable LineSeparator separator, @Nullable Charset charset, @Nullable Boolean bom, boolean readOnly, @Nullable DiffEditorTitleCustomizer titleCustomizer) {
        JComponent titleLabel;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        BorderLayoutPanel labelWithIcon = new BorderLayoutPanel();
        JComponent jComponent = titleLabel = titleCustomizer != null ? titleCustomizer.getLabel() : new JBLabel(StringUtil.notNullize((String)title)).setCopyable(true);
        if (titleCustomizer != null && titleLabel instanceof Disposable) {
            Disposable disposableTitleLabel = (Disposable)titleLabel;
            if (viewer != null) {
                Disposer.register((Disposable)viewer, (Disposable)disposableTitleLabel);
            } else {
                LOG.error("Viewer is not provided while the title label is disposable", new Throwable());
            }
        }
        if (titleLabel != null) {
            labelWithIcon.addToCenter((Component)titleLabel);
        }
        if (readOnly) {
            labelWithIcon.addToLeft((Component)new JBLabel(AllIcons.Ide.Readonly));
        }
        panel.add((Component)labelWithIcon, "Center");
        if (charset != null || separator != null) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 0));
            if (charset != null) {
                panel2.add(Box.createRigidArea((Dimension)JBUI.size((int)4, (int)0)));
                panel2.add(DiffUtil.createCharsetPanel(charset, bom));
            }
            if (separator != null) {
                panel2.add(Box.createRigidArea((Dimension)JBUI.size((int)4, (int)0)));
                panel2.add(DiffUtil.createSeparatorPanel(separator));
            }
            panel.add((Component)panel2, "East");
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            DiffUtil.$$$reportNull$$$0(69);
        }
        return jPanel;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset, @Nullable Boolean bom) {
        if (charset == null) {
            DiffUtil.$$$reportNull$$$0(70);
        }
        String text = charset.displayName();
        if (bom != null && bom.booleanValue()) {
            text = DiffBundle.message((String)"diff.utf.charset.name.bom.suffix", (Object[])new Object[]{text});
        }
        JLabel label = new JLabel(text);
        if (charset.equals(StandardCharsets.UTF_8)) {
            label.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(StandardCharsets.ISO_8859_1)) {
            label.setForeground((Color)JBColor.RED);
        } else {
            label.setForeground((Color)JBColor.BLACK);
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            DiffUtil.$$$reportNull$$$0(71);
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        if (separator == null) {
            DiffUtil.$$$reportNull$$$0(72);
        }
        JLabel label = new JLabel(separator.toString());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label.setForeground((Color)color);
        JLabel jLabel = label;
        if (jLabel == null) {
            DiffUtil.$$$reportNull$$$0(73);
        }
        return jLabel;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (components == null) {
            DiffUtil.$$$reportNull$$$0(74);
        }
        List<JComponent> list = SyncHeightComponent.createSyncHeightComponents(components);
        if (list == null) {
            DiffUtil.$$$reportNull$$$0(75);
        }
        return list;
    }

    @NotNull
    public static JComponent createStackedComponents(@NotNull List<? extends JComponent> components, @NotNull JBValue vGap) {
        if (components == null) {
            DiffUtil.$$$reportNull$$$0(76);
        }
        if (vGap == null) {
            DiffUtil.$$$reportNull$$$0(77);
        }
        JBPanel panel = new JBPanel((LayoutManager)new VerticalLayout(vGap, -1));
        for (JComponent jComponent : components) {
            panel.add(jComponent);
        }
        JBPanel jBPanel = panel;
        if (jBPanel == null) {
            DiffUtil.$$$reportNull$$$0(78);
        }
        return jBPanel;
    }

    @Nls
    @NotNull
    public static String getStatusText(int totalCount, int excludedCount, @NotNull ThreeState isContentsEqual) {
        if (isContentsEqual == null) {
            DiffUtil.$$$reportNull$$$0(79);
        }
        if (totalCount == 0 && isContentsEqual == ThreeState.NO) {
            String string = DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            if (string == null) {
                DiffUtil.$$$reportNull$$$0(80);
            }
            return string;
        }
        Object message = DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{totalCount - excludedCount});
        if (excludedCount > 0) {
            message = (String)message + " " + DiffBundle.message((String)"diff.inactive.count.differences.status.text", (Object[])new Object[]{excludedCount});
        }
        String string = message;
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    public static boolean isFocusedComponent(@Nullable Component component2) {
        return DiffUtil.isFocusedComponent(null, component2);
    }

    public static boolean isFocusedComponent(@Nullable Project project, @Nullable Component component2) {
        if (component2 == null) {
            return false;
        }
        Component ideFocusOwner = IdeFocusManager.getInstance((Project)project).getFocusOwner();
        if (ideFocusOwner != null && SwingUtilities.isDescendingFrom(ideFocusOwner, component2)) {
            return true;
        }
        Component jdkFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return jdkFocusOwner != null && SwingUtilities.isDescendingFrom(jdkFocusOwner, component2);
    }

    public static void requestFocus(@Nullable Project project, @Nullable Component component2) {
        if (component2 == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project).requestFocus(component2, true);
    }

    public static boolean isFocusedComponentInWindow(@Nullable Component component2) {
        if (component2 == null) {
            return false;
        }
        Window window = ComponentUtil.getWindow((Component)component2);
        if (window == null) {
            return false;
        }
        Component windowFocusOwner = window.getMostRecentFocusOwner();
        return windowFocusOwner != null && SwingUtilities.isDescendingFrom(windowFocusOwner, component2);
    }

    public static void requestFocusInWindow(@Nullable Component component2) {
        if (component2 != null) {
            component2.requestFocusInWindow();
        }
    }

    public static void runPreservingFocus(@NotNull FocusableContext context, @NotNull Runnable task) {
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(82);
        }
        if (task == null) {
            DiffUtil.$$$reportNull$$$0(83);
        }
        boolean hadFocus = context.isFocusedInWindow();
        task.run();
        if (hadFocus) {
            context.requestFocusInWindow();
        }
    }

    @NotNull
    public static TwosideTextDiffProvider createTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffUserDataKeysEx.DiffComputer diffComputer;
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(84);
        }
        if (settings == null) {
            DiffUtil.$$$reportNull$$$0(85);
        }
        if (rediff == null) {
            DiffUtil.$$$reportNull$$$0(86);
        }
        if (disposable == null) {
            DiffUtil.$$$reportNull$$$0(87);
        }
        if ((diffComputer = (DiffUserDataKeysEx.DiffComputer)request.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER)) != null) {
            return new SimpleTextDiffProvider(settings, rediff, disposable, diffComputer);
        }
        TwosideTextDiffProvider twosideTextDiffProvider = SmartTextDiffProvider.create(project, request, settings, rediff, disposable);
        if (twosideTextDiffProvider == null) {
            DiffUtil.$$$reportNull$$$0(88);
        }
        return twosideTextDiffProvider;
    }

    @NotNull
    public static TwosideTextDiffProvider.NoIgnore createNoIgnoreTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffUserDataKeysEx.DiffComputer diffComputer;
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(89);
        }
        if (settings == null) {
            DiffUtil.$$$reportNull$$$0(90);
        }
        if (rediff == null) {
            DiffUtil.$$$reportNull$$$0(91);
        }
        if (disposable == null) {
            DiffUtil.$$$reportNull$$$0(92);
        }
        if ((diffComputer = (DiffUserDataKeysEx.DiffComputer)request.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER)) != null) {
            return new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable, diffComputer);
        }
        TwosideTextDiffProvider.NoIgnore noIgnore = SmartTextDiffProvider.createNoIgnore(project, request, settings, rediff, disposable);
        if (noIgnore == null) {
            DiffUtil.$$$reportNull$$$0(93);
        }
        return noIgnore;
    }

    public static List<DocumentContent> getDocumentContentsForViewer(@Nullable Project project, @NotNull List<byte[]> byteContents, final @NotNull FilePath filePath, @Nullable ConflictType conflictType) {
        if (byteContents == null) {
            DiffUtil.$$$reportNull$$$0(94);
        }
        if (filePath == null) {
            DiffUtil.$$$reportNull$$$0(95);
        }
        return DiffUtil.getDocumentContentsForViewer(project, byteContents, conflictType, new DiffContentFactoryEx.ContextProvider(){

            @Override
            public void passContext(@NotNull DiffContentFactoryEx.DocumentContentBuilder builder) {
                if (builder == null) {
                    3.$$$reportNull$$$0(0);
                }
                builder.contextByFilePath(filePath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diff/util/DiffUtil$3", "passContext"));
            }
        });
    }

    public static List<DocumentContent> getDocumentContentsForViewer(@Nullable Project project, @NotNull List<byte[]> byteContents, final @NotNull VirtualFile file, @Nullable ConflictType conflictType) {
        if (byteContents == null) {
            DiffUtil.$$$reportNull$$$0(96);
        }
        if (file == null) {
            DiffUtil.$$$reportNull$$$0(97);
        }
        return DiffUtil.getDocumentContentsForViewer(project, byteContents, conflictType, new DiffContentFactoryEx.ContextProvider(){

            @Override
            public void passContext(@NotNull DiffContentFactoryEx.DocumentContentBuilder builder) {
                if (builder == null) {
                    4.$$$reportNull$$$0(0);
                }
                builder.contextByHighlightFile(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diff/util/DiffUtil$4", "passContext"));
            }
        });
    }

    private static List<DocumentContent> getDocumentContentsForViewer(@Nullable Project project, @NotNull List<byte[]> byteContents, @Nullable ConflictType conflictType, @NotNull DiffContentFactoryEx.ContextProvider contextProvider) {
        DocumentContent original;
        if (byteContents == null) {
            DiffUtil.$$$reportNull$$$0(98);
        }
        if (contextProvider == null) {
            DiffUtil.$$$reportNull$$$0(99);
        }
        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
        DocumentContent current = contentFactory.documentContent(project, true).contextByProvider(contextProvider).buildFromBytes((byte[])ObjectUtils.notNull((Object)byteContents.get(0), (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY));
        DocumentContent last = contentFactory.documentContent(project, true).contextByProvider(contextProvider).buildFromBytes((byte[])ObjectUtils.notNull((Object)byteContents.get(2), (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY));
        if (conflictType == ConflictType.ADDED_ADDED) {
            ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            CharSequence currentContent = DiffUtil.getDocumentCharSequence(current);
            CharSequence lastContent = DiffUtil.getDocumentCharSequence(last);
            String newContent = ComparisonManager.getInstance().mergeLinesAdditions(currentContent, lastContent, ComparisonPolicy.IGNORE_WHITESPACES, indicator);
            original = contentFactory.documentContent(project, true).contextByProvider(contextProvider).buildFromText(newContent, false);
        } else {
            original = contentFactory.documentContent(project, true).contextByProvider(contextProvider).buildFromBytes((byte[])ObjectUtils.notNull((Object)byteContents.get(1), (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY));
        }
        return Arrays.asList(current, original, last);
    }

    @Nullable
    public static MergeInnerDifferences compareThreesideInner(@NotNull List<? extends CharSequence> chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator) {
        if (chunks == null) {
            DiffUtil.$$$reportNull$$$0(100);
        }
        if (comparisonPolicy == null) {
            DiffUtil.$$$reportNull$$$0(101);
        }
        if (indicator == null) {
            DiffUtil.$$$reportNull$$$0(102);
        }
        if (chunks.get(0) == null && chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(1), comparisonPolicy) && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(2), comparisonPolicy)) {
            return new MergeInnerDifferences(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (chunks.get(0) == null && chunks.get(1) == null || chunks.get(0) == null && chunks.get(2) == null || chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (chunks.get(0) != null && chunks.get(1) != null && chunks.get(2) != null) {
            List<DiffFragment> fragments1 = ByWord.compare(chunks.get(1), chunks.get(0), comparisonPolicy, indicator);
            List<DiffFragment> fragments2 = ByWord.compare(chunks.get(1), chunks.get(2), comparisonPolicy, indicator);
            ArrayList<TextRange> left = new ArrayList<TextRange>();
            ArrayList<TextRange> base = new ArrayList<TextRange>();
            ArrayList<TextRange> right = new ArrayList<TextRange>();
            for (DiffFragment wordFragment : fragments1) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                left.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            for (DiffFragment wordFragment : fragments2) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                right.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            return new MergeInnerDifferences(left, base, right);
        }
        ThreeSide side1 = chunks.get(0) != null ? ThreeSide.LEFT : ThreeSide.BASE;
        ThreeSide side2 = chunks.get(2) != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select(chunks);
        CharSequence chunk2 = (CharSequence)side2.select(chunks);
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator);
        List textRanges = ThreeSide.map(side -> {
            if (side == side1) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()));
            }
            if (side == side2) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset2(), fragment.getEndOffset2()));
            }
            return null;
        });
        return new MergeInnerDifferences((List)textRanges.get(0), (List)textRanges.get(1), (List)textRanges.get(2));
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            DiffUtil.$$$reportNull$$$0(103);
        }
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonUtil.isEqualTexts((CharSequence)chunk1, (CharSequence)chunk2, (ComparisonPolicy)comparisonPolicy);
    }

    public static <T> int @NotNull [] getSortedIndexes(@NotNull List<? extends T> values, @NotNull Comparator<? super T> comparator) {
        if (values == null) {
            DiffUtil.$$$reportNull$$$0(104);
        }
        if (comparator == null) {
            DiffUtil.$$$reportNull$$$0(105);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            indexes.add(i);
        }
        ContainerUtil.sort(indexes, (i1, i2) -> {
            Object val1 = values.get((int)i1);
            Object val2 = values.get((int)i2);
            return comparator.compare((Object)val1, (Object)val2);
        });
        int[] nArray = ArrayUtil.toIntArray(indexes);
        if (nArray == null) {
            DiffUtil.$$$reportNull$$$0(106);
        }
        return nArray;
    }

    public static int @NotNull [] invertIndexes(int @NotNull [] indexes) {
        if (indexes == null) {
            DiffUtil.$$$reportNull$$$0(107);
        }
        int[] inverted = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            inverted[indexes[i]] = i;
        }
        if (inverted == null) {
            DiffUtil.$$$reportNull$$$0(108);
        }
        return inverted;
    }

    public static boolean compareStreams(@NotNull ThrowableComputable<? extends InputStream, ? extends IOException> stream1, @NotNull ThrowableComputable<? extends InputStream, ? extends IOException> stream2) throws IOException {
        if (stream1 == null) {
            DiffUtil.$$$reportNull$$$0(109);
        }
        if (stream2 == null) {
            DiffUtil.$$$reportNull$$$0(110);
        }
        int i = 0;
        try (InputStream s1 = (InputStream)stream1.compute();
             InputStream s2 = (InputStream)stream2.compute();){
            if (s1 == null && s2 == null) {
                boolean bl = true;
                return bl;
            }
            if (s1 == null || s2 == null) {
                boolean bl = false;
                return bl;
            }
            while (true) {
                int b2;
                int b1;
                if ((b1 = s1.read()) != (b2 = s2.read())) {
                    boolean bl = false;
                    return bl;
                }
                if (b1 == -1) {
                    boolean bl = true;
                    return bl;
                }
                if (i++ % 10000 != 0) continue;
                ProgressManager.checkCanceled();
            }
        }
    }

    @NotNull
    public static InputStream getFileInputStream(@NotNull VirtualFile file) throws IOException {
        VirtualFileSystem fs;
        if (file == null) {
            DiffUtil.$$$reportNull$$$0(111);
        }
        if ((fs = file.getFileSystem()) instanceof FileSystemInterface) {
            InputStream inputStream = ((FileSystemInterface)fs).getInputStream(file);
            if (inputStream == null) {
                DiffUtil.$$$reportNull$$$0(112);
            }
            return inputStream;
        }
        byte[] content = (byte[])ReadAction.compute(() -> file.contentsToByteArray());
        return new ByteArrayInputStream(content);
    }

    public static boolean isSomeRangeSelected(@NotNull Editor editor, @NotNull Condition<? super BitSet> condition) {
        List carets;
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(113);
        }
        if (condition == null) {
            DiffUtil.$$$reportNull$$$0(114);
        }
        if ((carets = editor.getCaretModel().getAllCarets()).size() != 1) {
            return true;
        }
        Caret caret = (Caret)carets.get(0);
        if (caret.hasSelection()) {
            return true;
        }
        return condition.value((Object)DiffUtil.getSelectedLines(editor));
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(115);
        }
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines = new BitSet(totalLines + 1);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            DiffUtil.appendSelectedLines(editor, lines, caret);
        }
        BitSet bitSet = lines;
        if (bitSet == null) {
            DiffUtil.$$$reportNull$$$0(116);
        }
        return bitSet;
    }

    private static void appendSelectedLines(@NotNull Editor editor, @NotNull BitSet lines, @NotNull Caret caret) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(117);
        }
        if (lines == null) {
            DiffUtil.$$$reportNull$$$0(118);
        }
        if (caret == null) {
            DiffUtil.$$$reportNull$$$0(119);
        }
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        if (caret.hasSelection()) {
            int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
            int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
            lines.set(line1, line2 + 1);
            if (caret.getSelectionEnd() == document.getTextLength()) {
                lines.set(totalLines);
            }
        } else {
            int offset = caret.getOffset();
            VisualPosition visualPosition = caret.getVisualPosition();
            Pair pair = EditorUtil.calcSurroundingRange((Editor)editor, (VisualPosition)visualPosition, (VisualPosition)visualPosition);
            lines.set(((LogicalPosition)pair.first).line, Math.max(((LogicalPosition)pair.second).line, ((LogicalPosition)pair.first).line + 1));
            if (offset == document.getTextLength()) {
                lines.set(totalLines);
            }
        }
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected, int line1, int line2) {
        if (selected == null) {
            DiffUtil.$$$reportNull$$$0(120);
        }
        if (line1 == line2) {
            return selected.get(line1);
        }
        int next = selected.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    private static void deleteLines(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(121);
        }
        TextRange range = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range.getStartOffset();
        int offset2 = range.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    private static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(122);
        }
        if (text == null) {
            DiffUtil.$$$reportNull$$$0(123);
        }
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + String.valueOf(text)));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(String.valueOf(text) + "\n"));
        }
    }

    private static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(124);
        }
        if (text == null) {
            DiffUtil.$$$reportNull$$$0(125);
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text);
    }

    public static void applyModification(@NotNull Document document, int line1, int line2, @NotNull List<? extends CharSequence> newLines) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(126);
        }
        if (newLines == null) {
            DiffUtil.$$$reportNull$$$0(127);
        }
        if (line1 == line2 && newLines.isEmpty()) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document, line1, StringUtil.join(newLines, (String)"\n"));
        } else if (newLines.isEmpty()) {
            DiffUtil.deleteLines(document, line1, line2);
        } else {
            DiffUtil.replaceLines(document, line1, line2, StringUtil.join(newLines, (String)"\n"));
        }
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            DiffUtil.$$$reportNull$$$0(128);
        }
        if (document2 == null) {
            DiffUtil.$$$reportNull$$$0(129);
        }
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        }
    }

    public static String applyModification(final @NotNull CharSequence text, final @NotNull LineOffsets lineOffsets, final @NotNull CharSequence otherText, final @NotNull LineOffsets otherLineOffsets, final @NotNull List<? extends Range> ranges) {
        if (text == null) {
            DiffUtil.$$$reportNull$$$0(130);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(131);
        }
        if (otherText == null) {
            DiffUtil.$$$reportNull$$$0(132);
        }
        if (otherLineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(133);
        }
        if (ranges == null) {
            DiffUtil.$$$reportNull$$$0(134);
        }
        return new Object(){
            private final StringBuilder stringBuilder = new StringBuilder();
            private boolean isEmpty = true;

            @NotNull
            public String execute() {
                int lastLine = 0;
                for (Range range : ranges) {
                    CharSequence newChunkContent = DiffRangeUtil.getLinesContent((CharSequence)otherText, (LineOffsets)otherLineOffsets, (int)range.start2, (int)range.end2);
                    this.appendOriginal(lastLine, range.start1);
                    this.append(newChunkContent, range.end2 - range.start2);
                    lastLine = range.end1;
                }
                this.appendOriginal(lastLine, lineOffsets.getLineCount());
                String string = this.stringBuilder.toString();
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            private void appendOriginal(int start, int end) {
                this.append(DiffRangeUtil.getLinesContent((CharSequence)text, (LineOffsets)lineOffsets, (int)start, (int)end), end - start);
            }

            private void append(CharSequence content, int lineCount) {
                if (lineCount > 0 && !this.isEmpty) {
                    this.stringBuilder.append('\n');
                }
                this.stringBuilder.append(content);
                this.isEmpty &= lineCount == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil$5", "execute"));
            }
        }.execute();
    }

    public static void clearLineModificationFlags(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(135);
        }
        if (document.getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        ((DocumentImpl)document).clearLineModificationFlags(startLine, endLine);
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(136);
        }
        CharSequence charSequence = DiffUtil.getLinesRange(document, line1, line2).subSequence(document.getImmutableCharSequence());
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(137);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2, boolean includeNewLine) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(138);
        }
        CharSequence charSequence = DiffUtil.getLinesRange(document, line1, line2, includeNewLine).subSequence(document.getImmutableCharSequence());
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(139);
        }
        return charSequence;
    }

    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(140);
        }
        return DiffUtil.getLinesRange(document, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2, boolean includeNewline) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(141);
        }
        LinesRange linesRange = DiffRangeUtil.getLinesRange((LineOffsets)LineOffsetsUtil.create(document), (int)line1, (int)line2, (boolean)includeNewline);
        return new TextRange(linesRange.getStartOffset(), linesRange.getEndOffset());
    }

    public static int getOffset(@NotNull Document document, int line, int column) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(142);
        }
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document)) {
            return document.getTextLength();
        }
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        return Math.min(start + column, end);
    }

    public static int getLineCount(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(143);
        }
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(144);
        }
        return DiffUtil.getLines(document, 0, DiffUtil.getLineCount(document));
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(145);
        }
        List list = DiffRangeUtil.getLines((CharSequence)document.getCharsSequence(), (LineOffsets)LineOffsetsUtil.create(document), (int)startLine, (int)endLine);
        if (list == null) {
            DiffUtil.$$$reportNull$$$0(146);
        }
        return list;
    }

    public static int bound(int value, int lowerBound, int upperBound) {
        assert (lowerBound <= upperBound) : String.format("%s - [%s, %s]", value, lowerBound, upperBound);
        return Math.clamp((long)value, lowerBound, upperBound);
    }

    @NotNull
    public static LineRange getAffectedLineRange(@NotNull DocumentEvent e) {
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(147);
        }
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        return new LineRange(line1, line2);
    }

    public static int countLinesShift(@NotNull DocumentEvent e) {
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(148);
        }
        return StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift) {
        return DiffUtil.updateRangeOnModification(start, end, changeStart, changeEnd, shift, false);
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            return new UpdatedLineRange(start, end, false);
        }
        if (start >= changeEnd) {
            return new UpdatedLineRange(start + shift, end + shift, false);
        }
        if (start <= changeStart && end >= changeEnd) {
            return new UpdatedLineRange(start, end + shift, false);
        }
        int newChangeEnd = changeEnd + shift;
        if (start >= changeStart && end <= changeEnd) {
            return greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
        }
        if (start < changeStart) {
            return greedy ? new UpdatedLineRange(start, newChangeEnd, true) : new UpdatedLineRange(start, changeStart, true);
        }
        return greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(149);
        }
        boolean left = fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getStartLine2() != fragment.getEndLine2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            DiffUtil.$$$reportNull$$$0(150);
        }
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull Range range) {
        if (range == null) {
            DiffUtil.$$$reportNull$$$0(151);
        }
        boolean left = range.start1 != range.end1;
        boolean right = range.start2 != range.end2;
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(boolean hasDeleted, boolean hasInserted) {
        if (hasDeleted && hasInserted) {
            TextDiffType textDiffType = TextDiffType.MODIFIED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(152);
            }
            return textDiffType;
        }
        if (hasDeleted) {
            TextDiffType textDiffType = TextDiffType.DELETED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(153);
            }
            return textDiffType;
        }
        if (hasInserted) {
            TextDiffType textDiffType = TextDiffType.INSERTED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(154);
            }
            return textDiffType;
        }
        LOG.error("Diff fragment should not be empty");
        TextDiffType textDiffType = TextDiffType.MODIFIED;
        if (textDiffType == null) {
            DiffUtil.$$$reportNull$$$0(155);
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull MergeConflictType conflictType) {
        if (conflictType == null) {
            DiffUtil.$$$reportNull$$$0(156);
        }
        TextDiffType textDiffType = switch (conflictType.getType()) {
            default -> throw new MatchException(null, null);
            case MergeConflictType.Type.INSERTED -> TextDiffType.INSERTED;
            case MergeConflictType.Type.DELETED -> TextDiffType.DELETED;
            case MergeConflictType.Type.MODIFIED -> TextDiffType.MODIFIED;
            case MergeConflictType.Type.CONFLICT -> TextDiffType.CONFLICT;
        };
        if (textDiffType == null) {
            DiffUtil.$$$reportNull$$$0(157);
        }
        return textDiffType;
    }

    @RequiresEdt
    public static boolean executeWriteCommand(@Nullable Project project, @NotNull Document document, @NlsContexts.Command @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @NotNull Runnable task) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(158);
        }
        if (confirmationPolicy == null) {
            DiffUtil.$$$reportNull$$$0(159);
        }
        if (task == null) {
            DiffUtil.$$$reportNull$$$0(160);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return DiffUtil.executeWriteCommand(project, document, commandName, commandGroupId, confirmationPolicy, underBulkUpdate, true, task);
    }

    @RequiresEdt
    public static boolean executeWriteCommand(@Nullable Project project, @NotNull Document document, @NlsContexts.Command @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, boolean shouldRecordCommandForActiveDocument, @NotNull Runnable task) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(161);
        }
        if (confirmationPolicy == null) {
            DiffUtil.$$$reportNull$$$0(162);
        }
        if (task == null) {
            DiffUtil.$$$reportNull$$$0(163);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!DiffUtil.makeWritable(project, document)) {
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            Object warning = "Document is read-only";
            if (file != null) {
                warning = (String)warning + ": " + file.getPresentableName();
                if (!file.isValid()) {
                    warning = (String)warning + " (invalid)";
                }
            }
            LOG.warn((String)warning);
            return false;
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
            if (underBulkUpdate) {
                DocumentUtil.executeInBulk((Document)document, (Runnable)task);
            } else {
                task.run();
            }
        }, commandName, (Object)commandGroupId, confirmationPolicy, shouldRecordCommandForActiveDocument, document));
        return true;
    }

    @RequiresEdt
    public static boolean executeWriteCommand(@NotNull Document document, @Nullable Project project, @Nullable @Nls String commandName, @NotNull Runnable task) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(164);
        }
        if (task == null) {
            DiffUtil.$$$reportNull$$$0(165);
        }
        ThreadingAssertions.assertEventDispatchThread();
        return DiffUtil.executeWriteCommand(project, document, commandName, null, UndoConfirmationPolicy.DEFAULT, false, task);
    }

    public static boolean isEditable(@NotNull Editor editor) {
        if (editor == null) {
            DiffUtil.$$$reportNull$$$0(166);
        }
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        VirtualFile file;
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(167);
        }
        if ((file = FileDocumentManager.getInstance().getFile(document)) != null && file.isInLocalFileSystem() && !file.isValid()) {
            return false;
        }
        if (document.isWritable()) {
            return true;
        }
        if (file != null && file.isValid() && file.isInLocalFileSystem()) {
            if (file.getUserData(TEMP_FILE_KEY) == Boolean.TRUE) {
                return false;
            }
            return !file.isWritable();
        }
        return false;
    }

    @RequiresEdt
    public static boolean makeWritable(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(168);
        }
        ThreadingAssertions.assertEventDispatchThread();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return document.isWritable();
        }
        if (!file.isValid()) {
            return false;
        }
        return DiffUtil.makeWritable(project, file) && document.isWritable();
    }

    @RequiresEdt
    public static boolean makeWritable(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            DiffUtil.$$$reportNull$$$0(169);
        }
        ThreadingAssertions.assertEventDispatchThread();
        Project projectOrDefault = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (Boolean)ReadAction.compute(() -> !ReadonlyStatusHandler.getInstance((Project)projectOrDefault).ensureFilesWritable(Collections.singletonList(file)).hasReadonlyFiles());
    }

    public static void putNonundoableOperation(@Nullable Project project, @NotNull Document document) {
        UndoManager undoManager;
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(170);
        }
        UndoManager undoManager2 = undoManager = project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
        if (undoManager != null) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            undoManager.nonundoableActionPerformed(ref, false);
        }
    }

    public static void refreshOnFrameActivation(VirtualFile ... files) {
        if (files == null) {
            DiffUtil.$$$reportNull$$$0(171);
        }
        if (GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, files);
        }
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        if (files == null) {
            DiffUtil.$$$reportNull$$$0(172);
        }
        if (files.length == 0) {
            return;
        }
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files);
        RefreshQueue.getInstance().refresh(async, recursive, null, modalityState, files);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        return new Dimension(400, 200);
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        return new Dimension(width, height);
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints) {
        WindowWrapper.Mode mode;
        if (hints == null) {
            DiffUtil.$$$reportNull$$$0(173);
        }
        if ((mode = hints.getMode()) == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        WindowWrapper.Mode mode2 = mode;
        if (mode2 == null) {
            DiffUtil.$$$reportNull$$$0(174);
        }
        return mode2;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        boolean isClosed;
        if (window == null) {
            return;
        }
        Container component2 = window;
        while (component2 != null && (!(component2 instanceof Window) || (isClosed = DiffUtil.closeWindow(component2, modalOnly)))) {
            component2 = recursive ? component2.getParent() : null;
        }
    }

    private static boolean closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window == null) {
            DiffUtil.$$$reportNull$$$0(175);
        }
        if (window instanceof IdeFrameImpl || modalOnly && DiffUtil.canBeHiddenBehind(window)) {
            return false;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return !window.isVisible();
        }
        window.setVisible(false);
        window.dispose();
        return true;
    }

    public static void minimizeDiffIfOpenedInWindow(@NotNull Component diffComponent) {
        Window window;
        if (diffComponent == null) {
            DiffUtil.$$$reportNull$$$0(176);
        }
        if (!SystemInfo.isMac) {
            return;
        }
        EditorWindowHolder holder = (EditorWindowHolder)UIUtil.getParentOfType(EditorWindowHolder.class, (Component)diffComponent);
        if (holder == null) {
            return;
        }
        EditorWindow editorWindow = holder.getEditorWindow();
        List composites = editorWindow.getAllComposites();
        if (composites.size() != 1) {
            return;
        }
        Project project = editorWindow.getManager().getProject();
        VirtualFile file = ((EditorComposite)composites.get(0)).getFile();
        if (DiffEditorTabFilesManager.getInstance(project).isDiffOpenedInWindow(file) && (window = UIUtil.getWindow((Component)diffComponent)) != null && !DiffUtil.canBeHiddenBehind(window) && window instanceof Frame) {
            ((Frame)window).setState(1);
        }
    }

    private static boolean canBeHiddenBehind(@NotNull Window window) {
        if (window == null) {
            DiffUtil.$$$reportNull$$$0(177);
        }
        if (!(window instanceof Frame)) {
            return false;
        }
        if (SystemInfo.isMac && window instanceof IdeFrame) {
            JComponent projectFrameComponent;
            Project project = ((IdeFrame)window).getProject();
            IdeFrame projectFrame = WindowManager.getInstance().getIdeFrame(project);
            if (projectFrame != null && (projectFrameComponent = projectFrame.getComponent()) != null) {
                return !projectFrame.isInFullScreen() || window.getGraphicsConfiguration().getDevice() != projectFrameComponent.getGraphicsConfiguration().getDevice();
            }
        }
        return true;
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(178);
        }
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key, value);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key, UserDataHolder ... holders) {
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(179);
        }
        for (UserDataHolder holder : holders) {
            Boolean data;
            if (holder == null || (data = (Boolean)holder.getUserData(key)) == null) continue;
            return data;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key) {
        Object data;
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(180);
        }
        if (first != null && (data = first.getUserData(key)) != null) {
            return (T)data;
        }
        if (second != null && (data = second.getUserData(key)) != null) {
            return (T)data;
        }
        return null;
    }

    public static void addNotification(@Nullable DiffNotificationProvider provider, @NotNull UserDataHolder holder) {
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(181);
        }
        if (provider == null) {
            return;
        }
        ArrayList<DiffNotificationProvider> newProviders = new ArrayList<DiffNotificationProvider>(DiffUtil.getNotificationProviders(holder));
        newProviders.add(provider);
        holder.putUserData(DiffUserDataKeys.NOTIFICATION_PROVIDERS, newProviders);
    }

    @NotNull
    public static List<JComponent> createCustomNotifications(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull UserDataHolder context, @NotNull UserDataHolder request) {
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(182);
        }
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(183);
        }
        List<DiffNotificationProvider> contextProviders = DiffUtil.getNotificationProviders(context);
        List<DiffNotificationProvider> requestProviders = DiffUtil.getNotificationProviders(request);
        return DiffUtil.createNotifications(viewer, ContainerUtil.concat(contextProviders, requestProviders));
    }

    @NotNull
    public static List<JComponent> createCustomNotifications(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull DiffContent content) {
        if (content == null) {
            DiffUtil.$$$reportNull$$$0(184);
        }
        List<DiffNotificationProvider> providers = DiffUtil.getNotificationProviders((UserDataHolder)content);
        return DiffUtil.createNotifications(viewer, providers);
    }

    @NotNull
    private static @Unmodifiable List<DiffNotificationProvider> getNotificationProviders(@NotNull UserDataHolder holder) {
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(185);
        }
        List list = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATION_PROVIDERS)));
        if (list == null) {
            DiffUtil.$$$reportNull$$$0(186);
        }
        return list;
    }

    @NotNull
    private static List<JComponent> createNotifications(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull List<? extends DiffNotificationProvider> providers) {
        if (providers == null) {
            DiffUtil.$$$reportNull$$$0(187);
        }
        List notifications = ContainerUtil.mapNotNull(providers, it -> it.createNotification(viewer));
        return DiffUtil.wrapEditorNotificationBorders(notifications);
    }

    @NotNull
    public static @Unmodifiable List<JComponent> wrapEditorNotificationBorders(@NotNull List<? extends JComponent> notifications) {
        if (notifications == null) {
            DiffUtil.$$$reportNull$$$0(188);
        }
        List list = ContainerUtil.map(notifications, component2 -> DiffUtil.wrapEditorNotificationComponent(component2));
        if (list == null) {
            DiffUtil.$$$reportNull$$$0(189);
        }
        return list;
    }

    @NotNull
    private static JComponent wrapEditorNotificationComponent(JComponent component2) {
        Border border = (Border)ClientProperty.get((Component)component2, (Key)FileEditorManager.SEPARATOR_BORDER);
        if (border == null) {
            JComponent jComponent = component2;
            if (jComponent == null) {
                DiffUtil.$$$reportNull$$$0(190);
            }
            return jComponent;
        }
        InvisibleWrapper wrapper = new InvisibleWrapper();
        wrapper.setContent(component2);
        wrapper.setBorder(border);
        InvisibleWrapper invisibleWrapper = wrapper;
        if (invisibleWrapper == null) {
            DiffUtil.$$$reportNull$$$0(191);
        }
        return invisibleWrapper;
    }

    @NotNull
    public static <T extends DiffRequest> T addTitleCustomizers(@NotNull T request, @NotNull List<DiffEditorTitleCustomizer> customizers) {
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(192);
        }
        if (customizers == null) {
            DiffUtil.$$$reportNull$$$0(193);
        }
        DiffUtil.tryTitleCustomizersNumber(request, customizers.size());
        request.putUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER, customizers);
        T t = request;
        if (t == null) {
            DiffUtil.$$$reportNull$$$0(194);
        }
        return t;
    }

    @NotNull
    public static <T extends DiffRequest> T addTitleCustomizers(@NotNull T request, DiffEditorTitleCustomizer ... customizers) {
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(195);
        }
        if (customizers == null) {
            DiffUtil.$$$reportNull$$$0(196);
        }
        DiffUtil.tryTitleCustomizersNumber(request, customizers.length);
        request.putUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER, List.of(customizers));
        T t = request;
        if (t == null) {
            DiffUtil.$$$reportNull$$$0(197);
        }
        return t;
    }

    @NotNull
    public static <T extends MergeRequest> T addTitleCustomizers(@NotNull T request, @NotNull List<DiffEditorTitleCustomizer> customizers) {
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(198);
        }
        if (customizers == null) {
            DiffUtil.$$$reportNull$$$0(199);
        }
        request.putUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER, customizers);
        T t = request;
        if (t == null) {
            DiffUtil.$$$reportNull$$$0(200);
        }
        return t;
    }

    private static void tryTitleCustomizersNumber(@NotNull DiffRequest request, int customizersNumber) {
        ContentDiffRequest contentDiffRequest;
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(201);
        }
        assert (customizersNumber != 0);
        if (request instanceof ContentDiffRequest && (contentDiffRequest = (ContentDiffRequest)request).getContentTitles().size() != customizersNumber) {
            LOG.error("Expected " + contentDiffRequest.getContentTitles().size() + " titles, but got " + customizersNumber);
        }
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key, @Nullable T value) {
        DataProvider dataProvider;
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(202);
        }
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(203);
        }
        if (!((dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER)) instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key, value);
    }

    @NotNull
    public static DiffSettingsHolder.DiffSettings getDiffSettings(@NotNull DiffContext context) {
        DiffSettingsHolder.DiffSettings settings;
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(204);
        }
        if ((settings = (DiffSettingsHolder.DiffSettings)context.getUserData(DiffSettingsHolder.DiffSettings.KEY)) == null) {
            settings = DiffSettingsHolder.DiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(DiffSettingsHolder.DiffSettings.KEY, (Object)settings);
        }
        DiffSettingsHolder.DiffSettings diffSettings = settings;
        if (diffSettings == null) {
            DiffUtil.$$$reportNull$$$0(205);
        }
        return diffSettings;
    }

    @NotNull
    public static <K, V> TreeMap<K, V> trimDefaultValues(@NotNull TreeMap<K, V> map, @NotNull Convertor<? super K, V> defaultValue) {
        if (map == null) {
            DiffUtil.$$$reportNull$$$0(206);
        }
        if (defaultValue == null) {
            DiffUtil.$$$reportNull$$$0(207);
        }
        TreeMap<K, V> result = new TreeMap<K, V>();
        for (Map.Entry<K, V> it : map.entrySet()) {
            K key = it.getKey();
            V value = it.getValue();
            if (value.equals(defaultValue.convert(key))) continue;
            result.put(key, value);
        }
        TreeMap<K, V> treeMap = result;
        if (treeMap == null) {
            DiffUtil.$$$reportNull$$$0(208);
        }
        return treeMap;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools == null) {
            DiffUtil.$$$reportNull$$$0(209);
        }
        if (tools.size() < 2) {
            List list = tools;
            if (list == null) {
                DiffUtil.$$$reportNull$$$0(210);
            }
            return list;
        }
        ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool2 : tools) {
            try {
                if (!(tool2 instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool2).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            List list = tools;
            if (list == null) {
                DiffUtil.$$$reportNull$$$0(211);
            }
            return list;
        }
        List filteredTools = ContainerUtil.filter(tools, tool -> !suppressedTools.contains(tool.getClass()));
        List list = filteredTools.isEmpty() ? tools : filteredTools;
        if (list == null) {
            DiffUtil.$$$reportNull$$$0(212);
        }
        return list;
    }

    @Nullable
    public static DiffTool findToolSubstitutor(@NotNull DiffTool tool, @NotNull DiffContext context, @NotNull DiffRequest request) {
        if (tool == null) {
            DiffUtil.$$$reportNull$$$0(213);
        }
        if (context == null) {
            DiffUtil.$$$reportNull$$$0(214);
        }
        if (request == null) {
            DiffUtil.$$$reportNull$$$0(215);
        }
        for (DiffToolSubstitutor substitutor : (DiffToolSubstitutor[])DiffToolSubstitutor.EP_NAME.getExtensions()) {
            DiffTool replacement = substitutor.getReplacement(tool, context, request);
            if (replacement == null) continue;
            boolean canShow = replacement.canShow(context, request);
            if (!canShow) {
                LOG.error("DiffTool substitutor returns invalid tool");
                continue;
            }
            return replacement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14, 29, 31, 39, 43, 45, 47, 56, 60, 64, 69, 71, 73, 75, 78, 80, 81, 88, 93, 106, 108, 112, 116, 137, 139, 146, 152, 153, 154, 155, 157, 174, 186, 189, 190, 191, 194, 197, 200, 205, 208, 210, 211, 212 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 113: 
            case 115: 
            case 117: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 97: 
            case 111: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 24: 
            case 67: 
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 44: 
            case 46: 
            case 123: 
            case 125: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 14: 
            case 29: 
            case 31: 
            case 39: 
            case 43: 
            case 45: 
            case 47: 
            case 56: 
            case 60: 
            case 64: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 80: 
            case 81: 
            case 88: 
            case 93: 
            case 106: 
            case 108: 
            case 112: 
            case 116: 
            case 137: 
            case 139: 
            case 146: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 157: 
            case 174: 
            case 186: 
            case 189: 
            case 190: 
            case 191: 
            case 194: 
            case 197: 
            case 200: 
            case 205: 
            case 208: 
            case 210: 
            case 211: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffUtil";
                break;
            }
            case 12: 
            case 13: 
            case 121: 
            case 122: 
            case 124: 
            case 126: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 158: 
            case 161: 
            case 164: 
            case 167: 
            case 168: 
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingSupport";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 32: 
            case 147: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 34: 
            case 36: 
            case 48: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 35: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activatable";
                break;
            }
            case 54: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 55: 
            case 58: 
            case 62: 
            case 84: 
            case 89: 
            case 183: 
            case 192: 
            case 195: 
            case 198: 
            case 201: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vGap";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isContentsEqual";
                break;
            }
            case 82: 
            case 182: 
            case 204: 
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 83: 
            case 160: 
            case 163: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 85: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 86: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 87: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 94: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteContents";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextProvider";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonPolicy";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream1";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream2";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLines";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherText";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherLineOffsets";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 149: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
            case 159: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 171: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 175: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffComponent";
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 203: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 181: 
            case 185: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifications";
                break;
            }
            case 193: 
            case 196: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizers";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "initEmptyEditorHighlighter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowIcon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowDownIcon";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessagePanel";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsConfigurablePath";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipText";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationText";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleTitles";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextTitles";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatchTextTitles";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitle";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharsetPanel";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparatorPanel";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncHeightComponents";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackedComponents";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextDiffProvider";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoIgnoreTextDiffProvider";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedIndexes";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "invertIndexes";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInputStream";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLines";
                break;
            }
            case 137: 
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesContent";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowMode";
                break;
            }
            case 186: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationProviders";
                break;
            }
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapEditorNotificationBorders";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapEditorNotificationComponent";
                break;
            }
            case 194: 
            case 197: 
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "addTitleCustomizers";
                break;
            }
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffSettings";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "trimDefaultValues";
                break;
            }
            case 210: 
            case 211: 
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSuppressedTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iconToImage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDiffEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileWithoutContent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initEditorHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initEmptyEditorHighlighter";
                break;
            }
            case 6: 
            case 14: 
            case 29: 
            case 31: 
            case 39: 
            case 43: 
            case 45: 
            case 47: 
            case 56: 
            case 60: 
            case 64: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 78: 
            case 80: 
            case 81: 
            case 88: 
            case 93: 
            case 106: 
            case 108: 
            case 112: 
            case 116: 
            case 137: 
            case 139: 
            case 146: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 157: 
            case 174: 
            case 186: 
            case 189: 
            case 190: 
            case 191: 
            case 194: 
            case 197: 
            case 200: 
            case 205: 
            case 208: 
            case 210: 
            case 211: 
            case 212: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHighlighter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEditorHighlighter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEditorCodeStyle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFoldingModelSupport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configureEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMirrored";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installLineConvertor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContentLineConvertor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disableBlitting";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scrollToPoint";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineRangeIfNeeded";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getArrowIcon";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getArrowDownIcon";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isFromShortcut";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "recursiveRegisterShortcutSet";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createMessagePanel";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addActionBlock";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipText";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationText";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "runWhenFirstShown";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "installShowNotifyListener";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleTitles";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createTextTitles";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createPatchTextTitles";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createTitleWithNotifications";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createTitle";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createCharsetPanel";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorPanel";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createSyncHeightComponents";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createStackedComponents";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "runPreservingFocus";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createTextDiffProvider";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createNoIgnoreTextDiffProvider";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentContentsForViewer";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "compareThreesideInner";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isChunksEquals";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getSortedIndexes";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "invertIndexes";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "compareStreams";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getFileInputStream";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isSomeRangeSelected";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLines";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "appendSelectedLines";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedByLine";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "deleteLines";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "insertLines";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "replaceLines";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "applyModification";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "clearLineModificationFlags";
                break;
            }
            case 136: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getLinesContent";
                break;
            }
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getLinesRange";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "getLineCount";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getLines";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLineRange";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "countLinesShift";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getLineDiffType";
                break;
            }
            case 150: 
            case 151: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getDiffType";
                break;
            }
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteCommand";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "canMakeWritable";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "makeWritable";
                break;
            }
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "putNonundoableOperation";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "refreshOnFrameActivation";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyAndRefresh";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "getWindowMode";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "closeWindow";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "minimizeDiffIfOpenedInWindow";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "canBeHiddenBehind";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "createUserDataHolder";
                break;
            }
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "isUserDataFlagSet";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "addNotification";
                break;
            }
            case 182: 
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "createCustomNotifications";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationProviders";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "createNotifications";
                break;
            }
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "wrapEditorNotificationBorders";
                break;
            }
            case 192: 
            case 193: 
            case 195: 
            case 196: 
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "addTitleCustomizers";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "tryTitleCustomizersNumber";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "putDataKey";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "getDiffSettings";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "trimDefaultValues";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "filterSuppressedTools";
                break;
            }
            case 213: 
            case 214: 
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "findToolSubstitutor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 14, 29, 31, 39, 43, 45, 47, 56, 60, 64, 69, 71, 73, 75, 78, 80, 81, 88, 93, 106, 108, 112, 116, 137, 139, 146, 152, 153, 154, 155, 157, 174, 186, 189, 190, 191, 194, 197, 200, 205, 208, 210, 211, 212 -> new IllegalStateException(string);
        };
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }
}

