/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.ConflictType;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.BinaryMergeRequestImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.TextMergeRequestImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    @NlsSafe
    public static final String DIFF_TITLE_SEPARATOR = " - ";
    @NlsSafe
    public static final String DIFF_TITLE_RENAME_SEPARATOR = " -> ";
    private final DiffContentFactoryEx myContentFactory = DiffContentFactoryEx.getInstanceEx();

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        assert (file1 != null || file2 != null);
        EmptyContent content1 = file1 != null ? this.myContentFactory.create(project, file1) : this.myContentFactory.createEmpty();
        EmptyContent content2 = file2 != null ? this.myContentFactory.create(project, file2) : this.myContentFactory.createEmpty();
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title = this.getTitleForComparison(file1, file2);
        return new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, title1, title2);
    }

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project, @NotNull VirtualFile leftFile, @NotNull VirtualFile baseFile, @NotNull VirtualFile rightFile) {
        if (leftFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(1);
        }
        if (rightFile == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(2);
        }
        DiffContent content1 = this.myContentFactory.create(project, leftFile);
        DiffContent content2 = this.myContentFactory.create(project, baseFile);
        DiffContent content3 = this.myContentFactory.create(project, rightFile);
        String title1 = this.getContentTitle(leftFile);
        String title2 = this.getContentTitle(baseFile);
        String title3 = this.getContentTitle(rightFile);
        return new SimpleDiffRequest(null, content1, content2, content3, title1, title2, title3);
    }

    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value) {
        if (value == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(3);
        }
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = DiffBundle.message((String)"diff.content.selected.value", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        return new SimpleDiffRequest(title, content1, (DiffContent)content2, title1, title2);
    }

    @Nullable
    public String getContentTitle(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return DiffRequestFactoryImpl.getContentTitle((FilePath)DiffRequestFactoryImpl.toFilePath(file));
    }

    @NotNull
    public String getTitleForModification(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        String string = this.getTitleForModification((FilePath)DiffRequestFactoryImpl.toFilePath(file1), (FilePath)DiffRequestFactoryImpl.toFilePath(file2));
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getTitleForComparison(@Nullable VirtualFile file1, @Nullable VirtualFile file2) {
        String string = this.getTitleForComparison((FilePath)DiffRequestFactoryImpl.toFilePath(file1), (FilePath)DiffRequestFactoryImpl.toFilePath(file2));
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file) {
        if (file == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(6);
        }
        String string = this.getTitleForComparison(file, null);
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getContentTitle(@NotNull FilePath path) {
        if (path == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(8);
        }
        if (path.isDirectory()) {
            String string = path.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        FilePath parent = path.getParentPath();
        return DiffRequestFactoryImpl.getContentTitle(path.getName(), path.getPresentableUrl(), parent != null ? parent.getPresentableUrl() : null);
    }

    @NotNull
    public String getTitle(@NotNull FilePath path) {
        if (path == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(10);
        }
        String string = this.getTitleForComparison(path, null);
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getTitleForComparison(@Nullable FilePath path1, @Nullable FilePath path2) {
        return DiffRequestFactoryImpl.getTitle(path1, path2, DIFF_TITLE_SEPARATOR);
    }

    @NotNull
    public String getTitleForModification(@Nullable FilePath path1, @Nullable FilePath path2) {
        return DiffRequestFactoryImpl.getTitle(path1, path2, DIFF_TITLE_RENAME_SEPARATOR);
    }

    @Nls
    @NotNull
    public static String getTitle(@Nullable FilePath path1, @Nullable FilePath path2, @NotNull @Nls String separator) {
        if (separator == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(12);
        }
        if (path1 == null && path2 == null) {
            String string = DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (path1 == null || path2 == null) {
            return DiffRequestFactoryImpl.getContentTitle((FilePath)ObjectUtils.chooseNotNull((Object)path1, (Object)path2));
        }
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            String string = path1.getPresentableUrl();
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(14);
            }
            return string;
        }
        Object name1 = path1.getName();
        Object name2 = path2.getName();
        if (path1.isDirectory() ^ path2.isDirectory()) {
            if (path1.isDirectory()) {
                name1 = (String)name1 + File.separatorChar;
            }
            if (path2.isDirectory()) {
                name2 = (String)name2 + File.separatorChar;
            }
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        return DiffRequestFactoryImpl.getRequestTitle((String)name1, path1.getPresentableUrl(), parent1 != null ? parent1.getPresentableUrl() : null, (String)name2, path2.getPresentableUrl(), parent2 != null ? parent2.getPresentableUrl() : null, separator);
    }

    @Nls
    @NotNull
    private static String getContentTitle(@NotNull @Nls String name, @NotNull @Nls String path, @Nullable @Nls String parentPath) {
        if (name == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(15);
        }
        if (path == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(16);
        }
        if (parentPath != null) {
            String string = name + " (" + parentPath + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nls
    @NotNull
    private static String getRequestTitle(@NotNull @Nls String name1, @NotNull @Nls String path1, @Nullable @Nls String parentPath1, @NotNull @Nls String name2, @NotNull @Nls String path2, @Nullable @Nls String parentPath2, @NotNull @Nls String sep) {
        if (name1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(19);
        }
        if (path1 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(20);
        }
        if (name2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(21);
        }
        if (path2 == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(22);
        }
        if (sep == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(23);
        }
        if (path1.equals(path2)) {
            return DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
        }
        if (Objects.equals(parentPath1, parentPath2)) {
            if (parentPath1 != null) {
                String string = name1 + sep + name2 + " (" + parentPath1 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(24);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(25);
            }
            return string;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                String string = name1 + " (" + parentPath1 + sep + parentPath2 + ")";
                if (string == null) {
                    DiffRequestFactoryImpl.$$$reportNull$$$0(26);
                }
                return string;
            }
            String string = path1 + sep + path2;
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (parentPath1 != null && parentPath2 != null) {
            String string = name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
            if (string == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = path1 + sep + path2;
        if (string == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @Nullable FileType fileType, @NotNull Document outputDocument, @NotNull List<String> textContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> titles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (outputDocument == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(30);
        }
        if (textContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(31);
        }
        if (titles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(32);
        }
        if (textContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (titles.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only");
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument, fileType);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (String text : textContents) {
            contents.add(this.myContentFactory.create(project, text, fileType));
        }
        TextMergeRequestImpl request = new TextMergeRequestImpl(project, outputContent, originalContent, contents, title, titles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(33);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(34);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(35);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(36);
        }
        MergeRequest mergeRequest = this.createMergeRequest(project, output, byteContents, null, title, contentTitles, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(37);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable ConflictType conflictType, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(38);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(39);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(40);
        }
        MergeRequest request = this.createMergeRequest(project, output, byteContents, conflictType, title, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(41);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(42);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(43);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(44);
        }
        MergeRequest mergeRequest = this.createMergeRequest(project, output, byteContents, null, title, contentTitles);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(45);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable ConflictType conflictType, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(46);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(47);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(48);
        }
        try {
            return this.createTextMergeRequest(project, output, byteContents, conflictType, title, contentTitles);
        }
        catch (InvalidDiffRequestException e) {
            return this.createBinaryMergeRequest(project, output, byteContents, title, contentTitles);
        }
    }

    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(49);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(50);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(51);
        }
        TextMergeRequest textMergeRequest = this.createTextMergeRequest(project, output, byteContents, null, title, contentTitles, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(52);
        }
        return textMergeRequest;
    }

    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable ConflictType conflictType, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(53);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(54);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(55);
        }
        TextMergeRequest request = this.createTextMergeRequest(project, output, byteContents, conflictType, title, contentTitles);
        TextMergeRequest textMergeRequest = (TextMergeRequest)MergeCallback.register((MergeRequest)request, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(56);
        }
        return textMergeRequest;
    }

    @NotNull
    private TextMergeRequest createTextMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable ConflictType conflictType, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(57);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(58);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(59);
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(output));
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        List<DocumentContent> contents = DiffUtil.getDocumentContentsForViewer(project, byteContents, output, conflictType);
        return new TextMergeRequestImpl(project, outputContent, originalContent, contents, title, contentTitles);
    }

    @NotNull
    public MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(60);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(61);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(62);
        }
        MergeRequest request = this.createBinaryMergeRequest(project, output, byteContents, title, contentTitles);
        MergeRequest mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(63);
        }
        return mergeRequest;
    }

    @NotNull
    private MergeRequest createBinaryMergeRequest(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(64);
        }
        if (byteContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(65);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(66);
        }
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + String.valueOf(output));
            }
            byte[] originalContent = (byte[])ReadAction.compute(() -> output.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            for (byte[] bytes : byteContents) {
                contents.add(this.myContentFactory.createFromBytes(project, (byte[])ObjectUtils.notNull((Object)bytes, (Object)ArrayUtilRt.EMPTY_BYTE_ARRAY), output));
            }
            return new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title, contentTitles);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(67);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(68);
        }
        String title = DiffBundle.message((String)"merge.window.title.file", (Object[])new Object[]{output.getPresentableUrl()});
        List<String> titles = Arrays.asList(DiffBundle.message((String)"merge.version.title.our", (Object[])new Object[0]), DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]), DiffBundle.message((String)"merge.version.title.their", (Object[])new Object[0]));
        MergeRequest mergeRequest = this.createMergeRequestFromFiles(project, output, fileContents, title, titles, applyCallback);
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(69);
        }
        return mergeRequest;
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        TextMergeRequest textMergeRequest;
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(70);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(71);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(72);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            textMergeRequest = this.createTextMergeRequestFromFiles(project, output, fileContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            MergeRequest mergeRequest = this.createBinaryMergeRequestFromFiles(project, output, fileContents, title, contentTitles, applyCallback);
            if (mergeRequest == null) {
                DiffRequestFactoryImpl.$$$reportNull$$$0(74);
            }
            return mergeRequest;
        }
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(73);
        }
        return textMergeRequest;
    }

    @NotNull
    public TextMergeRequest createTextMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(75);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(76);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(77);
        }
        ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
        for (VirtualFile virtualFile : fileContents) {
            try {
                byteContents.add((byte[])ReadAction.compute(() -> file.contentsToByteArray()));
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file: " + virtualFile.getPresentableUrl(), (Throwable)e);
            }
        }
        TextMergeRequest textMergeRequest = this.createTextMergeRequest(project, output, byteContents, title, contentTitles, applyCallback);
        if (textMergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(78);
        }
        return textMergeRequest;
    }

    @NotNull
    public MergeRequest createBinaryMergeRequestFromFiles(@Nullable Project project, @NotNull VirtualFile output, @NotNull List<? extends VirtualFile> fileContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles, @Nullable Consumer<? super MergeResult> applyCallback) throws InvalidDiffRequestException {
        MergeRequest mergeRequest;
        if (output == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(79);
        }
        if (fileContents == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(80);
        }
        if (contentTitles == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(81);
        }
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output.getPresentableUrl());
            }
            byte[] originalContent = (byte[])ReadAction.compute(() -> output.contentsToByteArray());
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
            for (VirtualFile virtualFile : fileContents) {
                FileContent content = this.myContentFactory.createFile(project, virtualFile);
                if (content == null) {
                    throw new InvalidDiffRequestException("Can't process file: " + virtualFile.getPresentableUrl());
                }
                contents.add((DiffContent)content);
                byteContents.add((byte[])ReadAction.compute(() -> file.contentsToByteArray()));
            }
            BinaryMergeRequestImpl request = new BinaryMergeRequestImpl(project, outputContent, originalContent, contents, byteContents, title, contentTitles);
            mergeRequest = MergeCallback.register((MergeRequest)request, applyCallback);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
        if (mergeRequest == null) {
            DiffRequestFactoryImpl.$$$reportNull$$$0(82);
        }
        return mergeRequest;
    }

    @Contract(value="!null -> !null; null -> null")
    @Nullable
    private static LocalFilePath toFilePath(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return new LocalFilePath(file.getPath(), file.isDirectory());
    }

    @NotNull
    public DiffRequest createOperationCanceled(@Nullable String requestName) {
        return new OperationCanceledDiffRequest(requestName);
    }

    @NotNull
    public DiffRequest createNothingToShow(@Nullable String requestName) {
        return new NoDiffRequest(requestName);
    }

    @NotNull
    public DiffRequest createLoading(@Nullable String requestName) {
        return new LoadingDiffRequest(requestName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9, 11, 13, 14, 17, 18, 24, 25, 26, 27, 28, 29, 33, 37, 41, 45, 52, 56, 63, 69, 73, 74, 78, 82 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 52: 
            case 56: 
            case 63: 
            case 69: 
            case 73: 
            case 74: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sep";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDocument";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textContents";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titles";
                break;
            }
            case 34: 
            case 38: 
            case 42: 
            case 46: 
            case 49: 
            case 53: 
            case 57: 
            case 60: 
            case 64: 
            case 67: 
            case 70: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 35: 
            case 39: 
            case 43: 
            case 47: 
            case 50: 
            case 54: 
            case 58: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteContents";
                break;
            }
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 51: 
            case 55: 
            case 59: 
            case 62: 
            case 66: 
            case 72: 
            case 77: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 68: 
            case 71: 
            case 76: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/DiffRequestFactoryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForModification";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForComparison";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 9: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitle";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestTitle";
                break;
            }
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequest";
                break;
            }
            case 52: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequest";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequest";
                break;
            }
            case 69: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeRequestFromFiles";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextMergeRequestFromFiles";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createClipboardVsValue";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 52: 
            case 56: 
            case 63: 
            case 69: 
            case 73: 
            case 74: 
            case 78: 
            case 82: {
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContentTitle";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRequestTitle";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequest";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequest";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequest";
                break;
            }
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createMergeRequestFromFiles";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "createTextMergeRequestFromFiles";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryMergeRequestFromFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 9, 11, 13, 14, 17, 18, 24, 25, 26, 27, 28, 29, 33, 37, 41, 45, 52, 56, 63, 69, 73, 74, 78, 82 -> new IllegalStateException(string);
        };
    }
}

