/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.lang.Language;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010\"\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/diff/merge/MergeStatisticsAggregator;", "", "changes", "", "autoResolvable", "autoResolvableWithSemantics", "conflicts", "language", "Lcom/intellij/lang/Language;", "<init>", "(IIIILcom/intellij/lang/Language;)V", "getChanges", "()I", "getAutoResolvable", "getAutoResolvableWithSemantics", "getConflicts", "getLanguage", "()Lcom/intellij/lang/Language;", "unresolved", "getUnresolved", "setUnresolved", "(I)V", "initialTimestamp", "", "getInitialTimestamp", "()J", "edited", "", "resolvedByAiChanges", "rolledBackAfterAI", "undoneAfterAi", "editedAfterAi", "resolvedByAi", "undoneAfterAI", "editedAfterAI", "wasEdited", "", "index", "wasResolvedByAi", "wasRolledBackAfterAI", "wasUndoneAfterAI", "wasEditedAfterAi", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class MergeStatisticsAggregator {
    private final int changes;
    private final int autoResolvable;
    private final int autoResolvableWithSemantics;
    private final int conflicts;
    @Nullable
    private final Language language;
    private int unresolved;
    private final long initialTimestamp;
    @NotNull
    private final Set<Integer> edited;
    @NotNull
    private final Set<Integer> resolvedByAiChanges;
    @NotNull
    private final Set<Integer> rolledBackAfterAI;
    @NotNull
    private final Set<Integer> undoneAfterAi;
    @NotNull
    private final Set<Integer> editedAfterAi;

    public MergeStatisticsAggregator(int changes, int autoResolvable, int autoResolvableWithSemantics, int conflicts, @Nullable Language language) {
        this.changes = changes;
        this.autoResolvable = autoResolvable;
        this.autoResolvableWithSemantics = autoResolvableWithSemantics;
        this.conflicts = conflicts;
        this.language = language;
        this.unresolved = -1;
        this.initialTimestamp = System.currentTimeMillis();
        this.edited = new LinkedHashSet();
        this.resolvedByAiChanges = new LinkedHashSet();
        this.rolledBackAfterAI = new LinkedHashSet();
        this.undoneAfterAi = new LinkedHashSet();
        this.editedAfterAi = new LinkedHashSet();
    }

    public final int getChanges() {
        return this.changes;
    }

    public final int getAutoResolvable() {
        return this.autoResolvable;
    }

    public final int getAutoResolvableWithSemantics() {
        return this.autoResolvableWithSemantics;
    }

    public final int getConflicts() {
        return this.conflicts;
    }

    @Nullable
    public final Language getLanguage() {
        return this.language;
    }

    public final int getUnresolved() {
        return this.unresolved;
    }

    public final void setUnresolved(int n) {
        this.unresolved = n;
    }

    public final long getInitialTimestamp() {
        return this.initialTimestamp;
    }

    public final int edited() {
        return this.edited.size();
    }

    public final int resolvedByAi() {
        return this.resolvedByAiChanges.size();
    }

    public final int rolledBackAfterAI() {
        return this.rolledBackAfterAI.size();
    }

    public final int undoneAfterAI() {
        return this.undoneAfterAi.size();
    }

    public final int editedAfterAI() {
        return this.editedAfterAi.size();
    }

    public final void wasEdited(int index) {
        this.edited.add(index);
    }

    public final void wasResolvedByAi(int index) {
        this.resolvedByAiChanges.add(index);
    }

    public final void wasRolledBackAfterAI(int index) {
        this.resolvedByAiChanges.remove(index);
        this.rolledBackAfterAI.add(index);
    }

    public final void wasUndoneAfterAI(int index) {
        this.resolvedByAiChanges.remove(index);
        this.undoneAfterAi.add(index);
    }

    public final void wasEditedAfterAi(int index) {
        this.editedAfterAi.add(index);
    }
}

