/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.holders;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BinaryEditorHolder
extends EditorHolder {
    @NotNull
    private final FileEditor myEditor;
    @Nullable
    private final FileEditorProvider myEditorProvider;

    public BinaryEditorHolder(@NotNull FileEditor editor, @Nullable FileEditorProvider editorProvider) {
        if (editor == null) {
            BinaryEditorHolder.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.myEditorProvider = editorProvider;
    }

    @NotNull
    public FileEditor getEditor() {
        FileEditor fileEditor = this.myEditor;
        if (fileEditor == null) {
            BinaryEditorHolder.$$$reportNull$$$0(1);
        }
        return fileEditor;
    }

    public void dispose() {
        if (this.myEditorProvider != null) {
            this.myEditorProvider.disposeEditor(this.myEditor);
        } else {
            Disposer.dispose((Disposable)this.myEditor);
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            BinaryEditorHolder.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Override
    public void installFocusListener(@NotNull FocusListener listener) {
        if (listener == null) {
            BinaryEditorHolder.$$$reportNull$$$0(3);
        }
        this.myEditor.getComponent().addFocusListener(listener);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/holders/BinaryEditorHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/holders/BinaryEditorHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installFocusListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class DumbFileEditor
    extends FileEditorBase {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final JComponent myComponent;

        private DumbFileEditor(@NotNull VirtualFile file, @NotNull JComponent component2) {
            if (file == null) {
                DumbFileEditor.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                DumbFileEditor.$$$reportNull$$$0(1);
            }
            this.myFile = file;
            this.myComponent = component2;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.myComponent;
            if (jComponent == null) {
                DumbFileEditor.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                DumbFileEditor.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        @NotNull
        public String getName() {
            return "Dumb";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/holders/BinaryEditorHolder$DumbFileEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/holders/BinaryEditorHolder$DumbFileEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class BinaryEditorHolderFactory
    extends EditorHolderFactory<BinaryEditorHolder> {
        public static final BinaryEditorHolderFactory INSTANCE = new BinaryEditorHolderFactory();

        @Override
        @NotNull
        public BinaryEditorHolder create(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                BinaryEditorHolderFactory.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BinaryEditorHolderFactory.$$$reportNull$$$0(1);
            }
            Project project = context.getProject();
            if (content instanceof FileContent) {
                if (project == null) {
                    project = ProjectManager.getInstance().getDefaultProject();
                }
                VirtualFile file = ((FileContent)content).getFile();
                List providers = FileEditorProviderManager.getInstance().getProviderList(project, file);
                if (providers.isEmpty()) {
                    JComponent component2 = FileTypeRegistry.getInstance().isFileOfType(file, UnknownFileType.INSTANCE) ? UnknownFileTypeDiffRequest.createComponent(file.getName(), context) : DiffUtil.createMessagePanel(DiffBundle.message((String)"error.cant.show.file", (Object[])new Object[0]));
                    return new BinaryEditorHolder(new DumbFileEditor(file, component2), null);
                }
                FileEditorProvider provider = (FileEditorProvider)providers.get(0);
                FileEditor editor = provider.createEditor(project, file);
                UIUtil.removeScrollBorder((Component)editor.getComponent());
                return new BinaryEditorHolder(editor, provider);
            }
            if (content instanceof DocumentContent) {
                Document document = ((DocumentContent)content).getDocument();
                EditorEx editor = DiffUtil.createEditor(document, project, true);
                TextEditorProvider provider = TextEditorProvider.getInstance();
                TextEditor fileEditor = provider.getTextEditor((Editor)editor);
                Disposer.register((Disposable)fileEditor, (Disposable)new Disposable(){
                    final /* synthetic */ Editor val$editor;
                    {
                        this.val$editor = editor;
                    }

                    public void dispose() {
                        EditorFactory.getInstance().releaseEditor(this.val$editor);
                    }
                });
                return new BinaryEditorHolder((FileEditor)fileEditor, (FileEditorProvider)provider);
            }
            throw new IllegalArgumentException(String.valueOf(content.getClass()) + " - " + content.toString());
        }

        @Override
        public boolean canShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                BinaryEditorHolderFactory.$$$reportNull$$$0(2);
            }
            if (context == null) {
                BinaryEditorHolderFactory.$$$reportNull$$$0(3);
            }
            if (content instanceof DocumentContent) {
                return true;
            }
            if (content instanceof FileContent) {
                VirtualFile file = ((FileContent)content).getFile();
                if (!file.isValid()) {
                    return false;
                }
                return !DiffUtil.isFileWithoutContent(file);
            }
            return false;
        }

        @Override
        public boolean wantShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
            if (content == null) {
                BinaryEditorHolderFactory.$$$reportNull$$$0(4);
            }
            if (context == null) {
                BinaryEditorHolderFactory.$$$reportNull$$$0(5);
            }
            if (content instanceof FileContent) {
                if (content.getContentType() == null) {
                    return false;
                }
                if (content.getContentType().isBinary()) {
                    return true;
                }
                return content.getContentType() instanceof UIBasedFileType;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/holders/BinaryEditorHolder$BinaryEditorHolderFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canShowContent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wantShowContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

