/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.AlignableChange;
import com.intellij.diff.tools.simple.AlignedDiffModel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b'\u0018\u00002\u00020\u0001:\u0006MNOPQRB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"H\u0002J\b\u0010(\u001a\u00020 H\u0002J.\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020%2\u0006\u0010'\u001a\u00020\"2\u0006\u0010/\u001a\u000200H\u0002J&\u00101\u001a\u00020 2\u0006\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u0010\u00103\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0002J,\u00104\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*2\u0006\u00105\u001a\u00020-2\n\u00106\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u00107\u001a\u00020%H\u0002J\u001c\u00108\u001a\u00020%2\u0006\u00105\u001a\u00020-2\n\u00106\u001a\u0006\u0012\u0002\b\u00030*H\u0002J.\u00109\u001a\u0004\u0018\u00010\u00182\u0006\u00105\u001a\u00020-2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00180;2\u0006\u0010.\u001a\u00020%H\u0002J\b\u0010<\u001a\u00020 H\u0002J \u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020%H\u0002J\b\u0010B\u001a\u00020 H\u0016J\b\u0010C\u001a\u00020 H\u0016J\u0018\u0010D\u001a\u00020 2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020G0FH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010H\u001a\u00020I*\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006S"}, d2={"Lcom/intellij/diff/tools/simple/AlignedDiffModelBase;", "Lcom/intellij/diff/tools/simple/AlignedDiffModel;", "diffRequest", "Lcom/intellij/diff/requests/DiffRequest;", "diffContext", "Lcom/intellij/diff/DiffContext;", "parent", "Ljavax/swing/JComponent;", "editor1", "Lcom/intellij/openapi/editor/ex/EditorEx;", "editor2", "syncScrollable", "Lcom/intellij/diff/tools/util/SyncScrollSupport$SyncScrollable;", "<init>", "(Lcom/intellij/diff/requests/DiffRequest;Lcom/intellij/diff/DiffContext;Ljavax/swing/JComponent;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/diff/tools/util/SyncScrollSupport$SyncScrollable;)V", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "textSettings", "Lcom/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings;", "Lorg/jetbrains/annotations/NotNull;", "getTextSettings", "()Lcom/intellij/diff/tools/util/base/TextDiffSettingsHolder$TextDiffSettings;", "changeInlays", "", "Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$ChangeInlay;", "mirrorInlays1", "Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$MirrorInlay;", "mirrorInlays2", "rangeHighlighters1", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "rangeHighlighters2", "scheduleRealignChanges", "", "needAlignChanges", "", "realignChanges", "calcPriority", "", "isLastLine", "isTop", "initInlays", "createAlignInlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$AlignDiffInlayRenderer;", "side", "Lcom/intellij/diff/util/Side;", "line", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "createGutterHighlighterIfNeeded", "inlay", "getEditor", "createMirrorInlay", "sourceSide", "sourceInlay", "targetLine", "getMirrorTargetLine", "getChangeBlockFor", "changeBlockMap", "Ljava/util/TreeMap;", "updateInlayHeights", "calcEffectiveVisualLinesHeight", "editor", "Lcom/intellij/openapi/editor/Editor;", "startLine", "endLine", "dispose", "clear", "disposeAndClear", "disposables", "", "Lcom/intellij/openapi/Disposable;", "range", "Lcom/intellij/diff/util/Range;", "Lcom/intellij/diff/tools/simple/AlignableChange;", "getRange", "(Lcom/intellij/diff/tools/simple/AlignableChange;)Lcom/intellij/diff/util/Range;", "MySoftWrapModelListener", "MyInlayModelListener", "AlignDiffInlayRenderer", "ChangeInlay", "MirrorInlay", "DiffInlayGutterMarkerRenderer", "intellij.platform.diff.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAlignedDiffModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlignedDiffModel.kt\ncom/intellij/diff/tools/simple/AlignedDiffModelBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,487:1\n1761#2,3:488\n774#2:491\n865#2,2:492\n774#2:494\n865#2,2:495\n1#3:497\n*S KotlinDebug\n*F\n+ 1 AlignedDiffModel.kt\ncom/intellij/diff/tools/simple/AlignedDiffModelBase\n*L\n133#1:488,3\n176#1:491\n176#1:492,2\n192#1:494\n192#1:495,2\n*E\n"})
public abstract class AlignedDiffModelBase
implements AlignedDiffModel {
    @NotNull
    private final DiffRequest diffRequest;
    @NotNull
    private final DiffContext diffContext;
    @NotNull
    private final EditorEx editor1;
    @NotNull
    private final EditorEx editor2;
    @NotNull
    private final SyncScrollSupport.SyncScrollable syncScrollable;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final List<ChangeInlay> changeInlays;
    @NotNull
    private final List<MirrorInlay> mirrorInlays1;
    @NotNull
    private final List<MirrorInlay> mirrorInlays2;
    @NotNull
    private final List<RangeHighlighter> rangeHighlighters1;
    @NotNull
    private final List<RangeHighlighter> rangeHighlighters2;

    public AlignedDiffModelBase(@NotNull DiffRequest diffRequest, @NotNull DiffContext diffContext, @NotNull JComponent parent, @NotNull EditorEx editor1, @NotNull EditorEx editor2, @NotNull SyncScrollSupport.SyncScrollable syncScrollable) {
        Intrinsics.checkNotNullParameter((Object)diffRequest, (String)"diffRequest");
        Intrinsics.checkNotNullParameter((Object)diffContext, (String)"diffContext");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        Intrinsics.checkNotNullParameter((Object)syncScrollable, (String)"syncScrollable");
        this.diffRequest = diffRequest;
        this.diffContext = diffContext;
        this.editor1 = editor1;
        this.editor2 = editor2;
        this.syncScrollable = syncScrollable;
        this.queue = new MergingUpdateQueue("SimpleAlignedDiffModel", 300, true, parent, (Disposable)this, null, false, 96, null);
        this.changeInlays = new ArrayList();
        this.mirrorInlays1 = new ArrayList();
        this.mirrorInlays2 = new ArrayList();
        this.rangeHighlighters1 = new ArrayList();
        this.rangeHighlighters2 = new ArrayList();
        MyInlayModelListener inlayListener = new MyInlayModelListener();
        this.editor1.getInlayModel().addListener((InlayModel.Listener)inlayListener, (Disposable)this);
        this.editor2.getInlayModel().addListener((InlayModel.Listener)inlayListener, (Disposable)this);
        MySoftWrapModelListener softWrapListener = new MySoftWrapModelListener();
        this.editor1.getSoftWrapModel().addSoftWrapChangeListener((SoftWrapChangeListener)softWrapListener);
        this.editor2.getSoftWrapModel().addSoftWrapChangeListener((SoftWrapChangeListener)softWrapListener);
    }

    @NotNull
    protected final TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.diffContext);
        Intrinsics.checkNotNullExpressionValue((Object)textDiffSettings, (String)"getTextSettings(...)");
        return textDiffSettings;
    }

    public final void scheduleRealignChanges() {
        if (!this.needAlignChanges()) {
            return;
        }
        this.queue.queue(Update.Companion.create((Object)"update", () -> AlignedDiffModelBase.scheduleRealignChanges$lambda$0(this)));
    }

    @Override
    public boolean needAlignChanges() {
        Boolean forcedValue;
        Boolean bl = (Boolean)this.diffRequest.getUserData(DiffUserDataKeys.ALIGNED_TWO_SIDED_DIFF);
        if (bl == null) {
            bl = (Boolean)this.diffContext.getUserData(DiffUserDataKeys.ALIGNED_TWO_SIDED_DIFF);
        }
        if ((forcedValue = bl) != null) {
            return forcedValue;
        }
        return this.getTextSettings().isEnableAligningChangesMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void realignChanges() {
        boolean bl;
        if (!this.needAlignChanges()) {
            return;
        }
        Object[] objectArray = new EditorEx[]{this.editor1, this.editor2};
        Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                EditorEx it = (EditorEx)element$iv;
                boolean bl2 = false;
                if (it.isDisposed()) return;
                FoldingModelEx foldingModelEx = it.getFoldingModel();
                Intrinsics.checkNotNull((Object)foldingModelEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
                if (((FoldingModelImpl)foldingModelEx).isInBatchFoldingOperation()) {
                    return;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        RecursionManager.doPreventingRecursion((Object)this, (boolean)true, () -> AlignedDiffModelBase.realignChanges$lambda$1(this));
    }

    private final int calcPriority(boolean isLastLine, boolean isTop) {
        return isLastLine ? (isTop ? Integer.MAX_VALUE : 0x7FFFFFFE) : (isTop ? 0x7FFFFFFE : Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    private final void initInlays() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        ChangeInlay changeBlock;
        void $this$filterTo$iv$iv2;
        Object changeInlay;
        TreeMap<Integer, ChangeInlay> map1 = new TreeMap<Integer, ChangeInlay>();
        TreeMap<Integer, ChangeInlay> map2 = new TreeMap<Integer, ChangeInlay>();
        for (AlignableChange alignableChange : this.getDiffChanges()) {
            Range range = this.getRange(alignableChange);
            changeInlay = new ChangeInlay(alignableChange, this.createAlignInlay(Side.LEFT, range.start1, true, alignableChange.getDiffType()), this.createAlignInlay(Side.RIGHT, range.start2, true, alignableChange.getDiffType()), this.createAlignInlay(Side.LEFT, range.end1, false, alignableChange.getDiffType()), this.createAlignInlay(Side.RIGHT, range.end2, false, alignableChange.getDiffType()));
            this.createGutterHighlighterIfNeeded(alignableChange.getDiffType(), Side.LEFT, ((ChangeInlay)changeInlay).getBottomInlay1());
            this.createGutterHighlighterIfNeeded(alignableChange.getDiffType(), Side.RIGHT, ((ChangeInlay)changeInlay).getBottomInlay2());
            ((Collection)this.changeInlays).add(changeInlay);
            ((Map)map1).put(range.start1, changeInlay);
            ((Map)map2).put(range.start2, changeInlay);
        }
        List list = this.editor1.getInlayModel().getBlockElementsInRange(0, this.editor1.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlockElementsInRange(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        changeInlay = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Inlay it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getRenderer() instanceof AlignDiffInlayRenderer))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inlays1 = (List)destination$iv$iv;
        for (Inlay sourceInlay : inlays1) {
            Intrinsics.checkNotNull((Object)sourceInlay);
            int targetLine = this.getMirrorTargetLine(Side.LEFT, sourceInlay);
            changeBlock = this.getChangeBlockFor(Side.LEFT, map1, targetLine);
            if (changeBlock != null) {
                ((Collection)changeBlock.getInnerSourceInlay1()).add(sourceInlay);
                continue;
            }
            ((Collection)this.mirrorInlays1).add(new MirrorInlay(sourceInlay, this.createMirrorInlay(Side.LEFT, sourceInlay, targetLine)));
        }
        List list2 = this.editor2.getInlayModel().getBlockElementsInRange(0, this.editor2.getDocument().getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBlockElementsInRange(...)");
        Iterable sourceInlay = list2;
        boolean $i$f$filter2 = false;
        changeBlock = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Inlay it = (Inlay)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getRenderer() instanceof AlignDiffInlayRenderer))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv2;
        for (Inlay sourceInlay2 : list3) {
            Intrinsics.checkNotNull((Object)sourceInlay2);
            int targetLine = this.getMirrorTargetLine(Side.RIGHT, sourceInlay2);
            ChangeInlay changeBlock2 = this.getChangeBlockFor(Side.RIGHT, map2, targetLine);
            if (changeBlock2 != null) {
                ((Collection)changeBlock2.getInnerSourceInlay2()).add(sourceInlay2);
                continue;
            }
            ((Collection)this.mirrorInlays2).add(new MirrorInlay(sourceInlay2, this.createMirrorInlay(Side.RIGHT, sourceInlay2, targetLine)));
        }
    }

    private final Inlay<AlignDiffInlayRenderer> createAlignInlay(Side side, int line, boolean isTop, TextDiffType diffType) {
        EditorEx editor = this.getEditor(side);
        boolean isLastLine = line == DiffUtil.getLineCount((Document)editor.getDocument());
        int offset = DiffUtil.getOffset((Document)editor.getDocument(), line, 0);
        InlayProperties properties = new InlayProperties().showAbove(!isLastLine).priority(this.calcPriority(isLastLine, isTop));
        Color color = isTop ? null : AlignableChange.Companion.getAlignedChangeColor(diffType, (Editor)editor);
        AlignDiffInlayRenderer inlayPresentation = new AlignDiffInlayRenderer(editor, color);
        Inlay inlay = editor.getInlayModel().addBlockElement(offset, properties, (EditorCustomElementRenderer)inlayPresentation);
        Intrinsics.checkNotNull((Object)inlay);
        return inlay;
    }

    private final void createGutterHighlighterIfNeeded(TextDiffType diffType, Side side, Inlay<AlignDiffInlayRenderer> inlay) {
        if (Intrinsics.areEqual((Object)diffType, (Object)TextDiffType.MODIFIED)) {
            return;
        }
        RangeHighlighter rangeHighlighter = this.getEditor(side).getMarkupModel().addRangeHighlighter(inlay.getOffset(), inlay.getOffset(), 6000, new TextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffInlayGutterMarkerRenderer(diffType, inlay));
        if (side == Side.LEFT) {
            ((Collection)this.rangeHighlighters1).add(highlighter);
        } else {
            ((Collection)this.rangeHighlighters2).add(highlighter);
        }
    }

    private final EditorEx getEditor(Side side) {
        return (EditorEx)side.selectNotNull((Object)this.editor1, (Object)this.editor2);
    }

    private final Inlay<AlignDiffInlayRenderer> createMirrorInlay(Side sourceSide, Inlay<?> sourceInlay, int targetLine) {
        Side side = sourceSide.other();
        EditorEx editor = this.getEditor(side);
        int offset = DiffUtil.getOffset((Document)editor.getDocument(), targetLine, 0);
        InlayProperties inlayProperties = new InlayProperties().showAbove(sourceInlay.getProperties().isShownAbove()).priority(sourceInlay.getProperties().getPriority());
        AlignDiffInlayRenderer inlayPresentation = new AlignDiffInlayRenderer(editor, null);
        return editor.getInlayModel().addBlockElement(offset, inlayProperties, (EditorCustomElementRenderer)inlayPresentation);
    }

    private final int getMirrorTargetLine(Side sourceSide, Inlay<?> sourceInlay) {
        EditorEx sourceEditor = this.getEditor(sourceSide);
        int sourceLine = sourceEditor.offsetToLogicalPosition((int)sourceInlay.getOffset()).line;
        return this.syncScrollable.transfer(sourceSide, sourceLine);
    }

    private final ChangeInlay getChangeBlockFor(Side sourceSide, TreeMap<Integer, ChangeInlay> changeBlockMap, int line) {
        Map.Entry<Integer, ChangeInlay> entry = changeBlockMap.ceilingEntry(line);
        if (entry == null || (entry = entry.getValue()) == null) {
            return null;
        }
        Map.Entry<Integer, ChangeInlay> block = entry;
        Range range = this.getRange(((ChangeInlay)((Object)block)).getChange());
        if (RangesBuilder.start(range, sourceSide) <= line && RangesBuilder.end(range, sourceSide) > line) {
            return block;
        }
        return null;
    }

    private final void updateInlayHeights() {
        Inlay<AlignDiffInlayRenderer> inlay;
        int last1 = 0;
        int last2 = 0;
        for (ChangeInlay changeInlay : this.changeInlays) {
            int n;
            Inlay it;
            int n2;
            Range range = this.getRange(changeInlay.getChange());
            int prefixDelta = this.calcEffectiveVisualLinesHeight((Editor)this.editor2, last2, range.start2) - this.calcEffectiveVisualLinesHeight((Editor)this.editor1, last1, range.start1);
            if (prefixDelta >= 0) {
                changeInlay.setTop(prefixDelta, 0);
            } else {
                changeInlay.setTop(0, -prefixDelta);
            }
            Iterable iterable = changeInlay.getInnerSourceInlay2();
            int n3 = this.calcEffectiveVisualLinesHeight((Editor)this.editor2, range.start2, range.end2) - this.calcEffectiveVisualLinesHeight((Editor)this.editor1, range.start1, range.end1);
            int n4 = 0;
            for (Object t : iterable) {
                Inlay inlay2 = (Inlay)t;
                n2 = n4;
                boolean bl = false;
                n = it.getHeightInPixels();
                n4 = n2 + n;
            }
            n2 = n4;
            iterable = changeInlay.getInnerSourceInlay1();
            n3 += n2;
            n4 = 0;
            for (Object t : iterable) {
                it = (Inlay)t;
                n2 = n4;
                boolean bl = false;
                n = it.getHeightInPixels();
                n4 = n2 + n;
            }
            n2 = n4;
            int bodyDelta = n3 - n2;
            if (bodyDelta >= 0) {
                changeInlay.setBottom(bodyDelta, 0);
            } else {
                changeInlay.setBottom(0, -bodyDelta);
            }
            last1 = range.end1;
            last2 = range.end2;
        }
        for (MirrorInlay mirrorInlay : this.mirrorInlays1) {
            if (mirrorInlay.getInlay() == null) continue;
            ((AlignDiffInlayRenderer)inlay.getRenderer()).setHeight(mirrorInlay.getSourceInlay().getHeightInPixels());
            inlay.update();
        }
        for (MirrorInlay mirrorInlay : this.mirrorInlays2) {
            if (mirrorInlay.getInlay() == null) continue;
            ((AlignDiffInlayRenderer)inlay.getRenderer()).setHeight(mirrorInlay.getSourceInlay().getHeightInPixels());
            inlay.update();
        }
    }

    private final int calcEffectiveVisualLinesHeight(Editor editor, int startLine, int endLine) {
        if (startLine == endLine) {
            return 0;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineCount = document2.getLineCount();
        if (lineCount == 0) {
            return 0;
        }
        int vLine1 = editor.offsetToVisualLine(document2.getLineStartOffset(startLine), false);
        int vLine2 = endLine == lineCount ? editor.offsetToVisualLine(document2.getLineStartOffset(endLine - 1), false) + 1 : editor.offsetToVisualLine(document2.getLineStartOffset(endLine), false);
        return editor.getLineHeight() * (vLine2 - vLine1);
    }

    public void dispose() {
    }

    @Override
    public void clear() {
        this.disposeAndClear((Collection<? extends Disposable>)this.changeInlays);
        this.disposeAndClear((Collection<? extends Disposable>)this.mirrorInlays1);
        this.disposeAndClear((Collection<? extends Disposable>)this.mirrorInlays2);
        for (RangeHighlighter highlighter : this.rangeHighlighters1) {
            this.editor1.getMarkupModel().removeHighlighter(highlighter);
        }
        this.rangeHighlighters1.clear();
        for (RangeHighlighter highlighter : this.rangeHighlighters2) {
            this.editor2.getMarkupModel().removeHighlighter(highlighter);
        }
        this.rangeHighlighters2.clear();
    }

    private final void disposeAndClear(Collection<? extends Disposable> disposables) {
        for (Disposable disposable : disposables) {
            Disposer.dispose((Disposable)disposable);
        }
        disposables.clear();
    }

    private final Range getRange(AlignableChange $this$range) {
        return new Range($this$range.getStartLine(Side.LEFT), $this$range.getEndLine(Side.LEFT), $this$range.getStartLine(Side.RIGHT), $this$range.getEndLine(Side.RIGHT));
    }

    private static final void scheduleRealignChanges$lambda$0(AlignedDiffModelBase this$0) {
        this$0.realignChanges();
    }

    private static final Unit realignChanges$lambda$1(AlignedDiffModelBase this$0) {
        this$0.clear();
        this$0.initInlays();
        this$0.updateInlayHeights();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0014\u0010\u0019\u001a\u00020\t2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$AlignDiffInlayRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "inlayColor", "Ljava/awt/Color;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Ljava/awt/Color;)V", "height", "", "getHeight", "()I", "setHeight", "(I)V", "paint", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "calcWidthInPixels", "calcHeightInPixels", "intellij.platform.diff.impl"})
    private static final class AlignDiffInlayRenderer
    implements EditorCustomElementRenderer {
        @NotNull
        private final EditorEx editor;
        @Nullable
        private final Color inlayColor;
        private int height;

        public AlignDiffInlayRenderer(@NotNull EditorEx editor, @Nullable Color inlayColor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.inlayColor = inlayColor;
        }

        public /* synthetic */ AlignDiffInlayRenderer(EditorEx editorEx, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                color = null;
            }
            this(editorEx, color);
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            Color color = this.inlayColor;
            if (color == null) {
                return;
            }
            Color paintColor = color;
            g.setColor(paintColor);
            g.fillRect(targetRegion.x, targetRegion.y, targetRegion.width, targetRegion.height);
        }

        public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            EditorEx editorEx = this.editor;
            Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            int n = ((EditorImpl)editorEx).getPreferredSize().width;
            int n2 = ((EditorImpl)this.editor).getComponent().getWidth();
            return Math.max(n, n2);
        }

        public int calcHeightInPixels(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return this.height;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001f\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u001b\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$ChangeInlay;", "Lcom/intellij/openapi/Disposable;", "change", "Lcom/intellij/diff/tools/simple/AlignableChange;", "topInlay1", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$AlignDiffInlayRenderer;", "topInlay2", "bottomInlay1", "bottomInlay2", "<init>", "(Lcom/intellij/diff/tools/simple/AlignableChange;Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/openapi/editor/Inlay;)V", "getChange", "()Lcom/intellij/diff/tools/simple/AlignableChange;", "getTopInlay1", "()Lcom/intellij/openapi/editor/Inlay;", "getTopInlay2", "getBottomInlay1", "getBottomInlay2", "innerSourceInlay1", "", "getInnerSourceInlay1", "()Ljava/util/List;", "innerSourceInlay2", "getInnerSourceInlay2", "setTop", "", "height1", "", "height2", "setBottom", "dispose", "intellij.platform.diff.impl"})
    private static final class ChangeInlay
    implements Disposable {
        @NotNull
        private final AlignableChange change;
        @NotNull
        private final Inlay<AlignDiffInlayRenderer> topInlay1;
        @NotNull
        private final Inlay<AlignDiffInlayRenderer> topInlay2;
        @NotNull
        private final Inlay<AlignDiffInlayRenderer> bottomInlay1;
        @NotNull
        private final Inlay<AlignDiffInlayRenderer> bottomInlay2;
        @NotNull
        private final List<Inlay<?>> innerSourceInlay1;
        @NotNull
        private final List<Inlay<?>> innerSourceInlay2;

        public ChangeInlay(@NotNull AlignableChange change, @NotNull Inlay<AlignDiffInlayRenderer> topInlay1, @NotNull Inlay<AlignDiffInlayRenderer> topInlay2, @NotNull Inlay<AlignDiffInlayRenderer> bottomInlay1, @NotNull Inlay<AlignDiffInlayRenderer> bottomInlay2) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter(topInlay1, (String)"topInlay1");
            Intrinsics.checkNotNullParameter(topInlay2, (String)"topInlay2");
            Intrinsics.checkNotNullParameter(bottomInlay1, (String)"bottomInlay1");
            Intrinsics.checkNotNullParameter(bottomInlay2, (String)"bottomInlay2");
            this.change = change;
            this.topInlay1 = topInlay1;
            this.topInlay2 = topInlay2;
            this.bottomInlay1 = bottomInlay1;
            this.bottomInlay2 = bottomInlay2;
            this.innerSourceInlay1 = new ArrayList();
            this.innerSourceInlay2 = new ArrayList();
        }

        @NotNull
        public final AlignableChange getChange() {
            return this.change;
        }

        @NotNull
        public final Inlay<AlignDiffInlayRenderer> getTopInlay1() {
            return this.topInlay1;
        }

        @NotNull
        public final Inlay<AlignDiffInlayRenderer> getTopInlay2() {
            return this.topInlay2;
        }

        @NotNull
        public final Inlay<AlignDiffInlayRenderer> getBottomInlay1() {
            return this.bottomInlay1;
        }

        @NotNull
        public final Inlay<AlignDiffInlayRenderer> getBottomInlay2() {
            return this.bottomInlay2;
        }

        @NotNull
        public final List<Inlay<?>> getInnerSourceInlay1() {
            return this.innerSourceInlay1;
        }

        @NotNull
        public final List<Inlay<?>> getInnerSourceInlay2() {
            return this.innerSourceInlay2;
        }

        public final void setTop(int height1, int height2) {
            ((AlignDiffInlayRenderer)this.topInlay1.getRenderer()).setHeight(height1);
            this.topInlay1.update();
            ((AlignDiffInlayRenderer)this.topInlay2.getRenderer()).setHeight(height2);
            this.topInlay2.update();
        }

        public final void setBottom(int height1, int height2) {
            ((AlignDiffInlayRenderer)this.bottomInlay1.getRenderer()).setHeight(height1);
            this.bottomInlay1.update();
            ((AlignDiffInlayRenderer)this.bottomInlay2.getRenderer()).setHeight(height2);
            this.bottomInlay2.update();
        }

        public void dispose() {
            Disposer.dispose((Disposable)((Disposable)this.topInlay1));
            Disposer.dispose((Disposable)((Disposable)this.topInlay2));
            Disposer.dispose((Disposable)((Disposable)this.bottomInlay1));
            Disposer.dispose((Disposable)((Disposable)this.bottomInlay2));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$DiffInlayGutterMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "type", "Lcom/intellij/diff/util/TextDiffType;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "<init>", "(Lcom/intellij/diff/util/TextDiffType;Lcom/intellij/openapi/editor/Inlay;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "getPosition", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "intellij.platform.diff.impl"})
    private static final class DiffInlayGutterMarkerRenderer
    implements LineMarkerRendererEx {
        @NotNull
        private final TextDiffType type;
        @NotNull
        private final Inlay<?> inlay;

        public DiffInlayGutterMarkerRenderer(@NotNull TextDiffType type, @NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            this.type = type;
            this.inlay = inlay;
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            EditorEx cfr_ignored_0 = (EditorEx)editor;
            Graphics2D cfr_ignored_1 = (Graphics2D)g;
            if (this.inlay instanceof RangeMarker) {
                EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor).getGutterComponentEx();
                Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
                EditorGutterComponentEx gutter = editorGutterComponentEx;
                int inlayHeight = this.inlay.getHeightInPixels();
                Color preservedBackground = ((Graphics2D)g).getBackground();
                Rectangle rectangle = this.inlay.getBounds();
                if (rectangle == null) {
                    return;
                }
                int y = rectangle.y;
                ((Graphics2D)g).setColor(AlignableChange.Companion.getAlignedChangeColor(this.type, editor));
                g.fillRect(0, y, gutter.getWidth(), inlayHeight);
                ((Graphics2D)g).setColor(preservedBackground);
            }
        }

        @NotNull
        public LineMarkerRendererEx.Position getPosition() {
            return LineMarkerRendererEx.Position.CUSTOM;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$MirrorInlay;", "Lcom/intellij/openapi/Disposable;", "sourceInlay", "Lcom/intellij/openapi/editor/Inlay;", "inlay", "Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$AlignDiffInlayRenderer;", "<init>", "(Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/openapi/editor/Inlay;)V", "getSourceInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getInlay", "dispose", "", "intellij.platform.diff.impl"})
    private static final class MirrorInlay
    implements Disposable {
        @NotNull
        private final Inlay<?> sourceInlay;
        @Nullable
        private final Inlay<AlignDiffInlayRenderer> inlay;

        public MirrorInlay(@NotNull Inlay<?> sourceInlay, @Nullable Inlay<AlignDiffInlayRenderer> inlay) {
            Intrinsics.checkNotNullParameter(sourceInlay, (String)"sourceInlay");
            this.sourceInlay = sourceInlay;
            this.inlay = inlay;
        }

        @NotNull
        public final Inlay<?> getSourceInlay() {
            return this.sourceInlay;
        }

        @Nullable
        public final Inlay<AlignDiffInlayRenderer> getInlay() {
            return this.inlay;
        }

        public void dispose() {
            if (this.inlay != null) {
                Disposer.dispose((Disposable)((Disposable)this.inlay));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u001c\u0010\t\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$MyInlayModelListener;", "Lcom/intellij/openapi/editor/InlayModel$Listener;", "<init>", "(Lcom/intellij/diff/tools/simple/AlignedDiffModelBase;)V", "onAdded", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "onRemoved", "onUpdated", "changeFlags", "", "intellij.platform.diff.impl"})
    private final class MyInlayModelListener
    implements InlayModel.Listener {
        public void onAdded(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            if (inlay.getRenderer() instanceof AlignDiffInlayRenderer) {
                return;
            }
            AlignedDiffModelBase.this.scheduleRealignChanges();
        }

        public void onRemoved(@NotNull Inlay<?> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            if (inlay.getRenderer() instanceof AlignDiffInlayRenderer) {
                return;
            }
            AlignedDiffModelBase.this.scheduleRealignChanges();
        }

        public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            if (inlay.getRenderer() instanceof AlignDiffInlayRenderer) {
                return;
            }
            if ((changeFlags & 2) != 0) {
                AlignedDiffModelBase.this.scheduleRealignChanges();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diff/tools/simple/AlignedDiffModelBase$MySoftWrapModelListener;", "Lcom/intellij/openapi/editor/ex/SoftWrapChangeListener;", "<init>", "(Lcom/intellij/diff/tools/simple/AlignedDiffModelBase;)V", "softWrapsChanged", "", "recalculationEnds", "intellij.platform.diff.impl"})
    private final class MySoftWrapModelListener
    implements SoftWrapChangeListener {
        public void softWrapsChanged() {
            if (!AlignedDiffModelBase.this.getTextSettings().isUseSoftWraps()) {
                AlignedDiffModelBase.this.scheduleRealignChanges();
            }
        }

        public void recalculationEnds() {
            AlignedDiffModelBase.this.scheduleRealignChanges();
        }
    }
}

