/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusPanel
extends JPanel {
    private final JLabel myTextLabel = new JLabel("");
    private final AnimatedIcon myBusySpinner;

    public StatusPanel() {
        super(new GridBagLayout());
        this.myTextLabel.setVisible(false);
        this.myBusySpinner = new AsyncProcessIcon("StatusPanelSpinner");
        this.myBusySpinner.setVisible(false);
        this.myBusySpinner.setToolTipText(DiffBundle.message((String)"diff.progress.spinner.tooltip.text", (Object[])new Object[0]));
        GridBag bag = new GridBag().setDefaultInsets((Insets)JBInsets.create((int)0, (int)2)).setDefaultFill(1).setDefaultWeightY(1.0);
        this.add((Component)this.myBusySpinner, bag.next());
        this.add((Component)this.myTextLabel, bag.next().weightx(1.0));
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
    }

    public void update() {
        String message = this.getMessage();
        this.myTextLabel.setVisible(message != null);
        this.myTextLabel.setText(message);
        this.myTextLabel.setIcon(this.getStatusIcon());
        this.myTextLabel.setForeground(this.getStatusForeground());
    }

    public void setBusy(boolean busy) {
        if (busy) {
            this.myBusySpinner.setVisible(true);
            this.myBusySpinner.resume();
        } else {
            this.myBusySpinner.setVisible(false);
            this.myBusySpinner.suspend();
        }
    }

    @NlsContexts.Label
    @Nullable
    protected String getMessage() {
        return null;
    }

    @Nullable
    protected Icon getStatusIcon() {
        return null;
    }

    @NotNull
    protected Color getStatusForeground() {
        Color color = UIUtil.getLabelForeground();
        if (color == null) {
            StatusPanel.$$$reportNull$$$0(0);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/StatusPanel", "getStatusForeground"));
    }
}

