/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineNumberConverter;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DiffLineNumberConverter
implements LineNumberConverter {
    @Nullable
    private final IntPredicate myFoldingHiddenLines;
    @Nullable
    private final IntUnaryOperator myLineConverter;

    public DiffLineNumberConverter(@Nullable IntPredicate foldingPredicate, @Nullable IntUnaryOperator function) {
        this.myFoldingHiddenLines = foldingPredicate;
        this.myLineConverter = function;
    }

    public Integer convert(@NotNull Editor editor, int lineNumber) {
        if (editor == null) {
            DiffLineNumberConverter.$$$reportNull$$$0(0);
        }
        return this.convertImpl(lineNumber, true);
    }

    public Integer getMaxLineNumber(@NotNull Editor editor) {
        if (editor == null) {
            DiffLineNumberConverter.$$$reportNull$$$0(1);
        }
        for (int i = editor.getDocument().getLineCount(); i > 0; --i) {
            Integer number = this.convertImpl(i, false);
            if (number == null) continue;
            return number;
        }
        return 0;
    }

    @Nullable
    public Integer convertImpl(int lineNumber, boolean hideFoldingLines) {
        int zeroBaseNumber = lineNumber - 1;
        if (hideFoldingLines && this.myFoldingHiddenLines != null && this.myFoldingHiddenLines.test(zeroBaseNumber)) {
            return null;
        }
        if (this.myLineConverter != null) {
            zeroBaseNumber = this.myLineConverter.applyAsInt(zeroBaseNumber);
        }
        return zeroBaseNumber < 0 ? null : Integer.valueOf(zeroBaseNumber + 1);
    }

    @Nullable
    public String convertLineNumberToStringImpl(int lineNumber, boolean hideFoldingLines) {
        Integer converted = this.convertImpl(lineNumber, hideFoldingLines);
        return converted == null ? null : String.valueOf(converted);
    }

    public boolean hasCustomLineNumbers() {
        return this.myLineConverter != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/diff/util/DiffLineNumberConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMaxLineNumber";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

