/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DefaultFlagsProvider;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.ActiveLineStatusGutterMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupService;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRangesSource;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRendererWithPopupController;
import com.intellij.openapi.vcs.ex.Range;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 02\u00020\u00012\u00020\u0002:\u0002/0BC\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015J \u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u000f\u0010\"\u001a\t\u0018\u00010#\u00a2\u0006\u0002\b$H\u0014J*\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\t\u001a\u00020\nH$J \u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!J\b\u0010(\u001a\u00020)H\u0004J\b\u0010*\u001a\u00020\u000eH\u0014J&\u0010+\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010-\u001a\u00020.H\u0014R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00061"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopup;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopupController;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "rangesSource", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRangesSource;", "disposable", "Lcom/intellij/openapi/Disposable;", "editorFilter", "Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;", "isMain", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRangesSource;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;Z)V", "getRangesSource", "()Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRangesSource;", "getRanges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "scrollAndShow", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "showAfterScroll", "showHint", "e", "Ljava/awt/event/MouseEvent;", "showHintAt", "mousePosition", "Ljava/awt/Point;", "getTooltipText", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "createPopupPanel", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupPanel;", "reopenRange", "createGutterMarkerRenderer", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "shouldPaintGutter", "paintGutterMarkers", "ranges", "g", "Ljava/awt/Graphics;", "LineStatusGutterMarkerRendererWithPopup", "Companion", "intellij.platform.diff.impl"})
public abstract class LineStatusMarkerRendererWithPopup
extends LineStatusMarkerRenderer
implements LineStatusMarkerRendererWithPopupController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineStatusMarkerRangesSource<?> rangesSource;

    public LineStatusMarkerRendererWithPopup(@Nullable Project project, @NotNull Document document, @NotNull LineStatusMarkerRangesSource<?> rangesSource, @NotNull Disposable disposable, @Nullable MarkupEditorFilter editorFilter, boolean isMain) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(rangesSource, (String)"rangesSource");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(project, document, disposable, editorFilter, isMain);
        this.rangesSource = rangesSource;
    }

    public /* synthetic */ LineStatusMarkerRendererWithPopup(Project project, Document document, LineStatusMarkerRangesSource lineStatusMarkerRangesSource, Disposable disposable, MarkupEditorFilter markupEditorFilter, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            markupEditorFilter = null;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(project, document, lineStatusMarkerRangesSource, disposable, markupEditorFilter, bl);
    }

    @NotNull
    protected final LineStatusMarkerRangesSource<?> getRangesSource() {
        return this.rangesSource;
    }

    @Override
    @Nullable
    protected final List<Range> getRanges() {
        return this.rangesSource.getRanges();
    }

    @Override
    public void scrollAndShow(@NotNull Editor editor, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (!this.rangesSource.isValid()) {
            return;
        }
        Companion.moveToRange(editor, range);
        this.showAfterScroll(editor, range);
    }

    @Override
    public final void showAfterScroll(@NotNull Editor editor, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        editor.getScrollingModel().runActionOnScrollingFinished(() -> LineStatusMarkerRendererWithPopup.showAfterScroll$lambda$0(this, editor, range));
    }

    private final void showHint(Editor editor, Range range, MouseEvent e) {
        Component component2 = e.getComponent();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent comp = (JComponent)component2;
        JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
        Component component3 = comp;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        Point point = SwingUtilities.convertPoint(component3, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
        this.showHintAt(editor, range, point);
        e.consume();
    }

    @Override
    public void showHintAt(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (!this.rangesSource.isValid()) {
            return;
        }
        DiffUsageTriggerCollector.logShowMarkerPopup(this.getProject());
        LineStatusMarkerPopupService.Companion.getInstance().buildAndShowPopup(this.getDisposable(), editor, mousePosition, (Function1<? super Disposable, ? extends LineStatusMarkerPopupPanel>)((Function1)arg_0 -> LineStatusMarkerRendererWithPopup.showHintAt$lambda$0(this, editor, range, mousePosition, arg_0)));
    }

    @Nullable
    protected String getTooltipText() {
        return null;
    }

    @NotNull
    protected abstract LineStatusMarkerPopupPanel createPopupPanel(@NotNull Editor var1, @NotNull Range var2, @Nullable Point var3, @NotNull Disposable var4);

    @Override
    public final void reopenRange(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Object newRange = this.rangesSource.findRange(range);
        if (newRange != null) {
            this.showHintAt(editor, (Range)newRange, mousePosition);
        } else {
            HintManagerImpl.getInstanceImpl().hideHints(32, false, false);
        }
    }

    @Override
    @NotNull
    protected final LineMarkerRenderer createGutterMarkerRenderer() {
        return (LineMarkerRenderer)new LineStatusGutterMarkerRendererWithPopup();
    }

    protected boolean shouldPaintGutter() {
        return true;
    }

    protected void paintGutterMarkers(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        LineStatusMarkerDrawUtil.paintDefault(editor, g, ranges, DefaultFlagsProvider.DEFAULT, 0);
    }

    private static final void showAfterScroll$lambda$0(LineStatusMarkerRendererWithPopup this$0, Editor $editor, Range $range) {
        this$0.reopenRange($editor, $range, null);
    }

    private static final LineStatusMarkerPopupPanel showHintAt$lambda$0(LineStatusMarkerRendererWithPopup this$0, Editor $editor, Range $range, Point $mousePosition, Disposable popupDisposable) {
        Intrinsics.checkNotNullParameter((Object)popupDisposable, (String)"popupDisposable");
        return this$0.createPopupPanel($editor, $range, $mousePosition, popupDisposable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopup$Companion;", "", "<init>", "()V", "moveToRange", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void moveToRange(@NotNull Editor editor, @NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int targetLine = !range.hasLines() ? range.getLine2() : range.getLine2() - 1;
            int line = Math.min(targetLine, DiffUtil.getLineCount(document2) - 1);
            int lastOffset = document2.getLineStartOffset(line);
            editor.getCaretModel().moveToOffset(lastOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0014J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J&\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u000f\u0010\u0015\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopup$LineStatusGutterMarkerRendererWithPopup;", "Lcom/intellij/openapi/vcs/ex/ActiveLineStatusGutterMarkerRenderer;", "<init>", "(Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRendererWithPopup;)V", "getPaintedRanges", "", "Lcom/intellij/openapi/vcs/ex/Range;", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "canDoAction", "", "ranges", "e", "Ljava/awt/event/MouseEvent;", "doAction", "getTooltipText", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "intellij.platform.diff.impl"})
    private final class LineStatusGutterMarkerRendererWithPopup
    extends ActiveLineStatusGutterMarkerRenderer {
        @Override
        @Nullable
        protected List<Range> getPaintedRanges() {
            List list;
            if (LineStatusMarkerRendererWithPopup.this.shouldPaintGutter()) {
                list = LineStatusMarkerRendererWithPopup.this.getRangesSource().getRanges();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
            } else {
                list = null;
            }
            return list;
        }

        @Override
        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            List<Range> list = this.getPaintedRanges();
            if (list == null) {
                return;
            }
            List<Range> ranges = list;
            LineStatusMarkerRendererWithPopup.this.paintGutterMarkers(editor, ranges, g);
        }

        @Override
        protected boolean canDoAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return LineStatusMarkerDrawUtil.isInsideMarkerArea(e);
        }

        @Override
        protected void doAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Range range = ranges.get(0);
            if (ranges.size() > 1) {
                LineStatusMarkerRendererWithPopup.this.scrollAndShow(editor, range);
            } else {
                LineStatusMarkerRendererWithPopup.this.showHint(editor, range, e);
            }
        }

        @Nullable
        public String getTooltipText() {
            return LineStatusMarkerRendererWithPopup.this.getTooltipText();
        }
    }
}

