/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJR\u0010\u000f\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00102\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J>\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/ex/RangeChangeHandler;", "", "<init>", "()V", "run", "Lcom/intellij/openapi/vcs/ex/RangeChangeHandler$Result;", "blocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "side", "Lcom/intellij/diff/util/Side;", "startLine", "", "beforeLength", "afterLength", "sortRanges", "Lkotlin/Triple;", "line1", "line2", "getOurToOtherShift", "beforeBlocks", "getNewAffectedBlock", "endLine", "rangeSizeDelta", "ourToOtherShift", "affectedBlocks", "Result", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nDocumentTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/RangeChangeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1374:1\n1563#2:1375\n1634#2,3:1376\n1761#2,3:1379\n*S KotlinDebug\n*F\n+ 1 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/RangeChangeHandler\n*L\n778#1:1375\n778#1:1376,3\n870#1:1379,3\n*E\n"})
final class RangeChangeHandler {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Result run(@NotNull List<DocumentTracker.Block> blocks, @NotNull Side side, int startLine, int beforeLength, int afterLength) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        int endLine = startLine + beforeLength;
        int rangeSizeDelta = afterLength - beforeLength;
        Triple<List<DocumentTracker.Block>, List<DocumentTracker.Block>, List<DocumentTracker.Block>> triple = this.sortRanges(blocks, side, startLine, endLine);
        List beforeBlocks = (List)triple.component1();
        List affectedBlocks = (List)triple.component2();
        List afterBlocks = (List)triple.component3();
        int ourToOtherShift = this.getOurToOtherShift(side, beforeBlocks);
        DocumentTracker.Block newAffectedBlock = this.getNewAffectedBlock(side, startLine, endLine, rangeSizeDelta, ourToOtherShift, affectedBlocks);
        Iterable $this$map$iv = afterBlocks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentTracker.Block block = (DocumentTracker.Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DocumentTrackerKt.access$shift((DocumentTracker.Block)it, side, rangeSizeDelta));
        }
        List newAfterBlocks = (List)destination$iv$iv;
        ArrayList<DocumentTracker.Block> newBlocks = new ArrayList<DocumentTracker.Block>(beforeBlocks.size() + newAfterBlocks.size() + 1);
        newBlocks.addAll(beforeBlocks);
        newBlocks.add(newAffectedBlock);
        newBlocks.addAll(newAfterBlocks);
        return new Result(beforeBlocks, (List<DocumentTracker.Block>)newBlocks, affectedBlocks, afterBlocks, newAffectedBlock, newAfterBlocks);
    }

    private final Triple<List<DocumentTracker.Block>, List<DocumentTracker.Block>, List<DocumentTracker.Block>> sortRanges(List<DocumentTracker.Block> blocks, Side side, int line1, int line2) {
        ArrayList<DocumentTracker.Block> beforeChange = new ArrayList<DocumentTracker.Block>();
        ArrayList<DocumentTracker.Block> affected = new ArrayList<DocumentTracker.Block>();
        ArrayList<DocumentTracker.Block> afterChange = new ArrayList<DocumentTracker.Block>();
        for (DocumentTracker.Block block : blocks) {
            boolean bl = RangesBuilder.end(block.getRange(), side) < line1 ? beforeChange.add(block) : (RangesBuilder.start(block.getRange(), side) > line2 ? afterChange.add(block) : affected.add(block));
        }
        return new Triple(beforeChange, affected, afterChange);
    }

    private final int getOurToOtherShift(Side side, List<DocumentTracker.Block> beforeBlocks) {
        DocumentTracker.Block block = (DocumentTracker.Block)CollectionsKt.lastOrNull(beforeBlocks);
        Range lastBefore = block != null ? block.getRange() : null;
        int otherShift = 0;
        otherShift = lastBefore == null ? 0 : RangesBuilder.end(lastBefore, side.other()) - RangesBuilder.end(lastBefore, side);
        return otherShift;
    }

    private final DocumentTracker.Block getNewAffectedBlock(Side side, int startLine, int endLine, int rangeSizeDelta, int ourToOtherShift, List<DocumentTracker.Block> affectedBlocks) {
        boolean bl;
        int rangeEndOther;
        int rangeStartOther;
        int rangeEnd;
        int rangeStart;
        block9: {
            rangeStart = 0;
            rangeEnd = 0;
            rangeStartOther = 0;
            rangeEndOther = 0;
            if (affectedBlocks.isEmpty()) {
                rangeStart = startLine;
                rangeEnd = endLine + rangeSizeDelta;
                rangeStartOther = startLine + ourToOtherShift;
                rangeEndOther = endLine + ourToOtherShift;
            } else {
                Range firstAffected = ((DocumentTracker.Block)CollectionsKt.first(affectedBlocks)).getRange();
                Range lastAffected = ((DocumentTracker.Block)CollectionsKt.last(affectedBlocks)).getRange();
                int affectedStart = RangesBuilder.start(firstAffected, side);
                int affectedStartOther = RangesBuilder.start(firstAffected, side.other());
                int affectedEnd = RangesBuilder.end(lastAffected, side);
                int affectedEndOther = RangesBuilder.end(lastAffected, side.other());
                if (affectedStart <= startLine) {
                    rangeStart = affectedStart;
                    rangeStartOther = affectedStartOther;
                } else {
                    rangeStart = startLine;
                    rangeStartOther = startLine + (affectedStartOther - affectedStart);
                }
                if (affectedEnd >= endLine) {
                    rangeEnd = affectedEnd + rangeSizeDelta;
                    rangeEndOther = affectedEndOther;
                } else {
                    rangeEnd = endLine + rangeSizeDelta;
                    rangeEndOther = endLine + (affectedEndOther - affectedEnd);
                }
            }
            Iterable $this$any$iv = affectedBlocks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                    boolean bl2 = false;
                    if (!it.isTooBig$intellij_platform_diff_impl()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean isTooBig = bl;
        Range range = DocumentTrackerKt.access$createRange(side, rangeStart, rangeEnd, rangeStartOther, rangeEndOther);
        return new DocumentTracker.Block(range, true, isTooBig);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003Jc\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/ex/RangeChangeHandler$Result;", "", "beforeBlocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "newBlocks", "affectedBlocks", "afterBlocks", "newAffectedBlock", "newAfterBlocks", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "getBeforeBlocks", "()Ljava/util/List;", "getNewBlocks", "getAffectedBlocks", "getAfterBlocks", "getNewAffectedBlock", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getNewAfterBlocks", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.diff.impl"})
    public static final class Result {
        @NotNull
        private final List<DocumentTracker.Block> beforeBlocks;
        @NotNull
        private final List<DocumentTracker.Block> newBlocks;
        @NotNull
        private final List<DocumentTracker.Block> affectedBlocks;
        @NotNull
        private final List<DocumentTracker.Block> afterBlocks;
        @NotNull
        private final DocumentTracker.Block newAffectedBlock;
        @NotNull
        private final List<DocumentTracker.Block> newAfterBlocks;

        public Result(@NotNull List<DocumentTracker.Block> beforeBlocks, @NotNull List<DocumentTracker.Block> newBlocks, @NotNull List<DocumentTracker.Block> affectedBlocks, @NotNull List<DocumentTracker.Block> afterBlocks, @NotNull DocumentTracker.Block newAffectedBlock, @NotNull List<DocumentTracker.Block> newAfterBlocks) {
            Intrinsics.checkNotNullParameter(beforeBlocks, (String)"beforeBlocks");
            Intrinsics.checkNotNullParameter(newBlocks, (String)"newBlocks");
            Intrinsics.checkNotNullParameter(affectedBlocks, (String)"affectedBlocks");
            Intrinsics.checkNotNullParameter(afterBlocks, (String)"afterBlocks");
            Intrinsics.checkNotNullParameter((Object)newAffectedBlock, (String)"newAffectedBlock");
            Intrinsics.checkNotNullParameter(newAfterBlocks, (String)"newAfterBlocks");
            this.beforeBlocks = beforeBlocks;
            this.newBlocks = newBlocks;
            this.affectedBlocks = affectedBlocks;
            this.afterBlocks = afterBlocks;
            this.newAffectedBlock = newAffectedBlock;
            this.newAfterBlocks = newAfterBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getBeforeBlocks() {
            return this.beforeBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getNewBlocks() {
            return this.newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getAffectedBlocks() {
            return this.affectedBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> getAfterBlocks() {
            return this.afterBlocks;
        }

        @NotNull
        public final DocumentTracker.Block getNewAffectedBlock() {
            return this.newAffectedBlock;
        }

        @NotNull
        public final List<DocumentTracker.Block> getNewAfterBlocks() {
            return this.newAfterBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component1() {
            return this.beforeBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component2() {
            return this.newBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component3() {
            return this.affectedBlocks;
        }

        @NotNull
        public final List<DocumentTracker.Block> component4() {
            return this.afterBlocks;
        }

        @NotNull
        public final DocumentTracker.Block component5() {
            return this.newAffectedBlock;
        }

        @NotNull
        public final List<DocumentTracker.Block> component6() {
            return this.newAfterBlocks;
        }

        @NotNull
        public final Result copy(@NotNull List<DocumentTracker.Block> beforeBlocks, @NotNull List<DocumentTracker.Block> newBlocks, @NotNull List<DocumentTracker.Block> affectedBlocks, @NotNull List<DocumentTracker.Block> afterBlocks, @NotNull DocumentTracker.Block newAffectedBlock, @NotNull List<DocumentTracker.Block> newAfterBlocks) {
            Intrinsics.checkNotNullParameter(beforeBlocks, (String)"beforeBlocks");
            Intrinsics.checkNotNullParameter(newBlocks, (String)"newBlocks");
            Intrinsics.checkNotNullParameter(affectedBlocks, (String)"affectedBlocks");
            Intrinsics.checkNotNullParameter(afterBlocks, (String)"afterBlocks");
            Intrinsics.checkNotNullParameter((Object)newAffectedBlock, (String)"newAffectedBlock");
            Intrinsics.checkNotNullParameter(newAfterBlocks, (String)"newAfterBlocks");
            return new Result(beforeBlocks, newBlocks, affectedBlocks, afterBlocks, newAffectedBlock, newAfterBlocks);
        }

        public static /* synthetic */ Result copy$default(Result result, List list, List list2, List list3, List list4, DocumentTracker.Block block, List list5, int n, Object object) {
            if ((n & 1) != 0) {
                list = result.beforeBlocks;
            }
            if ((n & 2) != 0) {
                list2 = result.newBlocks;
            }
            if ((n & 4) != 0) {
                list3 = result.affectedBlocks;
            }
            if ((n & 8) != 0) {
                list4 = result.afterBlocks;
            }
            if ((n & 0x10) != 0) {
                block = result.newAffectedBlock;
            }
            if ((n & 0x20) != 0) {
                list5 = result.newAfterBlocks;
            }
            return result.copy(list, list2, list3, list4, block, list5);
        }

        @NotNull
        public String toString() {
            return "Result(beforeBlocks=" + this.beforeBlocks + ", newBlocks=" + this.newBlocks + ", affectedBlocks=" + this.affectedBlocks + ", afterBlocks=" + this.afterBlocks + ", newAffectedBlock=" + this.newAffectedBlock + ", newAfterBlocks=" + this.newAfterBlocks + ")";
        }

        public int hashCode() {
            int result = ((Object)this.beforeBlocks).hashCode();
            result = result * 31 + ((Object)this.newBlocks).hashCode();
            result = result * 31 + ((Object)this.affectedBlocks).hashCode();
            result = result * 31 + ((Object)this.afterBlocks).hashCode();
            result = result * 31 + this.newAffectedBlock.hashCode();
            result = result * 31 + ((Object)this.newAfterBlocks).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (!Intrinsics.areEqual(this.beforeBlocks, result.beforeBlocks)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.newBlocks, result.newBlocks)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.affectedBlocks, result.affectedBlocks)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.afterBlocks, result.afterBlocks)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newAffectedBlock, (Object)result.newAffectedBlock)) {
                return false;
            }
            return Intrinsics.areEqual(this.newAfterBlocks, result.newAfterBlocks);
        }
    }
}

