/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class MergeModelBase<S extends State>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(MergeModelBase.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @Nullable
    private final UndoManager myUndoManager;
    @NotNull
    private final IntList myStartLines;
    @NotNull
    private final IntList myEndLines;
    @NotNull
    private final IntSet myChangesToUpdate;
    private int myBulkChangeUpdateDepth;
    private boolean myInsideCommand;
    private boolean myDisposed;

    public MergeModelBase(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            MergeModelBase.$$$reportNull$$$0(0);
        }
        this.myStartLines = new IntArrayList();
        this.myEndLines = new IntArrayList();
        this.myChangesToUpdate = new IntOpenHashSet();
        this.myProject = project;
        this.myDocument = document;
        this.myUndoManager = this.myProject != null ? UndoManager.getInstance((Project)this.myProject) : UndoManager.getGlobalInstance();
        this.myDocument.addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this);
    }

    @RequiresEdt
    public void dispose() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        LOG.assertTrue(this.myBulkChangeUpdateDepth == 0);
        this.myStartLines.clear();
        this.myEndLines.clear();
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public int getChangesCount() {
        return this.myStartLines.size();
    }

    public int getLineStart(int index) {
        return this.myStartLines.getInt(index);
    }

    public int getLineEnd(int index) {
        return this.myEndLines.getInt(index);
    }

    public void setChanges(@NotNull List<? extends LineRange> changes) {
        if (changes == null) {
            MergeModelBase.$$$reportNull$$$0(1);
        }
        this.myStartLines.clear();
        this.myEndLines.clear();
        for (LineRange lineRange : changes) {
            this.myStartLines.add(lineRange.start);
            this.myEndLines.add(lineRange.end);
        }
    }

    @RequiresEdt
    public boolean isInsideCommand() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.myInsideCommand;
    }

    private void setLineStart(int index, int line) {
        this.myStartLines.set(index, line);
    }

    private void setLineEnd(int index, int line) {
        this.myEndLines.set(index, line);
    }

    @RequiresEdt
    public void invalidateHighlighters(int n) {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myBulkChangeUpdateDepth > 0) {
            this.myChangesToUpdate.add((int)index);
        } else {
            this.reinstallHighlighters((int)index);
        }
    }

    @RequiresEdt
    public void enterBulkChangeUpdateBlock() {
        ThreadingAssertions.assertEventDispatchThread();
        ++this.myBulkChangeUpdateDepth;
    }

    @RequiresEdt
    public void exitBulkChangeUpdateBlock() {
        ThreadingAssertions.assertEventDispatchThread();
        --this.myBulkChangeUpdateDepth;
        LOG.assertTrue(this.myBulkChangeUpdateDepth >= 0);
        if (this.myBulkChangeUpdateDepth == 0) {
            this.myChangesToUpdate.forEach(index -> this.reinstallHighlighters(index));
            this.myChangesToUpdate.clear();
            this.postInstallHighlighters();
        }
    }

    @RequiresEdt
    protected abstract void reinstallHighlighters(int var1);

    @RequiresEdt
    protected void postInstallHighlighters() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    @Nullable
    protected abstract S storeChangeState(int var1);

    @RequiresEdt
    protected void restoreChangeState(@NotNull S state) {
        if (state == null) {
            MergeModelBase.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.setLineStart(((State)state).myIndex, ((State)state).myStartLine);
        this.setLineEnd(((State)state).myIndex, ((State)state).myEndLine);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @Nullable
    protected S processDocumentChange(int n, int n2, int n3, int n4) {
        boolean rangeManuallyEdit;
        void shift;
        void oldLine2;
        void oldLine1;
        void index;
        ThreadingAssertions.assertEventDispatchThread();
        int line1 = this.getLineStart((int)index);
        int line2 = this.getLineEnd((int)index);
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, (int)oldLine1, (int)oldLine2, (int)shift);
        boolean rangeAffected = newRange.damaged || oldLine2 >= line1 && oldLine1 <= line2;
        boolean bl = rangeManuallyEdit = newRange.damaged || oldLine2 > line1 && oldLine1 < line2;
        if (rangeManuallyEdit && !this.isInsideCommand() && this.myUndoManager != null && !this.myUndoManager.isUndoOrRedoInProgress()) {
            this.onRangeManuallyEdit((int)index);
        }
        S oldState = rangeAffected ? (S)this.storeChangeState((int)index) : null;
        this.setLineStart((int)index, newRange.startLine);
        this.setLineEnd((int)index, newRange.endLine);
        return oldState;
    }

    @ApiStatus.Internal
    protected void onRangeManuallyEdit(int index) {
    }

    public boolean executeMergeCommand(@NlsContexts.Command @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @Nullable IntList affectedChanges, @NotNull Runnable task) {
        if (confirmationPolicy == null) {
            MergeModelBase.$$$reportNull$$$0(3);
        }
        if (task == null) {
            MergeModelBase.$$$reportNull$$$0(4);
        }
        IntList allAffectedChanges = affectedChanges != null ? this.collectAffectedChanges(affectedChanges) : null;
        return DiffUtil.executeWriteCommand(this.myProject, this.myDocument, commandName, commandGroupId, confirmationPolicy, underBulkUpdate, () -> {
            LOG.assertTrue(!this.myInsideCommand);
            this.myInsideCommand = true;
            this.enterBulkChangeUpdateBlock();
            try {
                this.registerUndoRedo(true, allAffectedChanges);
                try {
                    task.run();
                }
                finally {
                    this.registerUndoRedo(false, allAffectedChanges);
                }
            }
            finally {
                this.exitBulkChangeUpdateBlock();
                this.myInsideCommand = false;
            }
        });
    }

    private void registerUndoRedo(boolean undo, @Nullable IntList affectedChanges) {
        ArrayList<S> states;
        if (this.myUndoManager == null) {
            return;
        }
        if (affectedChanges != null) {
            states = new ArrayList<S>(affectedChanges.size());
            affectedChanges.forEach(index -> states.add(this.storeChangeState(index)));
        } else {
            states = new ArrayList(this.getChangesCount());
            for (int index2 = 0; index2 < this.getChangesCount(); ++index2) {
                states.add(this.storeChangeState(index2));
            }
        }
        this.myUndoManager.undoableActionPerformed((UndoableAction)new MyUndoableAction(this, states, undo));
    }

    @RequiresWriteLock
    public void replaceChange(int index, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            MergeModelBase.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertWriteAccess();
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.myDocument, outputStartLine, outputEndLine, newContent);
        if (outputStartLine == outputEndLine) {
            int newOutputEndLine = outputStartLine + newContent.size();
            this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
        }
    }

    @RequiresWriteLock
    public void appendChange(int index, @NotNull List<? extends CharSequence> newContent) {
        if (newContent == null) {
            MergeModelBase.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertWriteAccess();
        LOG.assertTrue(this.isInsideCommand());
        int outputStartLine = this.getLineStart(index);
        int outputEndLine = this.getLineEnd(index);
        DiffUtil.applyModification(this.myDocument, outputEndLine, outputEndLine, newContent);
        int newOutputEndLine = outputEndLine + newContent.size();
        this.moveChangesAfterInsertion(index, outputStartLine, newOutputEndLine);
    }

    private void moveChangesAfterInsertion(int index, int newOutputStartLine, int newOutputEndLine) {
        LOG.assertTrue(this.isInsideCommand());
        if (this.getLineStart(index) != newOutputStartLine || this.getLineEnd(index) != newOutputEndLine) {
            this.setLineStart(index, newOutputStartLine);
            this.setLineEnd(index, newOutputEndLine);
            this.invalidateHighlighters(index);
        }
        boolean beforeChange = true;
        for (int otherIndex = 0; otherIndex < this.getChangesCount(); ++otherIndex) {
            int newEndLine;
            int startLine = this.getLineStart(otherIndex);
            int endLine = this.getLineEnd(otherIndex);
            if (endLine < newOutputStartLine) continue;
            if (startLine > newOutputEndLine) break;
            if (index == otherIndex) {
                beforeChange = false;
                continue;
            }
            int newStartLine = beforeChange ? Math.min(startLine, newOutputStartLine) : newOutputEndLine;
            int n = newEndLine = beforeChange ? Math.min(endLine, newOutputStartLine) : Math.max(endLine, newOutputEndLine);
            if (startLine == newStartLine && endLine == newEndLine) continue;
            this.setLineStart(otherIndex, newStartLine);
            this.setLineEnd(otherIndex, newEndLine);
            this.invalidateHighlighters(otherIndex);
        }
    }

    @RequiresEdt
    @NotNull
    private IntList collectAffectedChanges(@NotNull IntList directChanges) {
        if (directChanges == null) {
            MergeModelBase.$$$reportNull$$$0(7);
        }
        ThreadingAssertions.assertEventDispatchThread();
        IntArrayList result = new IntArrayList(directChanges.size());
        int directArrayIndex = 0;
        int otherIndex = 0;
        while (directArrayIndex < directChanges.size() && otherIndex < this.getChangesCount()) {
            int directIndex = directChanges.getInt(directArrayIndex);
            if (directIndex == otherIndex) {
                result.add(directIndex);
                ++otherIndex;
                continue;
            }
            int directStart = this.getLineStart(directIndex);
            int directEnd = this.getLineEnd(directIndex);
            int otherStart = this.getLineStart(otherIndex);
            int otherEnd = this.getLineEnd(otherIndex);
            if (otherEnd < directStart) {
                ++otherIndex;
                continue;
            }
            if (otherStart > directEnd) {
                ++directArrayIndex;
                continue;
            }
            result.add(otherIndex);
            ++otherIndex;
        }
        LOG.assertTrue(directChanges.size() <= result.size());
        IntArrayList intArrayList = result;
        if (intArrayList == null) {
            MergeModelBase.$$$reportNull$$$0(8);
        }
        return intArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directChanges";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/merge/MergeModelBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/merge/MergeModelBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAffectedChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreChangeState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeMergeCommand";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedChanges";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.enterBulkChangeUpdateBlock();
            if (MergeModelBase.this.getChangesCount() == 0) {
                return;
            }
            LineRange lineRange = DiffUtil.getAffectedLineRange(e);
            int shift = DiffUtil.countLinesShift(e);
            SmartList corruptedStates = new SmartList();
            for (int index = 0; index < MergeModelBase.this.getChangesCount(); ++index) {
                Object oldState = MergeModelBase.this.processDocumentChange(index, lineRange.start, lineRange.end, shift);
                if (oldState == null) continue;
                MergeModelBase.this.invalidateHighlighters(index);
                if (MergeModelBase.this.isInsideCommand()) continue;
                corruptedStates.add(oldState);
            }
            if (MergeModelBase.this.myUndoManager != null && !corruptedStates.isEmpty()) {
                MergeModelBase.this.myUndoManager.undoableActionPerformed((UndoableAction)new MyUndoableAction(MergeModelBase.this, (List<? extends State>)corruptedStates, true));
            }
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (MergeModelBase.this.isDisposed()) {
                return;
            }
            MergeModelBase.this.exitBulkChangeUpdateBlock();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/merge/MergeModelBase$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        public final int myIndex;
        public final int myStartLine;
        public final int myEndLine;

        public State(int index, int startLine, int endLine) {
            this.myIndex = index;
            this.myStartLine = startLine;
            this.myEndLine = endLine;
        }
    }

    private static final class MyUndoableAction
    extends BasicUndoableAction {
        @NotNull
        private final WeakReference<MergeModelBase<?>> myModelRef;
        @NotNull
        private final List<? extends State> myStates;
        private final boolean myUndo;

        MyUndoableAction(@NotNull MergeModelBase<?> model, @NotNull List<? extends State> states, boolean undo) {
            if (model == null) {
                MyUndoableAction.$$$reportNull$$$0(0);
            }
            if (states == null) {
                MyUndoableAction.$$$reportNull$$$0(1);
            }
            super(new Document[]{model.myDocument});
            this.myModelRef = new WeakReference(model);
            this.myStates = states;
            this.myUndo = undo;
        }

        public void undo() {
            MergeModelBase model = (MergeModelBase)this.myModelRef.get();
            if (model != null && this.myUndo) {
                this.restoreStates(model);
            }
        }

        public void redo() {
            MergeModelBase model = (MergeModelBase)this.myModelRef.get();
            if (model != null && !this.myUndo) {
                this.restoreStates(model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreStates(@NotNull MergeModelBase model) {
            if (model == null) {
                MyUndoableAction.$$$reportNull$$$0(2);
            }
            if (model.isDisposed()) {
                return;
            }
            if (model.getChangesCount() == 0) {
                return;
            }
            model.enterBulkChangeUpdateBlock();
            try {
                for (State state : this.myStates) {
                    model.restoreChangeState(state);
                    model.invalidateHighlighters(state.myIndex);
                }
            }
            finally {
                model.exitBulkChangeUpdateBlock();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "states";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/merge/MergeModelBase$MyUndoableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreStates";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

